/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.io.fs.index.FSFnv1aOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class CountingOutputStream
extends FilterOutputStream {
    private long myPosition;
    private FSFnv1aOutputStream myFnv1ChecksumOutputStream;

    public CountingOutputStream(OutputStream outputStream, long l2) {
        super(outputStream);
        this.myPosition = l2 >= 0L ? l2 : 0L;
        this.myFnv1ChecksumOutputStream = new FSFnv1aOutputStream(SVNFileUtil.DUMMY_OUT);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.myFnv1ChecksumOutputStream.write(byArray, n2, n3);
        this.out.write(byArray, n2, n3);
        this.myPosition += (long)n3;
    }

    @Override
    public void write(int n2) {
        this.myFnv1ChecksumOutputStream.write(n2);
        this.out.write(n2);
        ++this.myPosition;
    }

    @Override
    public void write(byte[] byArray) {
        this.myFnv1ChecksumOutputStream.write(byArray);
        this.out.write(byArray);
        this.myPosition += (long)byArray.length;
    }

    public void resetChecksum() {
        this.myFnv1ChecksumOutputStream.resetChecksum();
    }

    public int finalizeChecksum() {
        return this.myFnv1ChecksumOutputStream.finalizeChecksum();
    }

    public long getPosition() {
        return this.myPosition;
    }
}

