/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class XMLReader
extends Reader {
    public static final char COLON_REPLACEMENT = '\u3007';
    private Reader mySource;
    private boolean myIsEscaping;
    private int myColonCount;
    private boolean myIsClosed;

    public XMLReader(InputStream inputStream) {
        this.mySource = new InputStreamReader(inputStream, "UTF-8");
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        int n4 = this.mySource.read(cArray, n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = cArray[n2 + i2];
            if (c2 < ' ' && c2 != '\r' && c2 != '\n' && c2 != '\t') {
                cArray[n2 + i2] = 32;
                continue;
            }
            if (c2 == '\uffff' || c2 == '\ufffe') {
                cArray[n2 + i2] = 32;
                continue;
            }
            if (this.myIsEscaping) {
                if (c2 == ':') {
                    ++this.myColonCount;
                    if (this.myColonCount <= 1) continue;
                    cArray[n2 + i2] = 12295;
                    continue;
                }
                if (!Character.isWhitespace(c2) && c2 != '>') continue;
                this.myIsEscaping = false;
                continue;
            }
            if (this.myIsEscaping || c2 != '<') continue;
            this.myIsEscaping = true;
            this.myColonCount = 0;
        }
        this.myIsClosed = n4 < 0;
        return n4;
    }

    public boolean isClosed() {
        return this.myIsClosed;
    }

    @Override
    public void close() {
    }
}

