/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.INTLMEngine;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine$HMACMD5;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine$MD4;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine$Type1Message;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine$Type2Message;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine$Type3Message;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngineException;

final class NTLMEngine
implements INTLMEngine {
    protected static final int FLAG_REQUEST_UNICODE_ENCODING = 1;
    protected static final int FLAG_REQUEST_TARGET = 4;
    protected static final int FLAG_REQUEST_SIGN = 16;
    protected static final int FLAG_REQUEST_SEAL = 32;
    protected static final int FLAG_REQUEST_LAN_MANAGER_KEY = 128;
    protected static final int FLAG_REQUEST_NTLMv1 = 512;
    protected static final int FLAG_DOMAIN_PRESENT = 4096;
    protected static final int FLAG_WORKSTATION_PRESENT = 8192;
    protected static final int FLAG_REQUEST_ALWAYS_SIGN = 32768;
    protected static final int FLAG_REQUEST_NTLM2_SESSION = 524288;
    protected static final int FLAG_REQUEST_VERSION = 0x2000000;
    protected static final int FLAG_TARGETINFO_PRESENT = 0x800000;
    protected static final int FLAG_REQUEST_128BIT_KEY_EXCH = 0x20000000;
    protected static final int FLAG_REQUEST_EXPLICIT_KEY_EXCH = 0x40000000;
    protected static final int FLAG_REQUEST_56BIT_ENCRYPTION = Integer.MIN_VALUE;
    private static final SecureRandom RND_GEN;
    static final String DEFAULT_CHARSET = "ASCII";
    private String credentialCharset = "ASCII";
    private static final byte[] SIGNATURE;

    NTLMEngine() {
    }

    final String getResponseFor(String string, String string2, char[] cArray, String string3, String string4) {
        String string5;
        if (string == null || string.trim().equals("")) {
            string5 = this.getType1Message(string3, string4);
        } else {
            NTLMEngine$Type2Message nTLMEngine$Type2Message = new NTLMEngine$Type2Message(string);
            string5 = this.getType3Message(string2, cArray, string3, string4, nTLMEngine$Type2Message.getChallenge(), nTLMEngine$Type2Message.getFlags(), nTLMEngine$Type2Message.getTarget(), nTLMEngine$Type2Message.getTargetInfo());
        }
        return string5;
    }

    String getType1Message(String string, String string2) {
        return new NTLMEngine$Type1Message(string2, string).getResponse();
    }

    String getType3Message(String string, char[] cArray, String string2, String string3, byte[] byArray, int n2, String string4, byte[] byArray2) {
        return new NTLMEngine$Type3Message(string3, string2, string, cArray, byArray, n2, string4, byArray2).getResponse();
    }

    String getCredentialCharset() {
        return this.credentialCharset;
    }

    void setCredentialCharset(String string) {
        this.credentialCharset = string;
    }

    private static String stripDotSuffix(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(".");
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    private static String convertHost(String string) {
        return NTLMEngine.stripDotSuffix(string);
    }

    private static String convertDomain(String string) {
        return NTLMEngine.stripDotSuffix(string);
    }

    private static int readULong(byte[] byArray, int n2) {
        if (byArray.length < n2 + 4) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for DWORD");
        }
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    private static int readUShort(byte[] byArray, int n2) {
        if (byArray.length < n2 + 2) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for WORD");
        }
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    private static byte[] readSecurityBuffer(byte[] byArray, int n2) {
        int n3 = NTLMEngine.readUShort(byArray, n2);
        int n4 = NTLMEngine.readULong(byArray, n2 + 4);
        if (byArray.length < n4 + n3) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for data item");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n4, byArray2, 0, n3);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeRandomChallenge() {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] byArray = new byte[8];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeSecondaryKey() {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] byArray = new byte[16];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(byArray);
        }
        return byArray;
    }

    static byte[] hmacMD5(byte[] byArray, byte[] byArray2) {
        NTLMEngine$HMACMD5 nTLMEngine$HMACMD5 = new NTLMEngine$HMACMD5(byArray2);
        nTLMEngine$HMACMD5.update(byArray);
        return nTLMEngine$HMACMD5.getOutput();
    }

    static byte[] RC4(byte[] byArray, byte[] byArray2) {
        try {
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, new SecretKeySpec(byArray2, "RC4"));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    static byte[] ntlm2SessionResponse(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            byte[] byArray4 = messageDigest.digest();
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray4, 0, byArray5, 0, 8);
            return NTLMEngine.lmResponse(byArray, byArray5);
        }
        catch (Exception exception) {
            if (exception instanceof NTLMEngineException) {
                throw (NTLMEngineException)exception;
            }
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmHash(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            cArray2[i2] = Character.toUpperCase(cArray[i2]);
        }
        byte[] byArray = HTTPAuthentication.getBytes(cArray2, "US-ASCII");
        try {
            byte[] byArray2 = byArray;
            int n2 = Math.min(byArray2.length, 14);
            byte[] byArray3 = new byte[14];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            Key key = NTLMEngine.createDESKey(byArray3, 0);
            Key key2 = NTLMEngine.createDESKey(byArray3, 7);
            byte[] byArray4 = "KGS!@#$%".getBytes("US-ASCII");
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray5 = cipher.doFinal(byArray4);
            cipher.init(1, key2);
            byte[] byArray6 = cipher.doFinal(byArray4);
            byte[] byArray7 = new byte[16];
            System.arraycopy(byArray5, 0, byArray7, 0, 8);
            System.arraycopy(byArray6, 0, byArray7, 8, 8);
            byte[] byArray8 = byArray7;
            return byArray8;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
        finally {
            HTTPAuthentication.clear(byArray);
            HTTPAuthentication.clear(cArray2);
        }
    }

    private static byte[] ntlmHash(char[] cArray) {
        byte[] byArray = HTTPAuthentication.getBytes(cArray, "UnicodeLittleUnmarked");
        NTLMEngine$MD4 nTLMEngine$MD4 = new NTLMEngine$MD4();
        nTLMEngine$MD4.update(byArray);
        HTTPAuthentication.clear(byArray);
        return nTLMEngine$MD4.getOutput();
    }

    private static byte[] lmv2Hash(String string, String string2, byte[] byArray) {
        try {
            NTLMEngine$HMACMD5 nTLMEngine$HMACMD5 = new NTLMEngine$HMACMD5(byArray);
            nTLMEngine$HMACMD5.update(string2.toUpperCase(Locale.ENGLISH).getBytes("UnicodeLittleUnmarked"));
            if (string != null) {
                nTLMEngine$HMACMD5.update(string.toUpperCase(Locale.ENGLISH).getBytes("UnicodeLittleUnmarked"));
            }
            return nTLMEngine$HMACMD5.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NTLMEngineException("Unicode not supported! " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] ntlmv2Hash(String string, String string2, byte[] byArray) {
        try {
            NTLMEngine$HMACMD5 nTLMEngine$HMACMD5 = new NTLMEngine$HMACMD5(byArray);
            nTLMEngine$HMACMD5.update(string2.toUpperCase(Locale.ENGLISH).getBytes("UnicodeLittleUnmarked"));
            if (string != null) {
                nTLMEngine$HMACMD5.update(string.getBytes("UnicodeLittleUnmarked"));
            }
            return nTLMEngine$HMACMD5.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NTLMEngineException("Unicode not supported! " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] lmResponse(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[21];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            Key key = NTLMEngine.createDESKey(byArray3, 0);
            Key key2 = NTLMEngine.createDESKey(byArray3, 7);
            Key key3 = NTLMEngine.createDESKey(byArray3, 14);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray2);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray2);
            cipher.init(1, key3);
            byte[] byArray6 = cipher.doFinal(byArray2);
            byte[] byArray7 = new byte[24];
            System.arraycopy(byArray4, 0, byArray7, 0, 8);
            System.arraycopy(byArray5, 0, byArray7, 8, 8);
            System.arraycopy(byArray6, 0, byArray7, 16, 8);
            return byArray7;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmv2Response(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        NTLMEngine$HMACMD5 nTLMEngine$HMACMD5 = new NTLMEngine$HMACMD5(byArray);
        nTLMEngine$HMACMD5.update(byArray2);
        nTLMEngine$HMACMD5.update(byArray3);
        byte[] byArray4 = nTLMEngine$HMACMD5.getOutput();
        byte[] byArray5 = new byte[byArray4.length + byArray3.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        return byArray5;
    }

    private static byte[] createBlob(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[]{1, 1, 0, 0};
        byte[] byArray5 = new byte[]{0, 0, 0, 0};
        byte[] byArray6 = new byte[]{0, 0, 0, 0};
        byte[] byArray7 = new byte[]{0, 0, 0, 0};
        byte[] byArray8 = new byte[byArray4.length + byArray5.length + byArray3.length + 8 + byArray6.length + byArray2.length + byArray7.length];
        int n2 = 0;
        System.arraycopy(byArray4, 0, byArray8, n2, byArray4.length);
        System.arraycopy(byArray5, 0, byArray8, n2 += byArray4.length, byArray5.length);
        System.arraycopy(byArray3, 0, byArray8, n2 += byArray5.length, byArray3.length);
        System.arraycopy(byArray, 0, byArray8, n2 += byArray3.length, 8);
        System.arraycopy(byArray6, 0, byArray8, n2 += 8, byArray6.length);
        System.arraycopy(byArray2, 0, byArray8, n2 += byArray6.length, byArray2.length);
        System.arraycopy(byArray7, 0, byArray8, n2 += byArray2.length, byArray7.length);
        n2 += byArray7.length;
        return byArray8;
    }

    private static Key createDESKey(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n2, byArray2, 0, 7);
        byte[] byArray3 = new byte[]{byArray2[0], (byte)(byArray2[0] << 7 | (byArray2[1] & 0xFF) >>> 1), (byte)(byArray2[1] << 6 | (byArray2[2] & 0xFF) >>> 2), (byte)(byArray2[2] << 5 | (byArray2[3] & 0xFF) >>> 3), (byte)(byArray2[3] << 4 | (byArray2[4] & 0xFF) >>> 4), (byte)(byArray2[4] << 3 | (byArray2[5] & 0xFF) >>> 5), (byte)(byArray2[5] << 2 | (byArray2[6] & 0xFF) >>> 6), (byte)(byArray2[6] << 1)};
        NTLMEngine.oddParity(byArray3);
        return new SecretKeySpec(byArray3, "DES");
    }

    private static void oddParity(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            boolean bl2;
            byte by = byArray[i2];
            boolean bl3 = bl2 = ((by >>> 7 ^ by >>> 6 ^ by >>> 5 ^ by >>> 4 ^ by >>> 3 ^ by >>> 2 ^ by >>> 1) & 1) == 0;
            if (bl2) {
                int n2 = i2;
                byArray[n2] = (byte)(byArray[n2] | 1);
                continue;
            }
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] & 0xFFFFFFFE);
        }
    }

    static void writeULong(byte[] byArray, int n2, int n3) {
        byArray[n3] = (byte)(n2 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    static int F(int n2, int n3, int n4) {
        return n2 & n3 | ~n2 & n4;
    }

    static int G(int n2, int n3, int n4) {
        return n2 & n3 | n2 & n4 | n3 & n4;
    }

    static int H(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    static int rotintlft(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    @Override
    public String generateType1Msg(String string, String string2) {
        return this.getType1Message(string2, string);
    }

    @Override
    public String generateType3Msg(String string, char[] cArray, String string2, String string3, String string4) {
        NTLMEngine$Type2Message nTLMEngine$Type2Message = new NTLMEngine$Type2Message(string4);
        return this.getType3Message(string, cArray, string3, string2, nTLMEngine$Type2Message.getChallenge(), nTLMEngine$Type2Message.getFlags(), nTLMEngine$Type2Message.getTarget(), nTLMEngine$Type2Message.getTargetInfo());
    }

    static /* synthetic */ byte[] access$000() {
        return NTLMEngine.makeRandomChallenge();
    }

    static /* synthetic */ byte[] access$100() {
        return NTLMEngine.makeSecondaryKey();
    }

    static /* synthetic */ byte[] access$200(char[] cArray) {
        return NTLMEngine.lmHash(cArray);
    }

    static /* synthetic */ byte[] access$300(byte[] byArray, byte[] byArray2) {
        return NTLMEngine.lmResponse(byArray, byArray2);
    }

    static /* synthetic */ byte[] access$400(char[] cArray) {
        return NTLMEngine.ntlmHash(cArray);
    }

    static /* synthetic */ byte[] access$500(String string, String string2, byte[] byArray) {
        return NTLMEngine.lmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$600(String string, String string2, byte[] byArray) {
        return NTLMEngine.ntlmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$700(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngine.createBlob(byArray, byArray2, byArray3);
    }

    static /* synthetic */ byte[] access$800(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngine.lmv2Response(byArray, byArray2, byArray3);
    }

    static /* synthetic */ Key access$900(byte[] byArray, int n2) {
        return NTLMEngine.createDESKey(byArray, n2);
    }

    static /* synthetic */ byte[] access$1000() {
        return SIGNATURE;
    }

    static /* synthetic */ int access$1100(byte[] byArray, int n2) {
        return NTLMEngine.readUShort(byArray, n2);
    }

    static /* synthetic */ int access$1200(byte[] byArray, int n2) {
        return NTLMEngine.readULong(byArray, n2);
    }

    static /* synthetic */ byte[] access$1300(byte[] byArray, int n2) {
        return NTLMEngine.readSecurityBuffer(byArray, n2);
    }

    static /* synthetic */ String access$1400(String string) {
        return NTLMEngine.convertHost(string);
    }

    static /* synthetic */ String access$1500(String string) {
        return NTLMEngine.convertDomain(string);
    }

    static {
        Object object = null;
        try {
            object = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RND_GEN = object;
        try {
            object = "NTLMSSP".getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new byte[]{78, 84, 76, 77, 83, 83, 80};
        }
        SIGNATURE = new byte[((Object)object).length + 1];
        System.arraycopy(object, 0, SIGNATURE, 0, ((Object)object).length);
        NTLMEngine.SIGNATURE[((Object)object).length] = 0;
    }
}

