/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngineException;
import org.tmatesoft.svn.core.internal.util.SVNBase64;

class NTLMEngine$NTLMMessage {
    private byte[] messageContents = null;
    private int currentOutputPosition = 0;

    NTLMEngine$NTLMMessage() {
    }

    NTLMEngine$NTLMMessage(String string, int n2) {
        byte[] byArray = new byte[string.length()];
        int n3 = SVNBase64.base64ToByteArray(new StringBuffer(string), byArray);
        this.messageContents = new byte[n3];
        System.arraycopy(byArray, 0, this.messageContents, 0, n3);
        if (this.messageContents.length < NTLMEngine.access$1000().length) {
            throw new NTLMEngineException("NTLM message decoding error - packet too short");
        }
        for (int i2 = 0; i2 < NTLMEngine.access$1000().length; ++i2) {
            if (this.messageContents[i2] == NTLMEngine.access$1000()[i2]) continue;
            throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
        }
        int n4 = this.readULong(NTLMEngine.access$1000().length);
        if (n4 != n2) {
            throw new NTLMEngineException("NTLM type " + Integer.toString(n2) + " message expected - instead got type " + Integer.toString(n4));
        }
        this.currentOutputPosition = this.messageContents.length;
    }

    protected int getPreambleLength() {
        return NTLMEngine.access$1000().length + 4;
    }

    protected int getMessageLength() {
        return this.currentOutputPosition;
    }

    protected byte readByte(int n2) {
        if (this.messageContents.length < n2 + 1) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        return this.messageContents[n2];
    }

    protected void readBytes(byte[] byArray, int n2) {
        if (this.messageContents.length < n2 + byArray.length) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        System.arraycopy(this.messageContents, n2, byArray, 0, byArray.length);
    }

    protected int readUShort(int n2) {
        return NTLMEngine.access$1100(this.messageContents, n2);
    }

    protected int readULong(int n2) {
        return NTLMEngine.access$1200(this.messageContents, n2);
    }

    protected byte[] readSecurityBuffer(int n2) {
        return NTLMEngine.access$1300(this.messageContents, n2);
    }

    protected void prepareResponse(int n2, int n3) {
        this.messageContents = new byte[n2];
        this.currentOutputPosition = 0;
        this.addBytes(NTLMEngine.access$1000());
        this.addULong(n3);
    }

    protected void addByte(byte by) {
        this.messageContents[this.currentOutputPosition] = by;
        ++this.currentOutputPosition;
    }

    protected void addBytes(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = byArray;
        int n2 = byArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by;
            this.messageContents[this.currentOutputPosition] = by = byArray2[i2];
            ++this.currentOutputPosition;
        }
    }

    protected void addUShort(int n2) {
        this.addByte((byte)(n2 & 0xFF));
        this.addByte((byte)(n2 >> 8 & 0xFF));
    }

    protected void addULong(int n2) {
        this.addByte((byte)(n2 & 0xFF));
        this.addByte((byte)(n2 >> 8 & 0xFF));
        this.addByte((byte)(n2 >> 16 & 0xFF));
        this.addByte((byte)(n2 >> 24 & 0xFF));
    }

    String getResponse() {
        byte[] byArray;
        if (this.messageContents.length > this.currentOutputPosition) {
            byte[] byArray2 = new byte[this.currentOutputPosition];
            System.arraycopy(this.messageContents, 0, byArray2, 0, this.currentOutputPosition);
            byArray = byArray2;
        } else {
            byArray = this.messageContents;
        }
        return SVNBase64.byteArrayToBase64(byArray);
    }
}

