/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.text.ParseException;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;

public class HTTPStatus {
    private String myStatusLine;
    private String myVersion;
    private int myCode;
    private String myReason;
    private HTTPHeader myHeader;
    private SVNErrorMessage myError;

    public static boolean isHTTPStatusLine(String string) {
        try {
            HTTPStatus hTTPStatus = HTTPStatus.createHTTPStatus(string);
            return hTTPStatus != null;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static HTTPStatus createHTTPStatus(String string) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        String string2 = null;
        String string3 = null;
        int n5 = -1;
        try {
            int n6;
            while (Character.isWhitespace(string.charAt(n3))) {
                ++n3;
                ++n4;
            }
            if (!"HTTP".equals(string.substring(n3, n3 += 4))) {
                throw new ParseException("Status-Line '" + string + "' does not start with HTTP", 0);
            }
            while (!Character.isWhitespace(string.charAt(n3)) && n3 < string.length()) {
                ++n3;
            }
            if (n3 == string.length()) {
                throw new ParseException("Unable to parse HTTP-Version from the status line: '" + string + "'", 0);
            }
            string3 = string.substring(n4, n3).toUpperCase();
            while (Character.isWhitespace(string.charAt(n3)) && n3 < string.length()) {
                ++n3;
            }
            if (n3 == string.length()) {
                throw new ParseException("Status-Line '" + string + "' is not valid", 0);
            }
            for (n6 = n3; !Character.isWhitespace(string.charAt(n6)) && n6 < string.length(); ++n6) {
            }
            try {
                n5 = Integer.parseInt(string.substring(n3, n6));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Unable to parse status code from status line: '" + string + "'", 0);
            }
            n3 = n6 + 1;
            string2 = n3 < n2 ? string.substring(n3).trim() : "";
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParseException("Status-Line '" + string + "' is not valid", 0);
        }
        return new HTTPStatus(string3, string2, n5, string);
    }

    private HTTPStatus(String string, String string2, int n2, String string3) {
        this.myVersion = string;
        this.myStatusLine = string3;
        this.myReason = string2;
        this.myCode = n2;
    }

    public String getReason() {
        return this.myReason;
    }

    public int getCode() {
        return this.myCode;
    }

    public int getCodeClass() {
        return this.myCode / 100;
    }

    public String getStatusLine() {
        return this.myStatusLine;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public boolean isHTTP11() {
        return "HTTP/1.1".equals(this.myVersion);
    }

    public void setHeader(HTTPHeader hTTPHeader) {
        this.myHeader = hTTPHeader;
    }

    public HTTPHeader getHeader() {
        return this.myHeader;
    }

    public void setError(SVNErrorMessage sVNErrorMessage) {
        this.myError = sVNErrorMessage;
    }

    public SVNErrorMessage getError() {
        return this.myError;
    }
}

