/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.ISVNSSLPasspharsePromptSupport;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public final class HTTPSSLKeyManager
implements X509KeyManager {
    private final ISVNAuthenticationManager authenticationManager;
    private final String realm;
    private final SVNURL url;
    private KeyManager[] myKeyManagers;
    private SVNSSLAuthentication myAuthentication;
    private Exception myException;
    private String chooseAlias = null;
    private boolean myIsFirstRequest = true;

    public static KeyManager[] loadClientCertificate() {
        Provider provider = Security.getProvider("CAPI");
        Provider provider2 = Security.getProvider("SunMSCAPI");
        KeyManager[] keyManagerArray = null;
        SVNDebugLog.getDefaultLog().logError(SVNLogType.CLIENT, "using mscapi");
        KeyStore keyStore = null;
        try {
            if (provider2 != null) {
                provider2.setProperty("Signature.SHA1withRSA", "sun.security.mscapi.RSASignature$SHA1");
                keyStore = KeyStore.getInstance("Windows-MY", provider2);
            } else if (provider != null) {
                keyStore = KeyStore.getInstance("CAPI");
            }
            if (keyStore != null) {
                keyStore.load(null, null);
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Problems, when connecting with ms capi! " + throwable.getMessage(), null, 0, throwable), throwable);
        }
        KeyManagerFactory keyManagerFactory = null;
        if (keyStore != null) {
            try {
                keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                if (keyManagerFactory != null) {
                    keyManagerFactory.init(keyStore, null);
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                }
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "MS Capi error: " + throwable.getMessage()), throwable);
            }
        }
        return keyManagerArray;
    }

    public static KeyManager[] loadClientCertificate(File file, String string) {
        return HTTPSSLKeyManager.loadClientCertificate(file, string != null ? string.toCharArray() : null);
    }

    public static KeyManager[] loadClientCertificate(byte[] byArray, char[] cArray) {
        cArray = cArray == null ? new char[]{} : cArray;
        KeyManager[] keyManagerArray = null;
        KeyStore keyStore = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            if (keyStore != null) {
                keyStore.load(byteArrayInputStream, cArray);
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, throwable.getMessage(), null, 0, throwable), throwable);
        }
        finally {
            SVNFileUtil.closeFile(byteArrayInputStream);
        }
        KeyManagerFactory keyManagerFactory = null;
        if (keyStore != null) {
            try {
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                if (keyManagerFactory != null) {
                    keyManagerFactory.init(keyStore, cArray);
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                }
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, throwable.getMessage()), throwable);
            }
        }
        return keyManagerArray;
    }

    public static KeyManager[] loadClientCertificate(File file, char[] cArray) {
        cArray = cArray == null ? new char[]{} : cArray;
        KeyManager[] keyManagerArray = null;
        KeyStore keyStore = null;
        if (file != null && file.getName().startsWith("MSCAPI")) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.CLIENT, "using mscapi");
            try {
                keyStore = KeyStore.getInstance("Windows-MY");
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "using my windows store");
                if (keyStore != null) {
                    keyStore.load(null, null);
                }
                KeyManagerFactory keyManagerFactory = null;
                if (keyStore != null && (keyManagerFactory = KeyManagerFactory.getInstance("SunX509")) != null) {
                    keyManagerFactory.init(keyStore, cArray);
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                }
                return keyManagerArray;
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "loadClientCertificate ms capi with file - should not be called: " + throwable.getMessage(), null, 0, throwable), throwable);
            }
        }
        InputStream inputStream = SVNFileUtil.openFileForReading(file, SVNLogType.NETWORK);
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            if (keyStore != null) {
                keyStore.load(inputStream, cArray);
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, throwable.getMessage(), null, 0, throwable), throwable);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        KeyManagerFactory keyManagerFactory = null;
        if (keyStore != null) {
            try {
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                if (keyManagerFactory != null) {
                    keyManagerFactory.init(keyStore, cArray);
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                }
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, throwable.getMessage()), throwable);
            }
        }
        return keyManagerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyManager[] loadClientCertificate(SVNSSLAuthentication sVNSSLAuthentication) {
        Object object;
        char[] cArray = sVNSSLAuthentication.getPasswordValue();
        String string = sVNSSLAuthentication.getCertificatePath();
        File file = sVNSSLAuthentication.getCertificateFile();
        byte[] byArray = sVNSSLAuthentication.getCertificate();
        char[] cArray2 = cArray == null ? new char[]{} : cArray;
        String string2 = string;
        SVNAuthentication sVNAuthentication = null;
        KeyManager[] keyManagerArray = null;
        KeyStore keyStore = null;
        if (file != null && file.getName().startsWith("MSCAPI")) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.CLIENT, "using mscapi");
            try {
                keyStore = KeyStore.getInstance("Windows-MY");
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "using my windows store");
                if (keyStore != null) {
                    keyStore.load(null, null);
                }
                KeyManagerFactory keyManagerFactory = null;
                if (keyStore != null && (keyManagerFactory = KeyManagerFactory.getInstance("SunX509")) != null) {
                    keyManagerFactory.init(keyStore, cArray2);
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                }
                return keyManagerArray;
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                throw new SVNAuthenticationException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "loadClientCertificate ms capi with file - should not be called: " + throwable.getMessage(), null, 0, throwable), throwable);
            }
        }
        while (true) {
            try {
                object = byArray != null ? new ByteArrayInputStream(byArray) : SVNFileUtil.openFileForReading(file, SVNLogType.NETWORK);
                try {
                    keyStore = KeyStore.getInstance("PKCS12");
                    if (keyStore != null) {
                        keyStore.load((InputStream)object, cArray2);
                    }
                }
                finally {
                    SVNFileUtil.closeFile((InputStream)object);
                }
                if (sVNAuthentication != null) {
                    BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.ssl.client-passphrase", string2, null, sVNAuthentication, this.url, this.authenticationManager);
                    break;
                }
                BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.ssl.client-passphrase", string, null, SVNPasswordAuthentication.newInstance("", cArray, sVNSSLAuthentication.isStorageAllowed(), sVNSSLAuthentication.getURL(), false), this.url, this.authenticationManager);
            }
            catch (IOException iOException) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, iOException);
                if (sVNAuthentication != null) {
                    BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssl.client-passphrase", string2, SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, iOException.getMessage()), sVNAuthentication, this.url, this.authenticationManager);
                    sVNAuthentication = this.authenticationManager.getNextAuthentication("svn.ssl.client-passphrase", string2, sVNSSLAuthentication.getURL());
                } else {
                    sVNAuthentication = this.authenticationManager.getFirstAuthentication("svn.ssl.client-passphrase", string2, sVNSSLAuthentication.getURL());
                }
                if (sVNAuthentication instanceof SVNPasswordAuthentication) {
                    cArray2 = ((SVNPasswordAuthentication)sVNAuthentication).getPasswordValue();
                    continue;
                }
                sVNAuthentication = null;
                SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, throwable.getMessage(), null, 0, throwable), throwable);
            }
            break;
        }
        object = null;
        if (keyStore != null) {
            try {
                object = KeyManagerFactory.getInstance("SunX509");
                if (object != null) {
                    ((KeyManagerFactory)object).init(keyStore, cArray2);
                    keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
                }
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                throw new SVNAuthenticationException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, throwable.getMessage()), throwable);
            }
        }
        return keyManagerArray;
    }

    public HTTPSSLKeyManager(ISVNAuthenticationManager iSVNAuthenticationManager, String string, SVNURL sVNURL) {
        this.authenticationManager = iSVNAuthenticationManager;
        this.realm = string;
        this.url = sVNURL;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager x509KeyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String[] stringArray = x509KeyManager.getClientAliases(string, principalArray);
            if (stringArray == null) continue;
            return stringArray;
        }
        return null;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (!this.initializeNoException()) {
            return null;
        }
        if (this.chooseAlias != null) {
            return this.chooseAlias;
        }
        for (X509KeyManager x509KeyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String string = x509KeyManager.chooseClientAlias(stringArray, principalArray, socket);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager x509KeyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String[] stringArray = x509KeyManager.getServerAliases(string, principalArray);
            if (stringArray == null) continue;
            return stringArray;
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager x509KeyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String string2 = x509KeyManager.chooseServerAlias(string, principalArray, socket);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager x509KeyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            X509Certificate[] x509CertificateArray = x509KeyManager.getCertificateChain(string);
            if (x509CertificateArray == null) continue;
            return x509CertificateArray;
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager x509KeyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            PrivateKey privateKey = x509KeyManager.getPrivateKey(string);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    public Exception getException() {
        return this.myException;
    }

    public void acknowledgeAndClearAuthentication(SVNErrorMessage sVNErrorMessage) {
        if (this.myAuthentication != null) {
            BasicAuthenticationManager.acknowledgeAuthentication(sVNErrorMessage == null, "svn.ssl.client-passphrase", this.realm, sVNErrorMessage, this.myAuthentication, this.url, this.authenticationManager);
        }
        if (sVNErrorMessage != null) {
            this.myKeyManagers = null;
            this.chooseAlias = null;
        } else {
            this.myAuthentication = null;
            this.myIsFirstRequest = true;
        }
        Exception exception = this.myException;
        this.myException = null;
        if (exception instanceof SVNException) {
            throw (SVNException)exception;
        }
        if (exception != null) {
            throw new SVNException(SVNErrorMessage.UNKNOWN_ERROR_MESSAGE, (Throwable)exception);
        }
        if (sVNErrorMessage != null && this.isNonInteractive()) {
            throw new SVNException(sVNErrorMessage);
        }
    }

    public boolean isInitialized() {
        return this.myKeyManagers != null;
    }

    private boolean initializeNoException() {
        try {
            boolean bl2 = this.initialize();
            this.myException = null;
            return bl2;
        }
        catch (Exception exception) {
            this.myException = exception;
            return false;
        }
    }

    private boolean initialize() {
        KeyManager[] keyManagerArray;
        if (this.myKeyManagers != null) {
            return true;
        }
        while (true) {
            try {
                if (this.myIsFirstRequest) {
                    this.myAuthentication = (SVNSSLAuthentication)this.authenticationManager.getFirstAuthentication("svn.ssl.client-passphrase", this.realm, this.url);
                    this.myIsFirstRequest = false;
                } else {
                    this.myAuthentication = (SVNSSLAuthentication)this.authenticationManager.getNextAuthentication("svn.ssl.client-passphrase", this.realm, this.url);
                }
            }
            catch (SVNAuthenticationException sVNAuthenticationException) {
                if (this.isNonInteractive()) {
                    this.myKeyManagers = new KeyManager[0];
                    return true;
                }
                throw sVNAuthenticationException;
            }
            if (this.myAuthentication == null) {
                if (this.isNonInteractive()) {
                    this.myKeyManagers = new KeyManager[0];
                    return true;
                }
                SVNErrorManager.cancel("SSL authentication with client certificate cancelled", SVNLogType.NETWORK);
            }
            try {
                if (HTTPSSLKeyManager.isMSCAPI(this.myAuthentication)) {
                    keyManagerArray = HTTPSSLKeyManager.loadClientCertificate();
                    this.chooseAlias = this.myAuthentication.getAlias();
                    break;
                }
                if (this.authenticationManager instanceof ISVNSSLPasspharsePromptSupport && ((ISVNSSLPasspharsePromptSupport)((Object)this.authenticationManager)).isSSLPassphrasePromtSupported()) {
                    keyManagerArray = this.loadClientCertificate(this.myAuthentication);
                    break;
                }
                if (this.myAuthentication.getCertificate() != null) {
                    keyManagerArray = HTTPSSLKeyManager.loadClientCertificate(this.myAuthentication.getCertificate(), this.myAuthentication.getPasswordValue());
                    break;
                }
                keyManagerArray = HTTPSSLKeyManager.loadClientCertificate(this.myAuthentication.getCertificateFile(), this.myAuthentication.getPasswordValue());
            }
            catch (SVNAuthenticationException sVNAuthenticationException) {
                throw sVNAuthenticationException;
            }
            catch (SVNCancelException sVNCancelException) {
                throw sVNCancelException;
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Failed to load SSL client certificate: ''{0}''", new Object[]{sVNException.getMessage()}, 0, sVNException.getCause());
                BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssl.client-passphrase", this.realm, sVNErrorMessage, this.myAuthentication, this.url, this.authenticationManager);
                continue;
            }
            break;
        }
        this.myKeyManagers = keyManagerArray;
        return true;
    }

    private boolean isNonInteractive() {
        boolean bl2 = this.authenticationManager instanceof ISVNSSLPasspharsePromptSupport;
        if (!bl2) {
            return true;
        }
        boolean bl3 = ((ISVNSSLPasspharsePromptSupport)((Object)this.authenticationManager)).isSSLPassphrasePromtSupported();
        return !bl3;
    }

    private static List getX509KeyManagers(KeyManager[] keyManagerArray) {
        ArrayList<X509KeyManager> arrayList = new ArrayList<X509KeyManager>();
        for (int i2 = 0; i2 < keyManagerArray.length; ++i2) {
            KeyManager keyManager = keyManagerArray[i2];
            if (!(keyManager instanceof X509KeyManager)) continue;
            arrayList.add((X509KeyManager)keyManager);
        }
        return arrayList;
    }

    private static boolean isMSCAPI(SVNSSLAuthentication sVNSSLAuthentication) {
        return sVNSSLAuthentication != null && "MSCAPI".equals(sVNSSLAuthentication.getSSLKind());
    }
}

