/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPParser;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.util.Version;
import org.xml.sax.helpers.DefaultHandler;

class HTTPRequest {
    public static final char[] CRLF = new char[]{'\r', '\n'};
    private boolean myIsSecured;
    private boolean myIsProxied;
    private HTTPConnection myConnection;
    private String myAuthentication;
    private String myProxyAuthentication;
    private HTTPHeader myResponseHeader;
    private HTTPStatus myStatus;
    private SVNErrorMessage myErrorMessage;
    private DefaultHandler myResponseHandler;
    private OutputStream myResponseStream;
    private byte[] myRequestBody;
    private InputStream myRequestStream;
    private boolean myIsProxyAuthForced;
    private boolean myIsKeepAlive;
    private String myCharset;
    private long myTimeout;
    private Map myCookieHeaders;

    public HTTPRequest(String string) {
        this.myCharset = string;
    }

    public void reset() {
        if (this.myRequestStream != null) {
            try {
                this.myRequestStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myAuthentication = null;
        this.myProxyAuthentication = null;
        this.myResponseHeader = null;
        this.myStatus = null;
        this.myErrorMessage = null;
    }

    public void setProxied(boolean bl2) {
        this.myIsProxied = bl2;
    }

    public void setSecured(boolean bl2) {
        this.myIsSecured = bl2;
    }

    public void setConnection(HTTPConnection hTTPConnection) {
        this.myConnection = hTTPConnection;
    }

    public void initCredentials(HTTPAuthentication hTTPAuthentication, String string, String string2) {
        if (hTTPAuthentication != null) {
            hTTPAuthentication.setChallengeParameter("method", string);
            hTTPAuthentication.setChallengeParameter("uri", this.composeRequestURI(string, string2));
            hTTPAuthentication.setChallengeParameter("host", this.myConnection.getHost().getHost());
        }
    }

    public void setAuthentication(String string) {
        this.myAuthentication = string;
    }

    public void setProxyAuthentication(String string) {
        this.myProxyAuthentication = string;
    }

    public void setForceProxyAuth(boolean bl2) {
        this.myIsProxyAuthForced = bl2;
    }

    public void setResponseHandler(DefaultHandler defaultHandler) {
        this.myResponseHandler = defaultHandler;
    }

    public void setResponseStream(OutputStream outputStream) {
        this.myResponseStream = outputStream;
    }

    public void setRequestBody(byte[] byArray) {
        this.myRequestBody = byArray;
    }

    public void setRequestBody(StringBuffer stringBuffer) {
        try {
            this.myRequestBody = stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.myRequestBody = stringBuffer.toString().getBytes();
        }
    }

    public void setRequestBody(InputStream inputStream) {
        this.myRequestStream = inputStream;
    }

    public void dispatch(String string, String string2, HTTPHeader hTTPHeader, int n2, int n3, SVNErrorMessage sVNErrorMessage) {
        long l2 = 0L;
        if (this.myRequestBody != null) {
            l2 = this.myRequestBody.length;
        } else if (this.myRequestStream instanceof ByteArrayInputStream) {
            l2 = ((ByteArrayInputStream)this.myRequestStream).available();
        } else if (hTTPHeader != null && hTTPHeader.hasHeader("Content-Length")) {
            try {
                l2 = Long.parseLong(hTTPHeader.getFirstHeaderValue("Content-Length"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        }
        StringBuffer stringBuffer = this.composeHTTPHeader(string, string2, hTTPHeader, l2, this.myIsKeepAlive);
        this.myConnection.sendData(stringBuffer.toString().getBytes(this.myCharset));
        if (this.myRequestBody != null && l2 > 0L) {
            this.myConnection.sendData(this.myRequestBody);
        } else if (this.myRequestStream != null && l2 > 0L) {
            this.myConnection.sendData(this.myRequestStream, l2);
        }
        this.myConnection.readHeader(this);
        this.myTimeout = HTTPRequest.computeTimeout(this.myStatus, this.getResponseHeader());
        SVNErrorMessage sVNErrorMessage2 = sVNErrorMessage = sVNErrorMessage == null ? SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} of ''{1}''", string, string2) : sVNErrorMessage;
        if (this.myStatus.getCode() == 301 || this.myStatus.getCode() == 302 || this.myStatus.getCode() == 403 || this.myStatus.getCode() == 401 || this.myStatus.getCode() == 407) {
            this.myErrorMessage = HTTPRequest.createDefaultErrorMessage(this.myConnection.getHost(), string2, this.myStatus, sVNErrorMessage.getMessageTemplate(), sVNErrorMessage.getRelatedObjects());
            this.myConnection.skipData(this);
            return;
        }
        boolean bl2 = false;
        if (n2 >= 0) {
            if (n2 == 0) {
                int n4 = n2 = "PROPFIND".equals(string) ? 207 : 200;
            }
            if (n3 <= 0) {
                n3 = n2;
            }
            bl2 = this.myStatus.getCode() != n2 && this.myStatus.getCode() != n3;
        } else if ("CONNECT".equalsIgnoreCase(string) && this.myStatus.getCode() != 200) {
            bl2 = true;
        }
        if (bl2) {
            this.myErrorMessage = this.readError(string, string2, sVNErrorMessage);
        } else if (this.myStatus.getCode() == 204) {
            this.myConnection.skipData(this);
        } else if (this.myStatus.getCode() >= 300) {
            SVNErrorMessage sVNErrorMessage3 = this.readError(string, string2, sVNErrorMessage);
            this.myStatus.setError(sVNErrorMessage3);
        } else if (this.myResponseStream != null) {
            this.myErrorMessage = this.myConnection.readData(this, this.myResponseStream);
        } else if (this.myResponseHandler != null) {
            this.myErrorMessage = this.myConnection.readData(this, string, string2, this.myResponseHandler);
        } else if (!"CONNECT".equalsIgnoreCase(string)) {
            this.myConnection.skipData(this);
        }
    }

    private static long computeTimeout(HTTPStatus hTTPStatus, HTTPHeader hTTPHeader) {
        if (hTTPHeader == null) {
            return -1L;
        }
        String string = hTTPHeader.getFirstHeaderValue("Keep-Alive");
        if (string == null && hTTPStatus.isHTTP11()) {
            return Long.MAX_VALUE;
        }
        if (string == null) {
            String string22 = hTTPHeader.getFirstHeaderValue("Connection");
            if (string22 != null && string22.toLowerCase().indexOf("keep-alive") >= 0) {
                return Long.MAX_VALUE;
            }
            List list = hTTPHeader.getHeaderValues("Connection");
            if (list != null) {
                for (String string22 : list) {
                    if (string22 == null || string22.toLowerCase().indexOf("keep-alive") < 0) continue;
                    return Long.MAX_VALUE;
                }
            }
            return -1L;
        }
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n2 = stringArray[i2].indexOf(61);
            if (n2 < 0) continue;
            String string3 = stringArray[i2].substring(0, n2).trim();
            String string4 = stringArray[i2].substring(n2 + 1).trim();
            if (!"timeout".equalsIgnoreCase(string3)) continue;
            try {
                int n3 = Integer.parseInt(string4);
                if (n3 >= 1) {
                    return System.currentTimeMillis() + (long)((n3 - 1) * 1000);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return -1L;
        }
        return Long.MAX_VALUE;
    }

    private SVNErrorMessage readError(String string, String string2, SVNErrorMessage sVNErrorMessage) {
        SVNErrorMessage sVNErrorMessage2;
        String string3 = sVNErrorMessage.getMessageTemplate();
        Object[] objectArray = sVNErrorMessage.getRelatedObjects();
        if (this.myStatus.getCode() == 404) {
            string3 = "''{0}'' path not found";
            objectArray = new Object[]{string2};
        }
        SVNErrorMessage sVNErrorMessage3 = HTTPRequest.createDefaultErrorMessage(this.myConnection.getHost(), string2, this.myStatus, string3, objectArray);
        if (!"HEAD".equals(string) && (sVNErrorMessage2 = this.myConnection.readError(this, string, string2)) != null) {
            if (sVNErrorMessage3 != null) {
                sVNErrorMessage2.setChildErrorMessage(sVNErrorMessage3);
            }
            return sVNErrorMessage2;
        }
        return sVNErrorMessage3;
    }

    public HTTPHeader getResponseHeader() {
        return this.myResponseHeader;
    }

    public long getNextRequestTimeout() {
        return this.myTimeout;
    }

    public HTTPStatus getStatus() {
        return this.myStatus;
    }

    public void setStatus(HTTPStatus hTTPStatus) {
        this.myStatus = hTTPStatus;
    }

    public void setResponseHeader(HTTPHeader hTTPHeader) {
        this.myResponseHeader = hTTPHeader;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    private StringBuffer composeHTTPHeader(String string, String string2, HTTPHeader hTTPHeader, long l2, boolean bl2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.composeRequestURI(string, string2));
        stringBuffer.append(' ');
        stringBuffer.append("HTTP/1.1");
        stringBuffer.append(CRLF);
        stringBuffer.append("Host: ");
        stringBuffer.append(this.myConnection.getHost().getHost());
        int n3 = n2 = "https".equals(this.myConnection.getHost().getProtocol()) ? 443 : 80;
        if (this.myConnection.getHost().getPort() != n2) {
            stringBuffer.append(":");
            stringBuffer.append(this.myConnection.getHost().getPort());
        }
        stringBuffer.append(CRLF);
        stringBuffer.append("User-Agent: ");
        stringBuffer.append(Version.getUserAgent());
        stringBuffer.append(CRLF);
        if (bl2) {
            stringBuffer.append("Keep-Alive:");
            stringBuffer.append(CRLF);
            stringBuffer.append("Connection: TE, Keep-Alive");
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("TE: trailers");
        stringBuffer.append(CRLF);
        if (this.myAuthentication != null) {
            stringBuffer.append("Authorization: ");
            stringBuffer.append(this.myAuthentication);
            stringBuffer.append(CRLF);
        }
        if ((this.myIsProxyAuthForced || this.myIsProxied && !this.myIsSecured) && this.myProxyAuthentication != null) {
            stringBuffer.append("Proxy-Authorization: ");
            stringBuffer.append(this.myProxyAuthentication);
            stringBuffer.append(CRLF);
        }
        if (hTTPHeader == null || !hTTPHeader.hasHeader("Content-Length")) {
            stringBuffer.append("Content-Length: ");
            stringBuffer.append(l2);
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("Accept-Encoding: gzip");
        stringBuffer.append(CRLF);
        if (hTTPHeader == null || !hTTPHeader.hasHeader("Content-Type")) {
            stringBuffer.append("Content-Type: text/xml; charset=\"utf-8\"");
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("DAV: ");
        stringBuffer.append("http://subversion.tigris.org/xmlns/dav/svn/depth");
        stringBuffer.append(CRLF);
        stringBuffer.append("DAV: ");
        stringBuffer.append("http://subversion.tigris.org/xmlns/dav/svn/mergeinfo");
        stringBuffer.append(CRLF);
        stringBuffer.append("DAV: ");
        stringBuffer.append("http://subversion.tigris.org/xmlns/dav/svn/log-revprops");
        stringBuffer.append(CRLF);
        if (hTTPHeader != null) {
            stringBuffer.append(hTTPHeader.toString());
        }
        if (this.myCookieHeaders != null) {
            Set set = this.myCookieHeaders.entrySet();
            for (Map.Entry entry : set) {
                String string3 = (String)entry.getKey();
                for (String string4 : (List)entry.getValue()) {
                    stringBuffer.append(string3);
                    stringBuffer.append(": ");
                    stringBuffer.append(string4);
                    stringBuffer.append(CRLF);
                }
            }
        }
        stringBuffer.append(CRLF);
        return stringBuffer;
    }

    private String composeRequestURI(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myIsProxied && !this.myIsSecured) {
            stringBuffer.append("http://");
            stringBuffer.append(this.myConnection.getHost().getHost());
            stringBuffer.append(":");
            stringBuffer.append(this.myConnection.getHost().getPort());
        }
        if (string2 == null) {
            string2 = "/";
        }
        if (!("CONNECT".equals(string) || string2.length() != 0 && string2.charAt(0) == '/')) {
            string2 = "/" + string2;
        }
        HTTPParser.getCanonicalPath(string2, stringBuffer);
        return stringBuffer.toString();
    }

    public static SVNErrorMessage createDefaultErrorMessage(SVNURL sVNURL, String string, HTTPStatus hTTPStatus, String string2, Object[] objectArray) {
        String string3;
        SVNErrorCode sVNErrorCode = SVNErrorCode.RA_DAV_REQUEST_FAILED;
        String string4 = string3 = hTTPStatus != null ? hTTPStatus.getCode() + " " + hTTPStatus.getReason() : "";
        if (hTTPStatus != null && hTTPStatus.getCode() == 403 || hTTPStatus.getCode() == 401) {
            sVNErrorCode = SVNErrorCode.RA_NOT_AUTHORIZED;
            string3 = hTTPStatus.getCode() + " " + hTTPStatus.getReason();
        } else if (hTTPStatus != null && hTTPStatus.getCode() == 404) {
            sVNErrorCode = SVNErrorCode.FS_NOT_FOUND;
        } else if (hTTPStatus != null && (hTTPStatus.getCode() == 301 || hTTPStatus.getCode() == 302)) {
            String string5;
            String string6 = string5 = hTTPStatus.getHeader() != null ? hTTPStatus.getHeader().getFirstHeaderValue("Location") : null;
            if (string5 != null) {
                string3 = hTTPStatus.getCode() == 301 ? "Repository moved permanently to ''{0}''; please relocate" : "Repository moved temporarily to ''{0}''; please relocate";
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, string3, (Object)string5);
            }
            string3 = hTTPStatus.getCode() == 301 ? "Repository moved permanently; please relocate" : "Repository moved temporarily; please relocate";
            return SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, string3);
        }
        Object[] objectArray2 = objectArray == null ? new Object[1] : new Object[objectArray.length + 1];
        int n2 = objectArray2.length - 1;
        objectArray2[objectArray2.length - 1] = sVNURL;
        if (objectArray2.length > 1) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        return SVNErrorMessage.create(sVNErrorCode, string2 + ": " + string3 + " ({" + n2 + "})", objectArray2);
    }

    public void setKeepAlive(boolean bl2) {
        this.myIsKeepAlive = bl2;
    }

    public void setCookies(Map map) {
        this.myCookieHeaders = map;
    }
}

