/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.util.jna.SVNWinSecurity;
import org.tmatesoft.svn.core.internal.util.jna.SVNWinSecurity$SVNNTSecurityParameters;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class HTTPNativeNTLMAuthentication
extends HTTPNTLMAuthentication {
    private static final String NTLM_PROMPT_USER_PROPERTY = "svnkit.http.ntlm.promptUser";
    private SVNWinSecurity$SVNNTSecurityParameters myNTSecurityParameters;
    private String myLastToken;

    protected HTTPNativeNTLMAuthentication(String string) {
        super(string);
    }

    public static HTTPNativeNTLMAuthentication newInstance(String string) {
        if (!SVNWinSecurity.isNativeLibraryAvailable()) {
            return null;
        }
        return new HTTPNativeNTLMAuthentication(string);
    }

    @Override
    public String authenticate() {
        Object object;
        if (this.myState != 1 && this.myState != 3) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported message type in HTTP NTLM authentication");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        if (this.myNTSecurityParameters == null) {
            object = this.getPassword() != null ? new String(this.getPassword()) : null;
            this.myNTSecurityParameters = SVNWinSecurity.getSecurityParams(this.getUserName(), (String)object, this.getDomain());
        }
        object = "NTLM " + SVNWinSecurity.getAuthHeader(this.myLastToken, this.myNTSecurityParameters);
        if (this.myNTSecurityParameters.myCrdHandle == null) {
            this.myNTSecurityParameters = null;
        }
        if (this.isInType3State()) {
            this.setType1State();
            if (this.myLastToken != null) {
                this.myLastToken = null;
            }
        }
        return object;
    }

    @Override
    public void parseChallenge(String string) {
        this.myLastToken = string;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public boolean allowPropmtForCredentials() {
        String string = System.getProperty(NTLM_PROMPT_USER_PROPERTY, "false");
        return Boolean.valueOf(string);
    }
}

