/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

class HTTPNTLMAuthentication
extends HTTPAuthentication {
    private static final String NTLM_CASE_CONVERTION_PROPERTY = "svnkit.http.ntlm.uppercase";
    private static final String OLD_NTLM_CASE_CONVERTION_PROPERTY = "javasvn.http.ntlm.uppercase";
    private static final String DEFAULT_CHARSET = "ASCII";
    private static final String PROTOCOL_NAME = "NTLMSSP";
    private static final int LM_RESPONSE_LENGTH = 24;
    private static final int UNINITIATED = 0;
    protected static final int TYPE1 = 1;
    protected static final int TYPE3 = 3;
    private static byte[] ourMagicBytes = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    private static final long NEGOTIATE_UNICODE = 1L;
    private static final long NEGOTIATE_OEM = 2L;
    private static final long REQUEST_TARGET = 4L;
    private static final long NEGOTIATE_SIGN = 16L;
    private static final long NEGOTIATE_SEAL = 32L;
    private static final long NEGOTIATE_DATAGRAM_STYLE = 64L;
    private static final long NEGOTIATE_LAN_MANAGER_KEY = 128L;
    private static final long NEGOTIATE_NETWARE = 256L;
    private static final long NEGOTIATE_NTLM = 512L;
    private static final long NEGOTIATE_DOMAIN_SUPPLIED = 4096L;
    private static final long NEGOTIATE_WORKSTATION_SUPPLIED = 8192L;
    private static final long NEGOTIATE_LOCAL_CALL = 16384L;
    private static final long NEGOTIATE_ALWAYS_SIGN = 32768L;
    private static final long TARGET_TYPE_DOMAIN = 65536L;
    private static final long TARGET_TYPE_SERVER = 131072L;
    private static final long TARGET_TYPE_SHARE = 262144L;
    private static final long NEGOTIATE_NTLM2_KEY = 524288L;
    private static final long REQUEST_INIT_RESPONSE = 0x100000L;
    private static final long REQUEST_ACCEPT_RESPONSE = 0x200000L;
    private static final long REQUEST_NON_NT_SESSION_KEY = 0x400000L;
    private static final long NEGOTIATE_TARGET_INFO = 0x800000L;
    private static final long NEGOTIATE_128 = 0x20000000L;
    private static final long NEGOTIATE_KEY_EXCHANGE = 0x40000000L;
    private static final long NEGOTIATE_56 = 0x80000000L;
    private static Map ourFlags = new TreeMap();
    private static Map ourTargetInfoTypes;
    protected int myState = 0;
    private String myCharset;
    private byte[] myResponse;
    private int myPosition;
    private byte[] myNonce;
    private boolean myIsNegotiateLocalCall = false;

    protected HTTPNTLMAuthentication(String string) {
        this.myCharset = string;
        if (this.myCharset == null) {
            this.myCharset = "US-ASCII";
        }
    }

    public void setType1State() {
        this.myState = 1;
    }

    public void setType3State() {
        this.myState = 3;
    }

    public boolean isInType3State() {
        return this.myState == 3;
    }

    private void initResponse(int n2) {
        this.myResponse = new byte[n2];
        this.myPosition = 0;
    }

    private void addByte(byte by) {
        this.myResponse[this.myPosition++] = by;
    }

    private void addBytes(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.myResponse[this.myPosition++] = byArray[i2];
        }
    }

    private byte[] convertToShortValue(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF)};
        return byArray;
    }

    private String getResponse() {
        byte[] byArray;
        if (this.myResponse.length > this.myPosition) {
            byArray = new byte[this.myPosition];
            for (int i2 = 0; i2 < this.myPosition; ++i2) {
                byArray[i2] = this.myResponse[i2];
            }
        } else {
            byArray = this.myResponse;
        }
        return SVNBase64.byteArrayToBase64(byArray);
    }

    public void parseChallenge(String string) {
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        String string2;
        SVNErrorMessage sVNErrorMessage;
        String string3;
        Object object;
        Object object2;
        if (string == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: expected challenge");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.NETWORK);
        }
        object2 = HTTPAuthentication.getBytes(string, DEFAULT_CHARSET);
        byte[] byArray2 = new byte[((Object)object2).length];
        int n5 = 0;
        try {
            n5 = SVNBase64.base64ToByteArray(new StringBuffer(new String((byte[])object2, this.myCharset)), byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: " + unsupportedEncodingException.getMessage());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        try {
            string3 = new String(byArray2, 0, 7, this.myCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = new String(byArray2, 0, 7);
        }
        object = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            object[i2] = byArray2[8 + i2];
        }
        long l2 = this.toLong((byte[])object);
        if (!PROTOCOL_NAME.equalsIgnoreCase(string3)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: incorrect signature ''(0}''", (Object)string3);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        } else if (l2 != 2L) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: expected type 2 message instead of ''(0, number, integer}''", (Object)l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        this.myNonce = new byte[8];
        for (int i3 = 0; i3 < 8; ++i3) {
            this.myNonce[i3] = byArray2[i3 + 24];
        }
        byte[] byArray3 = new byte[4];
        for (int i4 = 0; i4 < 4; ++i4) {
            byArray3[i4] = byArray2[i4 + 20];
        }
        long l3 = this.toLong(byArray3);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            string2 = new String(byArray2, 0, n5, this.myCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray2, 0, n5);
        }
        stringBuffer.append("NTLM auth message: " + string2);
        stringBuffer.append('\n');
        stringBuffer.append("Length: " + string2.length());
        stringBuffer.append('\n');
        stringBuffer.append("Signature: " + string3);
        stringBuffer.append('\n');
        stringBuffer.append("Type: " + l2);
        stringBuffer.append('\n');
        stringBuffer.append("Flags: " + Long.toString(l3, 16));
        stringBuffer.append('\n');
        for (Long l4 : ourFlags.keySet()) {
            if ((l3 & l4) == 0L) continue;
            stringBuffer.append((String)ourFlags.get(l4));
            stringBuffer.append('\n');
        }
        Object object3 = new byte[2];
        for (n4 = 0; n4 < 2; ++n4) {
            object3[n4] = byArray2[12 + n4];
        }
        n4 = HTTPNTLMAuthentication.toInt((byte[])object3);
        byte[] byArray4 = new byte[2];
        for (n3 = 0; n3 < 2; ++n3) {
            byArray4[n3] = byArray2[14 + n3];
        }
        n3 = HTTPNTLMAuthentication.toInt(byArray4);
        byte[] byArray5 = new byte[4];
        for (int i5 = 0; i5 < 4; ++i5) {
            byArray5[i5] = byArray2[16 + i5];
        }
        long l5 = this.toLong(byArray5);
        if (n4 > 0) {
            String string4;
            try {
                string4 = new String(byArray2, (int)l5, n3, this.myCharset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string4 = new String(byArray2, (int)l5, n3);
            }
            stringBuffer.append("Target Name: " + string4);
            stringBuffer.append('\n');
        }
        stringBuffer.append("Challenge: ");
        for (int i6 = 0; i6 < this.myNonce.length; ++i6) {
            stringBuffer.append(SVNFormatUtil.getHexNumberFromByte(this.myNonce[i6]));
        }
        stringBuffer.append('\n');
        long l6 = -1L;
        long l7 = -1L;
        boolean bl2 = false;
        if (l5 != 32L && n5 >= 40) {
            byte[] byArray6 = new byte[4];
            byArray = new byte[4];
            n2 = 0;
            for (n2 = 0; n2 < 4; ++n2) {
                byArray6[n2] = byArray2[n2 + 32];
            }
            while (n2 < 8) {
                byArray[n2 - 4] = byArray2[n2 + 32];
                ++n2;
            }
            l6 = this.toLong(byArray6);
            l7 = this.toLong(byArray);
            if (l7 == 0L) {
                bl2 = true;
                stringBuffer.append("Context: ");
                stringBuffer.append(Long.toString(l6, 16) + " " + Long.toString(l7, 16));
                stringBuffer.append('\n');
            }
            this.myIsNegotiateLocalCall = l6 != 0L && (l3 & 0x4000L) != 0L;
        } else {
            this.myIsNegotiateLocalCall = false;
        }
        if ((l3 & 0x800000L) != 0L) {
            int n6;
            int n7 = bl2 ? 40 : 32;
            byArray = new byte[2];
            for (n2 = 0; n2 < 2; ++n2) {
                byArray[n2] = byArray2[n7 + n2];
            }
            n2 = HTTPNTLMAuthentication.toInt(byArray);
            byte[] byArray7 = new byte[2];
            for (n6 = 0; n6 < 2; ++n6) {
                byArray7[n6] = byArray2[n7 + 2 + n6];
            }
            n6 = HTTPNTLMAuthentication.toInt(byArray7);
            byte[] byArray8 = new byte[4];
            for (int i7 = 0; i7 < 4; ++i7) {
                byArray8[i7] = byArray2[n7 + 4 + i7];
            }
            long l8 = this.toLong(byArray8);
            byte[] byArray9 = new byte[2];
            byte[] byArray10 = new byte[2];
            int n8 = 0;
            while (n2 > 0 && n8 <= n6) {
                int n9;
                int n10;
                for (n10 = 0; n10 < 2; ++n10) {
                    byArray9[n10] = byArray2[(int)l8 + n10];
                }
                n8 += 2;
                l8 += 2L;
                n10 = HTTPNTLMAuthentication.toInt(byArray9);
                if (n10 == 0) break;
                for (n9 = 0; n9 < 2; ++n9) {
                    byArray10[n9] = byArray2[(int)l8 + n9];
                }
                n8 += 2;
                l8 += 2L;
                n9 = HTTPNTLMAuthentication.toInt(byArray10);
                String string5 = (String)ourTargetInfoTypes.get(n10);
                if (string5 != null) {
                    String string6;
                    try {
                        string6 = new String(byArray2, (int)l8, n9, this.myCharset);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string6 = new String(byArray2, (int)l8, n9);
                    }
                    stringBuffer.append(string5 + ": " + string6);
                    stringBuffer.append('\n');
                }
                n8 += n9;
                l8 += (long)n9;
            }
        }
        stringBuffer.append('\n');
    }

    private static int toInt(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            n2 |= (n3 <<= i2 * 8);
        }
        return n2;
    }

    @Override
    public String authenticate() {
        Object object;
        Object object2;
        if (this.myState != 1 && this.myState != 3) {
            object2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported message type in HTTP NTLM authentication");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.NETWORK);
        }
        object2 = this.getUserName();
        String string = this.getDomain();
        if (string == null) {
            string = "";
        }
        String string2 = null;
        try {
            object = InetAddress.getLocalHost();
            string2 = ((InetAddress)object).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = "";
        }
        if (this.isUpperCase()) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        object = HTTPAuthentication.getBytes(PROTOCOL_NAME, DEFAULT_CHARSET);
        byte[] byArray = HTTPAuthentication.getBytes(string, DEFAULT_CHARSET);
        byte[] byArray2 = HTTPAuthentication.getBytes(string2, DEFAULT_CHARSET);
        byte[] byArray3 = this.convertToShortValue(byArray.length);
        byte[] byArray4 = this.convertToShortValue(byArray2.length);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Signature: NTLMSSP");
        stringBuffer.append('\n');
        long l2 = 16902L;
        if (string.length() > 0) {
            l2 |= 0x1000L;
        }
        if (this.myState == 1) {
            Object object32;
            int n2 = 32 + byArray.length + byArray2.length;
            this.initResponse(n2);
            this.addBytes((byte[])object);
            this.addByte((byte)0);
            this.addByte((byte)1);
            this.addByte((byte)0);
            this.addByte((byte)0);
            this.addByte((byte)0);
            stringBuffer.append("Type: 1");
            stringBuffer.append('\n');
            this.addByte((byte)(l2 & 0xFFL));
            this.addByte((byte)(l2 >> 8 & 0xFFL));
            this.addByte((byte)(l2 >> 16 & 0xFFL));
            this.addByte((byte)(l2 >> 24 & 0xFFL));
            stringBuffer.append("Flags: " + Long.toString(l2, 16));
            stringBuffer.append('\n');
            for (Object object32 : ourFlags.keySet()) {
                if ((l2 & (Long)object32) == 0L) continue;
                stringBuffer.append((String)ourFlags.get(object32));
                stringBuffer.append('\n');
            }
            this.addBytes(byArray3);
            this.addBytes(byArray3);
            Object object4 = this.convertToShortValue(byArray2.length + 32);
            this.addBytes((byte[])object4);
            this.addByte((byte)0);
            this.addByte((byte)0);
            this.addBytes(byArray4);
            this.addBytes(byArray4);
            object32 = this.convertToShortValue(32);
            this.addBytes((byte[])object32);
            this.addByte((byte)0);
            this.addByte((byte)0);
            this.addBytes(byArray2);
            if (string2.length() > 0) {
                stringBuffer.append("Host Name: " + string2);
                stringBuffer.append('\n');
            }
            this.addBytes(byArray);
            if (string.length() > 0) {
                stringBuffer.append("Domain: " + string);
                stringBuffer.append('\n');
            }
        } else if (this.myState == 3) {
            int n3;
            Object object52;
            byte[] byArray5 = ((String)object2).getBytes();
            stringBuffer.append("Type: 3");
            stringBuffer.append('\n');
            stringBuffer.append("Flags: " + Long.toString(l2, 16));
            stringBuffer.append('\n');
            for (Object object52 : ourFlags.keySet()) {
                if ((l2 & (Long)object52) == 0L) continue;
                stringBuffer.append((String)ourFlags.get(object52));
                stringBuffer.append('\n');
            }
            if (!this.myIsNegotiateLocalCall) {
                char[] cArray;
                n3 = 88 + byArray.length + byArray2.length + byArray5.length;
                this.initResponse(n3);
                this.addBytes((byte[])object);
                this.addByte((byte)0);
                this.addByte((byte)3);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                object52 = this.convertToShortValue(24);
                this.addBytes((byte[])object52);
                this.addBytes((byte[])object52);
                this.addBytes(this.convertToShortValue(n3 - 24));
                this.addByte((byte)0);
                this.addByte((byte)0);
                byte[] byArray6 = this.convertToShortValue(0);
                this.addBytes(byArray6);
                this.addBytes(byArray6);
                byte[] byArray7 = this.convertToShortValue(n3);
                this.addBytes(byArray7);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(byArray3);
                this.addBytes(byArray3);
                this.addBytes(this.convertToShortValue(64));
                this.addByte((byte)0);
                this.addByte((byte)0);
                byte[] byArray8 = this.convertToShortValue(byArray5.length);
                this.addBytes(byArray8);
                this.addBytes(byArray8);
                this.addBytes(this.convertToShortValue(64 + byArray.length));
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(byArray4);
                this.addBytes(byArray4);
                this.addBytes(this.convertToShortValue(64 + byArray.length + byArray5.length));
                for (int i2 = 0; i2 < 6; ++i2) {
                    this.addByte((byte)0);
                }
                this.addBytes(byArray7);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)(l2 & 0xFFL));
                this.addByte((byte)(l2 >> 8 & 0xFFL));
                this.addByte((byte)(l2 >> 16 & 0xFFL));
                this.addByte((byte)(l2 >> 24 & 0xFFL));
                this.addBytes(byArray);
                if (string.length() > 0) {
                    stringBuffer.append("Domain: " + string);
                    stringBuffer.append('\n');
                }
                this.addBytes(byArray5);
                if (((String)object2).length() > 0) {
                    stringBuffer.append("User Name: " + (String)object2);
                    stringBuffer.append('\n');
                }
                this.addBytes(byArray2);
                if (string2.length() > 0) {
                    stringBuffer.append("Host Name: " + string2);
                    stringBuffer.append('\n');
                }
                byte[] byArray9 = this.hashPassword((cArray = this.getPassword()) != null ? cArray : new char[]{});
                this.addBytes(byArray9);
                stringBuffer.append("Hash: " + new String(byArray9));
                stringBuffer.append('\n');
            } else {
                n3 = 64;
                object52 = this.convertToShortValue(n3);
                this.initResponse(n3);
                this.addBytes((byte[])object);
                this.addByte((byte)0);
                this.addByte((byte)3);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes((byte[])object52);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes((byte[])object52);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes((byte[])object52);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes((byte[])object52);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes((byte[])object52);
                for (int i3 = 0; i3 < 6; ++i3) {
                    this.addByte((byte)0);
                }
                this.addBytes((byte[])object52);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)(l2 & 0xFFL));
                this.addByte((byte)(l2 >> 8 & 0xFFL));
                this.addByte((byte)(l2 >> 16 & 0xFFL));
                this.addByte((byte)(l2 >> 24 & 0xFFL));
            }
            this.setType1State();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = null;
        try {
            string3 = new String(this.myResponse, 0, this.myPosition, this.myCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = new String(this.myResponse, 0, this.myPosition);
        }
        stringBuffer2.append("NTLM auth message: " + string3);
        stringBuffer2.append('\n');
        stringBuffer2.append("Length: " + string3.length());
        stringBuffer2.append('\n');
        stringBuffer2.append(stringBuffer);
        return "NTLM " + this.getResponse();
    }

    @Override
    public String getAuthenticationScheme() {
        return "NTLM";
    }

    public boolean isNative() {
        return false;
    }

    @Override
    public String getUserName() {
        int n2;
        String string = this.getRawUserName();
        String string2 = null;
        int n3 = n2 = string != null ? string.indexOf(92) : -1;
        if (n2 != -1) {
            int n4;
            for (n4 = n2 + 1; n4 < string.length() && string.charAt(n4) == '\\'; ++n4) {
            }
            string2 = string.substring(n4);
        } else {
            string2 = string == null ? System.getProperty("user.name") : string;
        }
        return string2;
    }

    public String getDomain() {
        int n2;
        String string = this.getRawUserName();
        String string2 = null;
        int n3 = n2 = string != null ? string.indexOf(92) : -1;
        if (n2 != -1) {
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    private long toLong(byte[] byArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            long l3 = byArray[i2] & 0xFF;
            l2 |= (l3 <<= i2 * 8);
        }
        return l2;
    }

    private boolean isUpperCase() {
        String string = System.getProperty(NTLM_CASE_CONVERTION_PROPERTY, System.getProperty(OLD_NTLM_CASE_CONVERTION_PROPERTY, "true"));
        return Boolean.valueOf(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] hashPassword(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        if (this.isUpperCase()) {
            for (int i2 = 0; i2 < cArray2.length; ++i2) {
                cArray2[i2] = Character.toUpperCase(cArray[i2]);
            }
        }
        byte[] byArray = HTTPAuthentication.getBytes(cArray2, "US-ASCII");
        try {
            int n2;
            int n3;
            byte[] byArray2 = new byte[7];
            byte[] byArray3 = new byte[7];
            int n4 = byArray.length;
            if (n4 > 7) {
                n4 = 7;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                byArray2[n3] = byArray[n3];
            }
            while (n3 < 7) {
                byArray2[n3] = 0;
                ++n3;
            }
            n4 = byArray.length;
            if (n4 > 14) {
                n4 = 14;
            }
            for (n3 = 7; n3 < n4; ++n3) {
                byArray3[n3 - 7] = byArray[n3];
            }
            while (n3 < 14) {
                byArray3[n3 - 7] = 0;
                ++n3;
            }
            byte[] byArray4 = this.encrypt(byArray2, ourMagicBytes);
            byte[] byArray5 = this.encrypt(byArray3, ourMagicBytes);
            byte[] byArray6 = new byte[21];
            for (n2 = 0; n2 < byArray4.length; ++n2) {
                byArray6[n2] = byArray4[n2];
            }
            for (n2 = 0; n2 < byArray5.length; ++n2) {
                byArray6[n2 + 8] = byArray5[n2];
            }
            for (n2 = 0; n2 < 5; ++n2) {
                byArray6[n2 + 16] = 0;
            }
            byte[] byArray7 = new byte[24];
            this.calcResp(byArray6, byArray7);
            byte[] byArray8 = byArray7;
            return byArray8;
        }
        finally {
            HTTPAuthentication.clear(cArray2);
            HTTPAuthentication.clear(byArray);
        }
    }

    private void calcResp(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3;
        byte[] byArray3 = new byte[7];
        byte[] byArray4 = new byte[7];
        byte[] byArray5 = new byte[7];
        for (n3 = 0; n3 < 7; ++n3) {
            byArray3[n3] = byArray[n3];
        }
        for (n3 = 0; n3 < 7; ++n3) {
            byArray4[n3] = byArray[n3 + 7];
        }
        for (n3 = 0; n3 < 7; ++n3) {
            byArray5[n3] = byArray[n3 + 14];
        }
        byte[] byArray6 = this.encrypt(byArray3, this.myNonce);
        byte[] byArray7 = this.encrypt(byArray4, this.myNonce);
        byte[] byArray8 = this.encrypt(byArray5, this.myNonce);
        for (n2 = 0; n2 < 8; ++n2) {
            byArray2[n2] = byArray6[n2];
        }
        for (n2 = 0; n2 < 8; ++n2) {
            byArray2[n2 + 8] = byArray7[n2];
        }
        for (n2 = 0; n2 < 8; ++n2) {
            byArray2[n2 + 16] = byArray8[n2];
        }
    }

    private byte[] encrypt(byte[] byArray, byte[] byArray2) {
        Cipher cipher = this.getCipher(byArray);
        try {
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Invalid block size for DES encryption: {0}", (Object)illegalBlockSizeException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        catch (BadPaddingException badPaddingException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Data not padded correctly for DES encryption: {0}", (Object)badPaddingException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return null;
    }

    private Cipher getCipher(byte[] byArray) {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            byArray = this.setupKey(byArray);
            cipher.init(1, new SecretKeySpec(byArray, "DES"));
            return cipher;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "DES encryption is not available: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        catch (InvalidKeyException invalidKeyException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Invalid key for DES encryption: {0}", (Object)invalidKeyException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "NoPadding option for DES is not available: {0}", (Object)noSuchPaddingException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return null;
    }

    private byte[] setupKey(byte[] byArray) {
        byte[] byArray2 = new byte[]{(byte)(byArray[0] >> 1 & 0xFF), (byte)(((byArray[0] & 1) << 6 | (byArray[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((byArray[1] & 3) << 5 | (byArray[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((byArray[2] & 7) << 4 | (byArray[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((byArray[3] & 0xF) << 3 | (byArray[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((byArray[4] & 0x1F) << 2 | (byArray[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((byArray[5] & 0x3F) << 1 | (byArray[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(byArray[6] & 0x7F)};
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = (byte)(byArray2[i2] << 1);
        }
        return byArray2;
    }

    public boolean allowPropmtForCredentials() {
        return true;
    }

    static {
        ourFlags.put(1L, "0x00000001 (Negotiate Unicode)");
        ourFlags.put(2L, "0x00000002 (Negotiate OEM)");
        ourFlags.put(4L, "0x00000004 (Request Target)");
        ourFlags.put(8L, "0x00000008 (Unknown)");
        ourFlags.put(16L, "0x00000010 (Negotiate Sign)");
        ourFlags.put(32L, "0x00000020 (Negotiate Seal)");
        ourFlags.put(64L, "0x00000040 (Negotiate Datagram Style)");
        ourFlags.put(128L, "0x00000080 (Negotiate Lan Manager Key)");
        ourFlags.put(256L, "0x00000100 (Negotiate Netware)");
        ourFlags.put(512L, "0x00000200 (Negotiate NTLM)");
        ourFlags.put(1024L, "0x00000400 (Unknown)");
        ourFlags.put(2048L, "0x00000800 (Unknown)");
        ourFlags.put(4096L, "0x00001000 (Negotiate Domain Supplied)");
        ourFlags.put(8192L, "0x00002000 (Negotiate Workstation Supplied)");
        ourFlags.put(16384L, "0x00004000 (Negotiate Local Call)");
        ourFlags.put(32768L, "0x00008000 (Negotiate Always Sign)");
        ourFlags.put(65536L, "0x00010000 (Target Type Domain)");
        ourFlags.put(131072L, "0x00020000 (Target Type Server)");
        ourFlags.put(262144L, "0x00040000 (Target Type Share)");
        ourFlags.put(524288L, "0x00080000 (Negotiate NTLM2 Key)");
        ourFlags.put(0x100000L, "0x00100000 (Request Init Response)");
        ourFlags.put(0x200000L, "0x00200000 (Request Accept Response)");
        ourFlags.put(0x400000L, "0x00400000 (Request Non-NT Session Key)");
        ourFlags.put(0x800000L, "0x00800000 (Negotiate Target Info)");
        ourFlags.put(0x1000000L, "0x01000000 (Unknown)");
        ourFlags.put(0x2000000L, "0x02000000 (Unknown)");
        ourFlags.put(0x4000000L, "0x04000000 (Unknown)");
        ourFlags.put(0x8000000L, "0x08000000 (Unknown)");
        ourFlags.put(0x10000000L, "0x10000000 (Unknown)");
        ourFlags.put(0x20000000L, "0x20000000 (Negotiate 128)");
        ourFlags.put(0x40000000L, "0x40000000 (Negotiate Key Exchange)");
        ourFlags.put(0x80000000L, "0x80000000 (Negotiate 56)");
        ourTargetInfoTypes = new TreeMap();
        ourTargetInfoTypes.put(1, "Server Name");
        ourTargetInfoTypes.put(2, "Domain Name");
        ourTargetInfoTypes.put(3, "DNS Host Name");
        ourTargetInfoTypes.put(4, "DNS Domain Name");
    }
}

