/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.InputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPParser;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPRequest;

public class HTTPHeader {
    public static final String CONNECTION_HEADER = "Connection";
    public static final String PROXY_CONNECTION_HEADER = "Proxy-Connection";
    public static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String PROXY_AUTHENTICATE_HEADER = "Proxy-Authenticate";
    public static final String LOCATION_HEADER = "Location";
    public static final String LOCK_OWNER_HEADER = "X-SVN-Lock-Owner";
    public static final String CREATION_DATE_HEADER = "X-SVN-Creation-Date";
    public static final String SVN_VERSION_NAME_HEADER = "X-SVN-Version-Name";
    public static final String SVN_OPTIONS_HEADER = "X-SVN-Options";
    public static final String TEXT_MD5 = "X-SVN-Result-Fulltext-MD5";
    public static final String BASE_MD5 = "X-SVN-Base-Fulltext-MD5";
    public static final String LOCK_TOKEN_HEADER = "Lock-Token";
    public static final String IF_HEADER = "If";
    public static final String DEPTH_HEADER = "Depth";
    public static final String LABEL_HEADER = "Label";
    public static final String DESTINATION_HEADER = "Destination";
    public static final String TIMEOUT_HEADER = "Timeout";
    public static final String DAV_HEADER = "DAV";
    public static final String SVN_DELTA_BASE_HEADER = "X-SVN-VR-Base";
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String CONTENT_RANGE_HEADER = "content-range";
    public static final String HOST_HEADER = "Host";
    public static final String NEW_URI_HEADER = "New-uri";
    public static final String OVERWRITE_HEADER = "Overwrite";
    public static final String SVNDIFF_MIME_TYPE = "application/vnd.svn-svndiff";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE = "Cookie";
    private Map myHeaders;

    public String toString() {
        if (this.myHeaders == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.myHeaders.keySet()) {
            Collection collection = (Collection)this.myHeaders.get(string);
            for (String string2 : collection) {
                stringBuffer.append(string);
                stringBuffer.append(": ");
                stringBuffer.append(string2);
                stringBuffer.append(HTTPRequest.CRLF);
            }
        }
        return stringBuffer.toString();
    }

    public void addHeaderValue(String string, String string2) {
        Map map = this.getHeaders();
        LinkedList<String> linkedList = (LinkedList<String>)map.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<String>();
            map.put(string, linkedList);
        }
        linkedList.add(string2);
    }

    public Map getRawHeaders() {
        return this.getHeaders();
    }

    public List getHeaderValues(String string) {
        if (this.myHeaders == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        for (String string2 : this.myHeaders.keySet()) {
            if (!string.equalsIgnoreCase(string2)) continue;
            linkedList.addAll((Collection)this.myHeaders.get(string2));
        }
        return linkedList.isEmpty() ? null : linkedList;
    }

    public String getFirstHeaderValue(String string) {
        LinkedList linkedList = (LinkedList)this.getHeaderValues(string);
        return linkedList != null ? (String)linkedList.getFirst() : null;
    }

    public boolean hasHeader(String string) {
        LinkedList linkedList = (LinkedList)this.getHeaderValues(string);
        return linkedList != null && !linkedList.isEmpty();
    }

    public void setHeaderValue(String string, String string2) {
        Map map = this.getHeaders();
        LinkedList<String> linkedList = (LinkedList<String>)map.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<String>();
            map.put(string, linkedList);
        } else {
            linkedList.clear();
        }
        linkedList.add(string2);
    }

    private Map getHeaders() {
        if (this.myHeaders == null) {
            this.myHeaders = new TreeMap();
        }
        return this.myHeaders;
    }

    public static HTTPHeader parseHeader(InputStream inputStream, String string) {
        String string2;
        HTTPHeader hTTPHeader = new HTTPHeader();
        String string3 = null;
        StringBuffer stringBuffer = null;
        while ((string2 = HTTPParser.readLine(inputStream, string)) != null && string2.trim().length() >= 1) {
            int n2;
            if (string2.charAt(0) == ' ' || string2.charAt(0) == '\t') {
                if (stringBuffer == null) continue;
                stringBuffer.append(' ');
                stringBuffer.append(string2.trim());
                continue;
            }
            if (string3 != null) {
                hTTPHeader.addHeaderValue(string3, stringBuffer != null ? stringBuffer.toString() : "");
            }
            if ((n2 = string2.indexOf(":")) < 0) {
                throw new ParseException("Unable to parse header: " + string2, 0);
            }
            string3 = string2.substring(0, n2).trim();
            stringBuffer = new StringBuffer(string2.substring(n2 + 1).trim());
        }
        if (string3 != null) {
            hTTPHeader.addHeaderValue(string3, stringBuffer != null ? stringBuffer.toString() : "");
        }
        return hTTPHeader;
    }
}

