/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

class HTTPDigestAuthentication
extends HTTPAuthentication {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String myCnonce;
    private String myQop;
    private String myLastNonce;
    private int myNC = 0;
    private String myCharset;

    protected HTTPDigestAuthentication(String string) {
        this.myCharset = string;
    }

    public void init() {
        Object object;
        String string = this.getChallengeParameter("qop");
        String string2 = null;
        if (string != null) {
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens() && !"auth".equals(string2 = ((StringTokenizer)object).nextToken().trim())) {
            }
        }
        if (string2 != null && !"auth".equals(string2)) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Digest HTTP auth: ''(0}'' is not supported", string2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        this.myQop = string2;
        this.myCnonce = this.createCnonce();
    }

    @Override
    public String authenticate() {
        if (this.getUserName() == null || this.getPassword() == null) {
            return null;
        }
        String string = this.getUserName();
        String string2 = this.getParameter("nonce");
        if (string2 == null || !string2.equals(this.myLastNonce)) {
            this.myNC = 0;
        }
        ++this.myNC;
        this.myLastNonce = string2;
        String string3 = this.createDigest(string, this.getPassword(), this.myCharset);
        String string4 = this.getParameter("uri");
        String string5 = this.getParameter("realm");
        String string6 = this.getParameter("opaque");
        String string7 = this.getParameter("algorithm", "MD5");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Digest ");
        stringBuffer.append("username=\"" + string + "\"").append(", realm=\"" + string5 + "\"").append(", nonce=\"" + string2 + "\"").append(", uri=\"" + string4 + "\"").append(", response=\"" + string3 + "\"");
        String string8 = HTTPDigestAuthentication.formatNC(this.myNC);
        if (this.myQop != null) {
            stringBuffer.append(", qop=\"" + this.myQop + "\"").append(", nc=" + string8).append(", cnonce=\"" + this.myCnonce + "\"");
        }
        if (string7 != null) {
            stringBuffer.append(", algorithm=\"" + string7 + "\"");
        }
        if (string6 != null) {
            stringBuffer.append(", opaque=\"" + string6 + "\"");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getAuthenticationScheme() {
        return "Digest";
    }

    private String createDigest(String string, char[] cArray, String string2) {
        StringBuffer stringBuffer;
        CharSequence charSequence;
        String string3;
        MessageDigest messageDigest;
        String string4 = "MD5";
        String string5 = this.getParameter("uri");
        String string6 = this.getParameter("realm");
        String string7 = this.getParameter("nonce");
        String string8 = this.getParameter("method");
        String string9 = this.getParameter("algorithm", "MD5");
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported algorithm in HTTP Digest authentication: ''{0}''", (Object)"MD5");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            return null;
        }
        char[] cArray2 = new char[string.length() + string6.length() + cArray.length + 2];
        System.arraycopy(string.toCharArray(), 0, cArray2, 0, string.length());
        cArray2[string.length()] = 58;
        System.arraycopy(string6.toCharArray(), 0, cArray2, string.length() + 1, string6.length());
        cArray2[string.length() + string6.length() + 1] = 58;
        System.arraycopy(cArray, 0, cArray2, string.length() + string6.length() + 2, cArray.length);
        char[] cArray3 = cArray2;
        if ("MD5-sess".equals(string9)) {
            string3 = HTTPDigestAuthentication.encode(messageDigest.digest(HTTPAuthentication.getBytes(cArray2, string2)));
            charSequence = new StringBuffer(string3.length() + string7.length() + this.myCnonce.length() + 2);
            ((StringBuffer)charSequence).append(string3);
            ((StringBuffer)charSequence).append(':');
            ((StringBuffer)charSequence).append(string7);
            ((StringBuffer)charSequence).append(':');
            ((StringBuffer)charSequence).append(this.myCnonce);
            cArray3 = ((StringBuffer)charSequence).toString().toCharArray();
        }
        string3 = HTTPDigestAuthentication.encode(messageDigest.digest(HTTPAuthentication.getBytes(cArray3, string2)));
        charSequence = string8 + ":" + string5;
        String string10 = HTTPDigestAuthentication.encode(messageDigest.digest(HTTPAuthentication.getBytes((String)charSequence, string2)));
        HTTPAuthentication.clear(cArray2);
        if (this.myQop == null) {
            stringBuffer = new StringBuffer(string3.length() + string7.length() + string10.length());
            stringBuffer.append(string3);
            stringBuffer.append(':');
            stringBuffer.append(string7);
            stringBuffer.append(':');
            stringBuffer.append(string10);
        } else {
            String string11 = "auth";
            String string12 = HTTPDigestAuthentication.formatNC(this.myNC);
            stringBuffer = new StringBuffer(string3.length() + string7.length() + string12.length() + this.myCnonce.length() + string11.length() + string10.length() + 5);
            stringBuffer.append(string3);
            stringBuffer.append(':');
            stringBuffer.append(string7);
            stringBuffer.append(':');
            stringBuffer.append(string12);
            stringBuffer.append(':');
            stringBuffer.append(this.myCnonce);
            stringBuffer.append(':');
            stringBuffer.append(string11);
            stringBuffer.append(':');
            stringBuffer.append(string10);
        }
        return HTTPDigestAuthentication.encode(messageDigest.digest(HTTPAuthentication.getBytes(stringBuffer.toString(), string2)));
    }

    private String getParameter(String string) {
        return this.getParameter(string, null);
    }

    private String getParameter(String string, String string2) {
        String string3 = this.getChallengeParameter(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private String createCnonce() {
        MessageDigest messageDigest;
        String string = "MD5";
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        String string2 = Long.toString(System.currentTimeMillis());
        string2 = HTTPDigestAuthentication.encode(messageDigest.digest(HTTPAuthentication.getBytes(string2, this.myCharset)));
        return string2;
    }

    private static String encode(byte[] byArray) {
        if (byArray.length != 16) {
            return null;
        }
        char[] cArray = new char[32];
        for (int i2 = 0; i2 < 16; ++i2) {
            int n2 = byArray[i2] & 0xF;
            int n3 = (byArray[i2] & 0xF0) >> 4;
            cArray[i2 * 2] = HEXADECIMAL[n3];
            cArray[i2 * 2 + 1] = HEXADECIMAL[n2];
        }
        return new String(cArray);
    }

    private static String formatNC(int n2) {
        String string = Integer.toHexString(n2);
        int n3 = 8 - string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            string = '0' + string;
        }
        return string;
    }
}

