/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManagerExt;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNProxyManagerEx;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVErrorHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection$1;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPDigestAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNegotiateAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPParser;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPRequest;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPSSLKeyManager;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.SpoolFile;
import org.tmatesoft.svn.core.internal.io.dav.http.XMLReader;
import org.tmatesoft.svn.core.internal.util.ChunkedInputStream;
import org.tmatesoft.svn.core.internal.util.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil$CertificateDoesNotConformConstraints;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil$CertificateNotTrustedException;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream$IOCancelException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HTTPConnection
implements IHTTPConnection {
    private static final DefaultHandler DEFAULT_SAX_HANDLER = new DefaultHandler();
    private static EntityResolver NO_ENTITY_RESOLVER = new HTTPConnection$1();
    private static final int requestAttempts;
    private static final int DEFAULT_HTTP_TIMEOUT = 3600000;
    private static SAXParserFactory ourSAXParserFactory;
    private static final Map emptyHeader;
    private byte[] myBuffer;
    private SAXParser mySAXParser;
    private SVNURL myHost;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private Socket mySocket;
    private SVNRepository myRepository;
    private boolean myIsSecured;
    private boolean myIsProxied;
    private boolean myLogSSLParams;
    private SVNAuthentication myLastValidAuth;
    private HTTPAuthentication myChallengeCredentials;
    private HTTPAuthentication myProxyAuthentication;
    private boolean myIsSpoolResponse;
    private TrustManager myTrustManager;
    private HTTPSSLKeyManager myKeyManager;
    private String myCharset;
    private boolean myIsSpoolAll;
    private File mySpoolDirectory;
    private long myNextRequestTimeout;
    private int myRequestCount;
    private HTTPStatus myLastStatus;

    public HTTPConnection(SVNRepository sVNRepository, String string, File file, boolean bl2) {
        this.myRepository = sVNRepository;
        this.myCharset = string;
        this.myHost = sVNRepository.getLocation().setPath("", false);
        this.myIsSecured = "https".equalsIgnoreCase(this.myHost.getProtocol());
        this.myIsSpoolAll = bl2;
        this.mySpoolDirectory = file;
        this.myNextRequestTimeout = Long.MAX_VALUE;
    }

    @Override
    public HTTPStatus getLastStatus() {
        return this.myLastStatus;
    }

    public SVNURL getHost() {
        return this.myHost;
    }

    private void connect(HTTPSSLKeyManager hTTPSSLKeyManager, TrustManager trustManager, ISVNProxyManager iSVNProxyManager) {
        SVNURL sVNURL = this.myRepository.getLocation();
        if (this.mySocket == null || SVNSocketFactory.isSocketStale(this.mySocket)) {
            int n2;
            this.close();
            String string = sVNURL.getHost();
            int n3 = sVNURL.getPort();
            ISVNAuthenticationManager iSVNAuthenticationManager = this.myRepository.getAuthenticationManager();
            int n4 = iSVNAuthenticationManager != null ? iSVNAuthenticationManager.getConnectTimeout(this.myRepository) : 0;
            int n5 = n2 = iSVNAuthenticationManager != null ? iSVNAuthenticationManager.getReadTimeout(this.myRepository) : 3600000;
            if (n2 < 0) {
                n2 = 3600000;
            }
            if (iSVNProxyManager != null && iSVNProxyManager.getProxyHost() != null) {
                ISVNDebugLog iSVNDebugLog = this.myRepository.getDebugLog();
                iSVNDebugLog.logFine(SVNLogType.NETWORK, "Using proxy " + iSVNProxyManager.getProxyHost() + " (secured=" + this.myIsSecured + ")");
                this.mySocket = SVNSocketFactory.createPlainSocket(iSVNProxyManager.getProxyHost(), iSVNProxyManager.getProxyPort(), n4, n2, this.myRepository.getCanceller());
                this.myIsProxied = true;
                if (this.myIsSecured) {
                    int n6 = 0;
                    boolean bl2 = false;
                    while (true) {
                        Object object;
                        Object object2;
                        Object object3;
                        if (this.mySocket == null) {
                            this.mySocket = SVNSocketFactory.createPlainSocket(iSVNProxyManager.getProxyHost(), iSVNProxyManager.getProxyPort(), n4, n2, this.myRepository.getCanceller());
                            iSVNDebugLog.logFine(SVNLogType.NETWORK, "proxy connection reopened");
                        }
                        HTTPRequest hTTPRequest = new HTTPRequest(this.myCharset);
                        hTTPRequest.setConnection(this);
                        if (this.myProxyAuthentication != null) {
                            object3 = this.myProxyAuthentication.authenticate();
                            hTTPRequest.setProxyAuthentication((String)object3);
                            iSVNDebugLog.logFine(SVNLogType.NETWORK, "auth token set: " + (String)object3);
                        }
                        hTTPRequest.setForceProxyAuth(true);
                        hTTPRequest.dispatch("CONNECT", string + ":" + n3, null, 0, 0, null);
                        object3 = hTTPRequest.getStatus();
                        if (((HTTPStatus)object3).getCode() == 200) {
                            KeyManager[] keyManagerArray;
                            this.myInputStream = null;
                            this.myOutputStream = null;
                            this.myProxyAuthentication = null;
                            if (hTTPSSLKeyManager != null) {
                                KeyManager[] keyManagerArray2 = new KeyManager[1];
                                keyManagerArray = keyManagerArray2;
                                keyManagerArray2[0] = hTTPSSLKeyManager;
                            } else {
                                keyManagerArray = new KeyManager[]{};
                            }
                            this.mySocket = SVNSocketFactory.createSSLSocket(keyManagerArray, trustManager, string, n3, this.mySocket, n2);
                            iSVNProxyManager.acknowledgeProxyContext(true, null);
                            return;
                        }
                        if (((HTTPStatus)object3).getCode() == 407) {
                            Object object4;
                            if (HTTPConnection.hasToCloseConnection(hTTPRequest.getResponseHeader())) {
                                this.close();
                                iSVNDebugLog.logFine(SVNLogType.NETWORK, "Connection closed as requested by the response header");
                            }
                            iSVNDebugLog.logFine(SVNLogType.NETWORK, "authentication attempt #" + ++n6);
                            object2 = hTTPRequest.getResponseHeader().getHeaderValues("Proxy-Authenticate");
                            object = null;
                            if (iSVNAuthenticationManager != null && iSVNAuthenticationManager instanceof DefaultSVNAuthenticationManager) {
                                object4 = (DefaultSVNAuthenticationManager)iSVNAuthenticationManager;
                                object = ((DefaultSVNAuthenticationManager)object4).getAuthTypes(this.myRepository.getLocation());
                                iSVNDebugLog.logFine(SVNLogType.NETWORK, "authentication methods supported: " + object);
                            }
                            try {
                                this.myProxyAuthentication = HTTPAuthentication.parseAuthParameters((Collection)object2, this.myProxyAuthentication, this.myCharset, (Collection)object, null, this.myRequestCount);
                            }
                            catch (SVNException sVNException) {
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, sVNException);
                                this.close();
                                throw sVNException;
                            }
                            iSVNDebugLog.logFine(SVNLogType.NETWORK, "authentication type chosen: " + this.myProxyAuthentication.getClass().getSimpleName());
                            hTTPRequest.initCredentials(this.myProxyAuthentication, "CONNECT", string + ":" + n3);
                            object4 = null;
                            HTTPNegotiateAuthentication hTTPNegotiateAuthentication = null;
                            if (this.myProxyAuthentication instanceof HTTPNTLMAuthentication) {
                                object4 = (HTTPNTLMAuthentication)this.myProxyAuthentication;
                                if (((HTTPNTLMAuthentication)object4).isInType3State()) {
                                    iSVNDebugLog.logFine(SVNLogType.NETWORK, "continuation of NTLM authentication");
                                    continue;
                                }
                            } else if (this.myProxyAuthentication instanceof HTTPNegotiateAuthentication && (hTTPNegotiateAuthentication = (HTTPNegotiateAuthentication)this.myProxyAuthentication).isStarted()) {
                                iSVNDebugLog.logFine(SVNLogType.NETWORK, "continuation of Negotiate authentication");
                                continue;
                            }
                            if (object4 != null && n6 == 1 && !((HTTPNTLMAuthentication)object4).allowPropmtForCredentials()) continue;
                            if (hTTPNegotiateAuthentication != null && !hTTPNegotiateAuthentication.needsLogin()) {
                                iSVNDebugLog.logFine(SVNLogType.NETWORK, "Negotiate will use existing credentials");
                                continue;
                            }
                            if (!bl2) {
                                this.myProxyAuthentication.setCredentials(SVNPasswordAuthentication.newInstance(iSVNProxyManager.getProxyUserName(), this.getProxyPasswordValue(iSVNProxyManager), false, this.myRepository.getLocation(), false));
                                iSVNDebugLog.logFine(SVNLogType.NETWORK, "explicit credentials set");
                                bl2 = true;
                                continue;
                            }
                            iSVNDebugLog.logFine(SVNLogType.NETWORK, "no more credentials to try");
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "HTTP proxy authorization failed");
                            if (iSVNProxyManager != null) {
                                iSVNProxyManager.acknowledgeProxyContext(false, sVNErrorMessage);
                            }
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                            continue;
                        }
                        object2 = SVNURL.parseURIEncoded("http://" + iSVNProxyManager.getProxyHost() + ":" + iSVNProxyManager.getProxyPort());
                        object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} request failed on ''{1}''", "CONNECT", object2);
                        iSVNProxyManager.acknowledgeProxyContext(false, (SVNErrorMessage)object);
                        SVNErrorManager.error((SVNErrorMessage)object, hTTPRequest.getErrorMessage(), SVNLogType.NETWORK);
                    }
                }
                if (iSVNProxyManager.getProxyUserName() != null && this.getProxyPasswordValue(iSVNProxyManager) != null) {
                    this.myProxyAuthentication = new HTTPBasicAuthentication("UTF-8");
                    this.myProxyAuthentication.setCredentials(SVNPasswordAuthentication.newInstance(iSVNProxyManager.getProxyUserName(), this.getProxyPasswordValue(iSVNProxyManager), false, this.myRepository.getLocation(), false));
                    iSVNDebugLog.logFine(SVNLogType.NETWORK, "explicit credentials set");
                }
            } else {
                Socket socket;
                this.myIsProxied = false;
                this.myProxyAuthentication = null;
                if (this.myIsSecured) {
                    KeyManager[] keyManagerArray;
                    if (hTTPSSLKeyManager != null) {
                        KeyManager[] keyManagerArray3 = new KeyManager[1];
                        keyManagerArray = keyManagerArray3;
                        keyManagerArray3[0] = hTTPSSLKeyManager;
                    } else {
                        keyManagerArray = new KeyManager[]{};
                    }
                    socket = SVNSocketFactory.createSSLSocket(keyManagerArray, trustManager, string, n3, n4, n2, this.myRepository.getCanceller());
                } else {
                    socket = SVNSocketFactory.createPlainSocket(string, n3, n4, n2, this.myRepository.getCanceller());
                }
                this.mySocket = socket;
                this.myLogSSLParams = true;
            }
        }
    }

    private char[] getProxyPasswordValue(ISVNProxyManager iSVNProxyManager) {
        if (iSVNProxyManager == null) {
            return null;
        }
        if (iSVNProxyManager instanceof ISVNProxyManagerEx) {
            return ((ISVNProxyManagerEx)iSVNProxyManager).getProxyPasswordValue();
        }
        String string = iSVNProxyManager.getProxyPassword();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    public void readHeader(HTTPRequest hTTPRequest) {
        InputStream inputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.getInputStream());
        try {
            HTTPStatus hTTPStatus = HTTPParser.parseStatus(inputStream, this.myCharset);
            HTTPHeader hTTPHeader = HTTPHeader.parseHeader(inputStream, this.myCharset);
            hTTPRequest.setStatus(hTTPStatus);
            hTTPRequest.setResponseHeader(hTTPHeader);
        }
        catch (ParseException parseException) {
            String string = HTTPParser.readLine(inputStream, this.myCharset);
            while (string != null && string.length() > 0) {
                string = HTTPParser.readLine(inputStream, this.myCharset);
            }
            throw new IOException(parseException.getMessage());
        }
        finally {
            this.myRepository.getDebugLog().flushStream(inputStream);
        }
    }

    public SVNErrorMessage readError(HTTPRequest hTTPRequest, String string, String string2) {
        DAVErrorHandler dAVErrorHandler = new DAVErrorHandler();
        try {
            this.readData(hTTPRequest, string, string2, (DefaultHandler)dAVErrorHandler);
        }
        catch (IOException iOException) {
            return null;
        }
        return dAVErrorHandler.getErrorMessage();
    }

    public void sendData(byte[] byArray) {
        try {
            this.getOutputStream().write(byArray, 0, byArray.length);
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(InputStream inputStream, long l2) {
        try {
            byte[] byArray = this.getBuffer();
            while (l2 > 0L) {
                int n2 = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, l2));
                if (n2 > 0) {
                    l2 -= (long)n2;
                    this.getOutputStream().write(byArray, 0, n2);
                    continue;
                }
                if (n2 >= 0) continue;
                break;
            }
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    @Override
    public SVNAuthentication getLastValidCredentials() {
        return this.myLastValidAuth;
    }

    @Override
    public void clearAuthenticationCache() {
        this.clearLastValidAuth();
        this.myTrustManager = null;
        this.myKeyManager = null;
        this.myChallengeCredentials = null;
        this.myProxyAuthentication = null;
        this.myRequestCount = 0;
    }

    private void clearLastValidAuth() {
        if (this.myLastValidAuth != null) {
            this.myLastValidAuth.dismissSensitiveData();
        }
        this.myLastValidAuth = null;
    }

    @Override
    public HTTPStatus request(String string, String string2, HTTPHeader hTTPHeader, StringBuffer stringBuffer, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler) {
        return this.request(string, string2, hTTPHeader, stringBuffer, n2, n3, outputStream, defaultHandler, null);
    }

    @Override
    public HTTPStatus request(String string, String string2, HTTPHeader hTTPHeader, StringBuffer stringBuffer, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler, SVNErrorMessage sVNErrorMessage) {
        byte[] byArray = null;
        if (stringBuffer != null) {
            try {
                byArray = stringBuffer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = stringBuffer.toString().getBytes();
            }
        }
        return this.request(string, string2, hTTPHeader, byArray != null ? new ByteArrayInputStream(byArray) : null, n2, n3, outputStream, defaultHandler, sVNErrorMessage);
    }

    @Override
    public HTTPStatus request(String string, String string2, HTTPHeader hTTPHeader, InputStream inputStream, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler) {
        return this.request(string, string2, hTTPHeader, inputStream, n2, n3, outputStream, defaultHandler, null);
    }

    @Override
    public HTTPStatus request(String string, String string2, HTTPHeader hTTPHeader, InputStream inputStream, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler, SVNErrorMessage sVNErrorMessage) {
        SVNErrorMessage sVNErrorMessage2;
        block93: {
            HTTPRequest hTTPRequest;
            String string3;
            SVNAuthentication sVNAuthentication;
            ISVNProxyManager iSVNProxyManager;
            TrustManager trustManager;
            ISVNAuthenticationManager iSVNAuthenticationManager;
            block94: {
                boolean bl2;
                this.myLastStatus = null;
                ++this.myRequestCount;
                if ("".equals(string2) || string2 == null) {
                    string2 = "/";
                }
                iSVNAuthenticationManager = this.myRepository.getAuthenticationManager();
                HTTPSSLKeyManager hTTPSSLKeyManager = this.myKeyManager == null && iSVNAuthenticationManager != null ? this.createKeyManager() : this.myKeyManager;
                trustManager = this.myTrustManager == null && iSVNAuthenticationManager != null ? iSVNAuthenticationManager.getTrustManager(this.myRepository.getLocation()) : this.myTrustManager;
                iSVNProxyManager = iSVNAuthenticationManager != null ? iSVNAuthenticationManager.getProxyManager(this.myRepository.getLocation()) : null;
                String string4 = this.composeRealm("");
                sVNAuthentication = this.myLastValidAuth;
                boolean bl3 = bl2 = iSVNAuthenticationManager != null ? iSVNAuthenticationManager.isAuthenticationForced() : false;
                if (sVNAuthentication == null && bl2) {
                    sVNAuthentication = iSVNAuthenticationManager.getFirstAuthentication("svn.simple", string4, null);
                    this.myChallengeCredentials = new HTTPBasicAuthentication((SVNPasswordAuthentication)sVNAuthentication, this.myCharset);
                }
                string3 = null;
                hTTPRequest = new HTTPRequest(this.myCharset);
                hTTPRequest.setConnection(this);
                hTTPRequest.setKeepAlive(true);
                hTTPRequest.setRequestBody(inputStream);
                hTTPRequest.setResponseHandler(defaultHandler);
                hTTPRequest.setResponseStream(outputStream);
                sVNErrorMessage2 = null;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                int n4 = 0;
                while (true) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    if (this.myNextRequestTimeout < 0L || System.currentTimeMillis() >= this.myNextRequestTimeout) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Keep-Alive timeout detected");
                        this.close();
                        if (this.isClearCredentialsOnClose(this.myChallengeCredentials)) {
                            sVNAuthentication = null;
                        }
                    }
                    int n5 = 1;
                    try {
                        sVNErrorMessage2 = null;
                        object5 = null;
                        object4 = null;
                        object3 = null;
                        try {
                            object3 = new URI(this.myRepository.getLocation().toString());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            this.myRepository.getDebugLog().logError(SVNLogType.NETWORK, uRISyntaxException);
                        }
                        while (n5 >= 0) {
                            this.connect(hTTPSSLKeyManager, trustManager, iSVNProxyManager);
                            hTTPRequest.reset();
                            hTTPRequest.setProxied(this.myIsProxied);
                            hTTPRequest.setSecured(this.myIsSecured);
                            if (this.myProxyAuthentication != null && (bl5 || !"NTLM".equals(this.myProxyAuthentication.getAuthenticationScheme()))) {
                                if (object4 == null) {
                                    hTTPRequest.initCredentials(this.myProxyAuthentication, string, string2);
                                    object4 = this.myProxyAuthentication.authenticate();
                                }
                                hTTPRequest.setProxyAuthentication((String)object4);
                            }
                            if (this.myChallengeCredentials != null && (bl4 || bl6 || !"NTLM".equals(this.myChallengeCredentials.getAuthenticationScheme()) && !"Negotiate".equals(this.myChallengeCredentials.getAuthenticationScheme()) && sVNAuthentication != null)) {
                                if (object5 == null) {
                                    hTTPRequest.initCredentials(this.myChallengeCredentials, string, string2);
                                    object5 = this.myChallengeCredentials.authenticate();
                                }
                                hTTPRequest.setAuthentication((String)object5);
                            }
                            if ((object2 = CookieHandler.getDefault()) != null && object3 != null && (object = ((CookieHandler)object2).get((URI)object3, emptyHeader)) != null) {
                                hTTPRequest.setCookies((Map)object);
                            }
                            if (this.mySocket instanceof SSLSocket && this.myLogSSLParams && (object = ((SSLSocket)this.mySocket).getSession()) != null) {
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, "Connected to " + this.myRepository.getLocation() + " using " + object.getProtocol());
                                this.myLogSSLParams = false;
                            }
                            try {
                                hTTPRequest.dispatch(string, string2, hTTPHeader, n2, n3, sVNErrorMessage);
                                break;
                            }
                            catch (EOFException eOFException) {
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, eOFException);
                                if (n5 > 0) {
                                    this.close();
                                    continue;
                                }
                                throw (IOException)new IOException(eOFException.getMessage()).initCause(eOFException);
                            }
                            catch (SocketException socketException) {
                                if (!"Broken pipe".equals(socketException.getMessage())) {
                                    throw socketException;
                                }
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, socketException);
                                if (n5 > 0) {
                                    this.close();
                                    continue;
                                }
                                throw (SocketException)new SocketException(socketException.getMessage()).initCause(socketException);
                            }
                            finally {
                                --n5;
                            }
                        }
                        if ((object2 = CookieHandler.getDefault()) != null && object3 != null) {
                            ((CookieHandler)object2).put((URI)object3, hTTPRequest.getResponseHeader().getRawHeaders());
                        }
                        this.myNextRequestTimeout = hTTPRequest.getNextRequestTimeout();
                        this.myLastStatus = hTTPRequest.getStatus();
                        this.myLastStatus.setHeader(hTTPRequest.getResponseHeader());
                    }
                    catch (SSLHandshakeException sSLHandshakeException) {
                        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, sSLHandshakeException);
                        this.close();
                        if (sSLHandshakeException.getCause() instanceof SVNSSLUtil$CertificateNotTrustedException || sSLHandshakeException.getCause() instanceof SVNSSLUtil$CertificateDoesNotConformConstraints) {
                            SVNErrorManager.cancel(sSLHandshakeException.getCause().getMessage(), SVNLogType.NETWORK);
                        }
                        SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "SSL handshake failed: ''{0}''", new Object[]{sSLHandshakeException.getMessage()}, 0, sSLHandshakeException);
                        if (hTTPSSLKeyManager != null && hTTPSSLKeyManager.isInitialized()) {
                            hTTPSSLKeyManager.acknowledgeAndClearAuthentication(sVNErrorMessage3);
                        } else {
                            sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "SSL handshake failed: ''{0}''", new Object[]{sSLHandshakeException.getMessage()}, 0, sSLHandshakeException);
                            SVNErrorManager.error(sVNErrorMessage3, SVNLogType.NETWORK);
                        }
                        sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, sSLHandshakeException);
                        continue;
                    }
                    catch (IOException iOException) {
                        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, iOException);
                        if (iOException instanceof SocketTimeoutException) {
                            sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "timed out waiting for server", null, 0, iOException);
                        } else if (iOException instanceof UnknownHostException) {
                            sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "unknown host", null, 0, iOException);
                        } else if (iOException instanceof ConnectException) {
                            sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "connection refused by the server", null, 0, iOException);
                        } else if (iOException instanceof SVNCancellableOutputStream$IOCancelException) {
                            SVNErrorManager.cancel(iOException.getMessage(), SVNLogType.NETWORK);
                        } else {
                            sVNErrorMessage2 = iOException instanceof SSLException ? SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, iOException) : SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, iOException);
                        }
                    }
                    catch (SVNException sVNException) {
                        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, sVNException);
                        this.close();
                        throw sVNException;
                    }
                    finally {
                        this.finishResponse(hTTPRequest);
                        continue;
                    }
                    if (sVNErrorMessage2 != null) {
                        if (iSVNProxyManager != null) {
                            iSVNProxyManager.acknowledgeProxyContext(false, sVNErrorMessage2);
                        }
                        this.close();
                        break block93;
                    }
                    if (iSVNProxyManager != null) {
                        iSVNProxyManager.acknowledgeProxyContext(true, sVNErrorMessage2);
                    }
                    if (hTTPSSLKeyManager != null) {
                        this.myKeyManager = hTTPSSLKeyManager;
                        this.myTrustManager = trustManager;
                        hTTPSSLKeyManager.acknowledgeAndClearAuthentication(null);
                    }
                    if (this.myLastStatus.getCode() == 403) {
                        if (sVNAuthentication != null && iSVNAuthenticationManager != null) {
                            BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.simple", string3, hTTPRequest.getErrorMessage(), sVNAuthentication, this.myRepository.getLocation(), iSVNAuthenticationManager);
                        }
                        this.clearLastValidAuth();
                        this.close();
                        sVNErrorMessage2 = hTTPRequest.getErrorMessage();
                        break block94;
                    }
                    if (this.myIsProxied && this.myLastStatus.getCode() == 407) {
                        object5 = hTTPRequest.getResponseHeader().getHeaderValues("Proxy-Authenticate");
                        object4 = null;
                        if (iSVNAuthenticationManager != null && iSVNAuthenticationManager instanceof DefaultSVNAuthenticationManager) {
                            object3 = (DefaultSVNAuthenticationManager)iSVNAuthenticationManager;
                            object4 = ((DefaultSVNAuthenticationManager)object3).getAuthTypes(this.myRepository.getLocation());
                        }
                        try {
                            this.myProxyAuthentication = HTTPAuthentication.parseAuthParameters((Collection)object5, this.myProxyAuthentication, this.myCharset, (Collection)object4, null, this.myRequestCount);
                        }
                        catch (SVNException sVNException) {
                            this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, sVNException);
                            sVNErrorMessage2 = sVNException.getErrorMessage();
                            break block93;
                        }
                        if (this.myProxyAuthentication instanceof HTTPNTLMAuthentication) {
                            bl5 = true;
                            object3 = (HTTPNTLMAuthentication)this.myProxyAuthentication;
                            if (((HTTPNTLMAuthentication)object3).isInType3State()) continue;
                        }
                        sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "HTTP proxy authorization failed");
                        if (iSVNProxyManager != null) {
                            iSVNProxyManager.acknowledgeProxyContext(false, sVNErrorMessage2);
                        }
                        this.close();
                        break block93;
                    }
                    if (this.myLastStatus.getCode() == 401) {
                        ++n4;
                        object5 = hTTPRequest.getResponseHeader().getHeaderValues("WWW-Authenticate");
                        if (object5 == null || object5.size() == 0) {
                            sVNErrorMessage2 = hTTPRequest.getErrorMessage();
                            this.myLastStatus.setError(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, sVNErrorMessage2.getMessageTemplate(), sVNErrorMessage2.getRelatedObjects()));
                            if ("LOCK".equalsIgnoreCase(string)) {
                                this.myLastStatus.getError().setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Probably you are trying to lock file in repository that only allows anonymous access"));
                            }
                            SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
                            return this.myLastStatus;
                        }
                        boolean bl7 = false;
                        boolean bl8 = bl2 = iSVNAuthenticationManager != null ? iSVNAuthenticationManager.isAuthenticationForced() : false;
                        if (bl2 && sVNAuthentication != null && this.myChallengeCredentials != null && !HTTPAuthentication.isSchemeSupportedByServer(this.myChallengeCredentials.getAuthenticationScheme(), (Collection)object5)) {
                            bl7 = true;
                        }
                        object3 = null;
                        if (iSVNAuthenticationManager != null && iSVNAuthenticationManager instanceof DefaultSVNAuthenticationManager) {
                            object2 = (DefaultSVNAuthenticationManager)iSVNAuthenticationManager;
                            object3 = ((DefaultSVNAuthenticationManager)object2).getAuthTypes(this.myRepository.getLocation());
                        }
                        try {
                            this.myChallengeCredentials = HTTPAuthentication.parseAuthParameters((Collection)object5, this.myChallengeCredentials, this.myCharset, (Collection)object3, iSVNAuthenticationManager, this.myRequestCount);
                        }
                        catch (SVNException sVNException) {
                            sVNErrorMessage2 = sVNException.getErrorMessage();
                            break block93;
                        }
                        this.myChallengeCredentials.setChallengeParameter("method", string);
                        this.myChallengeCredentials.setChallengeParameter("uri", HTTPParser.getCanonicalPath(string2, null).toString());
                        if (bl7) {
                            this.close();
                            continue;
                        }
                        object2 = null;
                        object = null;
                        if (this.myChallengeCredentials instanceof HTTPNTLMAuthentication) {
                            bl4 = true;
                            object2 = (HTTPNTLMAuthentication)this.myChallengeCredentials;
                            if (((HTTPNTLMAuthentication)object2).isInType3State()) {
                                continue;
                            }
                        } else if (this.myChallengeCredentials instanceof HTTPDigestAuthentication) {
                            if (this.myLastValidAuth != null) {
                                this.clearLastValidAuth();
                                continue;
                            }
                        } else if (this.myChallengeCredentials instanceof HTTPNegotiateAuthentication) {
                            bl6 = true;
                            object = (HTTPNegotiateAuthentication)this.myChallengeCredentials;
                            if (((HTTPNegotiateAuthentication)object).isStarted()) continue;
                        }
                        this.clearLastValidAuth();
                        if (object2 != null && n4 == 1) {
                            if (!((HTTPNTLMAuthentication)object2).allowPropmtForCredentials()) continue;
                            sVNAuthentication = null;
                        }
                        if (object != null) {
                            if (!((HTTPNegotiateAuthentication)object).needsLogin()) continue;
                            sVNAuthentication = null;
                        }
                        if (iSVNAuthenticationManager == null) {
                            sVNErrorMessage2 = hTTPRequest.getErrorMessage();
                            break block93;
                        }
                        string3 = this.myChallengeCredentials.getChallengeParameter("realm");
                        string3 = string3 == null ? "" : " " + string3;
                        string3 = this.composeRealm(string3);
                        if (sVNAuthentication == null) {
                            sVNAuthentication = iSVNAuthenticationManager.getFirstAuthentication("svn.simple", string3, this.myRepository.getLocation());
                        } else if (n4 >= requestAttempts) {
                            BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.simple", string3, hTTPRequest.getErrorMessage(), sVNAuthentication, this.myRepository.getLocation(), iSVNAuthenticationManager);
                            sVNAuthentication = iSVNAuthenticationManager.getNextAuthentication("svn.simple", string3, this.myRepository.getLocation());
                        }
                        if (sVNAuthentication == null) {
                            sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.CANCELLED, new SVNCancelException(SVNErrorMessage.create(SVNErrorCode.CANCELLED, "ISVNAuthentication provider did not provide credentials; HTTP authorization cancelled.")));
                            break block93;
                        }
                        if (sVNAuthentication == null) continue;
                        this.myChallengeCredentials.setCredentials((SVNPasswordAuthentication)sVNAuthentication);
                        continue;
                    }
                    if (this.myLastStatus.getCode() != 301 && this.myLastStatus.getCode() != 302) break;
                    object5 = hTTPRequest.getResponseHeader().getFirstHeaderValue("Location");
                    if (object5 != null) {
                        int n6 = ((String)object5).indexOf("://");
                        if (n6 > 0) {
                            n6 += 3;
                            n6 = ((String)object5).indexOf("/", n6);
                        }
                        if (n6 > 0 && n6 < ((String)object5).length() && ((String)(object3 = ((String)object5).substring(n6))).endsWith("/") && !((String)object3).endsWith("//") && !string2.endsWith("/") && ((String)object3).substring(0, ((String)object3).length() - 1).equals(string2)) {
                            string2 = string2 + "//";
                            continue;
                        }
                    }
                    break block94;
                    break;
                }
                if (hTTPRequest.getErrorMessage() != null) {
                    sVNErrorMessage2 = hTTPRequest.getErrorMessage();
                } else {
                    bl5 = false;
                    bl4 = false;
                    bl6 = false;
                }
            }
            if (sVNErrorMessage2 == null) {
                if (this.myIsProxied && iSVNProxyManager != null) {
                    iSVNProxyManager.acknowledgeProxyContext(true, null);
                }
                if (sVNAuthentication != null && string3 != null && iSVNAuthenticationManager != null) {
                    BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.simple", string3, null, sVNAuthentication, this.myRepository.getLocation(), iSVNAuthenticationManager);
                }
                if (trustManager != null && iSVNAuthenticationManager != null) {
                    iSVNAuthenticationManager.acknowledgeTrustManager(trustManager);
                }
                if (sVNAuthentication != null) {
                    this.myLastValidAuth = sVNAuthentication.copy();
                }
                if (this.myLastStatus.getCodeClass() == 2 && iSVNAuthenticationManager instanceof ISVNAuthenticationManagerExt) {
                    ((ISVNAuthenticationManagerExt)iSVNAuthenticationManager).acknowledgeConnectionSuccessful(this.myRepository.getLocation(), string);
                }
                this.myLastStatus.setHeader(hTTPRequest.getResponseHeader());
                return this.myLastStatus;
            }
        }
        this.close();
        if (sVNErrorMessage2 != null && sVNErrorMessage2.getErrorCode().getCategory() != 175000 && sVNErrorMessage2.getErrorCode() != SVNErrorCode.UNSUPPORTED_FEATURE) {
            SVNErrorManager.error(sVNErrorMessage2, SVNLogType.NETWORK);
        }
        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, new Exception(sVNErrorMessage2.getMessage()));
        SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} request failed on ''{1}''", new Object[]{string, string2}, sVNErrorMessage2.getType(), sVNErrorMessage2.getCause());
        SVNErrorManager.error(sVNErrorMessage2, sVNErrorMessage4, SVNLogType.NETWORK);
        return null;
    }

    private String composeRealm(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.myHost.getProtocol());
        stringBuffer.append("://");
        if (this.myHost.getUserInfo() != null && !"".equals(this.myHost.getUserInfo().trim())) {
            stringBuffer.append(this.myHost.getUserInfo());
            stringBuffer.append("@");
        }
        stringBuffer.append(this.myHost.getHost());
        stringBuffer.append(":");
        stringBuffer.append(this.myHost.getPort());
        stringBuffer.append(">");
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private boolean isClearCredentialsOnClose(HTTPAuthentication hTTPAuthentication) {
        return !(hTTPAuthentication instanceof HTTPBasicAuthentication) && !(hTTPAuthentication instanceof HTTPDigestAuthentication) && !(hTTPAuthentication instanceof HTTPNegotiateAuthentication);
    }

    private HTTPSSLKeyManager createKeyManager() {
        if (!this.myIsSecured) {
            return null;
        }
        SVNURL sVNURL = this.myRepository.getLocation();
        ISVNAuthenticationManager iSVNAuthenticationManager = this.myRepository.getAuthenticationManager();
        String string = "<" + sVNURL.getProtocol() + "://" + sVNURL.getHost() + ":" + sVNURL.getPort() + ">";
        return new HTTPSSLKeyManager(iSVNAuthenticationManager, string, sVNURL);
    }

    public SVNErrorMessage readData(HTTPRequest hTTPRequest, OutputStream outputStream) {
        InputStream inputStream = this.createInputStream(hTTPRequest.getResponseHeader(), this.getInputStream());
        byte[] byArray = this.getBuffer();
        boolean bl2 = false;
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (outputStream == null) continue;
                outputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            bl2 = true;
            if (iOException instanceof IOExceptionWrapper) {
                IOExceptionWrapper iOExceptionWrapper = (IOExceptionWrapper)iOException;
                SVNErrorMessage sVNErrorMessage = iOExceptionWrapper.getOriginalException().getErrorMessage();
                return sVNErrorMessage;
            }
            if (iOException.getCause() instanceof SVNException) {
                SVNErrorMessage sVNErrorMessage = ((SVNException)iOException.getCause()).getErrorMessage();
                return sVNErrorMessage;
            }
            throw iOException;
        }
        finally {
            if (!bl2) {
                SVNFileUtil.closeFile(inputStream);
            }
            this.myRepository.getDebugLog().flushStream(inputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SVNErrorMessage readData(HTTPRequest var1_1, String var2_2, String var3_3, DefaultHandler var4_4) {
        block27: {
            block24: {
                block22: {
                    block25: {
                        block23: {
                            var5_5 = null;
                            var6_6 = null;
                            var7_7 = null;
                            if (!this.myIsSpoolResponse && !this.myIsSpoolAll) ** GOTO lbl41
                            var8_8 = null;
                            var6_6 = new SpoolFile(this.mySpoolDirectory);
                            var8_8 = var6_6.openForWriting();
                            var8_8 = new SVNCancellableOutputStream(var8_8, this.myRepository.getCanceller());
                            var7_7 = this.readData(var1_1, var8_8);
                            SVNFileUtil.closeFile(var8_8);
                            var8_8 = null;
                            if (var7_7 == null) break block22;
                            var9_11 = var7_7;
                            SVNFileUtil.closeFile(var8_8);
                            if (!this.myIsSpoolResponse && !this.myIsSpoolAll) break block23;
                            SVNFileUtil.closeFile(var5_5);
                            break block25;
                        }
                        if (var7_7 == null && !HTTPConnection.hasToCloseConnection(var1_1.getResponseHeader())) {
                            SVNFileUtil.closeFile(var5_5);
                        }
                    }
                    if (var6_6 != null) {
                        try {
                            var6_6.delete();
                        }
                        catch (SVNException var10_12) {
                            throw new IOException(var10_12.getMessage());
                        }
                    }
                    this.myIsSpoolResponse = false;
                    return var9_11;
                }
                try {
                    block26: {
                        var5_5 = var6_6.openForReading();
                        {
                            catch (Throwable var11_13) {
                                SVNFileUtil.closeFile(var8_8);
                                throw var11_13;
                            }
                        }
                        SVNFileUtil.closeFile(var8_8);
                        break block26;
lbl41:
                        // 1 sources

                        var5_5 = this.createInputStream(var1_1.getResponseHeader(), this.getInputStream());
                    }
                    var7_7 = this.readData(var5_5, var2_2, var3_3, var4_4);
                    if (!this.myIsSpoolResponse && !this.myIsSpoolAll) break block24;
                }
                catch (IOException var8_10) {
                    try {
                        throw var8_10;
                    }
                    catch (Throwable var12_14) {
                        if (this.myIsSpoolResponse || this.myIsSpoolAll) {
                            SVNFileUtil.closeFile(var5_5);
                        } else if (var7_7 == null && !HTTPConnection.hasToCloseConnection(var1_1.getResponseHeader())) {
                            SVNFileUtil.closeFile(var5_5);
                        }
                        if (var6_6 != null) {
                            try {
                                var6_6.delete();
                            }
                            catch (SVNException var13_15) {
                                throw new IOException(var13_15.getMessage());
                            }
                        }
                        this.myIsSpoolResponse = false;
                        throw var12_14;
                    }
                }
                SVNFileUtil.closeFile(var5_5);
                break block27;
            }
            if (var7_7 == null && !HTTPConnection.hasToCloseConnection(var1_1.getResponseHeader())) {
                SVNFileUtil.closeFile(var5_5);
            }
        }
        if (var6_6 != null) {
            try {
                var6_6.delete();
            }
            catch (SVNException var8_9) {
                throw new IOException(var8_9.getMessage());
            }
        }
        this.myIsSpoolResponse = false;
        return var7_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNErrorMessage readData(InputStream inputStream, String string, String string2, DefaultHandler defaultHandler) {
        try {
            if (this.mySAXParser == null) {
                this.mySAXParser = HTTPConnection.getSAXParserFactory().newSAXParser();
            }
            XMLReader xMLReader = new XMLReader(inputStream);
            while (!xMLReader.isClosed()) {
                org.xml.sax.XMLReader xMLReader2 = this.mySAXParser.getXMLReader();
                xMLReader2.setContentHandler(defaultHandler);
                xMLReader2.setDTDHandler(defaultHandler);
                xMLReader2.setErrorHandler(defaultHandler);
                xMLReader2.setEntityResolver(NO_ENTITY_RESOLVER);
                xMLReader2.parse(new InputSource(xMLReader));
            }
        }
        catch (SAXException sAXException) {
            this.mySAXParser = null;
            if (sAXException instanceof SAXParseException) {
                if (defaultHandler instanceof DAVErrorHandler) {
                    SVNErrorMessage sVNErrorMessage = null;
                    return sVNErrorMessage;
                }
            } else {
                if (sAXException.getException() instanceof SVNException) {
                    SVNErrorMessage sVNErrorMessage = ((SVNException)sAXException.getException()).getErrorMessage();
                    return sVNErrorMessage;
                }
                if (sAXException.getCause() instanceof SVNException) {
                    SVNErrorMessage sVNErrorMessage = ((SVNException)sAXException.getCause()).getErrorMessage();
                    return sVNErrorMessage;
                }
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Processing {0} request response failed: {1} ({2}) ", string, sAXException.getMessage(), string2);
            return sVNErrorMessage;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.mySAXParser = null;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "XML parser configuration error while processing {0} request response: {1} ({2}) ", string, parserConfigurationException.getMessage(), string2);
            return sVNErrorMessage;
        }
        catch (EOFException eOFException) {
        }
        finally {
            if (this.mySAXParser != null) {
                org.xml.sax.XMLReader xMLReader = null;
                try {
                    xMLReader = this.mySAXParser.getXMLReader();
                }
                catch (SAXException sAXException) {}
                if (xMLReader != null) {
                    xMLReader.setContentHandler(DEFAULT_SAX_HANDLER);
                    xMLReader.setDTDHandler(DEFAULT_SAX_HANDLER);
                    xMLReader.setErrorHandler(DEFAULT_SAX_HANDLER);
                    xMLReader.setEntityResolver(NO_ENTITY_RESOLVER);
                }
            }
            this.myRepository.getDebugLog().flushStream(inputStream);
        }
        return null;
    }

    public void skipData(HTTPRequest hTTPRequest) {
        if (HTTPConnection.hasToCloseConnection(hTTPRequest.getResponseHeader())) {
            return;
        }
        InputStream inputStream = this.createInputStream(hTTPRequest.getResponseHeader(), this.getInputStream());
        while (inputStream.skip(2048L) > 0L) {
        }
    }

    @Override
    public void close() {
        if (this.isClearCredentialsOnClose(this.myChallengeCredentials)) {
            this.clearAuthenticationCache();
        } else {
            this.clearLastValidAuth();
        }
        if (this.mySocket != null) {
            if (this.myInputStream != null) {
                try {
                    this.myInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.mySocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySocket = null;
            this.myOutputStream = null;
            this.myInputStream = null;
        }
    }

    private byte[] getBuffer() {
        if (this.myBuffer == null) {
            this.myBuffer = new byte[32768];
        }
        return this.myBuffer;
    }

    private InputStream getInputStream() {
        if (this.myInputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myInputStream = new BufferedInputStream(this.mySocket.getInputStream(), 2048);
        }
        return this.myInputStream;
    }

    private OutputStream getOutputStream() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "socket output stream requested...");
        if (this.myOutputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myOutputStream = new BufferedOutputStream(this.mySocket.getOutputStream(), 2048);
            this.myOutputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.myOutputStream);
        }
        return this.myOutputStream;
    }

    private void finishResponse(HTTPRequest hTTPRequest) {
        HTTPHeader hTTPHeader;
        if (this.myOutputStream != null) {
            try {
                this.myOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HTTPHeader hTTPHeader2 = hTTPHeader = hTTPRequest != null ? hTTPRequest.getResponseHeader() : null;
        if (HTTPConnection.hasToCloseConnection(hTTPHeader)) {
            this.close();
        }
    }

    private static boolean hasToCloseConnection(HTTPHeader hTTPHeader) {
        if (hTTPHeader == null) {
            return true;
        }
        String string = hTTPHeader.getFirstHeaderValue("Connection");
        String string2 = hTTPHeader.getFirstHeaderValue("Proxy-Connection");
        if (string != null && string.toLowerCase().indexOf("close") >= 0) {
            return true;
        }
        return string2 != null && string2.toLowerCase().indexOf("close") >= 0;
    }

    private InputStream createInputStream(HTTPHeader hTTPHeader, InputStream inputStream) {
        if ("chunked".equalsIgnoreCase(hTTPHeader.getFirstHeaderValue("Transfer-Encoding"))) {
            inputStream = new ChunkedInputStream(inputStream, this.myCharset);
        } else if (hTTPHeader.getFirstHeaderValue("Content-Length") != null) {
            String string = hTTPHeader.getFirstHeaderValue("Content-Length");
            long l2 = 0L;
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = 0L;
            }
            inputStream = new FixedSizeInputStream(inputStream, l2);
        } else if (!HTTPConnection.hasToCloseConnection(hTTPHeader)) {
            inputStream = new FixedSizeInputStream(inputStream, 0L);
            hTTPHeader.setHeaderValue("Connection", "close");
        }
        if ("gzip".equals(hTTPHeader.getFirstHeaderValue("Content-Encoding"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, inputStream);
    }

    private static synchronized SAXParserFactory getSAXParserFactory() {
        if (ourSAXParserFactory == null) {
            ourSAXParserFactory = HTTPConnection.createSAXParserFactory();
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                hashMap.put("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
                hashMap.put("http://xml.org/sax/features/validation", Boolean.FALSE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                hashMap.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            if (hashMap.size() < 3) {
                ourSAXParserFactory = HTTPConnection.createSAXParserFactory();
                for (String string : hashMap.keySet()) {
                    try {
                        ourSAXParserFactory.setFeature(string, hashMap.get(string) == Boolean.TRUE);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                    }
                    catch (ParserConfigurationException parserConfigurationException) {}
                }
            }
            ourSAXParserFactory.setNamespaceAware(true);
            ourSAXParserFactory.setValidating(false);
        }
        return ourSAXParserFactory;
    }

    public static SAXParserFactory createSAXParserFactory() {
        String string = System.getProperty("svnkit.sax.useDefault");
        if (string == null || !Boolean.valueOf(string).booleanValue()) {
            return SAXParserFactory.newInstance();
        }
        String[] stringArray = new String[]{"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "org.apache.crimson.jaxp.SAXParserFactoryImpl"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            ClassLoader classLoader = HTTPConnection.class.getClassLoader();
            try {
                Object obj;
                Class<?> clazz = null;
                clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                if (clazz == null || !((obj = clazz.newInstance()) instanceof SAXParserFactory)) continue;
                return (SAXParserFactory)obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return SAXParserFactory.newInstance();
    }

    @Override
    public void setSpoolResponse(boolean bl2) {
        this.myIsSpoolResponse = bl2;
    }

    public void setSpoolAll(boolean bl2) {
        this.myIsSpoolAll = bl2;
    }

    public void setSpoolDirectory(File file) {
        this.mySpoolDirectory = file;
    }

    static {
        String string = System.getProperty("svnkit.http.requestAttempts", "1");
        int n2 = 1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        requestAttempts = n2;
        emptyHeader = Collections.unmodifiableMap(Collections.emptyMap());
    }
}

