/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPNegotiateAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPApacheNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication$1;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPDigestAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNativeNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNegotiateAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPNegotiateAuthenticationFactory;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

abstract class HTTPAuthentication {
    private Map myChallengeParameters;
    private String myUserName;
    private char[] myPassword;
    private static final String AUTH_METHODS_PROPERTY = "svnkit.http.methods";
    private static final String OLD_AUTH_METHODS_PROPERTY = "javasvn.http.methods";

    protected HTTPAuthentication(SVNPasswordAuthentication sVNPasswordAuthentication) {
        if (sVNPasswordAuthentication != null) {
            this.myUserName = sVNPasswordAuthentication.getUserName();
            this.myPassword = sVNPasswordAuthentication.getPasswordValue();
        }
    }

    protected HTTPAuthentication(String string, char[] cArray) {
        this.myUserName = string;
        this.myPassword = cArray;
    }

    protected HTTPAuthentication() {
    }

    public void setChallengeParameter(String string, String string2) {
        Map map = this.getChallengeParameters();
        map.put(string, string2);
    }

    public String getChallengeParameter(String string) {
        if (this.myChallengeParameters == null) {
            return null;
        }
        return (String)this.myChallengeParameters.get(string);
    }

    protected Map getChallengeParameters() {
        if (this.myChallengeParameters == null) {
            this.myChallengeParameters = new TreeMap();
        }
        return this.myChallengeParameters;
    }

    public void setCredentials(SVNPasswordAuthentication sVNPasswordAuthentication) {
        if (sVNPasswordAuthentication != null) {
            this.myUserName = sVNPasswordAuthentication.getUserName();
            this.myPassword = sVNPasswordAuthentication.getPasswordValue();
        }
    }

    public String getRawUserName() {
        return this.myUserName;
    }

    public String getUserName() {
        return this.myUserName;
    }

    public char[] getPassword() {
        return this.myPassword;
    }

    public void setUserName(String string) {
        this.myUserName = string;
    }

    public void setPassword(char[] cArray) {
        this.myPassword = cArray;
    }

    public static HTTPAuthentication parseAuthParameters(Collection collection, HTTPAuthentication hTTPAuthentication, String string, Collection collection2, ISVNAuthenticationManager iSVNAuthenticationManager, int n2) {
        Object object;
        if (collection == null) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = null;
        String string22 = null;
        collection = HTTPAuthentication.sortSchemes(collection, collection2);
        for (String string22 : collection) {
            Object object2;
            String string3 = string22.trim();
            int n3 = string3.indexOf(32);
            if (n3 <= 0 && !"NTLM".equalsIgnoreCase(string3.substring(0, n3 = string3.length())) && !"Negotiate".equalsIgnoreCase(string3.substring(0, n3))) continue;
            String string4 = string3.substring(0, n3);
            string3 = string3.substring(n3).trim();
            if ("Basic".equalsIgnoreCase(string4)) {
                object = new HTTPBasicAuthentication(string);
                if (string3.indexOf("realm=") < 0) break;
                string3 = string3.substring(string3.indexOf("realm=") + "realm=".length());
                if ((string3 = string3.trim()).startsWith("\"")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("\"")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                ((HTTPAuthentication)object).setChallengeParameter("realm", string3);
                break;
            }
            if ("Digest".equalsIgnoreCase(string4)) {
                object = new HTTPDigestAuthentication(string);
                object2 = (string3 + " ").toCharArray();
                int n4 = 0;
                boolean bl2 = true;
                String string5 = null;
                int n5 = 0;
                for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
                    if (bl2) {
                        if (object2[i2] != 61) continue;
                        string5 = new String((char[])object2, n4, i2 - n4);
                        string5 = string5.trim();
                        n4 = i2 + 1;
                        bl2 = false;
                        continue;
                    }
                    if (object2[i2] == 34) {
                        n5 = n5 > 0 ? 0 : 1;
                        continue;
                    }
                    if (i2 + 1 < ((Object)object2).length && (object2[i2] != 44 || n5 != 0)) continue;
                    String string6 = new String((char[])object2, n4, i2 - n4);
                    if ((string6 = string6.trim()).charAt(0) == '\"' && string6.charAt(string6.length() - 1) == '\"') {
                        string6 = string6.substring(1);
                        string6 = string6.substring(0, string6.length() - 1);
                    }
                    ((HTTPAuthentication)object).setChallengeParameter(string5, string6);
                    n4 = i2 + 1;
                    bl2 = true;
                }
                HTTPDigestAuthentication hTTPDigestAuthentication = (HTTPDigestAuthentication)object;
                hTTPDigestAuthentication.init();
                break;
            }
            if ("NTLM".equalsIgnoreCase(string4)) {
                object2 = null;
                if (string3.length() == 0) {
                    String string7 = System.getProperty("svnkit.http.ntlm", "java:apache");
                    if ("jna".equalsIgnoreCase(string7) && (object2 = HTTPNativeNTLMAuthentication.newInstance(string)) != null) {
                        ((HTTPNTLMAuthentication)object2).parseChallenge(null);
                    }
                    if (object2 == null) {
                        if ("jna".equalsIgnoreCase(string7)) {
                            string7 = "java";
                        }
                        object2 = "java:apache".equalsIgnoreCase(string7) ? HTTPApacheNTLMAuthentication.newInstance(string, "APACHE") : ("java:jcifs".equalsIgnoreCase(string7) ? HTTPApacheNTLMAuthentication.newInstance(string, "JCIFS") : new HTTPNTLMAuthentication(string));
                    }
                    ((HTTPNTLMAuthentication)object2).setType1State();
                } else {
                    object2 = (HTTPNTLMAuthentication)hTTPAuthentication;
                    ((HTTPNTLMAuthentication)object2).parseChallenge(string3);
                    ((HTTPNTLMAuthentication)object2).setType3State();
                }
                object = object2;
                break;
            }
            if (!"Negotiate".equalsIgnoreCase(string4)) continue;
            object2 = null;
            if (string3.length() == 0) {
                if (iSVNAuthenticationManager instanceof IHTTPNegotiateAuthenticationFactory) {
                    object2 = ((IHTTPNegotiateAuthenticationFactory)((Object)iSVNAuthenticationManager)).createNegotiateAuthentication(hTTPAuthentication instanceof HTTPNegotiateAuthentication ? (HTTPNegotiateAuthentication)hTTPAuthentication : null, n2);
                } else if (DefaultHTTPNegotiateAuthentication.isSupported()) {
                    if (hTTPAuthentication instanceof DefaultHTTPNegotiateAuthentication) {
                        object2 = new DefaultHTTPNegotiateAuthentication((DefaultHTTPNegotiateAuthentication)hTTPAuthentication);
                    } else {
                        object2 = new DefaultHTTPNegotiateAuthentication();
                        try {
                            ((HTTPNegotiateAuthentication)object2).needsLogin();
                        }
                        catch (Throwable throwable) {
                            object2 = null;
                        }
                    }
                }
                if (object2 != null) {
                    ((HTTPNegotiateAuthentication)object2).respondTo(null);
                }
            } else {
                object2 = (HTTPNegotiateAuthentication)hTTPAuthentication;
                ((HTTPNegotiateAuthentication)object2).respondTo(string3);
            }
            if (object2 == null) continue;
            object = object2;
            break;
        }
        if (object == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "HTTP authorization method ''{0}'' is not supported", (Object)string22);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        if (hTTPAuthentication != null) {
            ((HTTPAuthentication)object).setUserName(hTTPAuthentication.getRawUserName());
            ((HTTPAuthentication)object).setPassword(hTTPAuthentication.getPassword());
        }
        return object;
    }

    public static boolean isSchemeSupportedByServer(String string, Collection collection) {
        Object object2;
        if (collection == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.NETWORK);
        }
        object2 = null;
        for (Object object2 : collection) {
            String string2;
            String string3 = ((String)object2).trim();
            int n2 = string3.indexOf(32);
            if (n2 <= 0) {
                n2 = string3.length();
            }
            if (!(string2 = string3.substring(0, n2)).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static Collection sortSchemes(Collection collection, Collection collection2) {
        Object object;
        String string = System.getProperty(AUTH_METHODS_PROPERTY, System.getProperty(OLD_AUTH_METHODS_PROPERTY));
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && !"".equals(string.trim())) {
            object = new StringTokenizer(string, " ,");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        } else if (collection2 != null && !collection2.isEmpty()) {
            arrayList.addAll(collection2);
        } else {
            return collection;
        }
        object = new ArrayList(collection);
        Collections.sort(object, new HTTPAuthentication$1(arrayList));
        return object;
    }

    private static String getSchemeName(String string) {
        String string2 = string.trim();
        int n2 = string2.indexOf(32);
        if (n2 <= 0) {
            n2 = string2.length();
        }
        return string2.substring(0, n2);
    }

    public abstract String getAuthenticationScheme();

    public abstract String authenticate();

    protected static byte[] getASCIIBytes(String string) {
        return HTTPAuthentication.getBytes(string, "US-ASCII");
    }

    protected static byte[] getBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    protected static byte[] getBytes(char[] cArray, String string) {
        return SVNEncodingUtil.getBytes(cArray, string);
    }

    public static void clear(byte[] byArray) {
        SVNEncodingUtil.clearArray(byArray);
    }

    public static void clear(char[] cArray) {
        SVNEncodingUtil.clearArray(cArray);
    }

    static /* synthetic */ String access$000(String string) {
        return HTTPAuthentication.getSchemeName(string);
    }
}

