/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.IOException;
import java.util.Locale;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.INTLMEngine;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMJCIFSEngine;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class HTTPApacheNTLMAuthentication
extends HTTPNTLMAuthentication {
    public static final String JCIFS_ENGINE = "JCIFS";
    public static final String APACHE_ENGINE = "APACHE";
    private final INTLMEngine myEngine;
    private String myLastToken = null;

    protected HTTPApacheNTLMAuthentication(String string, String string2) {
        super(string);
        if (JCIFS_ENGINE.equals(string2) && !NTLMJCIFSEngine.isAvailable()) {
            string2 = APACHE_ENGINE;
        }
        this.myEngine = JCIFS_ENGINE.equals(string2) ? new NTLMJCIFSEngine() : new NTLMEngine();
    }

    public static HTTPNTLMAuthentication newInstance(String string, String string2) {
        return new HTTPApacheNTLMAuthentication(string, string2);
    }

    @Override
    public String authenticate() {
        String string;
        char[] cArray;
        String string2;
        String string3;
        Object object;
        if (this.myState != 1 && this.myState != 3) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported message type in HTTP NTLM authentication");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = null;
        String string4 = this.getDomain() == null ? "" : this.getDomain().toUpperCase(Locale.ENGLISH);
        String string5 = System.getProperty("svnkit.http.ntlm.domain");
        if (string5 != null) {
            string4 = string5.toUpperCase(Locale.ENGLISH);
        }
        String string6 = "";
        String string7 = System.getProperty("svnkit.http.ntlm.workstation");
        if (string7 != null) {
            string6 = string7.toUpperCase(Locale.ENGLISH);
        }
        String string8 = string3 = (string2 = System.getProperty("svnkit.http.ntlm.user")) != null ? string2 : this.getUserName();
        if (string3 == null) {
            string3 = System.getProperty("user.name", System.getenv("USERNAME"));
        }
        char[] cArray2 = cArray = (string = System.getProperty("svnkit.http.ntlm.password")) != null ? string.toCharArray() : this.getPassword();
        if (SVNFileUtil.isWindows) {
            boolean bl2 = Boolean.parseBoolean(System.getProperty("svnkit.http.ntlm.domain.useEnv", "false"));
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Will try to use domain from environment: " + bl2);
            boolean bl3 = Boolean.parseBoolean(System.getProperty("svnkit.http.ntlm.workstation.useEnv", "true"));
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Will try to use workstation from environment: " + bl3);
            if ("".equals(string6) && string7 == null && bl3) {
                string6 = System.getenv("COMPUTERNAME");
                if (string6 == null) {
                    string6 = "";
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Workstation from environment: " + string6);
            }
            if ("".equals(string4) && string5 == null && bl2) {
                string4 = System.getenv("USERDOMAIN");
                if (string4 == null) {
                    string4 = "";
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Domain from environment: " + string4);
            }
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Domain: " + string4);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Workstation: " + string6);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "User: " + string3);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Password: " + (cArray != null && cArray.length > 0 ? "<not empty>" : "<empty or null>"));
        try {
            if (this.myState == 1) {
                object = this.myEngine.generateType1Msg(string4, string6);
            } else if (this.myState == 3) {
                object = this.myEngine.generateType3Msg(string3, cArray, string4, string6, this.myLastToken);
            }
        }
        catch (IOException iOException) {
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED), (Throwable)iOException);
        }
        if (this.isInType3State()) {
            this.setType1State();
            if (this.myLastToken != null) {
                this.myLastToken = null;
            }
        }
        return "NTLM " + (String)object;
    }

    @Override
    public void parseChallenge(String string) {
        this.myLastToken = string;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public boolean allowPropmtForCredentials() {
        return true;
    }
}

