/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPNegotiateAuthentication$1;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPNegotiateAuthentication$SVNKitCallbackHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNegotiateAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultHTTPNegotiateAuthentication
extends HTTPNegotiateAuthentication {
    private static final String NEGOTIATE_TYPE_PROPERTY = "svnkit.negotiate.type";
    private static final String NEGOTIATE_TYPE_SPNEGO = "spnego";
    private static final String NEGOTIATE_TYPE_KERBEROS = "krb";
    private static Map ourOids = new HashMap();
    private static volatile Boolean ourIsNegotiateSupported;
    private GSSManager myGSSManager = GSSManager.getInstance();
    private GSSContext myGSSContext;
    private Oid mySpnegoOid;
    private Subject mySubject;
    private byte[] myToken;
    private int myTokenLength;

    private static Oid getDefaultOID() {
        Oid oid;
        String string = System.getProperty(NEGOTIATE_TYPE_PROPERTY, NEGOTIATE_TYPE_KERBEROS);
        if (string == null || "".equals(string)) {
            string = NEGOTIATE_TYPE_KERBEROS;
        }
        if ((oid = (Oid)ourOids.get(string)) != null) {
            return oid;
        }
        return (Oid)ourOids.get(NEGOTIATE_TYPE_KERBEROS);
    }

    public DefaultHTTPNegotiateAuthentication(DefaultHTTPNegotiateAuthentication defaultHTTPNegotiateAuthentication) {
        if (defaultHTTPNegotiateAuthentication != null) {
            this.mySubject = defaultHTTPNegotiateAuthentication.mySubject;
        }
    }

    public DefaultHTTPNegotiateAuthentication() {
        this((DefaultHTTPNegotiateAuthentication)null);
    }

    public static synchronized boolean isSupported() {
        if (ourIsNegotiateSupported == null) {
            Oid oid = DefaultHTTPNegotiateAuthentication.getDefaultOID();
            Oid[] oidArray = GSSManager.getInstance().getMechs();
            for (int i2 = 0; i2 < oidArray.length; ++i2) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: supported OID: " + oidArray[i2]);
            }
            ourIsNegotiateSupported = Arrays.asList(GSSManager.getInstance().getMechs()).contains(oid);
        }
        return ourIsNegotiateSupported;
    }

    @Override
    public void respondTo(String string) {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: respond to, challenge: " + string);
        if (string == null) {
            this.myToken = new byte[0];
            this.myTokenLength = 0;
        } else {
            this.myToken = new byte[(string.length() * 3 + 3) / 4];
            this.myTokenLength = SVNBase64.base64ToByteArray(new StringBuffer(string), this.myToken);
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: respond to, token length: " + this.myTokenLength);
    }

    private void initializeSubject() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject");
        if (this.mySubject != null) {
            return;
        }
        try {
            LoginContext loginContext = new LoginContext("com.sun.security.jgss.krb5.initiate", new DefaultHTTPNegotiateAuthentication$SVNKitCallbackHandler(this));
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject, login context: " + loginContext);
            loginContext.login();
            this.mySubject = loginContext.getSubject();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject, subject: " + this.mySubject);
        }
        catch (LoginException loginException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, loginException);
        }
    }

    private void initializeContext() {
        if (this.mySpnegoOid == null) {
            this.mySpnegoOid = DefaultHTTPNegotiateAuthentication.getDefaultOID();
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, OID: " + this.mySpnegoOid);
        GSSCredential gSSCredential = this.myGSSManager.createCredential(1);
        GSSName gSSName = this.myGSSManager.createName(this.getServerPrincipalName(), GSSName.NT_HOSTBASED_SERVICE);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, server name: " + gSSName);
        this.myGSSContext = this.myGSSManager.createContext(gSSName, this.mySpnegoOid, gSSCredential, 0);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, GSS Context: " + this.myGSSContext);
    }

    @Override
    public String authenticate() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: isStarted:" + this.isStarted());
        if (!this.isStarted()) {
            this.initializeSubject();
        }
        DefaultHTTPNegotiateAuthentication$1 defaultHTTPNegotiateAuthentication$1 = new DefaultHTTPNegotiateAuthentication$1(this);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: subject:" + this.mySubject);
        if (this.mySubject != null) {
            try {
                String string = (String)Subject.doAs(this.mySubject, defaultHTTPNegotiateAuthentication$1);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: result:" + string);
                return string;
            }
            catch (PrivilegedActionException privilegedActionException) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, privilegedActionException);
                Throwable throwable = privilegedActionException.getCause();
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
                if (throwable instanceof SVNException) {
                    throw (SVNException)throwable;
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, privilegedActionException), SVNLogType.NETWORK);
            }
        }
        try {
            String string = (String)defaultHTTPNegotiateAuthentication$1.run();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: result (2):" + string);
            return string;
        }
        catch (Exception exception) {
            if (exception instanceof SVNException) {
                throw (SVNException)exception;
            }
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, exception), SVNLogType.NETWORK);
            return null;
        }
    }

    @Override
    public boolean isStarted() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: isStarted: " + this.myGSSContext);
        return this.myGSSContext != null;
    }

    @Override
    public boolean needsLogin() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: needsLogin");
        this.initializeSubject();
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: needsLogin, mySubject: " + this.mySubject);
        return this.mySubject == null;
    }

    static /* synthetic */ void access$100(DefaultHTTPNegotiateAuthentication defaultHTTPNegotiateAuthentication) {
        defaultHTTPNegotiateAuthentication.initializeContext();
    }

    static /* synthetic */ GSSContext access$200(DefaultHTTPNegotiateAuthentication defaultHTTPNegotiateAuthentication) {
        return defaultHTTPNegotiateAuthentication.myGSSContext;
    }

    static /* synthetic */ byte[] access$300(DefaultHTTPNegotiateAuthentication defaultHTTPNegotiateAuthentication) {
        return defaultHTTPNegotiateAuthentication.myToken;
    }

    static /* synthetic */ int access$400(DefaultHTTPNegotiateAuthentication defaultHTTPNegotiateAuthentication) {
        return defaultHTTPNegotiateAuthentication.myTokenLength;
    }

    static {
        try {
            ourOids.put(NEGOTIATE_TYPE_KERBEROS, new Oid("1.2.840.113554.1.2.2"));
        }
        catch (GSSException gSSException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, gSSException);
        }
        try {
            ourOids.put(NEGOTIATE_TYPE_SPNEGO, new Oid("1.3.6.1.5.5.2"));
        }
        catch (GSSException gSSException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, gSSException);
        }
    }
}

