/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.File;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DefaultHTTPConnectionFactory
implements IHTTPConnectionFactory {
    private File mySpoolDirectory;
    private String myHTTPCharset;
    private boolean myIsSpoolAll;
    private boolean myIsUseSendAll;

    public DefaultHTTPConnectionFactory(File file, boolean bl2, String string) {
        this(file, bl2, false, string);
    }

    public DefaultHTTPConnectionFactory(File file, boolean bl2, boolean bl3, String string) {
        this.mySpoolDirectory = file;
        this.myIsSpoolAll = bl2;
        this.myHTTPCharset = string;
        this.myIsUseSendAll = bl3;
    }

    @Override
    public IHTTPConnection createHTTPConnection(SVNRepository sVNRepository) {
        String string = this.myHTTPCharset != null ? this.myHTTPCharset : System.getProperty("svnkit.http.encoding", "UTF-8");
        File file = this.mySpoolDirectory;
        if (this.mySpoolDirectory != null && !this.mySpoolDirectory.isDirectory()) {
            file = null;
        }
        return new HTTPConnection(sVNRepository, string, file, this.myIsSpoolAll);
    }

    @Override
    public boolean useSendAllForDiff(SVNRepository sVNRepository) {
        return this.myIsUseSendAll;
    }
}

