/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.Serializable;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVReplayHandler
extends DAVEditorHandler {
    protected static final DAVElement EDITOR_REPORT = DAVElement.getElement("svn:", "editor-report");
    protected static final DAVElement OPEN_ROOT = DAVElement.getElement("svn:", "open-root");
    protected static final DAVElement APPLY_TEXT_DELTA = DAVElement.getElement("svn:", "apply-textdelta");
    protected static final DAVElement CLOSE_FILE = DAVElement.getElement("svn:", "close-file");
    protected static final DAVElement CLOSE_DIRECTORY = DAVElement.getElement("svn:", "close-directory");
    protected static final DAVElement CHANGE_FILE_PROPERTY = DAVElement.getElement("svn:", "change-file-prop");
    protected static final DAVElement CHANGE_DIR_PROPERTY = DAVElement.getElement("svn:", "change-dir-prop");
    protected static final String CHECKSUM_ATTR = "checksum";
    protected static final String DEL_ATTR = "del";

    public static StringBuffer generateReplayRequest(long l2, long l3, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "replay-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openCDataTag("S", "revision", String.valueOf(l2), stringBuffer);
        SVNXMLUtil.openCDataTag("S", "low-water-mark", String.valueOf(l3), stringBuffer);
        SVNXMLUtil.openCDataTag("S", "send-deltas", bl2 ? "1" : "0", stringBuffer);
        SVNXMLUtil.addXMLFooter("S", "replay-report", stringBuffer);
        return stringBuffer;
    }

    public DAVReplayHandler(ISVNEditor iSVNEditor, boolean bl2) {
        super(null, null, iSVNEditor, null, bl2, false, null);
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == TARGET_REVISION) {
            String string = attributes.getValue("rev");
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing revision attr in target-revision element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else {
                try {
                    this.myEditor.targetRevision(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                }
            }
        } else if (dAVElement2 == OPEN_ROOT) {
            String string = attributes.getValue("rev");
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing revision attr in open-root element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else {
                try {
                    this.myEditor.openRoot(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                }
                this.myPath = "";
                this.myIsDirectory = true;
            }
        } else if (dAVElement2 == DELETE_ENTRY) {
            String string = attributes.getValue("name");
            String string2 = attributes.getValue("rev");
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in delete-entry element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else if (string2 == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing rev attr in delete-entry element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else {
                try {
                    this.myEditor.deleteEntry(string, Long.parseLong(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                }
            }
        } else if (dAVElement2 == OPEN_DIRECTORY || dAVElement2 == ADD_DIRECTORY) {
            String string = attributes.getValue("name");
            String string3 = attributes.getValue("rev");
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (dAVElement2 == OPEN_DIRECTORY ? "open-directory" : "add-directory") + " element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else {
                long l2 = -1L;
                if (string3 != null) {
                    try {
                        l2 = Long.parseLong(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                    }
                }
                if (dAVElement2 == OPEN_DIRECTORY) {
                    this.myEditor.openDir(string, l2);
                } else {
                    String string4 = attributes.getValue("copyfrom-path");
                    String string5 = attributes.getValue("copyfrom-rev");
                    long l3 = -1L;
                    if (string5 != null) {
                        try {
                            l3 = Long.parseLong(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                        }
                    }
                    this.myEditor.addDir(string, string4, l3);
                }
            }
            this.myPath = string;
            this.myIsDirectory = true;
        } else if (dAVElement2 == OPEN_FILE || dAVElement2 == ADD_FILE) {
            Object object;
            String string = attributes.getValue("name");
            if (string == null) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (dAVElement2 == OPEN_FILE ? "open-file" : "add-file") + " element");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            if (dAVElement2 == ADD_FILE) {
                object = attributes.getValue("copyfrom-path");
                String string6 = attributes.getValue("copyfrom-rev");
                long l4 = -1L;
                if (string6 != null) {
                    try {
                        l4 = Long.parseLong(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                    }
                }
                this.myEditor.addFile(string, (String)object, l4);
            } else {
                object = attributes.getValue("rev");
                long l5 = -1L;
                if (object != null) {
                    try {
                        l5 = Long.parseLong((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                    }
                }
                this.myEditor.openFile(string, l5);
            }
            this.myIsDirectory = false;
            this.myPath = string;
        } else if (dAVElement2 == APPLY_TEXT_DELTA) {
            Object object;
            if (this.myIsDirectory) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got apply-textdelta element without preceding add-file or open-file");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            object = attributes.getValue(CHECKSUM_ATTR);
            try {
                this.myEditor.applyTextDelta(this.myPath, (String)object);
                this.setDeltaProcessing(true);
            }
            catch (SVNException sVNException) {}
        } else if (dAVElement2 == CLOSE_FILE) {
            if (this.myIsDirectory) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got close-file element without preceding add-file or open-file");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else {
                String string = attributes.getValue(CHECKSUM_ATTR);
                this.myEditor.closeFile(this.myPath, string);
                this.myIsDirectory = true;
            }
        } else if (dAVElement2 == CLOSE_DIRECTORY) {
            if (!this.myIsDirectory) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got close-directory element without ever opening a directory");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else {
                this.myEditor.closeDir();
            }
        } else if (dAVElement2 == CHANGE_FILE_PROPERTY || dAVElement2 == CHANGE_DIR_PROPERTY) {
            String string = attributes.getValue("name");
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (dAVElement2 == CHANGE_FILE_PROPERTY ? "change-file-prop" : "change-dir-prop") + " element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else if (attributes.getValue(DEL_ATTR) != null) {
                if (dAVElement2 == CHANGE_FILE_PROPERTY) {
                    this.myEditor.changeFileProperty(this.myPath, string, null);
                } else {
                    this.myEditor.changeDirProperty(string, null);
                }
                this.myPropertyName = null;
            } else {
                this.myPropertyName = string;
            }
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == APPLY_TEXT_DELTA) {
            this.setDeltaProcessing(false);
        } else if (dAVElement2 == CHANGE_FILE_PROPERTY || dAVElement2 == CHANGE_DIR_PROPERTY) {
            Serializable serializable;
            if (stringBuffer != null && !"".equals(stringBuffer.toString()) && this.myPropertyName == null) {
                serializable = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got cdata content for a prop delete");
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
            }
            if (this.myPropertyName != null) {
                serializable = this.createPropertyValueFromBase64(null, this.myPropertyName, stringBuffer);
                if (dAVElement2 == CHANGE_FILE_PROPERTY) {
                    this.myEditor.changeFileProperty(this.myPath, this.myPropertyName, (SVNPropertyValue)serializable);
                } else {
                    this.myEditor.changeDirProperty(this.myPropertyName, (SVNPropertyValue)serializable);
                }
            }
        }
    }
}

