/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVProppatchHandler
extends BasicDAVHandler {
    private static final Collection NAMESPACES = new LinkedList();
    private StringBuffer myPropertyName;
    private StringBuffer myPropstatDescription;
    private StringBuffer myDescription;
    private boolean myPropstatContainsError;
    private boolean myResponseContainsError;
    private SVNErrorMessage myError;

    public static StringBuffer generatePropertyRequest(StringBuffer stringBuffer, String string, SVNPropertyValue sVNPropertyValue) {
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put(string, sVNPropertyValue);
        return DAVProppatchHandler.generatePropertyRequest(stringBuffer, sVNProperties);
    }

    public static StringBuffer generatePropertyRequest(StringBuffer stringBuffer, String string, byte[] byArray) {
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put(string, byArray);
        return DAVProppatchHandler.generatePropertyRequest(stringBuffer, sVNProperties);
    }

    public static StringBuffer generatePropertyRequest(StringBuffer stringBuffer, SVNProperties sVNProperties) {
        SVNPropertyValue sVNPropertyValue;
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "propertyupdate", NAMESPACES, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        if (DAVProppatchHandler.hasNotNullValues(sVNProperties)) {
            SVNXMLUtil.openXMLTag("D", "set", 1, null, stringBuffer);
            SVNXMLUtil.openXMLTag("D", "prop", 1, null, stringBuffer);
            for (String string : sVNProperties.nameSet()) {
                sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
                if (sVNPropertyValue == null) continue;
                stringBuffer = DAVProppatchHandler.appendProperty(stringBuffer, string, sVNPropertyValue);
            }
            SVNXMLUtil.closeXMLTag("D", "prop", stringBuffer);
            SVNXMLUtil.closeXMLTag("D", "set", stringBuffer);
        }
        if (DAVProppatchHandler.hasNullValues(sVNProperties)) {
            SVNXMLUtil.openXMLTag("D", "remove", 1, null, stringBuffer);
            SVNXMLUtil.openXMLTag("D", "prop", 1, null, stringBuffer);
            for (String string : sVNProperties.nameSet()) {
                sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
                if (sVNPropertyValue != null) continue;
                stringBuffer = DAVProppatchHandler.appendProperty(stringBuffer, string, sVNPropertyValue);
            }
            SVNXMLUtil.closeXMLTag("D", "prop", stringBuffer);
            SVNXMLUtil.closeXMLTag("D", "remove", stringBuffer);
        }
        SVNXMLUtil.addXMLFooter("D", "propertyupdate", stringBuffer);
        return stringBuffer;
    }

    private static StringBuffer appendProperty(StringBuffer stringBuffer, String string, SVNPropertyValue sVNPropertyValue) {
        Object object;
        String string2 = SVNProperty.isSVNProperty(string) && !SVNProperty.isSVNKitProperty(string) ? "SS" : "SC";
        String string3 = SVNProperty.shortPropertyName(string);
        if (sVNPropertyValue == null) {
            return SVNXMLUtil.openXMLTag(string2, string3, 4, null, stringBuffer);
        }
        SVNHashMap sVNHashMap = null;
        String string4 = sVNPropertyValue.getString();
        boolean bl2 = true;
        if (sVNPropertyValue.isBinary()) {
            object = Charset.forName("UTF-8").newDecoder();
            ((CharsetDecoder)object).onMalformedInput(CodingErrorAction.REPORT);
            ((CharsetDecoder)object).onMalformedInput(CodingErrorAction.REPORT);
            try {
                string4 = ((CharsetDecoder)object).decode(ByteBuffer.wrap(sVNPropertyValue.getBytes())).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                bl2 = false;
            }
        }
        if (string4 != null) {
            bl2 = SVNEncodingUtil.isXMLSafe(string4);
        }
        if (!bl2) {
            sVNHashMap = new SVNHashMap();
            object = (String)SVNXMLUtil.PREFIX_MAP.get("http://subversion.tigris.org/xmlns/dav/");
            sVNHashMap.put((String)object + ":encoding", "base64");
            byte[] byArray = null;
            if (string4 != null) {
                try {
                    byArray = string4.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string4.getBytes();
                }
            } else {
                byArray = sVNPropertyValue.getBytes();
            }
            string4 = SVNBase64.byteArrayToBase64(byArray);
        }
        return SVNXMLUtil.openCDataTag(string2, string3, string4, sVNHashMap, stringBuffer);
    }

    private static boolean hasNullValues(SVNProperties sVNProperties) {
        if (sVNProperties.isEmpty()) {
            return false;
        }
        return sVNProperties.containsValue(null);
    }

    private static boolean hasNotNullValues(SVNProperties sVNProperties) {
        if (sVNProperties.isEmpty()) {
            return false;
        }
        if (!DAVProppatchHandler.hasNullValues(sVNProperties)) {
            return true;
        }
        for (String string : sVNProperties.nameSet()) {
            if (sVNProperties.getSVNPropertyValue(string) == null) continue;
            return true;
        }
        return false;
    }

    public DAVProppatchHandler() {
        this.init();
    }

    public SVNErrorMessage getError() {
        return this.myError;
    }

    private StringBuffer getPropertyName() {
        if (this.myPropertyName == null) {
            this.myPropertyName = new StringBuffer();
        }
        return this.myPropertyName;
    }

    private StringBuffer getPropstatDescription() {
        if (this.myPropstatDescription == null) {
            this.myPropstatDescription = new StringBuffer();
        }
        return this.myPropstatDescription;
    }

    private StringBuffer getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringBuffer();
        }
        return this.myDescription;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement == DAVElement.PROP) {
            this.getPropertyName().setLength(0);
            if ("http://subversion.tigris.org/xmlns/dav/".equals(dAVElement2.getNamespace())) {
                this.getPropertyName().append("svn:");
            } else if ("DAV:".equals(dAVElement2.getNamespace())) {
                this.getPropertyName().append("DAV:");
            }
            this.getPropertyName().append(dAVElement2.getName());
        } else if (dAVElement2 == DAVElement.PROPSTAT) {
            this.myPropstatContainsError = false;
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        block14: {
            if (dAVElement2 == DAVElement.MULTISTATUS) {
                if (this.myResponseContainsError) {
                    String string = null;
                    string = this.getDescription().length() == 0 ? "The request response contained at least one error" : this.getDescription().toString();
                    this.myError = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, string);
                }
            } else if (dAVElement2 == DAVElement.RESPONSE_DESCRIPTION) {
                if (dAVElement == DAVElement.PROPSTAT) {
                    this.getPropstatDescription().append(stringBuffer);
                } else {
                    if (this.getDescription().length() != 0) {
                        this.getDescription().append('\n');
                    }
                    this.getDescription().append(stringBuffer);
                }
            } else if (dAVElement2 == DAVElement.STATUS) {
                try {
                    HTTPStatus hTTPStatus = HTTPStatus.createHTTPStatus(stringBuffer.toString());
                    if (dAVElement != DAVElement.PROPSTAT) {
                        this.myResponseContainsError |= hTTPStatus.getCodeClass() != 2;
                        break block14;
                    }
                    this.myPropstatContainsError = hTTPStatus.getCodeClass() != 2;
                }
                catch (ParseException parseException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The response contains a non-conforming HTTP status line"), SVNLogType.NETWORK);
                }
            } else if (dAVElement2 == DAVElement.PROPSTAT) {
                this.myResponseContainsError |= this.myPropstatContainsError;
                this.getDescription().append("Error setting property ");
                this.getDescription().append(this.getPropertyName());
                this.getDescription().append(":");
                this.getDescription().append(this.getPropstatDescription());
            }
        }
    }

    static {
        NAMESPACES.add("DAV:");
        NAMESPACES.add("http://subversion.tigris.org/xmlns/dav/");
        NAMESPACES.add("http://subversion.tigris.org/xmlns/svn/");
        NAMESPACES.add("http://subversion.tigris.org/xmlns/custom/");
    }
}

