/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVPropertiesHandler
extends BasicDAVHandler {
    private static final Set PROP_ELEMENTS = new SVNHashSet();
    private DAVProperties myCurrentResource;
    private int myStatusCode;
    private String myEncoding;
    private Map myResources;
    private Map myCurrentProperties;

    public static StringBuffer generatePropertiesRequest(StringBuffer stringBuffer, DAVElement[] dAVElementArray) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag(null, "propfind", DAV_NAMESPACES_LIST, null, stringBuffer);
        if (dAVElementArray != null) {
            stringBuffer.append("<prop>");
            for (int i2 = 0; i2 < dAVElementArray.length; ++i2) {
                SVNXMLUtil.openXMLTag(null, dAVElementArray[i2].getName(), 4, "xmlns", dAVElementArray[i2].getNamespace(), stringBuffer);
            }
            SVNXMLUtil.closeXMLTag(null, "prop", stringBuffer);
        } else {
            SVNXMLUtil.openXMLTag(null, "allprop", 4, null, stringBuffer);
        }
        SVNXMLUtil.addXMLFooter(null, "propfind", stringBuffer);
        return stringBuffer;
    }

    public DAVPropertiesHandler() {
        this.init();
    }

    public Map getDAVProperties() {
        return this.myResources;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == DAVElement.RESPONSE) {
            if (this.myCurrentResource != null) {
                this.invalidXML();
            }
            this.myCurrentResource = new DAVProperties();
            this.myCurrentProperties = new SVNHashMap();
            this.myStatusCode = 0;
        } else if (dAVElement2 == DAVElement.PROPSTAT) {
            this.myStatusCode = 0;
        } else if (dAVElement2 == DAVElement.COLLECTION) {
            this.myCurrentResource.setCollection(true);
        } else {
            this.myEncoding = attributes.getValue("http://subversion.tigris.org/xmlns/dav/", "encoding");
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        DAVElement dAVElement3 = null;
        SVNPropertyValue sVNPropertyValue = null;
        if (this.myCurrentProperties == null) {
            this.invalidXML();
        }
        if (dAVElement2 == DAVElement.RESPONSE) {
            if (this.myCurrentResource.getURL() == null) {
                this.invalidXML();
            }
            this.myResources.put(this.myCurrentResource.getURL(), this.myCurrentResource);
            this.myCurrentResource = null;
            return;
        }
        if (dAVElement2 == DAVElement.PROPSTAT) {
            if (this.myStatusCode != 0) {
                for (Map.Entry entry : this.myCurrentProperties.entrySet()) {
                    DAVElement dAVElement4 = (DAVElement)entry.getKey();
                    SVNPropertyValue sVNPropertyValue2 = (SVNPropertyValue)entry.getValue();
                    if (this.myStatusCode != 200) continue;
                    this.myCurrentResource.setProperty(dAVElement4, sVNPropertyValue2);
                }
                this.myCurrentProperties.clear();
            } else {
                this.invalidXML();
            }
            return;
        }
        if (dAVElement2 == DAVElement.STATUS) {
            if (stringBuffer == null) {
                this.invalidXML();
            }
            try {
                HTTPStatus hTTPStatus = HTTPStatus.createHTTPStatus(stringBuffer.toString());
                if (hTTPStatus == null) {
                    this.invalidXML();
                }
                this.myStatusCode = hTTPStatus.getCode();
            }
            catch (ParseException parseException) {
                this.invalidXML();
            }
            return;
        }
        if (dAVElement2 == DAVElement.HREF) {
            if (dAVElement == DAVElement.RESPONSE) {
                String string = stringBuffer.toString();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                this.myCurrentResource.setURL(string);
                return;
            }
            dAVElement3 = dAVElement;
            if (dAVElement3 == null) {
                return;
            }
            sVNPropertyValue = SVNPropertyValue.create(stringBuffer.toString());
        } else if (stringBuffer != null) {
            if (this.myCurrentProperties.containsKey(dAVElement2)) {
                return;
            }
            dAVElement3 = dAVElement2;
            String string = DAVUtil.getPropertyNameByElement(dAVElement3);
            sVNPropertyValue = this.createPropertyValue(dAVElement3, string, stringBuffer, this.myEncoding);
            this.myEncoding = null;
        }
        if (dAVElement3 != null && sVNPropertyValue != null) {
            this.myCurrentProperties.put(dAVElement3, sVNPropertyValue);
        }
    }

    public void setDAVProperties(Map map) {
        this.myResources = map;
    }

    static {
        PROP_ELEMENTS.add(DAVElement.HREF);
        PROP_ELEMENTS.add(DAVElement.STATUS);
        PROP_ELEMENTS.add(DAVElement.BASELINE);
        PROP_ELEMENTS.add(DAVElement.BASELINE_COLLECTION);
        PROP_ELEMENTS.add(DAVElement.COLLECTION);
        PROP_ELEMENTS.add(DAVElement.VERSION_NAME);
        PROP_ELEMENTS.add(DAVElement.GET_CONTENT_LENGTH);
        PROP_ELEMENTS.add(DAVElement.CREATION_DATE);
        PROP_ELEMENTS.add(DAVElement.CREATOR_DISPLAY_NAME);
        PROP_ELEMENTS.add(DAVElement.BASELINE_RELATIVE_PATH);
        PROP_ELEMENTS.add(DAVElement.MD5_CHECKSUM);
        PROP_ELEMENTS.add(DAVElement.REPOSITORY_UUID);
    }
}

