/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVMergeInfoHandler
extends BasicDAVHandler {
    private String myPath;
    private StringBuffer myCurrentInfo;
    private Map myPathsToMergeInfos;

    public static StringBuffer generateMergeInfoRequest(StringBuffer stringBuffer, long l2, String[] stringArray, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "mergeinfo-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openCDataTag("S", "revision", String.valueOf(l2), stringBuffer);
        SVNXMLUtil.openCDataTag("S", "inherit", sVNMergeInfoInheritance.toString(), stringBuffer);
        if (bl2) {
            SVNXMLUtil.openCDataTag("S", "include-descendants", "yes", stringBuffer);
        }
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                SVNXMLUtil.openCDataTag("S", "path", stringArray[i2], stringBuffer);
            }
        }
        SVNXMLUtil.addXMLFooter("S", "mergeinfo-report", stringBuffer);
        return stringBuffer;
    }

    public DAVMergeInfoHandler() {
        this.init();
        this.myPathsToMergeInfos = new TreeMap();
    }

    public Map getMergeInfo() {
        return this.myPathsToMergeInfos;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == DAVElement.MERGE_INFO_ITEM) {
            this.myPath = null;
            this.myCurrentInfo = null;
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == DAVElement.MERGE_INFO_PATH) {
            this.myPath = stringBuffer.toString();
        } else if (dAVElement2 == DAVElement.MERGE_INFO_INFO) {
            this.myCurrentInfo = stringBuffer;
        } else if (dAVElement2 == DAVElement.MERGE_INFO_ITEM && this.myPath != null && this.myCurrentInfo != null) {
            Map map = SVNMergeInfoUtil.parseMergeInfo(this.myCurrentInfo, null);
            this.myPathsToMergeInfos.put(this.myPath, new SVNMergeInfo(this.myPath, map));
        }
    }
}

