/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVMergeHandler
extends BasicDAVHandler {
    private ISVNWorkspaceMediator myMediator;
    private Map myPathsMap;
    private static final DAVElement RESPONSE = DAVElement.getElement("DAV:", "response");
    private static final DAVElement POST_COMMIT_ERROR = DAVElement.getElement("svn:", "post-commit-err");
    private String myAuthor;
    private Date myCommitDate;
    private long myRevision;
    private String myRepositoryPath;
    private String myVersionPath;
    private DAVElement myResourceType;
    private SVNCommitInfo myCommitInfo;
    private SVNErrorMessage myPostCommitError;

    public static StringBuffer generateMergeRequest(StringBuffer stringBuffer, String string, String string2, Map map) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "merge", DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "source", 1, null, stringBuffer);
        SVNXMLUtil.openCDataTag("D", "href", string2, stringBuffer);
        SVNXMLUtil.closeXMLTag("D", "source", stringBuffer);
        SVNXMLUtil.openXMLTag("D", "no-auto-merge", 4, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "no-checkout", 4, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "prop", 1, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "checked-in", 4, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "version-name", 4, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "resourcetype", 4, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "creationdate", 4, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "creator-displayname", 4, null, stringBuffer);
        SVNXMLUtil.closeXMLTag("D", "prop", stringBuffer);
        if (map != null && !map.isEmpty()) {
            stringBuffer = DAVMergeHandler.generateLockDataRequest(stringBuffer, string, null, map);
        }
        SVNXMLUtil.addXMLFooter("D", "merge", stringBuffer);
        return stringBuffer;
    }

    public static StringBuffer generateLockDataRequest(StringBuffer stringBuffer, String string, String string2, Map map) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.openNamespaceDeclarationTag("S", "lock-token-list", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        for (String string3 : map.keySet()) {
            if (string2 != null && SVNPathUtil.getPathAsChild(string2, string3) == null) continue;
            String string4 = SVNPathUtil.getRelativePath(string, string3);
            String string5 = (String)map.get(string3);
            SVNXMLUtil.openXMLTag("S", "lock", 1, null, stringBuffer);
            SVNXMLUtil.openCDataTag("S", "lock-path", SVNEncodingUtil.uriDecode(string4), stringBuffer);
            SVNXMLUtil.openCDataTag("S", "lock-token", string5, stringBuffer);
            SVNXMLUtil.closeXMLTag("S", "lock", stringBuffer);
        }
        SVNXMLUtil.closeXMLTag("S", "lock-token-list", stringBuffer);
        return stringBuffer;
    }

    public static boolean hasChildPaths(String string, Map map) {
        for (String string2 : map.keySet()) {
            if (SVNPathUtil.getPathAsChild(string, string2) == null) continue;
            return true;
        }
        return false;
    }

    public DAVMergeHandler(ISVNWorkspaceMediator iSVNWorkspaceMediator, Map map) {
        this.myMediator = iSVNWorkspaceMediator;
        this.myPathsMap = map;
        this.init();
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == RESPONSE) {
            this.myResourceType = null;
            this.myRepositoryPath = null;
            this.myVersionPath = null;
            this.myAuthor = null;
            this.myCommitDate = null;
            this.myRevision = -1L;
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == POST_COMMIT_ERROR) {
            this.myPostCommitError = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, stringBuffer.toString(), 1);
        } else if (dAVElement2 == DAVElement.HREF) {
            if (dAVElement == RESPONSE) {
                this.myRepositoryPath = stringBuffer.toString();
                this.myRepositoryPath = SVNEncodingUtil.uriDecode(this.myRepositoryPath);
                this.myRepositoryPath = SVNPathUtil.canonicalizePath(this.myRepositoryPath);
            } else if (dAVElement == DAVElement.CHECKED_IN) {
                this.myVersionPath = stringBuffer.toString();
                this.myVersionPath = SVNPathUtil.canonicalizePath(this.myVersionPath);
            }
        } else if (dAVElement == DAVElement.RESOURCE_TYPE && dAVElement2 == DAVElement.BASELINE) {
            this.myResourceType = dAVElement2;
        } else if (dAVElement == DAVElement.RESOURCE_TYPE && dAVElement2 == DAVElement.COLLECTION) {
            this.myResourceType = dAVElement2;
        } else if (dAVElement2 == RESPONSE) {
            if (this.myResourceType == DAVElement.BASELINE) {
                this.myCommitInfo = new SVNCommitInfo(this.myRevision, this.myAuthor, this.myCommitDate, this.myPostCommitError);
            } else {
                String string = SVNEncodingUtil.uriEncode(this.myRepositoryPath);
                String string2 = (String)this.myPathsMap.get(string);
                if (string2 != null && this.myMediator != null) {
                    String string3 = "svn:wc:ra_dav:version-url";
                    SVNPropertyValue sVNPropertyValue = DAVUtil.isUseDAVWCURL() ? SVNPropertyValue.create(this.myVersionPath) : null;
                    this.myMediator.setWorkspaceProperty(SVNEncodingUtil.uriDecode(string2), string3, sVNPropertyValue);
                }
            }
        } else if (dAVElement2 == DAVElement.CREATION_DATE) {
            this.myCommitDate = SVNDate.parseDate(stringBuffer.toString());
        } else if (dAVElement2 == DAVElement.CREATOR_DISPLAY_NAME) {
            this.myAuthor = stringBuffer.toString();
        } else if (dAVElement2 == DAVElement.VERSION_NAME) {
            try {
                this.myRevision = Long.parseLong(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
        } else if (dAVElement != DAVElement.PROPSTAT || dAVElement2 == DAVElement.STATUS) {
            // empty if block
        }
    }
}

