/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVLogHandler
extends BasicDAVHandler {
    private static final DAVElement LOG_ITEM = DAVElement.getElement("svn:", "log-item");
    private static final DAVElement ADDED_PATH = DAVElement.getElement("svn:", "added-path");
    private static final DAVElement DELETED_PATH = DAVElement.getElement("svn:", "deleted-path");
    private static final DAVElement MODIFIED_PATH = DAVElement.getElement("svn:", "modified-path");
    private static final DAVElement REPLACED_PATH = DAVElement.getElement("svn:", "replaced-path");
    private static final DAVElement HAS_CHILDREN = DAVElement.getElement("svn:", "has-children");
    private static final DAVElement REVPROP = DAVElement.getElement("svn:", "revprop");
    private static final DAVElement SUBTRACTIVE_MERGE = DAVElement.getElement("svn:", "subtractive-merge");
    private ISVNLogEntryHandler myLogEntryHandler;
    private long myRevision;
    private Map myPaths;
    private String myAuthor;
    private Date myDate;
    private String myComment;
    private SVNLogEntryPath myPath;
    private long myCount;
    private long myLimit;
    private int myNestLevel;
    private boolean myIsCompatibleMode;
    private boolean myHasChildren;
    private boolean myIsWantAuthor;
    private boolean myIsWantDate;
    private boolean myIsWantComment;
    private boolean myIsWantCustomRevProps;
    private String myRevPropName;
    private SVNProperties myRevProps;
    private boolean myIsSubtractiveMerge;

    public static StringBuffer generateLogRequest(StringBuffer stringBuffer, long l2, long l3, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, long l4, String[] stringArray2) {
        int n2;
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "log-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        if (l2 >= 0L) {
            SVNXMLUtil.openCDataTag("S", "start-revision", String.valueOf(l2), stringBuffer);
        }
        if (l3 >= 0L) {
            SVNXMLUtil.openCDataTag("S", "end-revision", String.valueOf(l3), stringBuffer);
        }
        if (l4 > 0L) {
            SVNXMLUtil.openCDataTag("S", "limit", String.valueOf(l4), stringBuffer);
        }
        if (bl2) {
            SVNXMLUtil.openXMLTag("S", "discover-changed-paths", 4, null, stringBuffer);
        }
        if (bl3) {
            SVNXMLUtil.openXMLTag("S", "strict-node-history", 4, null, stringBuffer);
        }
        if (bl4) {
            SVNXMLUtil.openXMLTag("S", "include-merged-revisions", 4, null, stringBuffer);
        }
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string = stringArray[n2];
                SVNXMLUtil.openCDataTag("S", "revprop", string, stringBuffer);
            }
        } else {
            SVNXMLUtil.openXMLTag("S", "all-revprops", 4, null, stringBuffer);
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            SVNXMLUtil.openCDataTag("S", "path", stringArray2[n2], stringBuffer);
        }
        SVNXMLUtil.addXMLFooter("S", "log-report", stringBuffer);
        return stringBuffer;
    }

    public DAVLogHandler(ISVNLogEntryHandler iSVNLogEntryHandler, long l2, String[] stringArray) {
        this.myLogEntryHandler = iSVNLogEntryHandler;
        this.myRevision = -1L;
        this.myCount = 0L;
        this.myLimit = l2;
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if ("svn:author".equals(string)) {
                    this.myIsWantAuthor = true;
                    continue;
                }
                if ("svn:log".equals(string)) {
                    this.myIsWantComment = true;
                    continue;
                }
                if ("svn:date".equals(string)) {
                    this.myIsWantDate = true;
                    continue;
                }
                this.myIsWantCustomRevProps = true;
            }
        } else {
            this.myIsWantDate = true;
            this.myIsWantComment = true;
            this.myIsWantAuthor = true;
        }
        this.init();
    }

    public boolean isWantCustomRevprops() {
        return this.myIsWantCustomRevProps;
    }

    public boolean isCompatibleMode() {
        return this.myIsCompatibleMode;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        Object object;
        char c2 = '\u0000';
        String string = null;
        long l2 = -1L;
        if (dAVElement2 == REVPROP) {
            this.myRevPropName = attributes.getValue("name");
            if (this.myRevPropName == null) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in revprop element");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
        } else if (dAVElement2 == HAS_CHILDREN) {
            this.myHasChildren = true;
        } else if (dAVElement2 == SUBTRACTIVE_MERGE) {
            this.myIsSubtractiveMerge = true;
        }
        if (dAVElement2 == ADDED_PATH || dAVElement2 == REPLACED_PATH) {
            c2 = dAVElement2 == ADDED_PATH ? (char)'A' : 'R';
            string = attributes.getValue("copyfrom-path");
            object = attributes.getValue("copyfrom-rev");
            if (string != null && object != null) {
                try {
                    l2 = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (dAVElement2 == MODIFIED_PATH) {
            c2 = 'M';
        } else if (dAVElement2 == DELETED_PATH) {
            c2 = 'D';
        }
        if (c2 != '\u0000') {
            object = SVNNodeKind.UNKNOWN;
            String string2 = attributes.getValue("node-kind");
            if (string2 != null) {
                object = SVNNodeKind.parseKind(string2);
            }
            this.myPath = new SVNLogEntryPath(null, c2, string, l2, (SVNNodeKind)object);
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == LOG_ITEM) {
            Serializable serializable;
            if (this.myNestLevel == 0) {
                ++this.myCount;
            }
            if (this.myLimit > 0L && this.myCount > this.myLimit && this.myNestLevel == 0) {
                this.myIsCompatibleMode = true;
                serializable = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
            }
            if (this.myLogEntryHandler != null) {
                if (this.myPaths == null) {
                    this.myPaths = new SVNHashMap();
                }
                if (this.myRevProps == null) {
                    this.myRevProps = new SVNProperties();
                }
                if (this.myAuthor != null) {
                    this.myRevProps.put("svn:author", this.myAuthor);
                }
                if (this.myComment != null) {
                    this.myRevProps.put("svn:log", this.myComment);
                }
                if (this.myDate != null) {
                    this.myRevProps.put("svn:date", SVNDate.formatDate(this.myDate));
                }
                serializable = new SVNLogEntry(this.myPaths, this.myRevision, this.myRevProps, this.myHasChildren);
                ((SVNLogEntry)serializable).setSubtractiveMerge(this.myIsSubtractiveMerge);
                this.myLogEntryHandler.handleLogEntry((SVNLogEntry)serializable);
                if (((SVNLogEntry)serializable).hasChildren()) {
                    ++this.myNestLevel;
                }
                if (((SVNLogEntry)serializable).getRevision() < 0L) {
                    this.myNestLevel = this.myNestLevel <= 0 ? 0 : this.myNestLevel - 1;
                }
            }
            this.myPaths = null;
            this.myRevProps = null;
            this.myRevision = -1L;
            this.myAuthor = null;
            this.myDate = null;
            this.myComment = null;
            this.myRevPropName = null;
            this.myHasChildren = false;
            this.myIsSubtractiveMerge = false;
        } else if (dAVElement2 == DAVElement.VERSION_NAME && stringBuffer != null) {
            try {
                this.myRevision = Long.parseLong(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
        } else if (dAVElement2 == REVPROP) {
            if (this.myRevProps == null) {
                this.myRevProps = new SVNProperties();
            }
            if (this.myRevPropName != null && stringBuffer != null) {
                this.myRevProps.put(this.myRevPropName, stringBuffer.toString());
            }
        } else if (dAVElement2 == DAVElement.CREATOR_DISPLAY_NAME && stringBuffer != null) {
            if (this.myIsWantAuthor) {
                this.myAuthor = stringBuffer.toString();
            }
        } else if (dAVElement2 == DAVElement.COMMENT && stringBuffer != null) {
            if (this.myIsWantComment) {
                this.myComment = stringBuffer.toString();
            }
        } else if (dAVElement2 == DAVElement.DATE && stringBuffer != null) {
            if (this.myIsWantDate) {
                this.myDate = SVNDate.parseDate(stringBuffer.toString());
            }
        } else if (dAVElement2 == ADDED_PATH || dAVElement2 == MODIFIED_PATH || dAVElement2 == REPLACED_PATH || dAVElement2 == DELETED_PATH) {
            if (this.myPath != null && stringBuffer != null) {
                if (this.myPaths == null) {
                    this.myPaths = new SVNHashMap();
                }
                this.myPath.setPath(stringBuffer.toString());
                String string = this.myPath.getPath();
                this.myPath.setPath(string);
                this.myPaths.put(this.myPath.getPath(), this.myPath);
            }
            this.myPath = null;
        }
    }

    public long getEntriesCount() {
        return this.myCount;
    }
}

