/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVPropertiesHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVLockHandler
extends BasicDAVHandler {
    private boolean myIsHandlingToken;
    private String myID;
    private String myComment;
    private String myExpiration;

    public static StringBuffer generateGetLockRequest(StringBuffer stringBuffer) {
        return DAVPropertiesHandler.generatePropertiesRequest(stringBuffer, new DAVElement[]{DAVElement.LOCK_DISCOVERY});
    }

    public static StringBuffer generateSetLockRequest(StringBuffer stringBuffer, String string) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "lockinfo", DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "lockscope", 1, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "exclusive", 4, null, stringBuffer);
        SVNXMLUtil.closeXMLTag("D", "lockscope", stringBuffer);
        SVNXMLUtil.openXMLTag("D", "locktype", 1, null, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "write", 4, null, stringBuffer);
        SVNXMLUtil.closeXMLTag("D", "locktype", stringBuffer);
        string = string == null ? "" : string;
        SVNXMLUtil.openCDataTag("D", "owner", string, stringBuffer);
        SVNXMLUtil.addXMLFooter("D", "lockinfo", stringBuffer);
        return stringBuffer;
    }

    public DAVLockHandler() {
        this.init();
    }

    public String getComment() {
        return this.myComment;
    }

    public String getExpiration() {
        return this.myExpiration;
    }

    public String getID() {
        return this.myID;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == DAVElement.LOCK_TOKEN) {
            this.myIsHandlingToken = true;
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == DAVElement.HREF && this.myIsHandlingToken && stringBuffer != null) {
            this.myID = stringBuffer.toString();
        } else if (dAVElement2 == DAVElement.LOCK_TOKEN) {
            this.myIsHandlingToken = false;
        } else if (dAVElement2 == DAVElement.LOCK_OWNER && stringBuffer != null) {
            this.myComment = stringBuffer.toString();
        } else if (dAVElement2 == DAVElement.LOCK_TIMEOUT && stringBuffer != null) {
            this.myExpiration = stringBuffer.toString();
        }
    }
}

