/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVLocationsHandler
extends BasicDAVHandler {
    private static final DAVElement LOCATION_REPORT = DAVElement.getElement("svn:", "get-locations-report");
    private static final DAVElement LOCATION = DAVElement.getElement("svn:", "location");
    private ISVNLocationEntryHandler myLocationEntryHandler;
    private int myCount;

    public static StringBuffer generateLocationsRequest(StringBuffer stringBuffer, String string, long l2, long[] lArray) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "get-locations", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openCDataTag("S", "path", string, stringBuffer);
        SVNXMLUtil.openCDataTag("S", "peg-revision", String.valueOf(l2), stringBuffer);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            SVNXMLUtil.openCDataTag("S", "location-revision", String.valueOf(lArray[i2]), stringBuffer);
        }
        SVNXMLUtil.addXMLFooter("S", "get-locations", stringBuffer);
        return stringBuffer;
    }

    public DAVLocationsHandler(ISVNLocationEntryHandler iSVNLocationEntryHandler) {
        this.myLocationEntryHandler = iSVNLocationEntryHandler;
        this.init();
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        String string;
        String string2;
        if (dAVElement == LOCATION_REPORT && dAVElement2 == LOCATION && (string2 = attributes.getValue("rev")) != null && (string = attributes.getValue("path")) != null && this.myLocationEntryHandler != null) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            try {
                this.myLocationEntryHandler.handleLocationEntry(new SVNLocationEntry(Long.parseLong(string2), string));
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
            ++this.myCount;
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
    }

    public int getEntriesCount() {
        return this.myCount;
    }
}

