/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVLocationSegmentsHandler
extends BasicDAVHandler {
    private static final DAVElement LOCATION_SEGMENTS_REPORT = DAVElement.getElement("svn:", "get-location-segments-report");
    private static final DAVElement LOCATION_SEGMENT = DAVElement.getElement("svn:", "location-segment");
    private ISVNLocationSegmentHandler myLocationSegmentHandler;
    private long myCount;

    public static StringBuffer generateGetLocationSegmentsRequest(StringBuffer stringBuffer, String string, long l2, long l3, long l4) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "get-location-segments", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openCDataTag("S", "path", string, stringBuffer);
        if (SVNRevision.isValidRevisionNumber(l2)) {
            SVNXMLUtil.openCDataTag("S", "peg-revision", String.valueOf(l2), stringBuffer);
        }
        if (SVNRevision.isValidRevisionNumber(l3)) {
            SVNXMLUtil.openCDataTag("S", "start-revision", String.valueOf(l3), stringBuffer);
        }
        if (SVNRevision.isValidRevisionNumber(l4)) {
            SVNXMLUtil.openCDataTag("S", "end-revision", String.valueOf(l4), stringBuffer);
        }
        SVNXMLUtil.addXMLFooter("S", "get-location-segments", stringBuffer);
        return stringBuffer;
    }

    public DAVLocationSegmentsHandler(ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        this.myLocationSegmentHandler = iSVNLocationSegmentHandler;
        this.init();
    }

    public long getTotalRevisions() {
        return this.myCount;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement == LOCATION_SEGMENTS_REPORT && dAVElement2 == LOCATION_SEGMENT) {
            String string;
            long l2 = -1L;
            long l3 = -1L;
            String string2 = attributes.getValue("path");
            if (string2 != null && !string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if ((string = attributes.getValue("range-start")) != null) {
                try {
                    l2 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                }
            }
            if ((string = attributes.getValue("range-end")) != null) {
                try {
                    l3 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                }
            }
            if (SVNRevision.isValidRevisionNumber(l2) && SVNRevision.isValidRevisionNumber(l3)) {
                if (this.myLocationSegmentHandler != null) {
                    this.myLocationSegmentHandler.handleLocationSegment(new SVNLocationSegment(l2, l3, string2));
                    this.myCount += l3 - l2 + 1L;
                }
            } else {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Expected valid revision range");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
    }
}

