/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVInheritedPropertiesHandler
extends BasicDAVHandler {
    private Map inhertiedProperties;
    private String currentValueEncoding;
    private String currentPropertyName;
    private SVNPropertyValue currentPropertyValue;
    private SVNProperties currentProperties;
    private static final DAVElement IPROPNAME = DAVElement.getElement("svn:", "iprop-propname");
    private static final DAVElement IPROPVALUE = DAVElement.getElement("svn:", "iprop-propval");
    private static final DAVElement IPROPITEM = DAVElement.getElement("svn:", "iprop-item");
    private static final DAVElement IPROPPATH = DAVElement.getElement("svn:", "iprop-path");

    public static StringBuffer generateReport(StringBuffer stringBuffer, String string, long l2) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "inherited-props-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openCDataTag("S", "revision", String.valueOf(l2), stringBuffer);
        SVNXMLUtil.openCDataTag("S", "path", string, stringBuffer);
        SVNXMLUtil.closeXMLTag("S", "inherited-props-report", stringBuffer);
        return stringBuffer;
    }

    public DAVInheritedPropertiesHandler() {
        this.init();
        this.inhertiedProperties = new HashMap();
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == IPROPVALUE) {
            this.currentValueEncoding = attributes.getValue("encoding");
        } else if (dAVElement2 == IPROPITEM) {
            this.currentProperties = new SVNProperties();
            this.currentPropertyName = null;
            this.currentPropertyValue = null;
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == IPROPNAME) {
            this.currentPropertyName = stringBuffer.toString();
        } else if (dAVElement2 == IPROPVALUE) {
            this.currentPropertyValue = this.createPropertyValue(dAVElement2, this.currentPropertyName, stringBuffer, this.currentValueEncoding);
            this.currentProperties.put(this.currentPropertyName, this.currentPropertyValue);
            this.currentValueEncoding = null;
            this.currentPropertyName = null;
            this.currentPropertyValue = null;
        } else if (dAVElement2 == IPROPITEM) {
            this.currentPropertyName = null;
            this.currentPropertyValue = null;
        } else if (dAVElement2 == IPROPPATH) {
            String string = stringBuffer.toString();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            this.inhertiedProperties.put(string, this.currentProperties);
        }
    }

    public Map getInheritedProperties() {
        return this.inhertiedProperties;
    }
}

