/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVGetLocksHandler
extends BasicDAVHandler {
    private static final String LOCK_COMMENT_SUFFIX = "</ns0:owner>";
    private static final String LOCK_COMMENT_PREFIX = "<ns0:owner xmlns:ns0=\"DAV:\">";
    private static final String EMPTY_LOCK_COMMENT = "<ns0:owner xmlns:ns0=\"DAV:\"/>";
    private Collection myLocks = new ArrayList();
    private String myPath;
    private String myToken;
    private String myComment;
    private String myOwner;
    private Date myExpirationDate;
    private Date myCreationDate;
    private boolean myIsBase64;

    public static StringBuffer generateGetLocksRequest(StringBuffer stringBuffer) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "get-locks-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.addXMLFooter("S", "get-locks-report", stringBuffer);
        return stringBuffer;
    }

    public DAVGetLocksHandler() {
        this.init();
    }

    public SVNLock[] getLocks() {
        return this.myLocks.toArray(new SVNLock[this.myLocks.size()]);
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        this.myIsBase64 = false;
        if (attributes != null) {
            this.myIsBase64 = "base64".equals(attributes.getValue("encoding"));
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == DAVElement.SVN_LOCK) {
            if (this.myPath != null && this.myToken != null) {
                SVNLock sVNLock = new SVNLock(this.myPath, this.myToken, this.myOwner, this.myComment, this.myCreationDate, this.myExpirationDate);
                this.myLocks.add(sVNLock);
            }
            this.myPath = null;
            this.myOwner = null;
            this.myToken = null;
            this.myComment = null;
            this.myCreationDate = null;
            this.myExpirationDate = null;
        } else if (dAVElement2 == DAVElement.SVN_LOCK_PATH && stringBuffer != null) {
            this.myPath = stringBuffer.toString();
        } else if (dAVElement2 == DAVElement.SVN_LOCK_TOKEN && stringBuffer != null) {
            this.myToken = stringBuffer.toString();
        } else if (dAVElement2 == DAVElement.SVN_LOCK_OWNER && stringBuffer != null) {
            this.myOwner = stringBuffer.toString();
            if (this.myIsBase64) {
                StringBuffer stringBuffer2 = SVNBase64.normalizeBase64(new StringBuffer(this.myOwner));
                byte[] byArray = this.allocateBuffer(stringBuffer2.length());
                int n2 = SVNBase64.base64ToByteArray(stringBuffer2, byArray);
                try {
                    this.myOwner = new String(byArray, 0, n2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.myOwner = new String(byArray, 0, n2);
                }
            }
        } else if (dAVElement2 == DAVElement.SVN_LOCK_COMMENT && stringBuffer != null) {
            this.myComment = stringBuffer.toString();
            if (this.myComment != null && this.myComment.trim().startsWith(LOCK_COMMENT_PREFIX) && this.myComment.trim().endsWith(LOCK_COMMENT_SUFFIX)) {
                this.myComment = this.myComment.trim().substring(LOCK_COMMENT_PREFIX.length(), this.myComment.trim().length() - LOCK_COMMENT_SUFFIX.length());
            } else if (this.myComment.trim().equals(EMPTY_LOCK_COMMENT)) {
                this.myComment = "";
            }
            if (this.myIsBase64) {
                StringBuffer stringBuffer3 = SVNBase64.normalizeBase64(new StringBuffer(this.myComment));
                byte[] byArray = this.allocateBuffer(stringBuffer3.length());
                int n3 = SVNBase64.base64ToByteArray(stringBuffer3, byArray);
                try {
                    this.myComment = new String(byArray, 0, n3, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.myComment = new String(byArray, 0, n3);
                }
            }
        } else if (dAVElement2 == DAVElement.SVN_LOCK_CREATION_DATE && stringBuffer != null) {
            this.myCreationDate = SVNDate.parseDate(stringBuffer.toString());
        } else if (dAVElement2 == DAVElement.SVN_LOCK_EXPIRATION_DATE && stringBuffer != null) {
            this.myExpirationDate = SVNDate.parseDate(stringBuffer.toString());
        }
        this.myIsBase64 = false;
    }
}

