/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVDeltaHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVFileRevisionHandler
extends BasicDAVDeltaHandler {
    private static final DAVElement REVISION_PROPERTY = DAVElement.getElement("svn:", "rev-prop");
    private static final DAVElement FILE_REVISION = DAVElement.getElement("svn:", "file-rev");
    private static final DAVElement SET_PROPERTY = DAVElement.getElement("svn:", "set-prop");
    private static final DAVElement DELETE_PROPERTY = DAVElement.getElement("svn:", "remove-prop");
    private static final DAVElement MERGED_REVISION = DAVElement.getElement("svn:", "merged-revision");
    private ISVNFileRevisionHandler myFileRevisionsHandler;
    private String myPath;
    private long myRevision;
    private SVNProperties myProperties;
    private SVNProperties myPropertiesDelta;
    private String myPropertyName;
    private String myPropertyEncoding;
    private boolean myIsMergedRevision;
    private int myCount;

    public static StringBuffer generateFileRevisionsRequest(StringBuffer stringBuffer, long l2, long l3, String string, boolean bl2) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "file-revs-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        if (l2 >= 0L) {
            SVNXMLUtil.openCDataTag("S", "start-revision", String.valueOf(l2), stringBuffer);
        }
        if (l3 >= 0L) {
            SVNXMLUtil.openCDataTag("S", "end-revision", String.valueOf(l3), stringBuffer);
        }
        if (bl2) {
            SVNXMLUtil.openXMLTag("S", "include-merged-revisions", 4, null, stringBuffer);
        }
        SVNXMLUtil.openCDataTag("S", "path", string, stringBuffer);
        SVNXMLUtil.addXMLFooter("S", "file-revs-report", stringBuffer);
        return stringBuffer;
    }

    public DAVFileRevisionHandler(ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        this.myFileRevisionsHandler = iSVNFileRevisionHandler;
        this.myCount = 0;
        this.init();
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == FILE_REVISION) {
            String string;
            this.myIsMergedRevision = false;
            this.myPath = attributes.getValue("path");
            if (this.myPath == null) {
                this.missingAttributeError(dAVElement2, "path");
            }
            if ((string = attributes.getValue("rev")) == null) {
                this.missingAttributeError(dAVElement2, "rev");
            }
            try {
                this.myRevision = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
        } else if (dAVElement2 == REVISION_PROPERTY || dAVElement2 == SET_PROPERTY || dAVElement2 == DELETE_PROPERTY) {
            this.myPropertyName = attributes.getValue("name");
            if (this.myPropertyName == null) {
                this.missingAttributeError(dAVElement2, "name");
            }
            this.myPropertyEncoding = attributes.getValue("encoding");
        } else if (dAVElement2 == TX_DELTA) {
            if (this.myPath != null && this.myFileRevisionsHandler != null) {
                if (this.myProperties == null) {
                    this.myProperties = new SVNProperties();
                }
                if (this.myPropertiesDelta == null) {
                    this.myPropertiesDelta = new SVNProperties();
                }
                SVNFileRevision sVNFileRevision = new SVNFileRevision(this.myPath, this.myRevision, this.myProperties, this.myPropertiesDelta, this.myIsMergedRevision);
                this.myFileRevisionsHandler.openRevision(sVNFileRevision);
                this.myProperties = null;
                this.myPropertiesDelta = null;
                this.myPath = null;
                this.myFileRevisionsHandler.applyTextDelta(this.myPath, null);
            }
            this.setDeltaProcessing(true);
        } else if (dAVElement2 == MERGED_REVISION) {
            this.myIsMergedRevision = true;
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == FILE_REVISION) {
            if (this.myPath != null && this.myFileRevisionsHandler != null) {
                if (this.myProperties == null) {
                    this.myProperties = new SVNProperties();
                }
                if (this.myPropertiesDelta == null) {
                    this.myPropertiesDelta = new SVNProperties();
                }
                SVNFileRevision sVNFileRevision = new SVNFileRevision(this.myPath, this.myRevision, this.myProperties, this.myPropertiesDelta);
                this.myFileRevisionsHandler.openRevision(sVNFileRevision);
            }
            if (this.myFileRevisionsHandler != null) {
                this.myFileRevisionsHandler.closeRevision(this.myPath);
            }
            this.myPath = null;
            this.myProperties = null;
            this.myPropertiesDelta = null;
            this.myPropertyEncoding = null;
            this.myPropertyName = null;
        } else if (dAVElement2 == TX_DELTA) {
            this.setDeltaProcessing(false);
            ++this.myCount;
        } else if (dAVElement2 == REVISION_PROPERTY) {
            if (this.myProperties == null) {
                this.myProperties = new SVNProperties();
            }
            this.myProperties.put(this.myPropertyName, stringBuffer != null ? stringBuffer.toString() : "");
            this.myPropertyName = null;
        } else if (dAVElement2 == SET_PROPERTY) {
            if (this.myPropertiesDelta == null) {
                this.myPropertiesDelta = new SVNProperties();
            }
            if (this.myPropertyName != null) {
                SVNPropertyValue sVNPropertyValue = this.createPropertyValue(null, this.myPropertyName, stringBuffer, this.myPropertyEncoding);
                this.myPropertiesDelta.put(this.myPropertyName, sVNPropertyValue);
            }
            this.myPropertyName = null;
            this.myPropertyEncoding = null;
        } else if (dAVElement2 == DELETE_PROPERTY) {
            if (this.myPropertiesDelta == null) {
                this.myPropertiesDelta = new SVNProperties();
            }
            if (this.myPropertyName != null) {
                this.myPropertiesDelta.put(this.myPropertyName, (byte[])null);
            }
            this.myPropertyEncoding = null;
            this.myPropertyName = null;
        }
    }

    public int getEntriesCount() {
        return this.myCount;
    }

    @Override
    protected ISVNDeltaConsumer getDeltaConsumer() {
        return this.myFileRevisionsHandler;
    }

    @Override
    protected String getCurrentPath() {
        return this.myPath;
    }

    private void missingAttributeError(DAVElement dAVElement, String string) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing attribute ''{0}'' on element {1}", string, dAVElement);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
    }
}

