/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.xml.sax.Attributes;

public class DAVErrorHandler
extends BasicDAVHandler {
    private static final DAVElement SVN_ERROR = DAVElement.getElement("svn:", "error");
    private static final DAVElement ERROR_DATA = DAVElement.getElement("http://apache.org/dav/xmlns", "human-readable");
    private SVNErrorMessage myError;
    private SVNErrorCode myErrorCode;
    private String myErrorMessage;

    public DAVErrorHandler() {
        this.init();
        this.myErrorCode = SVNErrorCode.RA_DAV_REQUEST_FAILED;
        this.myErrorMessage = "General svn error from server";
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myError;
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        String string;
        if (dAVElement2 == SVN_ERROR) {
            this.myErrorMessage = "General svn error from server";
            this.myError = SVNErrorMessage.create(this.myErrorCode, this.myErrorMessage);
        } else if (dAVElement2 == ERROR_DATA && (string = attributes.getValue("errcode")) != null) {
            try {
                this.myErrorCode = SVNErrorCode.getErrorCode(Integer.parseInt(string));
                this.myError = SVNErrorMessage.create(this.myErrorCode, this.myErrorMessage);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == ERROR_DATA && stringBuffer != null) {
            String string = stringBuffer.toString();
            while (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            while (string.startsWith("\n")) {
                string = string.substring(1);
            }
            this.myErrorMessage = string;
            this.myError = SVNErrorMessage.create(this.myErrorCode, this.myErrorMessage);
        }
    }
}

