/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.InputStream;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVDeltaHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler$1;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler$2;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler$DeltaOutputStreamWrapper;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler$DirInfo;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNWorkingCopyContentMediator;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnChecksum$Kind;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVEditorHandler
extends BasicDAVDeltaHandler {
    public static final String PLACEHOLDER_PROPERTY_NAME = "svn:BOGOSITY";
    protected static final DAVElement TARGET_REVISION = DAVElement.getElement("svn:", "target-revision");
    protected static final DAVElement UPDATE_REPORT = DAVElement.getElement("svn:", "update-report");
    protected static final DAVElement RESOURCE = DAVElement.getElement("svn:", "resource");
    protected static final DAVElement OPEN_DIRECTORY = DAVElement.getElement("svn:", "open-directory");
    protected static final DAVElement ADD_DIRECTORY = DAVElement.getElement("svn:", "add-directory");
    protected static final DAVElement ABSENT_DIRECTORY = DAVElement.getElement("svn:", "absent-directory");
    protected static final DAVElement OPEN_FILE = DAVElement.getElement("svn:", "open-file");
    protected static final DAVElement ADD_FILE = DAVElement.getElement("svn:", "add-file");
    protected static final DAVElement ABSENT_FILE = DAVElement.getElement("svn:", "absent-file");
    protected static final DAVElement DELETE_ENTRY = DAVElement.getElement("svn:", "delete-entry");
    protected static final DAVElement FETCH_PROPS = DAVElement.getElement("svn:", "fetch-props");
    protected static final DAVElement SET_PROP = DAVElement.getElement("svn:", "set-prop");
    protected static final DAVElement REMOVE_PROP = DAVElement.getElement("svn:", "remove-prop");
    protected static final DAVElement FETCH_FILE = DAVElement.getElement("svn:", "fetch-file");
    protected static final String REVISION_ATTR = "rev";
    protected static final String NAME_ATTR = "name";
    protected static final String ENCODING_ATTR = "encoding";
    protected static final String COPYFROM_REV_ATTR = "copyfrom-rev";
    protected static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    protected static final String INLINE_PROPS_ATTR = "inline-props";
    protected static final String SEND_ALL_ATTR = "send-all";
    protected static final String BC_URL_ATTR = "bc-url";
    protected static final String BASE_CHECKSUM_ATTR = "base-checksum";
    protected static final String PATH_ATTR = "path";
    protected static final String SHA1_CHECKSUM_ATTR = "sha1-checksum";
    protected ISVNEditor myEditor;
    protected String myPath;
    protected String myPropertyName;
    protected boolean myIsDirectory;
    protected Stack myDirs;
    protected Map myLockTokens;
    protected DAVRepository myOwner;
    protected boolean myIsFetchContent;
    private String myChecksum;
    private String myEncoding;
    private ISVNDeltaConsumer myDeltaConsumer;
    private boolean myIsAddPropsIncluded;
    private boolean myIsReceiveAll;
    private DAVConnection myConnection;
    private IHTTPConnectionFactory myConnectionFactory;
    private String myHref;
    private String myCurrentWCPath;
    private boolean myIsInResource;
    private boolean myIsFetchProps;
    private boolean myHasTarget;
    private Map myVersionURLs;
    private String mySha1Checksum;
    private ISVNWorkingCopyContentMediator myWorkingCopyContentMediator;

    public static StringBuffer generateEditorRequest(DAVConnection dAVConnection, StringBuffer stringBuffer, String string, long l2, String string2, String string3, SVNDepth sVNDepth, Map map, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ISVNReporterBaton iSVNReporterBaton) {
        stringBuffer = SVNXMLUtil.addXMLHeader(stringBuffer);
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put(SEND_ALL_ATTR, Boolean.toString(bl6));
        SVNXMLUtil.openNamespaceDeclarationTag("S", "update-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, sVNHashMap, stringBuffer, true);
        SVNXMLUtil.openCDataTag("S", "include-props", "yes", stringBuffer);
        SVNXMLUtil.openCDataTag("S", "src-path", string, stringBuffer);
        if (l2 >= 0L) {
            SVNXMLUtil.openCDataTag("S", "target-revision", String.valueOf(l2), stringBuffer);
        }
        if (string2 != null && !"".equals(string2)) {
            SVNXMLUtil.openCDataTag("S", "update-target", string2, stringBuffer);
        }
        if (string3 != null) {
            SVNXMLUtil.openCDataTag("S", "dst-path", string3, stringBuffer);
        }
        if (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.EMPTY) {
            SVNXMLUtil.openCDataTag("S", "recursive", "no", stringBuffer);
        }
        SVNXMLUtil.openCDataTag("S", "depth", SVNDepth.asString(sVNDepth), stringBuffer);
        if (bl2) {
            SVNXMLUtil.openCDataTag("S", "ignore-ancestry", "yes", stringBuffer);
        }
        if (bl5) {
            SVNXMLUtil.openCDataTag("S", "send-copyfrom-args", "yes", stringBuffer);
        }
        if (bl3) {
            SVNXMLUtil.openCDataTag("S", "resource-walk", "yes", stringBuffer);
        }
        if (bl6 && !bl4) {
            SVNXMLUtil.openCDataTag("S", "text-deltas", "no", stringBuffer);
        }
        StringBuffer stringBuffer2 = stringBuffer;
        iSVNReporterBaton.report(new DAVEditorHandler$1(stringBuffer2, map, dAVConnection));
        SVNXMLUtil.addXMLFooter("S", "update-report", stringBuffer);
        return stringBuffer;
    }

    public DAVEditorHandler(IHTTPConnectionFactory iHTTPConnectionFactory, DAVRepository dAVRepository, ISVNEditor iSVNEditor, Map map, boolean bl2, boolean bl3, ISVNWorkingCopyContentMediator iSVNWorkingCopyContentMediator) {
        this.myConnectionFactory = iHTTPConnectionFactory;
        this.myOwner = dAVRepository;
        this.myEditor = iSVNEditor;
        this.myIsFetchContent = bl2;
        this.myHasTarget = bl3;
        this.myLockTokens = map;
        this.myWorkingCopyContentMediator = iSVNWorkingCopyContentMediator;
        this.myDeltaConsumer = bl2 ? iSVNEditor : new DAVEditorHandler$2(this);
        this.init();
        this.myDirs = new Stack();
        this.myVersionURLs = new SVNHashMap();
    }

    public void closeConnection() {
        if (this.myConnection != null) {
            this.myConnection.close();
            this.myConnection = null;
        }
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
        if (dAVElement2 == UPDATE_REPORT) {
            String string;
            String string2 = attributes.getValue(INLINE_PROPS_ATTR);
            if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
                this.myIsAddPropsIncluded = true;
            }
            if ((string = attributes.getValue(SEND_ALL_ATTR)) != null && Boolean.valueOf(string).booleanValue()) {
                this.myIsReceiveAll = true;
                this.myIsAddPropsIncluded = true;
            }
        } else if (dAVElement2 == TARGET_REVISION) {
            long l2 = -1L;
            try {
                l2 = Long.parseLong(attributes.getValue(REVISION_ATTR));
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
            this.myEditor.targetRevision(l2);
        } else if (dAVElement2 == ABSENT_DIRECTORY) {
            String string = attributes.getValue(NAME_ATTR);
            this.myEditor.absentDir(SVNPathUtil.append(this.myPath, string));
        } else if (dAVElement2 == ABSENT_FILE) {
            String string = attributes.getValue(NAME_ATTR);
            this.myEditor.absentFile(SVNPathUtil.append(this.myPath, string));
        } else if (dAVElement2 == OPEN_DIRECTORY) {
            Object object;
            String string = attributes.getValue(REVISION_ATTR);
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing rev attr in open-directory element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            long l3 = -1L;
            try {
                l3 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
            this.myIsDirectory = true;
            if (this.myPath == null) {
                this.myPath = "";
                this.myEditor.openRoot(l3);
            } else {
                object = attributes.getValue(NAME_ATTR);
                if (object == null) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in open-directory element");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
                this.myPath = SVNPathUtil.append(this.myPath, (String)object);
                this.myEditor.openDir(this.myPath, l3);
            }
            object = new DAVEditorHandler$DirInfo(this);
            this.myDirs.push(object);
        } else if (dAVElement2 == ADD_DIRECTORY) {
            Object object;
            Object object2;
            Object object3;
            this.myIsDirectory = true;
            String string = attributes.getValue(NAME_ATTR);
            if (string == null) {
                object3 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in add-directory element");
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.NETWORK);
            }
            object3 = attributes.getValue(COPYFROM_PATH_ATTR);
            long l4 = -1L;
            if (object3 != null) {
                object2 = attributes.getValue(COPYFROM_REV_ATTR);
                if (object2 == null) {
                    object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing copyfrom-rev attr in add-directory element");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                }
                try {
                    l4 = Long.parseLong((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                }
            }
            this.myPath = SVNPathUtil.append(this.myPath, string);
            this.myEditor.addDir(this.myPath, (String)object3, l4);
            object2 = new DAVEditorHandler$DirInfo(this);
            this.myDirs.push(object2);
            if (!this.myIsAddPropsIncluded) {
                DAVEditorHandler$DirInfo.access$102((DAVEditorHandler$DirInfo)object2, true);
            }
            object = attributes.getValue(BC_URL_ATTR);
            if (!this.myIsReceiveAll && object != null && !this.myIsAddPropsIncluded) {
                DAVElement[] dAVElementArray = null;
                SVNHashMap sVNHashMap = new SVNHashMap();
                DAVUtil.getProperties(this.getConnection(), DAVUtil.getPathFromURL((String)object), 1, null, dAVElementArray, sVNHashMap);
                if (!sVNHashMap.isEmpty()) {
                    DAVEditorHandler$DirInfo.access$202((DAVEditorHandler$DirInfo)object2, new SVNHashMap());
                    for (DAVProperties dAVProperties : sVNHashMap.values()) {
                        SVNPropertyValue sVNPropertyValue = dAVProperties.getPropertyValue(DAVElement.CHECKED_IN);
                        if (sVNPropertyValue == null) continue;
                        DAVEditorHandler$DirInfo.access$200((DAVEditorHandler$DirInfo)object2).put(SVNPropertyValue.getPropertyAsString(sVNPropertyValue), dAVProperties);
                    }
                }
            }
        } else if (dAVElement2 == OPEN_FILE) {
            this.myIsDirectory = false;
            String string = attributes.getValue(REVISION_ATTR);
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing rev attr in open-file element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            long l5 = -1L;
            try {
                l5 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
            String string3 = attributes.getValue(NAME_ATTR);
            if (string3 == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in open-file element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.myPath = SVNPathUtil.append(this.myPath, string3);
            this.myEditor.openFile(this.myPath, l5);
            this.myIsFetchProps = false;
        } else if (dAVElement2 == ADD_FILE) {
            String string;
            Object object;
            this.myIsDirectory = false;
            String string4 = attributes.getValue(NAME_ATTR);
            if (string4 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in add-file element");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            this.myPath = SVNPathUtil.append(this.myPath, string4);
            object = attributes.getValue(COPYFROM_PATH_ATTR);
            long l6 = -1L;
            if (object != null) {
                string = attributes.getValue(COPYFROM_REV_ATTR);
                if (string == null) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing copyfrom-rev attr in add-file element");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
                try {
                    l6 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                }
            }
            string = attributes.getValue(SHA1_CHECKSUM_ATTR);
            this.myEditor.addFile(this.myPath, (String)object, l6);
            if (string != null) {
                this.myEditor.changeFileProperty(this.myPath, "svnkit:entry:sha1-checksum", SVNPropertyValue.create(string));
            }
            if (!this.myIsAddPropsIncluded) {
                this.myIsFetchProps = true;
            }
            this.mySha1Checksum = string;
        } else if (dAVElement2 == DELETE_ENTRY) {
            String string = attributes.getValue(NAME_ATTR);
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in delete-entry element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.myEditor.deleteEntry(SVNPathUtil.append(this.myPath, string), -1L);
        } else if (dAVElement2 == SET_PROP) {
            this.myPropertyName = attributes.getValue(NAME_ATTR);
            if (this.myPropertyName == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in set-prop element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.myEncoding = attributes.getValue(ENCODING_ATTR);
        } else if (dAVElement2 == REMOVE_PROP) {
            String string = attributes.getValue(NAME_ATTR);
            if (string == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in remove-prop element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            if (this.myIsDirectory) {
                this.myEditor.changeDirProperty(string, null);
            } else {
                this.myEditor.changeFileProperty(this.myPath, string, null);
            }
        } else if (dAVElement2 == FETCH_FILE) {
            String string = attributes.getValue(BASE_CHECKSUM_ATTR);
            String string5 = attributes.getValue(SHA1_CHECKSUM_ATTR);
            if (string5 != null) {
                this.myEditor.changeFileProperty(this.myPath, "svnkit:entry:sha1-checksum", SVNPropertyValue.create(string5));
            }
            this.myChecksum = null;
            this.mySha1Checksum = string5;
            if (!this.myIsReceiveAll) {
                this.fetchFile(string);
            }
        } else if (dAVElement2 == RESOURCE) {
            this.myCurrentWCPath = attributes.getValue(PATH_ATTR);
            if (this.myCurrentWCPath == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing path attr in resource element");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.myIsInResource = true;
        } else if (dAVElement2 == FETCH_PROPS) {
            if (this.myIsDirectory) {
                DAVEditorHandler$DirInfo dAVEditorHandler$DirInfo = (DAVEditorHandler$DirInfo)this.myDirs.peek();
                DAVEditorHandler$DirInfo.access$102(dAVEditorHandler$DirInfo, true);
            } else {
                this.myIsFetchProps = true;
            }
        } else if (dAVElement2 == TX_DELTA) {
            String string = attributes.getValue(BASE_CHECKSUM_ATTR);
            if (this.myIsReceiveAll) {
                this.setDeltaProcessing(true);
                this.myEditor.applyTextDelta(this.myPath, string);
            }
        }
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == RESOURCE) {
            this.myIsInResource = false;
        } else if (dAVElement2 == UPDATE_REPORT) {
            this.myEditor.closeEdit();
        } else if (dAVElement2 == OPEN_DIRECTORY || dAVElement2 == ADD_DIRECTORY) {
            if (this.myDirs.size() != 1 || !this.myHasTarget) {
                this.addNodeProperties(this.myPath, true);
            }
            this.myEditor.closeDir();
            this.myChecksum = null;
            this.myPath = SVNPathUtil.removeTail(this.myPath);
            this.myDirs.pop();
        } else if (dAVElement2 == ADD_FILE) {
            if (!this.myIsReceiveAll) {
                this.fetchFile(null);
                this.addNodeProperties(this.myPath, false);
            }
            this.myEditor.closeFile(this.myPath, this.myChecksum);
            this.myChecksum = null;
            this.mySha1Checksum = null;
            this.myPath = SVNPathUtil.removeTail(this.myPath);
            this.myIsDirectory = true;
        } else if (dAVElement2 == OPEN_FILE) {
            this.addNodeProperties(this.myPath, false);
            this.myEditor.closeFile(this.myPath, this.myChecksum);
            this.myChecksum = null;
            this.mySha1Checksum = null;
            this.myPath = SVNPathUtil.removeTail(this.myPath);
            this.myIsDirectory = true;
        } else if (dAVElement2 == DAVElement.MD5_CHECKSUM) {
            this.myChecksum = stringBuffer.toString();
        } else if (dAVElement2 == DAVElement.CREATOR_DISPLAY_NAME || dAVElement2 == DAVElement.VERSION_NAME || dAVElement2 == DAVElement.CREATION_DATE) {
            boolean bl2;
            if (this.myIsDirectory) {
                DAVEditorHandler$DirInfo dAVEditorHandler$DirInfo = (DAVEditorHandler$DirInfo)this.myDirs.peek();
                bl2 = !DAVEditorHandler$DirInfo.access$100(dAVEditorHandler$DirInfo);
            } else {
                boolean bl3 = bl2 = !this.myIsFetchProps;
            }
            if (bl2) {
                DAVUtil.setSpecialWCProperties(this.myEditor, this.myIsDirectory, this.myPath, dAVElement2, SVNPropertyValue.create(stringBuffer.toString()));
            }
        } else if (dAVElement2 == DAVElement.HREF) {
            this.myHref = stringBuffer.toString();
            if (this.myIsInResource) {
                this.myVersionURLs.put(this.myCurrentWCPath, this.myHref);
            } else if (this.myIsDirectory) {
                if (this.myDirs.size() != 1 || !this.myHasTarget) {
                    Object object;
                    try {
                        object = DAVUtil.isUseDAVWCURL() ? SVNPropertyValue.create(this.myHref) : null;
                        this.myEditor.changeDirProperty("svn:wc:ra_dav:version-url", (SVNPropertyValue)object);
                    }
                    catch (SVNCancelException sVNCancelException) {
                        throw sVNCancelException;
                    }
                    catch (SVNException sVNException) {
                        SVNErrorManager.error(sVNException.getErrorMessage().wrap("Could not save the URL of the version resource"), SVNLogType.NETWORK);
                    }
                    object = (DAVEditorHandler$DirInfo)this.myDirs.peek();
                    DAVEditorHandler$DirInfo.access$302((DAVEditorHandler$DirInfo)object, this.myHref);
                }
            } else if (this.myIsFetchContent) {
                try {
                    SVNPropertyValue sVNPropertyValue = DAVUtil.isUseDAVWCURL() ? SVNPropertyValue.create(this.myHref) : null;
                    this.myEditor.changeFileProperty(this.myPath, "svn:wc:ra_dav:version-url", sVNPropertyValue);
                }
                catch (SVNCancelException sVNCancelException) {
                    throw sVNCancelException;
                }
                catch (SVNException sVNException) {
                    SVNErrorManager.error(sVNException.getErrorMessage().wrap("Could not save the URL of the version resource"), SVNLogType.NETWORK);
                }
            }
        } else if (dAVElement2 == SET_PROP) {
            if (this.myPropertyName == null) {
                this.myPropertyName = DAVEditorHandler.computeWCPropertyName(dAVElement2);
            }
            SVNPropertyValue sVNPropertyValue = this.createPropertyValue(null, this.myPropertyName, stringBuffer, this.myEncoding);
            if (this.myIsDirectory) {
                this.myEditor.changeDirProperty(this.myPropertyName, sVNPropertyValue);
            } else {
                this.myEditor.changeFileProperty(this.myPath, this.myPropertyName, sVNPropertyValue);
            }
            this.myPropertyName = null;
            this.myEncoding = null;
        } else if (dAVElement2 == TX_DELTA && this.myIsReceiveAll) {
            this.setDeltaProcessing(false);
        }
    }

    @Override
    protected String getCurrentPath() {
        return this.myPath;
    }

    @Override
    protected ISVNDeltaConsumer getDeltaConsumer() {
        return this.myDeltaConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchFile(String string) {
        this.setDeltaProcessing(true);
        try {
            this.myEditor.applyTextDelta(this.myPath, string);
        }
        catch (SVNCancelException sVNCancelException) {
            throw sVNCancelException;
        }
        catch (SVNException sVNException) {
            SVNErrorManager.error(sVNException.getErrorMessage().wrap("Could not save file"), SVNLogType.NETWORK);
        }
        if (this.myIsFetchContent) {
            InputStream inputStream;
            block11: {
                inputStream = null;
                try {
                    SVNErrorManager.assertionFailure(this.myHref != null, "myHref is null", SVNLogType.NETWORK);
                    String string2 = this.myPath != null ? (String)this.myVersionURLs.get(this.myPath) : null;
                    DAVEditorHandler$DeltaOutputStreamWrapper dAVEditorHandler$DeltaOutputStreamWrapper = new DAVEditorHandler$DeltaOutputStreamWrapper(this, string2 != null, this.myPath);
                    if (this.myWorkingCopyContentMediator != null) {
                        inputStream = this.myWorkingCopyContentMediator.getContentAsStream(new SvnChecksum(SvnChecksum$Kind.sha1, this.mySha1Checksum));
                    }
                    if (inputStream != null) {
                        try {
                            FSRepositoryUtil.copy(inputStream, dAVEditorHandler$DeltaOutputStreamWrapper, null);
                            break block11;
                        }
                        finally {
                            SVNFileUtil.closeFile(dAVEditorHandler$DeltaOutputStreamWrapper);
                        }
                    }
                    DAVConnection dAVConnection = this.getConnection();
                    dAVConnection.doGet(this.myHref, string2, dAVEditorHandler$DeltaOutputStreamWrapper);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(inputStream);
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(inputStream);
        }
        this.setDeltaProcessing(false);
    }

    protected void addNodeProperties(String string, boolean bl2) {
        if (this.myIsReceiveAll) {
            return;
        }
        if (!bl2) {
            Object object;
            Object object2;
            if (!this.myIsFetchContent && !this.myIsFetchProps) {
                return;
            }
            String string2 = (String)this.myLockTokens.get(string);
            if (string2 != null) {
                object2 = this.myOwner.doGetFullPath(string);
                object2 = SVNEncodingUtil.uriEncode((String)object2);
                object = this.getConnection();
                SVNLock sVNLock = ((DAVConnection)object).doGetLock((String)object2, this.myOwner);
                if (sVNLock == null || sVNLock.getID() == null || !string2.equals(sVNLock.getID())) {
                    this.myEditor.changeFileProperty(string, "svn:entry:lock-token", null);
                }
            }
            if (!this.myIsFetchProps) {
                return;
            }
            object2 = (DAVEditorHandler$DirInfo)this.myDirs.peek();
            Object object3 = object = DAVEditorHandler$DirInfo.access$200((DAVEditorHandler$DirInfo)object2) != null ? (DAVProperties)DAVEditorHandler$DirInfo.access$200((DAVEditorHandler$DirInfo)object2).get(this.myHref) : null;
            if (object == null) {
                object = DAVUtil.getResourceProperties(this.getConnection(), this.myHref, null, null);
            }
            this.addProps((DAVProperties)object, false);
        } else {
            DAVProperties dAVProperties;
            DAVEditorHandler$DirInfo dAVEditorHandler$DirInfo = (DAVEditorHandler$DirInfo)this.myDirs.peek();
            if (!DAVEditorHandler$DirInfo.access$100(dAVEditorHandler$DirInfo)) {
                return;
            }
            DAVProperties dAVProperties2 = dAVProperties = DAVEditorHandler$DirInfo.access$200(dAVEditorHandler$DirInfo) != null ? (DAVProperties)DAVEditorHandler$DirInfo.access$200(dAVEditorHandler$DirInfo).get(DAVEditorHandler$DirInfo.access$300(dAVEditorHandler$DirInfo)) : null;
            if (dAVProperties == null) {
                dAVProperties = DAVUtil.getResourceProperties(this.getConnection(), DAVEditorHandler$DirInfo.access$300(dAVEditorHandler$DirInfo), null, null);
            }
            this.addProps(dAVProperties, true);
        }
    }

    private void addProps(DAVProperties dAVProperties, boolean bl2) {
        Map map = dAVProperties.getProperties();
        for (DAVElement dAVElement : map.keySet()) {
            String string;
            SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)map.get(dAVElement);
            String string2 = dAVElement.getNamespace();
            if (string2.equals("http://subversion.tigris.org/xmlns/custom/")) {
                string = dAVElement.getName();
                if (bl2) {
                    this.myEditor.changeDirProperty(string, sVNPropertyValue);
                    continue;
                }
                this.myEditor.changeFileProperty(this.myPath, string, sVNPropertyValue);
                continue;
            }
            if (string2.equals("http://subversion.tigris.org/xmlns/svn/")) {
                string = "svn:" + dAVElement.getName();
                if (bl2) {
                    this.myEditor.changeDirProperty(string, sVNPropertyValue);
                    continue;
                }
                this.myEditor.changeFileProperty(this.myPath, string, sVNPropertyValue);
                continue;
            }
            DAVUtil.setSpecialWCProperties(this.myEditor, bl2, this.myPath, dAVElement, sVNPropertyValue);
        }
    }

    private DAVConnection getConnection() {
        if (this.myConnection == null) {
            this.myConnection = new DAVConnection(this.myConnectionFactory, this.myOwner);
            this.myConnection.setReportResponseSpooled(this.myOwner.isSpoolResponse());
            this.myConnection.open(this.myOwner);
        }
        return this.myConnection;
    }

    private static String computeWCPropertyName(DAVElement dAVElement) {
        return "svn:entry:" + dAVElement.getName();
    }

    static /* synthetic */ ISVNDeltaConsumer access$400(DAVEditorHandler dAVEditorHandler) {
        return dAVEditorHandler.myDeltaConsumer;
    }
}

