/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVDateRevisionHandler
extends BasicDAVHandler {
    private long myRevisionNumber;

    public static StringBuffer generateDateRevisionRequest(StringBuffer stringBuffer, Date date) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "dated-rev-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openCDataTag("D", "creationdate", SVNDate.formatDate(date), stringBuffer);
        SVNXMLUtil.addXMLFooter("S", "dated-rev-report", stringBuffer);
        return stringBuffer;
    }

    public DAVDateRevisionHandler() {
        this.init();
        this.myRevisionNumber = -1L;
    }

    public long getRevisionNumber() {
        return this.myRevisionNumber;
    }

    @Override
    protected void endElement(DAVElement dAVElement, DAVElement dAVElement2, StringBuffer stringBuffer) {
        if (dAVElement2 == DAVElement.VERSION_NAME && stringBuffer != null) {
            try {
                this.myRevisionNumber = Long.parseLong(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
        }
    }

    @Override
    protected void startElement(DAVElement dAVElement, DAVElement dAVElement2, Attributes attributes) {
    }
}

