/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BasicDAVHandler
extends DefaultHandler {
    protected static final Collection SVN_DAV_NAMESPACES_LIST = new LinkedList();
    protected static final Collection SVN_NAMESPACES_LIST = new LinkedList();
    protected static final Collection DAV_NAMESPACES_LIST = new LinkedList();
    private static final Object ROOT;
    private Map myPrefixesMap = new SVNHashMap();
    private List myNamespacesCollection = new LinkedList();
    private String myNamespace;
    private StringBuffer myCDATA;
    private Stack myParent = new Stack();
    private byte[] myDeltaBuffer;

    protected BasicDAVHandler() {
    }

    private void setNamespace(String string) {
        this.myNamespace = "".equals(string) ? null : string;
    }

    protected void init() {
        this.myPrefixesMap.clear();
        this.myNamespacesCollection.clear();
        this.myParent.clear();
        this.myParent.push(ROOT);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.setNamespace(string);
        DAVElement dAVElement = this.getDAVElement(string3, string2, this.myNamespace);
        try {
            this.startElement(this.getParent(), dAVElement, attributes);
        }
        catch (SVNException sVNException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, sVNException);
            throw new SAXException(sVNException);
        }
        this.myParent.push(dAVElement);
        this.myCDATA = new StringBuffer();
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.myParent.pop();
        String string4 = string != null && !"".equals(string) ? string : this.myNamespace;
        DAVElement dAVElement = this.getDAVElement(string3, string2, string4);
        try {
            this.endElement(this.getParent(), dAVElement, this.myCDATA);
        }
        catch (SVNException sVNException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, sVNException);
            throw new SAXException(sVNException);
        }
        this.myCDATA = null;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (this.myCDATA != null) {
            this.myCDATA.append(cArray, n2, n3);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        Stack<String> stack = (Stack<String>)this.myPrefixesMap.get(string);
        if (stack == null) {
            stack = new Stack<String>();
            this.myPrefixesMap.put(string, stack);
        }
        stack.push(string2);
        if (!this.myNamespacesCollection.contains(string2)) {
            this.myNamespacesCollection.add(string2);
        }
    }

    @Override
    public void endPrefixMapping(String string) {
        Stack stack = (Stack)this.myPrefixesMap.get(string);
        if (stack != null) {
            stack.pop();
        }
    }

    protected abstract void startElement(DAVElement var1, DAVElement var2, Attributes var3);

    protected abstract void endElement(DAVElement var1, DAVElement var2, StringBuffer var3);

    protected void invalidXML() {
        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, "Malformed XML"), SVNLogType.NETWORK);
    }

    protected List getNamespaces() {
        return this.myNamespacesCollection;
    }

    private DAVElement getParent() {
        Object e2 = this.myParent.peek();
        if (e2 == ROOT) {
            return null;
        }
        return (DAVElement)e2;
    }

    private DAVElement getDAVElement(String string, String string2, String string3) {
        if (string == null || string.trim().length() == 0) {
            string = string2;
        }
        String string4 = string3;
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            string4 = string.substring(0, n2);
            Stack stack = (Stack)this.myPrefixesMap.get(string4);
            if (stack != null && !stack.isEmpty()) {
                string4 = (String)stack.peek();
            }
            string = string.substring(n2 + 1);
        }
        return DAVElement.getElement(string4, string);
    }

    protected SVNPropertyValue createPropertyValue(DAVElement dAVElement, String string, StringBuffer stringBuffer, String string2) {
        Object object;
        if ("base64".equalsIgnoreCase(string2)) {
            return this.createPropertyValueFromBase64(dAVElement, string, stringBuffer);
        }
        if (string2 != null && !"".equals(string2)) {
            object = SVNErrorMessage.create(SVNErrorCode.XML_UNKNOWN_ENCODING, "Unknown XML encoding: ''{0}''", (Object)string2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        if (this.useStringProperty(dAVElement, string)) {
            return SVNPropertyValue.create(stringBuffer.toString());
        }
        try {
            object = stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = stringBuffer.toString().getBytes();
        }
        return SVNPropertyValue.create(string, (byte[])object);
    }

    protected SVNPropertyValue createPropertyValueFromBase64(DAVElement dAVElement, String string, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = SVNBase64.normalizeBase64(stringBuffer);
        byte[] byArray = this.allocateBuffer(stringBuffer2.length());
        int n2 = SVNBase64.base64ToByteArray(stringBuffer2, byArray);
        if (this.useStringProperty(dAVElement, string)) {
            String string2;
            try {
                string2 = new String(byArray, 0, n2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = new String(byArray, 0, n2);
            }
            return SVNPropertyValue.create(string2);
        }
        return SVNPropertyValue.create(string, byArray, 0, n2);
    }

    private boolean useStringProperty(DAVElement dAVElement, String string) {
        String string2 = dAVElement == null ? null : dAVElement.getNamespace();
        return SVNProperty.isSVNProperty(string) || "http://subversion.tigris.org/xmlns/dav/".equals(string2) || "http://subversion.tigris.org/xmlns/svn/".equals(string2) || "svn:".equals(string2) || "DAV:".equals(string2);
    }

    protected byte[] allocateBuffer(int n2) {
        if (this.myDeltaBuffer == null || this.myDeltaBuffer.length < n2) {
            this.myDeltaBuffer = new byte[n2 * 3 / 2];
        }
        return this.myDeltaBuffer;
    }

    static {
        SVN_DAV_NAMESPACES_LIST.add("svn:");
        SVN_DAV_NAMESPACES_LIST.add("DAV:");
        SVN_NAMESPACES_LIST.add("svn:");
        DAV_NAMESPACES_LIST.add("DAV:");
        ROOT = new Object();
    }
}

