/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.xml.sax.SAXException;

public abstract class BasicDAVDeltaHandler
extends BasicDAVHandler {
    protected static final DAVElement TX_DELTA = DAVElement.getElement("svn:", "txdelta");
    private boolean myIsDeltaProcessing;
    private SVNDeltaReader myDeltaReader;
    private StringBuffer myDeltaOutputStream;

    protected void setDeltaProcessing(boolean bl2) {
        this.myIsDeltaProcessing = bl2;
        if (!this.myIsDeltaProcessing) {
            this.myDeltaReader.reset(this.getCurrentPath(), this.getDeltaConsumer());
            this.getDeltaConsumer().textDeltaEnd(this.getCurrentPath());
        } else {
            this.myDeltaOutputStream.delete(0, this.myDeltaOutputStream.length());
        }
    }

    @Override
    protected void init() {
        this.myDeltaReader = new SVNDeltaReader();
        this.myDeltaOutputStream = new StringBuffer();
        super.init();
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (this.myIsDeltaProcessing) {
            int n4;
            int n5;
            int n6 = n2;
            for (n5 = n2; n5 < n2 + n3; ++n5) {
                if (cArray[n5] != '\r' && cArray[n5] != '\n') continue;
                this.myDeltaOutputStream.append(cArray, n6, n5 - n6);
                n6 = n5 + 1;
                if (n5 + 1 >= n2 + n3 || cArray[n5 + 1] != '\n') continue;
                ++n6;
                ++n5;
            }
            if (n6 < n2 + n3) {
                this.myDeltaOutputStream.append(cArray, n6, n2 + n3 - n6);
            }
            if ((n5 = this.myDeltaOutputStream.length()) < 4) {
                return;
            }
            int n7 = n5 / 4;
            int n8 = n5 - n7 * 4;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.myDeltaOutputStream);
            stringBuffer.delete(this.myDeltaOutputStream.length() - n8, this.myDeltaOutputStream.length());
            for (n4 = 0; n4 < stringBuffer.length() && Character.isWhitespace(stringBuffer.charAt(n4)); ++n4) {
            }
            if (n4 > 0) {
                stringBuffer = stringBuffer.delete(0, n4);
            }
            for (n4 = stringBuffer.length() - 1; n4 >= 0 && Character.isWhitespace(stringBuffer.charAt(n4)); --n4) {
                stringBuffer.delete(n4, stringBuffer.length());
            }
            byte[] byArray = this.allocateBuffer(stringBuffer.length());
            try {
                int n9 = SVNBase64.base64ToByteArray(stringBuffer, byArray);
                this.myDeltaReader.nextWindow(byArray, 0, n9, this.getCurrentPath(), this.getDeltaConsumer());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException(illegalArgumentException);
            }
            catch (SVNException sVNException) {
                throw new SAXException(sVNException);
            }
            this.myDeltaOutputStream.delete(0, stringBuffer.length());
        } else {
            super.characters(cArray, n2, n3);
        }
    }

    protected abstract String getCurrentPath();

    protected abstract ISVNDeltaConsumer getDeltaConsumer();
}

