/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.Serializable;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVPropertiesHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVUtil {
    public static int DEPTH_ZERO = 0;
    public static int DEPTH_ONE = 1;
    public static int DEPTH_INFINITE = -1;
    private static boolean ourIsUseDAVWCURL = true;

    public static synchronized boolean isUseDAVWCURL() {
        return ourIsUseDAVWCURL;
    }

    public static synchronized void setUseDAVWCURL(boolean bl2) {
        ourIsUseDAVWCURL = bl2;
    }

    public static HTTPStatus getProperties(DAVConnection dAVConnection, String string, int n2, String string2, DAVElement[] dAVElementArray, Map map) {
        Serializable serializable;
        HTTPHeader hTTPHeader = new HTTPHeader();
        if (n2 == DEPTH_ZERO) {
            hTTPHeader.setHeaderValue("Depth", "0");
        } else if (n2 == DEPTH_ONE) {
            hTTPHeader.setHeaderValue("Depth", "1");
        } else if (n2 == DEPTH_INFINITE) {
            hTTPHeader.setHeaderValue("Depth", "infinity");
        } else {
            serializable = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Invalid PROPFIND depth value: ''{0}''", new Object[]{n2});
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
        }
        if (string2 != null) {
            hTTPHeader.setHeaderValue("Label", string2);
        }
        serializable = DAVPropertiesHandler.generatePropertiesRequest(null, dAVElementArray);
        DAVPropertiesHandler dAVPropertiesHandler = new DAVPropertiesHandler();
        dAVPropertiesHandler.setDAVProperties(map);
        return dAVConnection.doPropfind(string, hTTPHeader, (StringBuffer)serializable, dAVPropertiesHandler);
    }

    public static DAVProperties getResourceProperties(DAVConnection dAVConnection, String string, String string2, DAVElement[] dAVElementArray) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        HTTPStatus hTTPStatus = DAVUtil.getProperties(dAVConnection, string, DEPTH_ZERO, string2, dAVElementArray, sVNHashMap);
        if (hTTPStatus.getError() != null) {
            SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
        }
        if (!sVNHashMap.isEmpty()) {
            return (DAVProperties)sVNHashMap.values().iterator().next();
        }
        string2 = string2 == null ? "NULL" : string2;
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Failed to find label ''{0}'' for URL ''{1}''", string2, string);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        return null;
    }

    public static String getPropertyValue(DAVConnection dAVConnection, String string, String string2, DAVElement dAVElement) {
        DAVProperties dAVProperties = DAVUtil.getResourceProperties(dAVConnection, string, string2, new DAVElement[]{dAVElement});
        SVNPropertyValue sVNPropertyValue = dAVProperties.getPropertyValue(dAVElement);
        if (sVNPropertyValue == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_PROPS_NOT_FOUND, "''{0}'' was not present on the resource", (Object)dAVElement.toString());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return sVNPropertyValue.getString();
    }

    public static DAVProperties getStartingProperties(DAVConnection dAVConnection, String string, String string2) {
        return DAVUtil.getResourceProperties(dAVConnection, string, string2, DAVElement.STARTING_PROPERTIES);
    }

    public static DAVProperties findStartingProperties(DAVConnection dAVConnection, DAVRepository dAVRepository, String string) {
        String string2;
        Object object;
        DAVProperties dAVProperties = null;
        String string3 = string;
        String string4 = "";
        if ("".equals(string)) {
            dAVProperties = DAVUtil.getStartingProperties(dAVConnection, string, null);
            if (dAVProperties != null) {
                if (dAVProperties.getPropertyValue(DAVElement.REPOSITORY_UUID) != null && dAVRepository != null) {
                    dAVRepository.setRepositoryUUID(dAVProperties.getPropertyValue(DAVElement.REPOSITORY_UUID).getString());
                }
                dAVProperties.setLoppedPath(string4);
            }
            return dAVProperties;
        }
        while (!"".equals(string)) {
            object = null;
            string2 = null;
            try {
                dAVProperties = DAVUtil.getStartingProperties(dAVConnection, string, null);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage() == null) {
                    throw sVNException;
                }
                object = sVNException.getErrorMessage();
            }
            if (object == null) break;
            if (((SVNErrorMessage)object).getErrorCode() != SVNErrorCode.FS_NOT_FOUND) {
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            string4 = SVNPathUtil.append(SVNPathUtil.tail(string), string4);
            int n2 = string.length();
            string = SVNPathUtil.removeTail(string);
            if (n2 > 1 && "".equals(string)) {
                string = "/";
            }
            if (n2 != string.length()) continue;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(((SVNErrorMessage)object).getErrorCode(), "The path was not part of repository");
            SVNErrorManager.error(sVNErrorMessage, (SVNErrorMessage)object, (Throwable)((Object)string2), SVNLogType.NETWORK);
        }
        if ("".equals(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "No part of path ''{0}'' was found in repository HEAD", (Object)string3);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        if (dAVProperties != null) {
            if (dAVProperties.getPropertyValue(DAVElement.REPOSITORY_UUID) != null && dAVRepository != null) {
                dAVRepository.setRepositoryUUID(dAVProperties.getPropertyValue(DAVElement.REPOSITORY_UUID).getString());
            }
            if (dAVProperties.getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH) != null && dAVRepository != null) {
                object = dAVProperties.getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH).getString();
                object = SVNEncodingUtil.uriEncode((String)object);
                string2 = string.substring(0, string.length() - ((String)object).length());
                dAVRepository.setRepositoryRoot(dAVRepository.getLocation().setPath(string2, true));
            }
            dAVProperties.setLoppedPath(string4);
        }
        return dAVProperties;
    }

    public static String getVCCPath(DAVConnection dAVConnection, DAVRepository dAVRepository, String string) {
        DAVProperties dAVProperties = DAVUtil.findStartingProperties(dAVConnection, dAVRepository, string);
        SVNPropertyValue sVNPropertyValue = dAVProperties.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        if (sVNPropertyValue == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The VCC property was not found on the resource");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return sVNPropertyValue.getString();
    }

    public static DAVBaselineInfo getStableURL(DAVConnection dAVConnection, DAVRepository dAVRepository, String string, long l2, boolean bl2, boolean bl3, DAVBaselineInfo dAVBaselineInfo) {
        if (dAVConnection.hasHttpV2Support()) {
            dAVBaselineInfo = dAVBaselineInfo == null ? new DAVBaselineInfo() : dAVBaselineInfo;
            dAVBaselineInfo.revision = SVNRevision.isValidRevisionNumber(l2) ? l2 : DAVUtil.getLatestRevisionHttpV2(dAVConnection);
            dAVBaselineInfo.baselineBase = SVNPathUtil.append(dAVConnection.myRevRootStub, String.valueOf(dAVBaselineInfo.revision));
            dAVBaselineInfo.baselinePath = dAVConnection.getRelativePath(string);
            return dAVBaselineInfo;
        }
        return DAVUtil.getBaselineInfo(dAVConnection, dAVRepository, string, l2, bl2, bl3, dAVBaselineInfo);
    }

    public static DAVBaselineInfo getBaselineInfo(DAVConnection dAVConnection, DAVRepository dAVRepository, String string, long l2, boolean bl2, boolean bl3, DAVBaselineInfo dAVBaselineInfo) {
        Object object;
        Serializable serializable;
        DAVElement[] dAVElementArray;
        DAVBaselineInfo dAVBaselineInfo2 = dAVBaselineInfo = dAVBaselineInfo == null ? new DAVBaselineInfo() : dAVBaselineInfo;
        if (bl3) {
            dAVElementArray = DAVElement.BASELINE_PROPERTIES;
        } else {
            DAVElement[] dAVElementArray2 = new DAVElement[1];
            dAVElementArray = dAVElementArray2;
            dAVElementArray2[0] = DAVElement.BASELINE_COLLECTION;
        }
        DAVElement[] dAVElementArray3 = dAVElementArray;
        DAVProperties dAVProperties = DAVUtil.getBaselineProperties(dAVConnection, dAVRepository, string, l2, dAVElementArray3);
        dAVBaselineInfo.baselinePath = dAVProperties.getURL();
        SVNPropertyValue sVNPropertyValue = dAVProperties.getPropertyValue(DAVElement.BASELINE_COLLECTION);
        dAVBaselineInfo.baselineBase = sVNPropertyValue == null ? null : sVNPropertyValue.getString();
        dAVBaselineInfo.baseline = dAVProperties.getOriginalURL();
        if (dAVBaselineInfo.baselineBase == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "'DAV:baseline-collection' not present on the baseline resource");
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
        }
        if (bl3) {
            serializable = dAVProperties.getPropertyValue(DAVElement.VERSION_NAME);
            if (serializable == null) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "'DAV:version-name' not present on the baseline resource");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            try {
                dAVBaselineInfo.revision = Long.parseLong(((SVNPropertyValue)serializable).getString());
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
        }
        if (bl2) {
            serializable = new SVNHashMap();
            string = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            object = DAVUtil.getProperties(dAVConnection, string, 0, null, new DAVElement[]{DAVElement.RESOURCE_TYPE}, (Map)((Object)serializable));
            if (((HTTPStatus)object).getError() != null) {
                SVNErrorManager.error(((HTTPStatus)object).getError(), SVNLogType.NETWORK);
            }
            if (!serializable.isEmpty()) {
                DAVProperties dAVProperties2 = (DAVProperties)serializable.values().iterator().next();
                dAVBaselineInfo.isDirectory = dAVProperties2 != null && dAVProperties2.isCollection();
            }
        }
        return dAVBaselineInfo;
    }

    public static DAVProperties getBaselineProperties(DAVConnection dAVConnection, DAVRepository dAVRepository, String string, long l2, DAVElement[] dAVElementArray) {
        Object object;
        Serializable serializable;
        boolean bl2;
        boolean bl3 = bl2 = dAVRepository != null ? dAVRepository.isHttpV2Enabled() : ((DAVRepository)dAVConnection.getRepository()).isHttpV2Enabled();
        if (bl2) {
            if (l2 < 0L) {
                l2 = DAVUtil.getLatestRevisionHttpV2(dAVConnection);
            }
            String string2 = dAVConnection.myRevStub + "/" + l2;
            return DAVUtil.getResourceProperties(dAVConnection, string2, String.valueOf(-1L), dAVElementArray);
        }
        DAVProperties dAVProperties = null;
        String string3 = "";
        dAVProperties = DAVUtil.findStartingProperties(dAVConnection, dAVRepository, string);
        SVNPropertyValue sVNPropertyValue = dAVProperties.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        if (sVNPropertyValue == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The VCC property was not found on the resource");
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
        }
        string3 = dAVProperties.getLoppedPath();
        serializable = dAVProperties.getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH);
        if (serializable == null) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The relative-path property was not found on the resource");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = SVNEncodingUtil.uriEncode(((SVNPropertyValue)serializable).getString());
        object = SVNPathUtil.append((String)object, string3);
        String string4 = null;
        String string5 = sVNPropertyValue.getString();
        if (l2 < 0L) {
            string5 = DAVUtil.getPropertyValue(dAVConnection, string5, null, DAVElement.CHECKED_IN);
        } else {
            string4 = Long.toString(l2);
        }
        dAVProperties = DAVUtil.getResourceProperties(dAVConnection, string5, string4, dAVElementArray);
        dAVProperties.setURL((String)object);
        return dAVProperties;
    }

    public static long getLatestRevisionHttpV2(DAVConnection dAVConnection) {
        SVNErrorMessage sVNErrorMessage;
        dAVConnection.myLatestRevision = -1L;
        HTTPStatus hTTPStatus = dAVConnection.doOptions(dAVConnection.getLocation().getPath());
        if (hTTPStatus.getCode() != 200) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "OPTIONS request (for latest revision) got HTTP response code {0}", new Object[]{hTTPStatus.getCode()});
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        dAVConnection.parseCapabilities(hTTPStatus);
        if (!SVNRevision.isValidRevisionNumber(dAVConnection.myLatestRevision)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "The OPTIONS response did not include the youngest revision");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return dAVConnection.myLatestRevision;
    }

    public static SVNProperties filterProperties(DAVProperties dAVProperties, SVNProperties sVNProperties) {
        sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
        for (Map.Entry entry : dAVProperties.getProperties().entrySet()) {
            DAVElement dAVElement = (DAVElement)entry.getKey();
            SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
            String string = DAVUtil.getPropertyNameByElement(dAVElement);
            if (string == null) continue;
            sVNProperties.put(string, sVNPropertyValue);
        }
        return sVNProperties;
    }

    public static String getPropertyNameByElement(DAVElement dAVElement) {
        if (dAVElement == null) {
            return null;
        }
        String string = dAVElement.getNamespace();
        String string2 = dAVElement.getName();
        if (string.equals("http://subversion.tigris.org/xmlns/custom/")) {
            if (string2.startsWith("svk_")) {
                string2 = string2.substring(0, "svk".length()) + ":" + string2.substring("svk".length() + 1);
            }
            return string2;
        }
        if (string.equals("http://subversion.tigris.org/xmlns/svn/")) {
            return "svn:" + string2;
        }
        if (dAVElement == DAVElement.CHECKED_IN) {
            return "svn:wc:ra_dav:version-url";
        }
        return null;
    }

    public static void setSpecialWCProperties(SVNProperties sVNProperties, DAVElement dAVElement, SVNPropertyValue sVNPropertyValue) {
        DAVUtil.setSpecialWCProperties(sVNProperties, dAVElement, sVNPropertyValue, false);
    }

    public static void setSpecialWCProperties(SVNProperties sVNProperties, DAVElement dAVElement, SVNPropertyValue sVNPropertyValue, boolean bl2) {
        String string = DAVUtil.convertDAVElementToPropName(dAVElement, bl2);
        if (string != null) {
            sVNProperties.put(string, sVNPropertyValue);
        }
    }

    public static void setSpecialWCProperties(ISVNEditor iSVNEditor, boolean bl2, String string, DAVElement dAVElement, SVNPropertyValue sVNPropertyValue) {
        String string2 = DAVUtil.convertDAVElementToPropName(dAVElement, bl2);
        if (string2 != null) {
            if (bl2) {
                iSVNEditor.changeDirProperty(string2, sVNPropertyValue);
            } else {
                iSVNEditor.changeFileProperty(string, string2, sVNPropertyValue);
            }
        }
    }

    public static String getPathFromURL(String string) {
        String string2 = "://";
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        string = string.substring(string2.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '/' && c2 != '?' && c2 != '#') continue;
            return string.substring(i2);
        }
        return "/";
    }

    private static String convertDAVElementToPropName(DAVElement dAVElement, boolean bl2) {
        String string = null;
        if (dAVElement == DAVElement.VERSION_NAME) {
            string = "svn:entry:committed-rev";
        } else if (dAVElement == DAVElement.CREATOR_DISPLAY_NAME) {
            string = "svn:entry:last-author";
        } else if (dAVElement == DAVElement.CREATION_DATE) {
            string = "svn:entry:committed-date";
        } else if (dAVElement == DAVElement.REPOSITORY_UUID) {
            string = "svn:entry:uuid";
        } else if (dAVElement == DAVElement.MD5_CHECKSUM && !bl2) {
            string = "svn:entry:checksum";
        } else if (dAVElement == DAVElement.SHA1_CHECKSUM && !bl2) {
            string = "svnkit:entry:sha1-checksum";
        }
        return string;
    }

    public static SVNErrorMessage createUnexpectedStatusErrorMessage(HTTPStatus hTTPStatus, String string, String string2) {
        SVNErrorMessage sVNErrorMessage;
        int n2 = hTTPStatus.getCode();
        String string3 = hTTPStatus.getHeader().getFirstHeaderValue("Location");
        if (n2 != 405 && (sVNErrorMessage = DAVUtil.createDefaultUnexpectedStatusErrorMessage(hTTPStatus, string2, string3)) != null) {
            return sVNErrorMessage;
        }
        switch (n2) {
            case 201: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Path ''{0}'' unexpectedly created", (Object)string2);
            }
            case 204: {
                return SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)string2);
            }
            case 405: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_METHOD_NOT_ALLOWED, "The HTTP method ''{0}'' is not allowed on ''{1}''", string, string2);
            }
        }
        return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unexpected HTTP status {0} ''{1}'' on ''{2}'' request to ''{3}''", n2, hTTPStatus.getReason(), string, string2);
    }

    private static SVNErrorMessage createDefaultUnexpectedStatusErrorMessage(HTTPStatus hTTPStatus, String string, String string2) {
        int n2 = hTTPStatus.getCode();
        switch (n2) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, n2 == 301 ? "Repository moved permanently to ''{0}''" : "Repository moved temporarily to '%s'", (Object)string2);
            }
            case 403: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_FORBIDDEN, "Access to ''{0}'' forbidden", (Object)string);
            }
            case 404: {
                return SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' path not found", (Object)string);
            }
            case 405: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_METHOD_NOT_ALLOWED, "HTTP method is not allowed on ''{0}''", (Object)string);
            }
            case 409: {
                return SVNErrorMessage.create(SVNErrorCode.FS_CONFLICT, "''{0}'' conflicts", (Object)string);
            }
            case 412: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_PRECONDITION_FAILED, "Precondition on ''{0}'' failed", (Object)string);
            }
            case 423: {
                return SVNErrorMessage.create(SVNErrorCode.FS_NO_LOCK_TOKEN, "''{0}'': no lock token available", (Object)string);
            }
            case 411: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "DAV request failed: 411 Content length required. The server or an intermediate proxy does not accept chunked encoding. Try setting 'http-chunked-requests' to 'auto' or 'no' in your client configuration.");
            }
            case 500: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unexpected server error {0} ''{1}'' on ''{2}''", n2, hTTPStatus.getReason(), string);
            }
            case 501: {
                return SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The requested feature is not supported by '%s'", (Object)string);
            }
        }
        if (n2 >= 300 || n2 <= 199) {
            return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unexpected HTTP status {0} ''{1}'' on ''{2}''", n2, hTTPStatus.getReason(), string);
        }
        return null;
    }
}

