/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.util.SVNLogType;

class DAVResource {
    private String myWURL;
    private String myVURL;
    private String myURL;
    private String myPath;
    private ISVNWorkspaceMediator myMediator;
    private long myRevision;
    private boolean myIsCopy;
    private DAVConnection myConnection;
    private SVNProperties myProperties;
    private boolean myIsAdded;
    private String myCustomURL;

    public DAVResource(ISVNWorkspaceMediator iSVNWorkspaceMediator, DAVConnection dAVConnection, String string, long l2) {
        this(iSVNWorkspaceMediator, dAVConnection, string, l2, false);
    }

    public DAVResource(ISVNWorkspaceMediator iSVNWorkspaceMediator, DAVConnection dAVConnection, String string, long l2, boolean bl2) {
        this.myPath = string;
        this.myMediator = iSVNWorkspaceMediator;
        String string2 = SVNEncodingUtil.uriEncode(dAVConnection.getLocation().getPath());
        this.myURL = SVNPathUtil.append(string2, string);
        this.myRevision = l2;
        this.myConnection = dAVConnection;
        this.myIsCopy = bl2;
    }

    public void setAdded(boolean bl2) {
        this.myIsAdded = bl2;
    }

    public boolean isAdded() {
        return this.myIsAdded;
    }

    public boolean isCopy() {
        return this.myIsCopy;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getVersionURL() {
        return this.myVURL;
    }

    public void fetchVersionURL(DAVResource dAVResource, boolean bl2) {
        DAVBaselineInfo dAVBaselineInfo;
        Object object;
        if (!bl2 && this.getVersionURL() != null) {
            return;
        }
        if (!bl2) {
            if (this.myMediator != null && DAVUtil.isUseDAVWCURL()) {
                object = this.myMediator.getWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url");
                String string = this.myVURL = object == null ? null : ((SVNPropertyValue)object).getString();
                if ("".equals(this.myVURL)) {
                    this.myMediator.setWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url", null);
                    this.myVURL = null;
                }
                if (this.myVURL != null) {
                    return;
                }
            }
            if (dAVResource != null && dAVResource.getVersionURL() != null && dAVResource.myRevision == this.myRevision) {
                this.myVURL = SVNPathUtil.append(dAVResource.getVersionURL(), SVNPathUtil.tail(this.myPath));
                return;
            }
        }
        object = this.myURL;
        if (this.myRevision >= 0L) {
            dAVBaselineInfo = DAVUtil.getStableURL(this.myConnection, null, (String)object, this.myRevision, false, false, null);
            object = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
        }
        try {
            this.myVURL = DAVUtil.getPropertyValue(this.myConnection, (String)object, null, DAVElement.CHECKED_IN);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_PROPS_NOT_FOUND) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.PROPERTY_NOT_FOUND, "Could not fetch the Version Resource URL (needed during an import or when it is missing from the local, cached props)");
                SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.NETWORK);
            }
            throw sVNException;
        }
        if (this.myMediator != null) {
            dAVBaselineInfo = DAVUtil.isUseDAVWCURL() ? SVNPropertyValue.create(this.myVURL) : null;
            this.myMediator.setWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url", (SVNPropertyValue)((Object)dAVBaselineInfo));
        }
    }

    public String getWorkingURL() {
        return this.myWURL;
    }

    public void dispose() {
        this.myProperties = null;
    }

    public void setWorkingURL(String string) {
        this.myWURL = string;
    }

    public void putProperty(String string, String string2) {
        if (this.myProperties == null) {
            this.myProperties = new SVNProperties();
        }
        this.myProperties.put(string, string2);
    }

    public void putProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (this.myProperties == null) {
            this.myProperties = new SVNProperties();
        }
        this.myProperties.put(string, sVNPropertyValue);
    }

    public SVNProperties getProperties() {
        return this.myProperties;
    }

    public String getCustomURL() {
        return this.myCustomURL;
    }

    public void setCustomURL(String string) {
        this.myCustomURL = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.myURL);
        stringBuffer.append("][");
        stringBuffer.append(this.myVURL);
        stringBuffer.append("][");
        stringBuffer.append(this.myWURL);
        stringBuffer.append("][");
        stringBuffer.append(this.myPath);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

