/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class DAVRepositoryFactory
extends SVNRepositoryFactory {
    private IHTTPConnectionFactory myConnectionFactory;

    public static void setup() {
        DAVRepositoryFactory.setup(IHTTPConnectionFactory.DEFAULT);
    }

    public static void setup(IHTTPConnectionFactory iHTTPConnectionFactory) {
        iHTTPConnectionFactory = iHTTPConnectionFactory == null ? IHTTPConnectionFactory.DEFAULT : iHTTPConnectionFactory;
        DAVRepositoryFactory dAVRepositoryFactory = new DAVRepositoryFactory(iHTTPConnectionFactory);
        SVNRepositoryFactory.registerRepositoryFactory("^https?://.*$", dAVRepositoryFactory);
    }

    private DAVRepositoryFactory(IHTTPConnectionFactory iHTTPConnectionFactory) {
        this.myConnectionFactory = iHTTPConnectionFactory;
    }

    @Override
    public SVNRepository createRepositoryImpl(SVNURL sVNURL, ISVNSession iSVNSession) {
        return new DAVRepository(this.myConnectionFactory, sVNURL, iSVNSession);
    }
}

