/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVCommitEditor;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository$1;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository$2;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVDateRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVDeletedRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVFileRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVInheritedPropertiesHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLocationSegmentsHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLocationsHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLogHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeInfoHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVReplayHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNInheritedPropertiesHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNLockTimeoutProvider;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkingCopyContentMediator;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnChecksum$Kind;
import org.tmatesoft.svn.util.SVNLogType;
import org.tmatesoft.svn.util.Version;

public class DAVRepository
extends SVNRepository {
    private DAVConnection myConnection;
    private IHTTPConnectionFactory myConnectionFactory;
    private boolean myIsSpoolResponse;
    private boolean myHttpV2Enabled;
    private static boolean ourIsKeepCredentials = Boolean.valueOf(System.getProperty("svnkit.http.keepCredentials", Boolean.TRUE.toString()));
    private static boolean ourHttpV2Enabled = Boolean.valueOf(System.getProperty("svnkit.http.httpV2Enabled", Boolean.FALSE.toString()));
    protected static boolean ourRedirectsEnabled = true;
    private File mySpoolLocation;

    public static void setKeepCredentials(boolean bl2) {
        ourIsKeepCredentials = bl2;
    }

    public static void setRedirectsEnabled(boolean bl2) {
        ourRedirectsEnabled = bl2;
    }

    protected DAVRepository(IHTTPConnectionFactory iHTTPConnectionFactory, SVNURL sVNURL, ISVNSession iSVNSession) {
        super(sVNURL, iSVNSession);
        this.myConnectionFactory = iHTTPConnectionFactory;
        this.myHttpV2Enabled = ourHttpV2Enabled;
    }

    public void setSpoolLocation(File file) {
        this.mySpoolLocation = file;
    }

    public File getSpoolLocation() {
        return this.mySpoolLocation;
    }

    @Override
    public void testConnection() {
        try {
            this.openConnection();
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
            DAVConnection dAVConnection = this.getConnection();
            dAVConnection.fetchRepositoryUUID(this);
            dAVConnection.fetchRepositoryRoot(this);
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean hasRepositoryUUID() {
        return this.myRepositoryUUID != null;
    }

    public void setRepositoryUUID(String string) {
        this.myRepositoryUUID = string;
    }

    public boolean hasRepositoryRoot() {
        return this.myRepositoryRoot != null;
    }

    public void setRepositoryRoot(SVNURL sVNURL) {
        this.myRepositoryRoot = sVNURL;
    }

    @Override
    public SVNURL getRepositoryRoot(boolean bl2) {
        if (this.myRepositoryRoot != null && !bl2) {
            return this.myRepositoryRoot;
        }
        if (this.myRepositoryRoot == null) {
            try {
                this.openConnection();
                DAVConnection dAVConnection = this.getConnection();
                dAVConnection.fetchRepositoryRoot(this);
            }
            finally {
                this.closeConnection();
            }
        }
        return this.myRepositoryRoot;
    }

    @Override
    public String getRepositoryUUID(boolean bl2) {
        if (this.myRepositoryUUID != null && !bl2) {
            return this.myRepositoryUUID;
        }
        if (this.myRepositoryUUID == null) {
            try {
                this.openConnection();
                DAVConnection dAVConnection = this.getConnection();
                dAVConnection.fetchRepositoryUUID(this);
            }
            finally {
                this.closeConnection();
            }
        }
        return this.myRepositoryUUID;
    }

    public void setSpoolResponse(boolean bl2) {
        this.myIsSpoolResponse = bl2;
        DAVConnection dAVConnection = this.getConnection();
        if (dAVConnection != null) {
            dAVConnection.setReportResponseSpooled(bl2);
        }
    }

    public boolean isSpoolResponse() {
        return this.myIsSpoolResponse;
    }

    public boolean isHttpV2Enabled() {
        return this.myHttpV2Enabled;
    }

    public void setHttpV2Enabled(boolean bl2) {
        this.myHttpV2Enabled = bl2;
    }

    @Override
    public void setAuthenticationManager(ISVNAuthenticationManager iSVNAuthenticationManager) {
        DAVConnection dAVConnection = this.getConnection();
        if (iSVNAuthenticationManager != this.getAuthenticationManager() && dAVConnection != null) {
            dAVConnection.clearAuthenticationCache();
        }
        super.setAuthenticationManager(iSVNAuthenticationManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatestRevision() {
        try {
            this.openConnection();
            String string = this.getLocation().getPath();
            string = SVNEncodingUtil.uriEncode(string);
            DAVConnection dAVConnection = this.getConnection();
            if (dAVConnection.hasHttpV2Support()) {
                long l2 = DAVUtil.getLatestRevisionHttpV2(dAVConnection);
                return l2;
            }
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getBaselineInfo(dAVConnection, this, string, -1L, false, true, null);
            long l3 = dAVBaselineInfo.revision;
            return l3;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDatedRevision(Date date) {
        date = date == null ? new Date(System.currentTimeMillis()) : date;
        DAVDateRevisionHandler dAVDateRevisionHandler = new DAVDateRevisionHandler();
        StringBuffer stringBuffer = DAVDateRevisionHandler.generateDateRevisionRequest(null, date);
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            String string = this.getReportTarget(dAVConnection);
            HTTPStatus hTTPStatus = dAVConnection.doReport(string, stringBuffer, dAVDateRevisionHandler);
            if (hTTPStatus.getError() != null) {
                if (hTTPStatus.getError().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(hTTPStatus.getError().getErrorCode(), "Server does not support date-based operations");
                    SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
                }
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
        }
        finally {
            this.closeConnection();
        }
        return dAVDateRevisionHandler.getRevisionNumber();
    }

    @Override
    public SVNNodeKind checkPath(String string, long l2) {
        Object object;
        try {
            this.openConnection();
            string = this.doGetFullPath(string);
            string = SVNEncodingUtil.uriEncode(string);
            DAVConnection dAVConnection = this.getConnection();
            if (DAVRepository.isValidRevision(l2)) {
                object = DAVUtil.getStableURL(dAVConnection, this, string, l2, true, false, null);
                string = SVNPathUtil.append(((DAVBaselineInfo)object).baselineBase, ((DAVBaselineInfo)object).baselinePath);
            }
            if ((object = DAVUtil.getResourceProperties(dAVConnection, string, DAVRepository.isValidRevision(l2) ? Long.toString(l2) : null, new DAVElement[]{DAVElement.RESOURCE_TYPE})) != null && ((DAVProperties)object).isCollection()) {
                SVNNodeKind sVNNodeKind = SVNNodeKind.DIR;
                return sVNNodeKind;
            }
            SVNNodeKind sVNNodeKind = SVNNodeKind.FILE;
            return sVNNodeKind;
        }
        catch (SVNException sVNException) {
            for (object = sVNException.getErrorMessage(); object != null; object = ((SVNErrorMessage)object).getChildErrorMessage()) {
                if (((SVNErrorMessage)object).getErrorCode() != SVNErrorCode.FS_NOT_FOUND) continue;
                SVNNodeKind sVNNodeKind = SVNNodeKind.NONE;
                return sVNNodeKind;
            }
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties getRevisionProperties(long l2, SVNProperties sVNProperties) {
        sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
        try {
            this.openConnection();
            String string = this.getLocation().getPath();
            string = SVNEncodingUtil.uriEncode(string);
            DAVConnection dAVConnection = this.getConnection();
            DAVProperties dAVProperties = DAVUtil.getBaselineProperties(dAVConnection, this, string, l2, null);
            sVNProperties = DAVUtil.filterProperties(dAVProperties, sVNProperties);
            if (l2 >= 0L) {
                String string2 = sVNProperties.getStringValue("svn:log");
                this.getOptions().saveCommitMessage(this, l2, string2);
            }
        }
        finally {
            this.closeConnection();
        }
        return sVNProperties;
    }

    @Override
    public SVNPropertyValue getRevisionPropertyValue(long l2, String string) {
        SVNProperties sVNProperties = this.getRevisionProperties(l2, null);
        return sVNProperties.getSVNPropertyValue(string);
    }

    @Override
    public long getFile(String string, long l2, SVNProperties sVNProperties, OutputStream outputStream) {
        return this.getFile(string, l2, sVNProperties, outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFile(String string, long l2, SVNProperties sVNProperties, OutputStream outputStream, ISVNWorkingCopyContentMediator iSVNWorkingCopyContentMediator) {
        long l3;
        block13: {
            l3 = l2;
            try {
                Object object;
                Object object2;
                this.openConnection();
                string = this.doGetFullPath(string);
                string = SVNEncodingUtil.uriEncode(string);
                DAVConnection dAVConnection = this.getConnection();
                if (l2 != -2L) {
                    object2 = DAVUtil.getStableURL(dAVConnection, this, string, l2, false, true, null);
                    string = SVNPathUtil.append(((DAVBaselineInfo)object2).baselineBase, ((DAVBaselineInfo)object2).baselinePath);
                    l3 = ((DAVBaselineInfo)object2).revision;
                }
                if (sVNProperties != null) {
                    object2 = DAVUtil.getResourceProperties(dAVConnection, string, null, null);
                    DAVUtil.filterProperties((DAVProperties)object2, sVNProperties);
                    object = ((DAVProperties)object2).getProperties().keySet().iterator();
                    while (object.hasNext()) {
                        DAVElement dAVElement = (DAVElement)object.next();
                        DAVUtil.setSpecialWCProperties(sVNProperties, dAVElement, ((DAVProperties)object2).getPropertyValue(dAVElement), false);
                    }
                    if (l3 >= 0L) {
                        sVNProperties.put("svn:entry:revision", Long.toString(l3));
                    }
                }
                if (outputStream == null) break block13;
                object2 = null;
                try {
                    if (iSVNWorkingCopyContentMediator != null && sVNProperties != null && sVNProperties.containsName("svnkit:entry:sha1-checksum") && (object = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("svnkit:entry:sha1-checksum"))) != null) {
                        object2 = iSVNWorkingCopyContentMediator.getContentAsStream(new SvnChecksum(SvnChecksum$Kind.sha1, (String)object));
                    }
                    if (object2 != null) {
                        FSRepositoryUtil.copy((InputStream)object2, outputStream, this.getCanceller());
                    } else {
                        dAVConnection.doGet(string, outputStream);
                    }
                }
                finally {
                    SVNFileUtil.closeFile((InputStream)object2);
                }
            }
            finally {
                this.closeConnection();
            }
        }
        return l3;
    }

    @Override
    public long getDir(String string, long l2, SVNProperties sVNProperties, ISVNDirEntryHandler iSVNDirEntryHandler) {
        return this.getDir(string, l2, sVNProperties, -1, iSVNDirEntryHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDir(String string, long l2, SVNProperties sVNProperties, int n2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        long l3 = l2;
        try {
            DAVElement[] dAVElementArray;
            boolean bl2;
            Object object;
            this.openConnection();
            string = this.doGetFullPath(string);
            String string2 = string = SVNEncodingUtil.uriEncode(string);
            DAVConnection dAVConnection = this.getConnection();
            if (l2 != -2L) {
                object = DAVUtil.getStableURL(dAVConnection, this, string, l2, false, true, null);
                string = SVNPathUtil.append(((DAVBaselineInfo)object).baselineBase, ((DAVBaselineInfo)object).baselinePath);
                l3 = ((DAVBaselineInfo)object).revision;
            }
            boolean bl3 = bl2 = (object = DAVUtil.getResourceProperties(dAVConnection, string, null, new DAVElement[]{DAVElement.DEADPROP_COUNT})) != null && ((DAVProperties)object).getPropertyValue(DAVElement.DEADPROP_COUNT) != null;
            if (iSVNDirEntryHandler != null) {
                dAVElementArray = null;
                if ((n2 & 4) == 0 || bl2) {
                    LinkedList<DAVElement> linkedList = new LinkedList<DAVElement>();
                    if ((n2 & 1) != 0) {
                        linkedList.add(DAVElement.RESOURCE_TYPE);
                    }
                    if ((n2 & 2) != 0) {
                        linkedList.add(DAVElement.GET_CONTENT_LENGTH);
                    }
                    if ((n2 & 4) != 0) {
                        linkedList.add(DAVElement.DEADPROP_COUNT);
                    }
                    if ((n2 & 8) != 0) {
                        linkedList.add(DAVElement.VERSION_NAME);
                    }
                    if ((n2 & 0x10) != 0) {
                        linkedList.add(DAVElement.CREATION_DATE);
                    }
                    if ((n2 & 0x20) != 0) {
                        linkedList.add(DAVElement.CREATOR_DISPLAY_NAME);
                    }
                    dAVElementArray = linkedList.toArray(new DAVElement[linkedList.size()]);
                }
                int n3 = SVNPathUtil.getSegmentsCount(string);
                Object object2 = new SVNHashMap();
                HTTPStatus hTTPStatus = DAVUtil.getProperties(dAVConnection, string, DAVUtil.DEPTH_ONE, null, dAVElementArray, (Map)object2);
                if (hTTPStatus.getError() != null) {
                    SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
                }
                if (!this.hasRepositoryRoot()) {
                    dAVConnection.fetchRepositoryRoot(this);
                }
                SVNURL sVNURL = this.getRepositoryRoot(false);
                for (String string3 : object2.keySet()) {
                    Object object3;
                    Object object4;
                    Serializable serializable;
                    SVNPropertyValue sVNPropertyValue;
                    Object object5;
                    DAVProperties dAVProperties = (DAVProperties)object2.get(string3);
                    String string4 = dAVProperties.getURL();
                    if (n3 == SVNPathUtil.getSegmentsCount(string4)) continue;
                    String string5 = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(string4));
                    SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
                    if ((n2 & 1) != 0) {
                        sVNNodeKind = dAVProperties.isCollection() ? SVNNodeKind.DIR : SVNNodeKind.FILE;
                    }
                    long l4 = 0L;
                    if ((n2 & 2) != 0 && (object5 = SVNPropertyValue.getPropertyAsString(sVNPropertyValue = dAVProperties.getPropertyValue(DAVElement.GET_CONTENT_LENGTH))) != null && ((String)object5).trim().length() > 0) {
                        try {
                            l4 = Long.parseLong(((String)object5).trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                        }
                    }
                    boolean bl4 = false;
                    if ((n2 & 4) != 0) {
                        if (bl2) {
                            object5 = dAVProperties.getPropertyValue(DAVElement.DEADPROP_COUNT);
                            if (object5 == null) {
                                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Server response missing the expected deadprop-count property");
                                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                            } else {
                                long l5 = -1L;
                                try {
                                    l5 = Long.parseLong(((SVNPropertyValue)object5).getString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                                }
                                bl4 = l5 > 0L;
                            }
                        } else {
                            object5 = dAVProperties.getProperties().keySet().iterator();
                            while (object5.hasNext()) {
                                DAVElement dAVElement = (DAVElement)object5.next();
                                if (!"http://subversion.tigris.org/xmlns/custom/".equals(dAVElement.getNamespace()) && !"http://subversion.tigris.org/xmlns/svn/".equals(dAVElement.getNamespace())) continue;
                                bl4 = true;
                                break;
                            }
                        }
                    }
                    long l6 = -1L;
                    if ((n2 & 8) != 0 && (serializable = dAVProperties.getPropertyValue(DAVElement.VERSION_NAME)) != null) {
                        try {
                            l6 = Long.parseLong(((Object)serializable).toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            object4 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA);
                            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.NETWORK);
                        }
                    }
                    serializable = null;
                    if ((n2 & 0x10) != 0 && (object3 = dAVProperties.getPropertyValue(DAVElement.CREATION_DATE)) != null) {
                        serializable = SVNDate.parseDate(((SVNPropertyValue)object3).getString());
                    }
                    object3 = null;
                    if ((n2 & 0x20) != 0) {
                        object4 = dAVProperties.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME);
                        object3 = object4 == null ? null : ((SVNPropertyValue)object4).getString();
                    }
                    object4 = this.getLocation().setPath(string2, true);
                    object4 = ((SVNURL)object4).appendPath(string5, false);
                    SVNDirEntry sVNDirEntry = new SVNDirEntry((SVNURL)object4, sVNURL, string5, sVNNodeKind, l4, bl4, l6, (Date)serializable, (String)object3);
                    iSVNDirEntryHandler.handleDirEntry(sVNDirEntry);
                }
            }
            if (sVNProperties != null) {
                dAVElementArray = DAVUtil.getResourceProperties(dAVConnection, string, null, null);
                DAVUtil.filterProperties((DAVProperties)dAVElementArray, sVNProperties);
                for (Object object2 : dAVElementArray.getProperties().keySet()) {
                    DAVUtil.setSpecialWCProperties(sVNProperties, (DAVElement)object2, dAVElementArray.getPropertyValue((DAVElement)object2), true);
                }
            }
        }
        finally {
            this.closeConnection();
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNDirEntry getDir(String string, long l2, boolean bl2, Collection collection) {
        SVNDirEntry[] sVNDirEntryArray;
        block24: {
            sVNDirEntryArray = new SVNDirEntry[1];
            String[] stringArray = new String[1];
            try {
                Object object;
                Object object2;
                String string2;
                Object object3;
                Object object42;
                this.openConnection();
                string = this.doGetFullPath(string);
                String string3 = string = SVNEncodingUtil.uriEncode(string);
                DAVConnection dAVConnection = this.getConnection();
                if (l2 >= 0L) {
                    DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string, l2, false, true, null);
                    string = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
                }
                int n2 = SVNPathUtil.getSegmentsCount(string);
                ArrayList<SVNPropertyValue> arrayList = new ArrayList<SVNPropertyValue>();
                DAVElement[] dAVElementArray = new DAVElement[]{DAVElement.VERSION_CONTROLLED_CONFIGURATION, DAVElement.VERSION_NAME, DAVElement.GET_CONTENT_LENGTH, DAVElement.RESOURCE_TYPE, DAVElement.CREATOR_DISPLAY_NAME, DAVElement.CREATION_DATE};
                SVNHashMap sVNHashMap = new SVNHashMap();
                HTTPStatus hTTPStatus = DAVUtil.getProperties(dAVConnection, string, DAVUtil.DEPTH_ONE, null, dAVElementArray, sVNHashMap);
                if (hTTPStatus.getError() != null) {
                    SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
                }
                for (Object object42 : sVNHashMap.keySet()) {
                    SVNPropertyValue sVNPropertyValue;
                    SVNPropertyValue sVNPropertyValue2;
                    object3 = (DAVProperties)sVNHashMap.get(object42);
                    string2 = ((DAVProperties)object3).getURL();
                    String string4 = "";
                    if (n2 != SVNPathUtil.getSegmentsCount(string2)) {
                        string4 = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(string2));
                    }
                    object2 = SVNNodeKind.FILE;
                    object = ((DAVProperties)object3).getPropertyValue(DAVElement.VERSION_NAME);
                    long l3 = -1L;
                    if (object != null) {
                        try {
                            l3 = Long.parseLong(object.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                        }
                    }
                    SVNPropertyValue sVNPropertyValue3 = ((DAVProperties)object3).getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
                    String string5 = SVNPropertyValue.getPropertyAsString(sVNPropertyValue3);
                    long l4 = 0L;
                    if (string5 != null && string5.trim().length() > 0) {
                        try {
                            l4 = Long.parseLong(string5.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
                        }
                    }
                    if (((DAVProperties)object3).isCollection()) {
                        object2 = SVNNodeKind.DIR;
                    }
                    String string6 = (sVNPropertyValue2 = ((DAVProperties)object3).getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME)) == null ? null : sVNPropertyValue2.getString();
                    SVNPropertyValue sVNPropertyValue4 = ((DAVProperties)object3).getPropertyValue(DAVElement.CREATION_DATE);
                    SVNDate sVNDate = sVNPropertyValue4 != null ? SVNDate.parseDate(sVNPropertyValue4.getString()) : null;
                    dAVConnection.fetchRepositoryRoot(this);
                    SVNURL sVNURL = this.getRepositoryRoot(false);
                    SVNURL sVNURL2 = this.getLocation().setPath(string3, true);
                    if ("".equals(string4)) {
                        sVNDirEntryArray[0] = new SVNDirEntry(sVNURL2, sVNURL, string4, (SVNNodeKind)object2, l4, false, l3, sVNDate, string6);
                        sVNPropertyValue = ((DAVProperties)object3).getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
                        stringArray[0] = sVNPropertyValue == null ? null : sVNPropertyValue.getString();
                        continue;
                    }
                    sVNURL2 = sVNURL2.appendPath(string4, false);
                    if (collection != null) {
                        collection.add(new SVNDirEntry(sVNURL2, sVNURL, string4, (SVNNodeKind)object2, l4, false, l3, sVNDate, string6));
                    }
                    sVNPropertyValue = ((DAVProperties)object3).getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
                    arrayList.add(sVNPropertyValue);
                }
                if (!bl2) break block24;
                DAVElement dAVElement = DAVElement.getElement("http://subversion.tigris.org/xmlns/svn/", "log");
                object42 = collection != null ? collection.iterator() : null;
                object3 = sVNDirEntryArray[0];
                string2 = stringArray[0];
                int n3 = 0;
                while (true) {
                    if (((SVNDirEntry)object3).getRevision() >= 0L && string2 != null) {
                        object2 = Long.toString(((SVNDirEntry)object3).getRevision());
                        if (((SVNDirEntry)object3).getDate() != null && this.getOptions().hasCommitMessage(this, ((SVNDirEntry)object3).getRevision())) {
                            object = this.getOptions().getCommitMessage(this, ((SVNDirEntry)object3).getRevision());
                            ((SVNDirEntry)object3).setCommitMessage((String)object);
                        } else if (((SVNDirEntry)object3).getDate() != null && string2 != null) {
                            String string7;
                            block25: {
                                object = object3;
                                string7 = null;
                                try {
                                    string7 = DAVUtil.getPropertyValue(dAVConnection, string2, (String)object2, dAVElement);
                                }
                                catch (SVNException sVNException) {
                                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_PROPS_NOT_FOUND) break block25;
                                    throw sVNException;
                                }
                            }
                            this.getOptions().saveCommitMessage(this, ((SVNDirEntry)object).getRevision(), string7);
                            ((SVNDirEntry)object).setCommitMessage(string7);
                        }
                    }
                    if (object42 != null && object42.hasNext()) {
                        object3 = (SVNDirEntry)object42.next();
                        object2 = (SVNPropertyValue)arrayList.get(n3);
                        string2 = object2 != null ? ((SVNPropertyValue)object2).getString() : null;
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.closeConnection();
            }
        }
        return sVNDirEntryArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replay(long l2, long l3, boolean bl2, ISVNEditor iSVNEditor) {
        try {
            this.openConnection();
            StringBuffer stringBuffer = DAVReplayHandler.generateReplayRequest(l3, l2, bl2);
            DAVReplayHandler dAVReplayHandler = new DAVReplayHandler(iSVNEditor, true);
            String string = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            DAVConnection dAVConnection = this.getConnection();
            HTTPStatus hTTPStatus = dAVConnection.doReport(string, stringBuffer, dAVReplayHandler);
            if (hTTPStatus.getCode() == 501) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'replay' REPORT not implemented");
                SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
            } else if (hTTPStatus.getError() != null) {
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRevisionPropertyValue(long l2, String string, SVNPropertyValue sVNPropertyValue) {
        DAVRepository.assertValidRevision(l2);
        StringBuffer stringBuffer = DAVProppatchHandler.generatePropertyRequest(null, string, sVNPropertyValue);
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getBaselineInfo(dAVConnection, this, SVNEncodingUtil.uriEncode(this.getLocation().getPath()), l2, false, false, null);
            String string2 = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            string2 = dAVBaselineInfo.baseline;
            DAVProppatchHandler dAVProppatchHandler = new DAVProppatchHandler();
            SVNErrorMessage sVNErrorMessage = null;
            try {
                dAVConnection.doProppatch(null, string2, stringBuffer, dAVProppatchHandler, null);
            }
            catch (SVNException sVNException) {
                sVNErrorMessage = sVNException.getErrorMessage();
            }
            if (sVNErrorMessage != null || dAVProppatchHandler.getError() != null) {
                if (sVNErrorMessage != null) {
                    sVNErrorMessage.setChildErrorMessage(dAVProppatchHandler.getError());
                } else {
                    sVNErrorMessage = dAVProppatchHandler.getError();
                }
                SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "DAV request failed; it's possible that the repository's pre-revprop-change hook either failed or is non-existent");
                SVNErrorManager.error(sVNErrorMessage2, sVNErrorMessage, SVNLogType.NETWORK);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public ISVNEditor getCommitEditor(String string, Map map, boolean bl2, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        return this.getCommitEditor(string, map, bl2, null, iSVNWorkspaceMediator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock getLock(String string) {
        try {
            this.openConnection();
            string = this.doGetFullPath(string);
            string = SVNEncodingUtil.uriEncode(string);
            DAVConnection dAVConnection = this.getConnection();
            SVNLock sVNLock = dAVConnection.doGetLock(string, this);
            return sVNLock;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock[] getLocks(String string) {
        try {
            this.openConnection();
            string = this.doGetFullPath(string);
            string = SVNEncodingUtil.uriEncode(string);
            DAVConnection dAVConnection = this.getConnection();
            SVNLock[] sVNLockArray = dAVConnection.doGetLocks(string);
            return sVNLockArray;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Map map, String string, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            for (String string2 : map.keySet()) {
                SVNErrorMessage sVNErrorMessage;
                SVNLock sVNLock;
                String string3;
                block8: {
                    Long l2 = (Long)map.get(string2);
                    string3 = this.doGetRepositoryPath(string2);
                    string2 = this.doGetFullPath(string2);
                    string2 = SVNEncodingUtil.uriEncode(string2);
                    sVNLock = null;
                    sVNErrorMessage = null;
                    long l3 = l2 != null ? l2 : -1L;
                    long l4 = -1L;
                    if (iSVNLockHandler instanceof ISVNLockTimeoutProvider) {
                        l4 = ((ISVNLockTimeoutProvider)((Object)iSVNLockHandler)).getLockTimeout(string3, string2, string, bl2);
                    }
                    try {
                        sVNLock = dAVConnection.doLock(string3, string2, this, string, bl2, l3, l4);
                    }
                    catch (SVNException sVNException) {
                        sVNErrorMessage = null;
                        if (sVNException.getErrorMessage() != null && FSErrors.isLockError(sVNException.getErrorMessage())) {
                            sVNErrorMessage = sVNException.getErrorMessage();
                        }
                        if (sVNErrorMessage != null) break block8;
                        throw sVNException;
                    }
                }
                if (iSVNLockHandler == null) continue;
                iSVNLockHandler.handleLock(string3, sVNLock, sVNErrorMessage);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Map map, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                String string3 = (String)map.get(string);
                String string4 = this.doGetRepositoryPath(string);
                string = this.doGetFullPath(string);
                string = SVNEncodingUtil.uriEncode(string);
                SVNErrorMessage sVNErrorMessage = null;
                try {
                    dAVConnection.doUnlock(string, this, string3, bl2);
                    sVNErrorMessage = null;
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage() != null && (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_LOCKED || FSErrors.isUnlockError(sVNException.getErrorMessage()))) {
                        sVNErrorMessage = sVNException.getErrorMessage();
                        string2 = string4 != null && string4.startsWith("/") ? string4.substring("/".length()) : (string4 != null ? string4 : "");
                        sVNErrorMessage = SVNErrorMessage.create(sVNErrorMessage.getErrorCode(), sVNErrorMessage.getMessageTemplate(), (Object)string2);
                    }
                    throw sVNException;
                }
                if (iSVNLockHandler == null) continue;
                iSVNLockHandler.handleUnlock(string4, new SVNLock(string4, string3, null, null, null, null), sVNErrorMessage);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SVNDirEntry info(String string, long l2) {
        try {
            SVNHashMap sVNHashMap;
            HTTPStatus hTTPStatus;
            DAVBaselineInfo dAVBaselineInfo;
            this.openConnection();
            string = this.doGetFullPath(string);
            String string2 = string = SVNEncodingUtil.uriEncode(string);
            DAVConnection dAVConnection = this.getConnection();
            if (l2 >= 0L) {
                try {
                    dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string, l2, false, true, null);
                    string = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage() == null) throw sVNException;
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) throw sVNException;
                    SVNDirEntry sVNDirEntry = null;
                    this.closeConnection();
                    return sVNDirEntry;
                }
            }
            if ((hTTPStatus = DAVUtil.getProperties(dAVConnection, string, 0, null, (DAVElement[])(dAVBaselineInfo = null), sVNHashMap = new SVNHashMap())).getError() != null) {
                if (hTTPStatus.getError().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    SVNDirEntry sVNDirEntry = null;
                    return sVNDirEntry;
                }
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
            if (sVNHashMap.isEmpty()) return null;
            DAVProperties dAVProperties = (DAVProperties)sVNHashMap.values().iterator().next();
            SVNDirEntry sVNDirEntry = this.createDirEntry(string2, dAVProperties);
            return sVNDirEntry;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void closeSession() {
        this.lock(true);
        try {
            if (this.myConnection != null) {
                this.myConnection.close();
                this.myConnection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    public String doGetFullPath(String string) {
        String string2;
        if (string == null) {
            return this.doGetFullPath("/");
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            DAVConnection dAVConnection = this.getConnection();
            dAVConnection.fetchRepositoryRoot(this);
            string2 = SVNPathUtil.append(this.myRepositoryRoot.getPath(), string);
        } else {
            string2 = SVNPathUtil.append(this.getLocation().getPath(), string);
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    @Override
    public void diff(SVNURL sVNURL, long l2, long l3, String string, boolean bl2, SVNDepth sVNDepth, boolean bl3, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        if (sVNURL == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL could not be NULL");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        if (l3 < 0L) {
            l3 = l2;
        }
        boolean bl4 = this.myConnectionFactory.useSendAllForDiff(this);
        boolean bl5 = bl3;
        this.runReport(this.getLocation(), l2, string, sVNURL.toString(), sVNDepth, bl2, false, bl3, false, bl4, false, bl5, null, iSVNReporterBaton, iSVNEditor);
    }

    @Override
    public void status(long l2, String string, SVNDepth sVNDepth, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.runReport(this.getLocation(), l2, string, null, sVNDepth, false, false, false, false, true, false, false, null, iSVNReporterBaton, iSVNEditor);
    }

    @Override
    public void update(SVNURL sVNURL, long l2, String string, SVNDepth sVNDepth, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        if (sVNURL == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL could not be NULL");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        this.runReport(this.getLocation(), l2, string, sVNURL.toString(), sVNDepth, true, false, true, false, true, true, false, null, iSVNReporterBaton, iSVNEditor);
    }

    @Override
    public void update(long l2, String string, SVNDepth sVNDepth, boolean bl2, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.runReport(this.getLocation(), l2, string, null, sVNDepth, false, false, true, bl2, true, false, false, null, iSVNReporterBaton, iSVNEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasCapability(SVNCapability sVNCapability) {
        if (sVNCapability == SVNCapability.COMMIT_REVPROPS) {
            return true;
        }
        try {
            Serializable serializable;
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            String string = dAVConnection.getCapabilityResponse(sVNCapability);
            if ("server-yes".equals(string)) {
                if (sVNCapability == SVNCapability.MERGE_INFO) {
                    serializable = null;
                    try {
                        this.doGetMergeInfo(new String[]{""}, -1L, SVNMergeInfoInheritance.EXPLICIT, false);
                    }
                    catch (SVNException sVNException) {
                        serializable = sVNException;
                    }
                    if (serializable != null) {
                        if (((SVNException)serializable).getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                            string = "no";
                        } else {
                            if (((SVNException)serializable).getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) throw serializable;
                            string = "yes";
                        }
                    } else {
                        string = "yes";
                    }
                    dAVConnection.setCapability(SVNCapability.MERGE_INFO, string);
                } else {
                    serializable = SVNErrorMessage.create(SVNErrorCode.UNKNOWN_CAPABILITY, "Don''t know how to handle ''{0}'' for capability ''{1}''", "server-yes", SVNCapability.MERGE_INFO);
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
                }
            }
            if ("yes".equals(string)) {
                boolean bl2 = true;
                return bl2;
            }
            if ("no".equals(string)) {
                boolean bl3 = false;
                return bl3;
            }
            if (string == null) {
                serializable = SVNErrorMessage.create(SVNErrorCode.UNKNOWN_CAPABILITY, "Don''t know anything about capability ''{0}''", new Object[]{sVNCapability});
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
                return false;
            } else {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "Attempt to fetch capability ''{0}'' resulted in ''{1}''", sVNCapability, string), SVNLogType.NETWORK);
            }
            return false;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getFileRevisionsImpl(String string, long l2, long l3, boolean bl2, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        String string2 = this.getLocation().getPath();
        string2 = SVNEncodingUtil.uriEncode(string2);
        try {
            SVNErrorMessage sVNErrorMessage;
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            string = "".equals(string) ? "" : this.doGetRepositoryPath(string);
            DAVFileRevisionHandler dAVFileRevisionHandler = new DAVFileRevisionHandler(iSVNFileRevisionHandler);
            StringBuffer stringBuffer = DAVFileRevisionHandler.generateFileRevisionsRequest(null, l2, l3, string, bl2);
            long l4 = -1L;
            if (DAVRepository.isValidRevision(l2) && DAVRepository.isValidRevision(l3)) {
                l4 = Math.max(l2, l3);
            }
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string2, l4, false, false, null);
            string2 = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            HTTPStatus hTTPStatus = dAVConnection.doReport(string2, stringBuffer, dAVFileRevisionHandler);
            if (hTTPStatus.getCode() == 501) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-file-revs' REPORT not implemented");
                SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
            } else if (hTTPStatus.getError() != null) {
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
            if (dAVFileRevisionHandler.getEntriesCount() <= 0) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The file-revs report didn't contain any revisions");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            int n2 = dAVFileRevisionHandler.getEntriesCount();
            return n2;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long logImpl(String[] stringArray, long l2, long l3, boolean bl2, boolean bl3, long l4, boolean bl4, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        DAVLogHandler dAVLogHandler;
        block13: {
            if (stringArray == null || stringArray.length == 0) {
                stringArray = new String[]{""};
            }
            dAVLogHandler = null;
            DAVRepository$1 dAVRepository$1 = new DAVRepository$1(this, iSVNLogEntryHandler);
            long l5 = -1L;
            if (DAVRepository.isInvalidRevision(l2)) {
                l2 = l5 = this.getLatestRevision();
            }
            if (DAVRepository.isInvalidRevision(l3)) {
                l3 = l5 != -1L ? l5 : this.getLatestRevision();
            }
            try {
                String string;
                this.openConnection();
                DAVConnection dAVConnection = this.getConnection();
                String[] stringArray3 = new String[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray3[i2] = this.doGetFullPath(stringArray[i2]);
                }
                SVNHashSet sVNHashSet = new SVNHashSet();
                String string2 = SVNPathUtil.condencePaths(stringArray3, sVNHashSet, false);
                if (sVNHashSet.isEmpty()) {
                    sVNHashSet.add("");
                }
                stringArray3 = sVNHashSet.toArray(new String[sVNHashSet.size()]);
                StringBuffer stringBuffer = DAVLogHandler.generateLogRequest(null, l2, l3, bl2, bl3, bl4, stringArray2, l4, stringArray3);
                dAVLogHandler = new DAVLogHandler(dAVRepository$1, l4, stringArray2);
                if (dAVLogHandler.isWantCustomRevprops() && !"server-yes".equals(string = dAVConnection.getCapabilityResponse(SVNCapability.LOG_REVPROPS)) && !"yes".equals(string)) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support custom revprops via log");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
                long l6 = Math.max(l2, l3);
                string2 = SVNEncodingUtil.uriEncode(string2);
                DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string2, l6, false, false, null);
                string2 = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
                try {
                    HTTPStatus hTTPStatus = dAVConnection.doReport(string2, stringBuffer, dAVLogHandler);
                    if (hTTPStatus.getError() != null) {
                        SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
                    }
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.UNKNOWN && dAVLogHandler.isCompatibleMode()) {
                        dAVRepository$1.handleLogEntry(SVNLogEntry.EMPTY_ENTRY);
                        break block13;
                    }
                    throw sVNException;
                }
            }
            finally {
                this.closeConnection();
            }
        }
        return dAVLogHandler.getEntriesCount();
    }

    protected void openConnection() {
        this.fireConnectionOpened();
        this.lock();
        if (this.myConnection == null) {
            DAVConnection dAVConnection = null;
            HashSet<SVNURL> hashSet = new HashSet<SVNURL>();
            SVNURL[] sVNURLArray = new SVNURL[1];
            int n2 = 4;
            while (n2-- > 0) {
                Object object;
                SVNURL sVNURL = this.myLocation;
                sVNURLArray[0] = null;
                dAVConnection = this.createDAVConnection(this.myConnectionFactory, this);
                dAVConnection.setReportResponseSpooled(this.isSpoolResponse());
                dAVConnection.open(this, sVNURLArray);
                if (sVNURLArray[0] == null) break;
                this.myOriginalLocations.add(sVNURL);
                ISVNEventHandler iSVNEventHandler = this.getEventHandler();
                if (iSVNEventHandler != null) {
                    object = SVNEventFactory.createSVNEvent(new File("."), SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.URL_REDIRECT, SVNEventAction.URL_REDIRECT, null, null);
                    ((SVNEvent)object).setURL(sVNURLArray[0]);
                    iSVNEventHandler.handleEvent((SVNEvent)object, -1.0);
                }
                if (hashSet.contains(sVNURLArray[0])) {
                    object = SVNErrorMessage.create(SVNErrorCode.CLIENT_CYCLE_DETECTED, "Redirect cycle detected for URL ''{0}''", (Object)sVNURLArray[0]);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                }
                hashSet.add(sVNURLArray[0]);
                this.setLocationInternal(sVNURLArray[0], false);
            }
            this.myConnection = dAVConnection;
        }
    }

    protected DAVConnection createDAVConnection(IHTTPConnectionFactory iHTTPConnectionFactory, DAVRepository dAVRepository) {
        return new DAVConnection(iHTTPConnectionFactory, dAVRepository);
    }

    protected void closeConnection() {
        DAVConnection dAVConnection = this.getConnection();
        if (dAVConnection != null && !ourIsKeepCredentials) {
            dAVConnection.clearAuthenticationCache();
        }
        if (!this.getOptions().keepConnection(this)) {
            this.closeSession();
        }
        this.unlock();
        this.fireConnectionClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLocationsImpl(String string, long l2, long[] lArray, ISVNLocationEntryHandler iSVNLocationEntryHandler) {
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            if (string.startsWith("/")) {
                dAVConnection.fetchRepositoryRoot(this);
                string = SVNPathUtil.append(this.myRepositoryRoot.getPath(), string);
                string = string.equals(this.getLocation().getPath()) ? "" : string.substring(this.getLocation().getPath().length() + 1);
            }
            StringBuffer stringBuffer = DAVLocationsHandler.generateLocationsRequest(null, string, l2, lArray);
            DAVLocationsHandler dAVLocationsHandler = new DAVLocationsHandler(iSVNLocationEntryHandler);
            String string2 = this.getLocation().getPath();
            string2 = SVNEncodingUtil.uriEncode(string2);
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string2, l2, false, false, null);
            string = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            HTTPStatus hTTPStatus = dAVConnection.doReport(string, stringBuffer, dAVLocationsHandler);
            if (hTTPStatus.getCode() == 501) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-locations' REPORT not implemented");
                SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
            } else if (hTTPStatus.getError() != null) {
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
            int n2 = dAVLocationsHandler.getEntriesCount();
            return n2;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getLocationSegmentsImpl(String string, long l2, long l3, long l4, ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            boolean bl2 = string.startsWith("/");
            if (bl2) {
                dAVConnection.fetchRepositoryRoot(this);
                string = SVNPathUtil.append(this.myRepositoryRoot.getPath(), string);
                string = string.equals(this.getLocation().getPath()) ? "" : string.substring(this.myRepositoryRoot.getPath().length() + 1);
            }
            StringBuffer stringBuffer = DAVLocationSegmentsHandler.generateGetLocationSegmentsRequest(null, string, l2, l3, l4);
            DAVLocationSegmentsHandler dAVLocationSegmentsHandler = new DAVLocationSegmentsHandler(iSVNLocationSegmentHandler);
            String string2 = bl2 ? this.myRepositoryRoot.getPath() : this.getLocation().getPath();
            string2 = SVNEncodingUtil.uriEncode(string2);
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string2, l2, false, false, null);
            string = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            HTTPStatus hTTPStatus = dAVConnection.doReport(string, stringBuffer, dAVLocationSegmentsHandler);
            if (hTTPStatus.getCode() == 501) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-location-segments' REPORT not implemented");
                SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
            } else if (hTTPStatus.getError() != null) {
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
            long l5 = dAVLocationSegmentsHandler.getTotalRevisions();
            return l5;
        }
        finally {
            this.closeConnection();
        }
    }

    protected String doGetRepositoryPath(String string) {
        if (string == null) {
            return "/";
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            return string;
        }
        String string2 = SVNPathUtil.append(this.getLocation().getPath(), string);
        DAVConnection dAVConnection = this.getConnection();
        dAVConnection.fetchRepositoryRoot(this);
        String string3 = string2.substring(this.myRepositoryRoot.getPath().length());
        if ("".equals(string3)) {
            return "/";
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map getMergeInfoImpl(String[] stringArray, long l2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        try {
            this.openConnection();
            Map map = this.doGetMergeInfo(stringArray, l2, sVNMergeInfoInheritance, bl2);
            return map;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    protected void replayRangeImpl(long l2, long l3, long l4, boolean bl2, ISVNReplayHandler iSVNReplayHandler) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
    }

    @Override
    protected ISVNEditor getCommitEditorInternal(Map map, boolean bl2, SVNProperties sVNProperties, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            SVNProperties sVNProperties2 = new SVNProperties();
            if (sVNProperties != null) {
                sVNProperties2.putAll(sVNProperties);
            }
            if ("yes".equals(dAVConnection.getCapabilityResponse(SVNCapability.EPHEMERAL_PROPS))) {
                if (!sVNProperties2.containsName("svn:txn-user-agent")) {
                    sVNProperties2.put("svn:txn-user-agent", Version.getUserAgent());
                }
                if (!sVNProperties2.containsName("svn:txn-client-compat-version")) {
                    sVNProperties2.put("svn:txn-client-compat-version", Version.getSVNVersion());
                }
            } else {
                for (String string : new HashSet(sVNProperties2.nameSet())) {
                    if (!string.startsWith("svn:txn-")) continue;
                    sVNProperties2.remove(string);
                }
            }
            sVNProperties = sVNProperties2;
            Object object = null;
            if (map != null && !map.isEmpty()) {
                String string;
                object = new SVNHashMap();
                dAVConnection.fetchRepositoryRoot(this);
                string = this.myRepositoryRoot.getPath();
                string = SVNEncodingUtil.uriEncode(string);
                for (String string2 : map.keySet()) {
                    String string3 = (String)map.get(string2);
                    if (string2.startsWith("/")) {
                        string2 = SVNPathUtil.append(string, SVNEncodingUtil.uriEncode(string2));
                    } else {
                        string2 = this.doGetFullPath(string2);
                        string2 = SVNEncodingUtil.uriEncode(string2);
                    }
                    object.put(string2, string3);
                }
            }
            dAVConnection.setLocks((Map)object, bl2);
            return new DAVCommitEditor(this, dAVConnection, sVNProperties, iSVNWorkspaceMediator, (Runnable)new DAVRepository$2(this));
        }
        catch (Throwable throwable) {
            this.closeConnection();
            if (throwable instanceof SVNException) {
                throw (SVNException)throwable;
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "can not get commit editor: ''{0}''", (Object)throwable.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, throwable, SVNLogType.NETWORK);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getDeletedRevisionImpl(String string, long l2, long l3) {
        try {
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            String string2 = this.doGetFullPath("");
            string2 = SVNEncodingUtil.uriEncode(string2);
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string2, l2, false, false, null);
            String string3 = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            StringBuffer stringBuffer = DAVDeletedRevisionHandler.generateGetDeletedRevisionRequest(null, string, l2, l3);
            DAVDeletedRevisionHandler dAVDeletedRevisionHandler = new DAVDeletedRevisionHandler();
            HTTPStatus hTTPStatus = dAVConnection.doReport(string3, stringBuffer, dAVDeletedRevisionHandler);
            if (hTTPStatus.getCode() == 501) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-deleted-rev' REPORT not implemented");
                SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
            }
            long l4 = dAVDeletedRevisionHandler.getRevision();
            return l4;
        }
        finally {
            this.closeConnection();
        }
    }

    protected DAVConnection getConnection() {
        return this.myConnection;
    }

    protected IHTTPConnectionFactory getConnectionFactory() {
        return this.myConnectionFactory;
    }

    private Map doGetMergeInfo(String[] stringArray, long l2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        Object object;
        DAVMergeInfoHandler dAVMergeInfoHandler;
        String string = this.doGetFullPath("");
        string = SVNEncodingUtil.uriEncode(string);
        DAVConnection dAVConnection = this.getConnection();
        DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string, l2, false, true, null);
        string = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = stringArray[i2];
        }
        StringBuffer stringBuffer = DAVMergeInfoHandler.generateMergeInfoRequest(null, l2, stringArray2, sVNMergeInfoInheritance, bl2);
        HTTPStatus hTTPStatus = dAVConnection.doReport(string, stringBuffer, dAVMergeInfoHandler = new DAVMergeInfoHandler());
        if (hTTPStatus.getCode() == 501) {
            object = hTTPStatus.getError() != null ? hTTPStatus.getError() : SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Server does not support mergeinfo");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        if (hTTPStatus.getError() != null) {
            SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
        }
        if ((object = dAVMergeInfoHandler.getMergeInfo()) == null) {
            return null;
        }
        HashMap<String, SVNMergeInfo> hashMap = new HashMap<String, SVNMergeInfo>();
        for (Map.Entry entry : object.entrySet()) {
            SVNMergeInfo sVNMergeInfo = (SVNMergeInfo)entry.getValue();
            if (sVNMergeInfo == null) continue;
            String string2 = (String)entry.getKey();
            if (string2.startsWith("/")) {
                string2 = string2.substring("/".length());
            }
            string2 = this.doGetRepositoryPath(string2);
            hashMap.put(string2, new SVNMergeInfo(string2, sVNMergeInfo.getMergeSourcesToMergeLists()));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReport(SVNURL sVNURL, long l2, String string, String string2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, ISVNWorkingCopyContentMediator iSVNWorkingCopyContentMediator, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        boolean bl9 = this.hasCapability(SVNCapability.DEPTH);
        if (sVNDepth != SVNDepth.FILES && sVNDepth != SVNDepth.INFINITY && !bl9) {
            iSVNEditor = SVNDepthFilterEditor.getDepthFilterEditor(sVNDepth, iSVNEditor, string != null);
        }
        DAVEditorHandler dAVEditorHandler = null;
        try {
            String string3;
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            SVNHashMap sVNHashMap = new SVNHashMap();
            StringBuffer stringBuffer = DAVEditorHandler.generateEditorRequest(dAVConnection, null, sVNURL.toString(), l2, string, string2, sVNDepth, sVNHashMap, bl2, bl3, bl4, bl5, bl6, iSVNReporterBaton);
            dAVEditorHandler = new DAVEditorHandler(this.myConnectionFactory, this, iSVNEditor, sVNHashMap, bl4, string != null && !"".equals(string), iSVNWorkingCopyContentMediator);
            try {
                string3 = this.getReportTarget(dAVConnection);
            }
            catch (SVNException sVNException) {
                if (bl7) {
                    iSVNEditor.closeEdit();
                }
                throw sVNException;
            }
            HTTPStatus hTTPStatus = dAVConnection.doReport(string3, stringBuffer, dAVEditorHandler, bl8);
            if (hTTPStatus.getError() != null) {
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
        }
        finally {
            if (dAVEditorHandler != null) {
                dAVEditorHandler.closeConnection();
            }
            this.closeConnection();
        }
    }

    private String getReportTarget(DAVConnection dAVConnection) {
        if (this.isHttpV2Enabled()) {
            return dAVConnection.getMeResource();
        }
        String string = this.getLocation().getURIEncodedPath();
        return DAVUtil.getVCCPath(dAVConnection, this, string);
    }

    private SVNDirEntry createDirEntry(String string, DAVProperties dAVProperties) {
        Object object2;
        SVNPropertyValue sVNPropertyValue;
        String string2 = dAVProperties.getURL();
        string2 = SVNEncodingUtil.uriDecode(string2);
        SVNNodeKind sVNNodeKind = SVNNodeKind.FILE;
        SVNPropertyValue sVNPropertyValue2 = dAVProperties.getPropertyValue(DAVElement.VERSION_NAME);
        long l2 = -1L;
        if (sVNPropertyValue2 != null) {
            try {
                l2 = Long.parseLong(((Object)sVNPropertyValue2).toString());
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
        }
        SVNPropertyValue sVNPropertyValue3 = dAVProperties.getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
        String string3 = SVNPropertyValue.getPropertyAsString(sVNPropertyValue3);
        long l3 = 0L;
        if (string3 != null && string3.trim().length() > 0) {
            try {
                l3 = Long.parseLong(string3.trim());
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, numberFormatException), SVNLogType.NETWORK);
            }
        }
        if (dAVProperties.isCollection()) {
            sVNNodeKind = SVNNodeKind.DIR;
        }
        String string4 = (sVNPropertyValue = dAVProperties.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME)) == null ? null : sVNPropertyValue.getString();
        SVNPropertyValue sVNPropertyValue4 = dAVProperties.getPropertyValue(DAVElement.CREATION_DATE);
        SVNDate sVNDate = sVNPropertyValue4 != null ? SVNDate.parseDate(sVNPropertyValue4.getString()) : null;
        boolean bl2 = false;
        for (Object object2 : dAVProperties.getProperties().keySet()) {
            if (!"http://subversion.tigris.org/xmlns/custom/".equals(((DAVElement)object2).getNamespace()) && !"http://subversion.tigris.org/xmlns/svn/".equals(((DAVElement)object2).getNamespace())) continue;
            bl2 = true;
            break;
        }
        DAVConnection dAVConnection = this.getConnection();
        dAVConnection.fetchRepositoryRoot(this);
        object2 = this.getRepositoryRoot(false);
        SVNURL sVNURL = this.getLocation().setPath(string, true);
        String string5 = ((SVNURL)object2).equals(sVNURL) ? "" : SVNPathUtil.tail(string2);
        return new SVNDirEntry(sVNURL, (SVNURL)object2, string5, sVNNodeKind, l3, bl2, l2, sVNDate, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getInheritedPropertiesImpl(String string, long l2, String string2, ISVNInheritedPropertiesHandler iSVNInheritedPropertiesHandler) {
        try {
            Object object;
            this.openConnection();
            DAVConnection dAVConnection = this.getConnection();
            String string3 = this.doGetFullPath("");
            string3 = SVNEncodingUtil.uriEncode(string3);
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(dAVConnection, this, string3, l2, false, false, null);
            String string4 = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            StringBuffer stringBuffer = DAVInheritedPropertiesHandler.generateReport(null, string, l2);
            DAVInheritedPropertiesHandler dAVInheritedPropertiesHandler = new DAVInheritedPropertiesHandler();
            HTTPStatus hTTPStatus = dAVConnection.doReport(string4, stringBuffer, dAVInheritedPropertiesHandler);
            if (hTTPStatus.getCode() == 501) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'inherited-props-report' REPORT not implemented");
                SVNErrorManager.error((SVNErrorMessage)object, hTTPStatus.getError(), SVNLogType.NETWORK);
            }
            if (iSVNInheritedPropertiesHandler != null) {
                object = dAVInheritedPropertiesHandler.getInheritedProperties();
                for (String string5 : object.keySet()) {
                    SVNProperties sVNProperties = (SVNProperties)object.get(string5);
                    if (string2 != null && sVNProperties.containsName(string2)) {
                        SVNProperties sVNProperties2 = new SVNProperties();
                        sVNProperties2.put(string2, sVNProperties.getSVNPropertyValue(string2));
                        iSVNInheritedPropertiesHandler.handleInheritedProperites(string5, sVNProperties2);
                        continue;
                    }
                    if (string2 != null) continue;
                    iSVNInheritedPropertiesHandler.handleInheritedProperites(string5, sVNProperties);
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }
}

