/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

class DAVKeyManager {
    private static final String CERTIFICATE_FILE = "svnkit.ssl.client-cert-file";
    private static final String CERTIFICATE_PASSPHRASE = "svnkit.ssl.client-cert-password";
    private static final String OLD_CERTIFICATE_FILE = "javasvn.ssl.client-cert-file";
    private static final String OLD_CERTIFICATE_PASSPHRASE = "javasvn.ssl.client-cert-password";
    private static KeyManager[] ourKeyManagers;
    private static boolean ourIsInitialized;

    DAVKeyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyManager[] getKeyManagers() {
        if (ourIsInitialized) {
            return ourKeyManagers;
        }
        ourIsInitialized = true;
        String string = System.getProperty(CERTIFICATE_FILE, System.getProperty(OLD_CERTIFICATE_FILE));
        if (string == null) {
            return null;
        }
        char[] cArray = null;
        String string2 = System.getProperty(CERTIFICATE_PASSPHRASE, System.getProperty(OLD_CERTIFICATE_PASSPHRASE));
        if (string2 != null) {
            cArray = string2.toCharArray();
        }
        KeyStore keyStore = null;
        InputStream inputStream = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            if (keyStore != null) {
                inputStream = new FileInputStream(string);
                keyStore.load(inputStream, cArray);
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, throwable);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        KeyManagerFactory keyManagerFactory = null;
        if (keyStore != null) {
            try {
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                if (keyManagerFactory != null) {
                    keyManagerFactory.init(keyStore, cArray);
                    ourKeyManagers = keyManagerFactory.getKeyManagers();
                }
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, throwable);
            }
        }
        return ourKeyManagers;
    }
}

