/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVGetLocksHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLockHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVOptionsHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.helpers.DefaultHandler;

public class DAVConnection {
    protected static final String DAV_CAPABILITY_YES = "yes";
    protected static final String DAV_CAPABILITY_NO = "no";
    protected static final String DAV_CAPABILITY_SERVER_YES = "server-yes";
    private IHTTPConnection myHttpConnection;
    private String myActivityCollectionURL;
    private SVNRepository myRepository;
    private boolean myIsSpoolReport;
    protected boolean myKeepLocks;
    protected Map myLocks;
    protected Map myCapabilities;
    protected boolean myHttpV2Enabled;
    protected String myMeResource;
    protected String myRevStub;
    protected String myRevRootStub;
    protected String myTxnStub;
    protected String myTxnRootStub;
    protected String myVtxnStub;
    protected String myVtxnRootStub;
    protected String myUUID;
    protected String myServerAllowsBulk;
    protected long myLatestRevision;
    protected List mySupportedPosts;
    protected SVNURL myRepositoryRoot;
    protected IHTTPConnectionFactory myConnectionFactory;
    private HTTPStatus myLastStatus;

    public DAVConnection(IHTTPConnectionFactory iHTTPConnectionFactory, SVNRepository sVNRepository) {
        this.myRepository = sVNRepository;
        this.myConnectionFactory = iHTTPConnectionFactory;
        this.myLatestRevision = -1L;
        this.myHttpV2Enabled = sVNRepository instanceof DAVRepository && ((DAVRepository)sVNRepository).isHttpV2Enabled();
    }

    public boolean isReportResponseSpooled() {
        return this.myIsSpoolReport;
    }

    public void setReportResponseSpooled(boolean bl2) {
        this.myIsSpoolReport = bl2;
    }

    public SVNURL getLocation() {
        return this.myRepository.getLocation();
    }

    public HTTPStatus getLastStatus() {
        return this.myLastStatus;
    }

    public void updateLocation() {
        this.myActivityCollectionURL = null;
    }

    public void open(DAVRepository dAVRepository) {
        this.open(dAVRepository, null);
    }

    public void open(DAVRepository dAVRepository, SVNURL[] sVNURLArray) {
        if (this.myHttpConnection == null) {
            this.myHttpConnection = this.myConnectionFactory.createHTTPConnection(dAVRepository);
            if (dAVRepository.getSpoolLocation() != null && this.myHttpConnection instanceof HTTPConnection) {
                ((HTTPConnection)this.myHttpConnection).setSpoolAll(true);
                ((HTTPConnection)this.myHttpConnection).setSpoolDirectory(dAVRepository.getSpoolLocation());
            }
            this.exchangeCapabilities(sVNURLArray);
        }
    }

    public void fetchRepositoryRoot(DAVRepository dAVRepository) {
        if (!dAVRepository.hasRepositoryRoot()) {
            if (this.hasHttpV2Support()) {
                dAVRepository.setRepositoryRoot(this.myRepositoryRoot);
            } else {
                String string = dAVRepository.getLocation().getURIEncodedPath();
                DAVBaselineInfo dAVBaselineInfo = DAVUtil.getBaselineInfo(this, dAVRepository, string, -1L, false, false, null);
                string = string.substring(0, string.length() - dAVBaselineInfo.baselinePath.length());
                SVNURL sVNURL = dAVRepository.getLocation();
                SVNURL sVNURL2 = sVNURL.setPath(string, true);
                dAVRepository.setRepositoryRoot(sVNURL2);
            }
        }
    }

    public void fetchRepositoryUUID(DAVRepository dAVRepository) {
        if (!dAVRepository.hasRepositoryUUID()) {
            DAVUtil.findStartingProperties(this, dAVRepository, dAVRepository.getLocation().getURIEncodedPath());
            if (!dAVRepository.hasRepositoryUUID()) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NO_REPOS_UUID, "Please upgrade to server 0.19 or later");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
        }
    }

    public HTTPStatus doPropfind(String string, HTTPHeader hTTPHeader, StringBuffer stringBuffer, DefaultHandler defaultHandler) {
        this.beforeCall();
        IHTTPConnection iHTTPConnection = this.getConnection();
        return this.performHttpRequest(iHTTPConnection, "PROPFIND", string, hTTPHeader, stringBuffer, -1, 0, null, defaultHandler);
    }

    public HTTPStatus doOptions(String string) {
        this.beforeCall();
        IHTTPConnection iHTTPConnection = this.getConnection();
        return this.performHttpRequest(iHTTPConnection, "OPTIONS", string, null, DAVOptionsHandler.OPTIONS_REQUEST, 200, 0, null, null);
    }

    public SVNLock doGetLock(String string, DAVRepository dAVRepository) {
        this.beforeCall();
        DAVBaselineInfo dAVBaselineInfo = DAVUtil.getBaselineInfo(this, dAVRepository, string, -1L, false, true, null);
        StringBuffer stringBuffer = DAVLockHandler.generateGetLockRequest(null);
        DAVLockHandler dAVLockHandler = new DAVLockHandler();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Failed to fetch lock information");
        IHTTPConnection iHTTPConnection = this.getConnection();
        HTTPStatus hTTPStatus = this.performHttpRequest(iHTTPConnection, "PROPFIND", string, null, stringBuffer, 200, 207, null, dAVLockHandler, sVNErrorMessage);
        String string2 = dAVLockHandler.getID();
        if (string2 == null) {
            return null;
        }
        String string3 = dAVLockHandler.getComment();
        String string4 = hTTPStatus.getHeader().getFirstHeaderValue("X-SVN-Lock-Owner");
        String string5 = hTTPStatus.getHeader().getFirstHeaderValue("X-SVN-Creation-Date");
        SVNDate sVNDate = string5 != null ? SVNDate.parseDate(string5) : null;
        string = SVNEncodingUtil.uriDecode(dAVBaselineInfo.baselinePath);
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return new SVNLock(string, string2, string4, string3, sVNDate, null);
    }

    public SVNLock[] doGetLocks(String string) {
        DAVGetLocksHandler dAVGetLocksHandler = new DAVGetLocksHandler();
        HTTPStatus hTTPStatus = null;
        try {
            hTTPStatus = this.doReport(string, DAVGetLocksHandler.generateGetLocksRequest(null), dAVGetLocksHandler);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
                SVNErrorManager.error(sVNErrorMessage, sVNException.getErrorMessage(), SVNLogType.NETWORK);
            } else if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                return new SVNLock[0];
            }
            throw sVNException;
        }
        if (hTTPStatus.getCode() == 501) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
            SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
        } else {
            if (hTTPStatus.getCode() == 404) {
                return new SVNLock[0];
            }
            if (hTTPStatus.getError() != null && hTTPStatus.getError().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
                SVNErrorManager.error(sVNErrorMessage, hTTPStatus.getError(), SVNLogType.NETWORK);
            } else if (hTTPStatus.getError() != null) {
                SVNErrorManager.error(hTTPStatus.getError(), SVNLogType.NETWORK);
            }
        }
        return dAVGetLocksHandler.getLocks();
    }

    public SVNLock doLock(String string, String string2, DAVRepository dAVRepository, String string3, boolean bl2, long l2, long l3) {
        this.beforeCall();
        StringBuffer stringBuffer = DAVLockHandler.generateSetLockRequest(null, string3);
        HTTPHeader hTTPHeader = new HTTPHeader();
        hTTPHeader.setHeaderValue("Depth", "0");
        if (l3 <= 0L) {
            hTTPHeader.setHeaderValue("Timeout", "Infinite");
        } else {
            hTTPHeader.setHeaderValue("Timeout", "Second-" + Long.toString(l3));
        }
        hTTPHeader.setHeaderValue("Content-Type", "text/xml; charset=\"utf-8\"");
        if (l2 >= 0L) {
            hTTPHeader.setHeaderValue("X-SVN-Version-Name", Long.toString(l2));
        }
        if (bl2) {
            hTTPHeader.setHeaderValue("X-SVN-Options", "lock-steal");
        }
        DAVLockHandler dAVLockHandler = new DAVLockHandler();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Lock request failed");
        SVNException sVNException = null;
        IHTTPConnection iHTTPConnection = this.getConnection();
        try {
            this.myLastStatus = this.performHttpRequest(iHTTPConnection, "LOCK", string2, hTTPHeader, stringBuffer, -1, 0, null, dAVLockHandler, sVNErrorMessage);
        }
        catch (SVNException sVNException2) {
            this.myLastStatus = iHTTPConnection.getLastStatus();
            sVNException = sVNException2;
        }
        if (this.myLastStatus != null) {
            Serializable serializable;
            Object object;
            if (this.myLastStatus.getCode() == 405) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Lock request failed: {0} {1}", this.myLastStatus.getCode(), this.myLastStatus.getReason());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.CLIENT);
            } else if (this.myLastStatus.getCode() == 403) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_FORBIDDEN, "Lock request failed failed on ''{0}'' (403 Forbidden)", (Object)string2), SVNLogType.NETWORK);
            }
            if (this.myLastStatus.getError() != null) {
                this.myLastStatus.getError().setChildErrorMessage(null);
                SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
            }
            if (this.myLastStatus.getHeader() == null) {
                if (sVNException != null) {
                    throw sVNException;
                }
                return null;
            }
            object = this.myLastStatus.getHeader().getFirstHeaderValue("X-SVN-Lock-Owner");
            if (object == null) {
                object = iHTTPConnection.getLastValidCredentials() != null ? iHTTPConnection.getLastValidCredentials().getUserName() : null;
            }
            String string4 = this.myLastStatus.getHeader().getFirstHeaderValue("X-SVN-Creation-Date");
            if (object == null || string4 == null) {
                serializable = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Incomplete lock data returned");
                SVNErrorManager.error(serializable, SVNLogType.NETWORK);
            }
            serializable = string4 != null ? SVNDate.parseDate(string4) : null;
            return new SVNLock(string, dAVLockHandler.getID(), (String)object, string3, (Date)serializable, null);
        }
        if (sVNException != null) {
            throw sVNException;
        }
        return null;
    }

    public void doUnlock(String string, DAVRepository dAVRepository, String string2, boolean bl2) {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        this.beforeCall();
        if (string2 == null) {
            object = this.doGetLock(string, dAVRepository);
            if (object != null) {
                string2 = ((SVNLock)object).getID();
            }
            if (string2 == null) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "''{0}'' is not locked in the repository", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
        }
        object = new HTTPHeader();
        ((HTTPHeader)object).setHeaderValue("Lock-Token", "<" + string2 + ">");
        if (bl2) {
            ((HTTPHeader)object).setHeaderValue("X-SVN-Options", "lock-break");
        }
        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unlock request failed");
        IHTTPConnection iHTTPConnection = this.getConnection();
        SVNException sVNException = null;
        try {
            this.myLastStatus = this.performHttpRequest(iHTTPConnection, "UNLOCK", string, (HTTPHeader)object, null, -1, 0, null, null, sVNErrorMessage);
        }
        catch (SVNException sVNException2) {
            this.myLastStatus = iHTTPConnection.getLastStatus();
            sVNException = sVNException2;
        }
        if (this.myLastStatus != null) {
            switch (this.myLastStatus.getCode()) {
                case 403: {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_LOCK_OWNER_MISMATCH, "Unlock failed on ''{0}'' (403 Forbidden)", (Object)string), SVNLogType.NETWORK);
                    break;
                }
                case 400: {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_LOCK, "No lock on path ''{0}'' (400 Bad Request)", (Object)string), SVNLogType.NETWORK);
                    break;
                }
            }
            if (this.myLastStatus.getCode() >= 300 && this.myLastStatus.getError() != null) {
                SVNErrorMessage sVNErrorMessage2 = this.myLastStatus.getError() != null ? this.myLastStatus.getError() : SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED);
                SVNErrorManager.error(sVNErrorMessage2, SVNLogType.NETWORK);
            }
        }
        if (sVNException != null) {
            throw sVNException;
        }
    }

    public void doGet(String string, OutputStream outputStream) {
        this.beforeCall();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "GET request failed for ''{0}''", (Object)string);
        IHTTPConnection iHTTPConnection = this.getConnection();
        this.performHttpRequest(iHTTPConnection, "GET", string, null, null, 200, 226, outputStream, null, sVNErrorMessage);
    }

    public void doGet(String string, String string2, OutputStream outputStream) {
        this.beforeCall();
        HTTPHeader hTTPHeader = null;
        if (string2 != null) {
            hTTPHeader = new HTTPHeader();
            hTTPHeader.addHeaderValue("X-SVN-VR-Base", string2);
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "GET request failed for ''{0}''", (Object)string);
        IHTTPConnection iHTTPConnection = this.getConnection();
        this.performHttpRequest(iHTTPConnection, "GET", string, hTTPHeader, null, 200, 226, outputStream, null, sVNErrorMessage);
    }

    public HTTPStatus doReport(String string, StringBuffer stringBuffer, DefaultHandler defaultHandler) {
        return this.doReport(string, stringBuffer, defaultHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPStatus doReport(String string, StringBuffer stringBuffer, DefaultHandler defaultHandler, boolean bl2) {
        this.beforeCall();
        IHTTPConnection iHTTPConnection = this.getConnection();
        iHTTPConnection.setSpoolResponse(bl2 || this.isReportResponseSpooled());
        try {
            HTTPHeader hTTPHeader = new HTTPHeader();
            hTTPHeader.addHeaderValue("Accept-Encoding", "svndiff1;q=0.9,svndiff;q=0.8");
            HTTPStatus hTTPStatus = this.performHttpRequest(iHTTPConnection, "REPORT", string, hTTPHeader, stringBuffer, -1, 0, null, defaultHandler);
            return hTTPStatus;
        }
        finally {
            iHTTPConnection.setSpoolResponse(false);
        }
    }

    public void doProppatch(String string, String string2, StringBuffer stringBuffer, DefaultHandler defaultHandler, SVNErrorMessage sVNErrorMessage) {
        this.beforeCall();
        HTTPHeader hTTPHeader = null;
        if (this.myLocks != null && string != null && this.myLocks.containsKey(string)) {
            hTTPHeader = new HTTPHeader();
            hTTPHeader.setHeaderValue("If", "(<" + this.myLocks.get(string) + ">)");
        }
        IHTTPConnection iHTTPConnection = this.getConnection();
        try {
            this.performHttpRequest(iHTTPConnection, "PROPPATCH", string2, hTTPHeader, stringBuffer, 200, 207, null, defaultHandler, sVNErrorMessage);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage2;
            HTTPStatus hTTPStatus = iHTTPConnection.getLastStatus();
            if (hTTPStatus != null) {
                switch (hTTPStatus.getCode()) {
                    case 423: {
                        sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "No lock on path ''{0}'';  repository is unchanged", new Object[]{string2});
                        SVNErrorManager.error(sVNErrorMessage2, sVNException, SVNLogType.NETWORK);
                        break;
                    }
                }
            }
            sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_PROPPATCH_FAILED, "At least one property change failed; repository is unchanged");
            SVNErrorManager.error(sVNErrorMessage2, sVNException, SVNLogType.NETWORK);
        }
    }

    public String doMakeActivity(ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        String string;
        IHTTPConnection iHTTPConnection;
        HTTPStatus hTTPStatus;
        Object object;
        this.beforeCall();
        String string2 = null;
        if (iSVNWorkspaceMediator != null && (object = iSVNWorkspaceMediator.getWorkspaceProperty("", "svn:wc:ra_dav:activity-url")) != null && ((SVNPropertyValue)object).isString()) {
            string2 = ((SVNPropertyValue)object).getString();
        }
        object = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        if (string2 == null) {
            string2 = this.getActivityCollectionURL((String)object, false);
        }
        if ((hTTPStatus = this.performHttpRequest(iHTTPConnection = this.getConnection(), "MKACTIVITY", string = SVNPathUtil.append(string2, DAVConnection.generateUUID()), null, (StringBuffer)null, 201, 404, null, null)).getCode() == 404) {
            string2 = this.getActivityCollectionURL((String)object, true);
            string = SVNPathUtil.append(string2, DAVConnection.generateUUID());
            hTTPStatus = this.performHttpRequest(iHTTPConnection, "MKACTIVITY", string, null, (StringBuffer)null, 201, 0, null, null);
        }
        if (string2 != null && iSVNWorkspaceMediator != null) {
            iSVNWorkspaceMediator.setWorkspaceProperty("", "svn:wc:ra_dav:activity-url", SVNPropertyValue.create(string2));
        }
        return string;
    }

    public HTTPStatus doDelete(String string) {
        this.beforeCall();
        IHTTPConnection iHTTPConnection = this.getConnection();
        return this.performHttpRequest(iHTTPConnection, "DELETE", string, null, (StringBuffer)null, 404, 204, null, null);
    }

    public HTTPStatus doDelete(String string, String string2, long l2) {
        Object object;
        this.beforeCall();
        HTTPHeader hTTPHeader = new HTTPHeader();
        if (l2 >= 0L) {
            hTTPHeader.setHeaderValue("X-SVN-Version-Name", Long.toString(l2));
        }
        hTTPHeader.setHeaderValue("Depth", "infinity");
        StringBuffer stringBuffer = null;
        if (this.myLocks != null) {
            if (this.myLocks.containsKey(string)) {
                hTTPHeader.setHeaderValue("If", "<" + string + "> (<" + this.myLocks.get(string) + ">)");
            }
            if (this.myKeepLocks) {
                hTTPHeader.setHeaderValue("X-SVN-Options", "keep-locks");
            }
            stringBuffer = new StringBuffer();
            SVNXMLUtil.addXMLHeader(stringBuffer);
            object = this.getLocation().getPath();
            object = SVNEncodingUtil.uriEncode((String)object);
            stringBuffer = DAVMergeHandler.generateLockDataRequest(stringBuffer, (String)object, string, this.myLocks);
        }
        object = this.getConnection();
        SVNException sVNException = null;
        try {
            this.myLastStatus = this.performHttpRequest((IHTTPConnection)object, "DELETE", string2, hTTPHeader, stringBuffer, 204, 0, null, null);
        }
        catch (SVNException sVNException2) {
            this.myLastStatus = object.getLastStatus();
            sVNException = sVNException2;
        }
        if (this.myLastStatus != null && this.myLastStatus.getError() != null) {
            SVNErrorCode sVNErrorCode = this.myLastStatus.getError().getErrorCode();
            if (sVNErrorCode == SVNErrorCode.FS_BAD_LOCK_TOKEN || sVNErrorCode == SVNErrorCode.FS_NO_LOCK_TOKEN || sVNErrorCode == SVNErrorCode.FS_LOCK_OWNER_MISMATCH || sVNErrorCode == SVNErrorCode.FS_PATH_ALREADY_LOCKED) {
                String string3;
                Iterator iterator;
                SVNHashMap sVNHashMap = null;
                if (this.myLocks != null) {
                    sVNHashMap = new SVNHashMap();
                    iterator = this.myLocks.keySet().iterator();
                    while (iterator.hasNext()) {
                        string3 = (String)iterator.next();
                        if (!string3.startsWith(string2)) continue;
                        sVNHashMap.put(string3, this.myLocks.get(string3));
                    }
                }
                if (sVNHashMap == null || sVNHashMap.isEmpty()) {
                    SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
                } else {
                    this.myLastStatus.setError(null);
                }
                Iterator iterator2 = iterator = this.myLocks != null ? (String)this.myLocks.get(string2) : null;
                if (iterator != null) {
                    sVNHashMap.put(string2, iterator);
                }
                stringBuffer = new StringBuffer();
                string3 = this.getLocation().getPath();
                string3 = SVNEncodingUtil.uriEncode(string3);
                stringBuffer = DAVMergeHandler.generateLockDataRequest(stringBuffer, string3, string, sVNHashMap);
                try {
                    this.myLastStatus = this.performHttpRequest((IHTTPConnection)object, "DELETE", string2, hTTPHeader, stringBuffer, 204, 404, null, null);
                }
                catch (SVNException sVNException3) {
                    this.myLastStatus = object.getLastStatus();
                    sVNException = sVNException3;
                }
                if (this.myLastStatus.getError() != null) {
                    SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
                }
                if (sVNException != null) {
                    throw sVNException;
                }
                return this.myLastStatus;
            }
            SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
        }
        if (sVNException != null) {
            throw sVNException;
        }
        return this.myLastStatus;
    }

    public HTTPStatus doMakeCollection(String string) {
        this.beforeCall();
        IHTTPConnection iHTTPConnection = this.getConnection();
        return this.performHttpRequest(iHTTPConnection, "MKCOL", string, null, (StringBuffer)null, 201, 0, null, null);
    }

    public HTTPStatus doPutDiff(String string, String string2, InputStream inputStream, long l2, String string3, String string4, long l3) {
        this.beforeCall();
        HTTPHeader hTTPHeader = new HTTPHeader();
        hTTPHeader.setHeaderValue("Content-Type", "application/vnd.svn-svndiff");
        hTTPHeader.setHeaderValue("Content-Length", l2 + "");
        if (this.myLocks != null && this.myLocks.containsKey(string)) {
            hTTPHeader.setHeaderValue("If", "<" + string + "> (<" + this.myLocks.get(string) + ">)");
        }
        if (SVNRevision.isValidRevisionNumber(l3)) {
            hTTPHeader.setHeaderValue("X-SVN-Version-Name", String.valueOf(l3));
        }
        if (string3 != null) {
            hTTPHeader.setHeaderValue("X-SVN-Base-Fulltext-MD5", string3);
        }
        if (string4 != null) {
            hTTPHeader.setHeaderValue("X-SVN-Result-Fulltext-MD5", string4);
        }
        IHTTPConnection iHTTPConnection = this.getConnection();
        return this.performHttpRequest(iHTTPConnection, "PUT", string2, hTTPHeader, inputStream, 201, 204, null, null);
    }

    public HTTPStatus doMerge(String string, boolean bl2, DefaultHandler defaultHandler) {
        Object object;
        this.beforeCall();
        String string2 = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        StringBuffer stringBuffer = DAVMergeHandler.generateMergeRequest(null, string2, string, this.myLocks);
        HTTPHeader hTTPHeader = null;
        if (!bl2 || this.myLocks != null && !this.myKeepLocks) {
            hTTPHeader = new HTTPHeader();
            object = "";
            if (!bl2) {
                object = (String)object + "no-merge-response";
            }
            if (this.myLocks != null && !this.myKeepLocks) {
                object = (String)object + " release-locks";
            }
            hTTPHeader.setHeaderValue("X-SVN-Options", (String)object);
        }
        object = this.getConnection();
        return this.performHttpRequest((IHTTPConnection)object, "MERGE", this.getLocation().getURIEncodedPath(), hTTPHeader, stringBuffer, -1, 0, null, defaultHandler);
    }

    public HTTPStatus doCheckout(String string, String string2, String string3, boolean bl2) {
        this.beforeCall();
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("DAV:");
        SVNXMLUtil.addXMLHeader(stringBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "checkout", linkedList, SVNXMLUtil.PREFIX_MAP, stringBuffer);
        SVNXMLUtil.openXMLTag("D", "activity-set", 1, null, stringBuffer);
        SVNXMLUtil.openCDataTag("D", "href", string, stringBuffer);
        SVNXMLUtil.closeXMLTag("D", "activity-set", stringBuffer);
        SVNXMLUtil.closeXMLTag("D", "checkout", stringBuffer);
        HTTPHeader hTTPHeader = null;
        if (this.myLocks != null && string2 != null && this.myLocks.containsKey(string2)) {
            hTTPHeader = new HTTPHeader();
            hTTPHeader.setHeaderValue("If", "(<" + this.myLocks.get(string2) + ">)");
        }
        IHTTPConnection iHTTPConnection = this.getConnection();
        HTTPStatus hTTPStatus = this.performHttpRequest(iHTTPConnection, "CHECKOUT", string3, hTTPHeader, stringBuffer, 201, bl2 ? 404 : 0, null, null);
        if (bl2 && hTTPStatus.getCode() == 404 && hTTPStatus.getError() != null) {
            hTTPStatus.setError(null);
        }
        if (hTTPStatus.getHeader().hasHeader("Location")) {
            String string4 = null;
            String string5 = hTTPStatus.getHeader().getFirstHeaderValue("Location");
            if (string5.startsWith("/")) {
                string4 = string5;
            } else {
                SVNURL sVNURL = SVNURL.parseURIEncoded(hTTPStatus.getHeader().getFirstHeaderValue("Location"));
                string4 = sVNURL.getURIEncodedPath();
            }
            hTTPStatus.getHeader().setHeaderValue("Location", string4);
        }
        return hTTPStatus;
    }

    public void doCopy(String string, String string2, int n2) {
        this.beforeCall();
        HTTPHeader hTTPHeader = new HTTPHeader();
        hTTPHeader.setHeaderValue("Destination", string2);
        hTTPHeader.setHeaderValue("Depth", n2 > 0 ? "infinity" : "0");
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "COPY of {0}", (Object)string);
        IHTTPConnection iHTTPConnection = this.getConnection();
        HTTPStatus hTTPStatus = this.performHttpRequest(iHTTPConnection, "COPY", string, hTTPHeader, null, -1, 0, null, null, sVNErrorMessage);
        if (hTTPStatus.getCode() >= 300 && hTTPStatus.getError() != null) {
            SVNErrorMessage sVNErrorMessage2 = hTTPStatus.getError();
            SVNErrorManager.error(sVNErrorMessage2, SVNLogType.NETWORK);
        }
    }

    public HTTPStatus doPost(String string, String string2, byte[] byArray) {
        this.beforeCall();
        IHTTPConnection iHTTPConnection = this.getConnection();
        HTTPHeader hTTPHeader = new HTTPHeader();
        if (string2 != null) {
            hTTPHeader.setHeaderValue("Content-Type", string2);
        }
        HTTPStatus hTTPStatus = this.performHttpRequest(iHTTPConnection, "POST", string, hTTPHeader, byArray, 404, 201, null, null);
        return hTTPStatus;
    }

    public HTTPStatus doHead(String string) {
        this.beforeCall();
        IHTTPConnection iHTTPConnection = this.getConnection();
        HTTPStatus hTTPStatus = this.performHttpRequest(iHTTPConnection, "HEAD", string, null, (StringBuffer)null, 404, 0, null, null);
        return hTTPStatus;
    }

    public void close() {
        if (this.myHttpConnection != null) {
            this.myHttpConnection.close();
            this.myHttpConnection = null;
            this.myLocks = null;
            this.myKeepLocks = false;
        }
    }

    public void setLocks(Map map, boolean bl2) {
        this.myLocks = map;
        this.myKeepLocks = bl2;
    }

    public void clearAuthenticationCache() {
        if (this.myHttpConnection != null) {
            this.myHttpConnection.clearAuthenticationCache();
        }
    }

    public String getCapabilityResponse(SVNCapability sVNCapability) {
        if (this.myCapabilities == null || this.myCapabilities.get(sVNCapability) == null) {
            this.exchangeCapabilities(null);
        }
        return (String)this.myCapabilities.get(sVNCapability);
    }

    public void setCapability(SVNCapability sVNCapability, String string) {
        this.myCapabilities.put(sVNCapability, string);
    }

    public boolean hasHttpV2Support() {
        return this.myHttpV2Enabled && this.myMeResource != null;
    }

    public String getMeResource() {
        return this.myMeResource;
    }

    public List getSupportedPosts() {
        return this.mySupportedPosts;
    }

    public String getTxnStub() {
        return this.myTxnStub;
    }

    public String getTxnRootStub() {
        return this.myTxnRootStub;
    }

    public String getVtxnStub() {
        return this.myVtxnStub;
    }

    public String getVtxnRootStub() {
        return this.myVtxnRootStub;
    }

    protected IHTTPConnection getConnection() {
        return this.myHttpConnection;
    }

    protected void exchangeCapabilities(SVNURL[] sVNURLArray) {
        Object object;
        String string = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        IHTTPConnection iHTTPConnection = this.getConnection();
        HTTPStatus hTTPStatus = this.performHttpRequest(iHTTPConnection, "OPTIONS", string, null, DAVOptionsHandler.OPTIONS_REQUEST, 200, 0, null, null);
        if (DAVRepository.ourRedirectsEnabled && sVNURLArray != null && hTTPStatus.getCode() == 301) {
            String string2 = hTTPStatus.getHeader().getFirstHeaderValue("Location");
            if (string2 == null || string2.length() == 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_RESPONSE_HEADER_BADNESS, "Location header not set on redirect response");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            } else if (SVNPathUtil.isURL(string2)) {
                sVNURLArray[0] = SVNURL.parseURIEncoded(string2);
            } else {
                SVNURL sVNURL = this.getLocation();
                sVNURLArray[0] = SVNURL.create(sVNURL.getProtocol(), sVNURL.getUserInfo(), sVNURL.getHost(), sVNURL.getPort(), string2, false);
            }
            return;
        }
        if (hTTPStatus.getCode() >= 300 && hTTPStatus.getCode() < 399) {
            SVNErrorMessage sVNErrorMessage;
            Object object2 = object = hTTPStatus.getHeader() != null ? hTTPStatus.getHeader().getFirstHeaderValue("Location") : null;
            if (object != null) {
                String string3 = hTTPStatus.getCode() == 301 ? "Repository moved permanently to ''{0}''; please relocate" : "Repository moved temporarily to ''{0}''; please relocate";
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, string3, object);
            } else {
                String string4 = hTTPStatus.getCode() == 301 ? "Repository moved permanently; please relocate" : "Repository moved temporarily; please relocate";
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, string4);
            }
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        if (hTTPStatus.getCode() == 200) {
            this.parseCapabilities(hTTPStatus);
        } else {
            object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "OPTIONS request (for capabilities) got HTTP response code {0}", new Object[]{hTTPStatus.getCode()});
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
    }

    protected SVNRepository getRepository() {
        return this.myRepository;
    }

    protected void parseCapabilities(HTTPStatus hTTPStatus) {
        if (this.myCapabilities == null) {
            this.myCapabilities = new SVNHashMap();
        }
        this.myCapabilities.put(SVNCapability.DEPTH, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.MERGE_INFO, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.LOG_REVPROPS, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.ATOMIC_REVPROPS, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.INHERITED_PROPS, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.EPHEMERAL_PROPS, DAV_CAPABILITY_NO);
        HTTPHeader hTTPHeader = hTTPStatus.getHeader();
        List list = hTTPHeader.getHeaderValues("DAV");
        if (list != null) {
            for (Object object : list) {
                String[] string = ((String)object).split(",");
                for (Iterator numberFormatException : string) {
                    if ("http://subversion.tigris.org/xmlns/dav/svn/depth".equalsIgnoreCase((String)((Object)(numberFormatException = ((String)((Object)numberFormatException)).trim())))) {
                        this.myCapabilities.put(SVNCapability.DEPTH, DAV_CAPABILITY_YES);
                        continue;
                    }
                    if ("http://subversion.tigris.org/xmlns/dav/svn/mergeinfo".equalsIgnoreCase((String)((Object)numberFormatException))) {
                        this.myCapabilities.put(SVNCapability.MERGE_INFO, DAV_CAPABILITY_SERVER_YES);
                        continue;
                    }
                    if ("http://subversion.tigris.org/xmlns/dav/svn/log-revprops".equalsIgnoreCase((String)((Object)numberFormatException))) {
                        this.myCapabilities.put(SVNCapability.LOG_REVPROPS, DAV_CAPABILITY_YES);
                        continue;
                    }
                    if ("http://subversion.tigris.org/xmlns/dav/svn/partial-replay".equalsIgnoreCase((String)((Object)numberFormatException))) {
                        this.myCapabilities.put(SVNCapability.PARTIAL_REPLAY, DAV_CAPABILITY_YES);
                        continue;
                    }
                    if ("http://subversion.tigris.org/xmlns/dav/svn/atomic-revprops".equalsIgnoreCase((String)((Object)numberFormatException))) {
                        this.myCapabilities.put(SVNCapability.ATOMIC_REVPROPS, DAV_CAPABILITY_YES);
                        continue;
                    }
                    if ("http://subversion.tigris.org/xmlns/dav/svn/inherited-props".equalsIgnoreCase((String)((Object)numberFormatException))) {
                        this.myCapabilities.put(SVNCapability.INHERITED_PROPS, DAV_CAPABILITY_YES);
                        continue;
                    }
                    if (!"http://subversion.tigris.org/xmlns/dav/svn/ephemeral-txnprops".equalsIgnoreCase((String)((Object)numberFormatException))) continue;
                    this.myCapabilities.put(SVNCapability.EPHEMERAL_PROPS, DAV_CAPABILITY_YES);
                }
            }
        }
        Map map = hTTPHeader.getRawHeaders();
        for (Map.Entry entry : map.entrySet()) {
            String string;
            List list2;
            String string2 = (String)entry.getKey();
            if (!string2.toUpperCase().startsWith("SVN") || (list2 = (List)entry.getValue()) == null) continue;
            String string3 = string = list2 != null && list2.size() > 0 ? (String)list2.get(0) : null;
            if (this.mySupportedPosts == null) {
                this.mySupportedPosts = Collections.singletonList("create-txn");
            }
            if ("SVN-Repository-Root".equals(string2)) {
                try {
                    this.myRepositoryRoot = this.myRepository.getLocation().setPath(string, false);
                }
                catch (SVNException sVNException) {
                    this.myRepositoryRoot = null;
                }
                continue;
            }
            if ("SVN-Me-Resource".equals(string2)) {
                this.myMeResource = string;
                continue;
            }
            if ("SVN-Rev-Stub".equals(string2)) {
                this.myRevStub = string;
                continue;
            }
            if ("SVN-Rev-Root-Stub".equals(string2)) {
                this.myRevRootStub = string;
                continue;
            }
            if ("SVN-Txn-Stub".equals(string2)) {
                this.myTxnStub = string;
                continue;
            }
            if ("SVN-Txn-Root-Stub".equals(string2)) {
                this.myTxnRootStub = string;
                continue;
            }
            if ("SVN-VTxn-Stub".equals(string2)) {
                this.myVtxnStub = string;
                continue;
            }
            if ("SVN-VTxn-Root-Stub".equals(string2)) {
                this.myVtxnRootStub = string;
                continue;
            }
            if ("SVN-Repository-UUID".equals(string2)) {
                this.myUUID = string;
                continue;
            }
            if ("SVN-Youngest-Rev".equals(string2)) {
                try {
                    this.myLatestRevision = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.myLatestRevision = -1L;
                }
                continue;
            }
            if ("SVN-Allow-Bulk-Updates".equals(string2)) {
                this.myServerAllowsBulk = string;
                continue;
            }
            if ("SVN-Supported-Posts".equals(string2)) {
                this.mySupportedPosts = new ArrayList();
                for (String string4 : list2) {
                    String[] stringArray;
                    for (String string5 : stringArray = string4.split(",")) {
                        this.mySupportedPosts.add(string5.trim());
                    }
                }
                continue;
            }
            if (!"SVN-Repository-MergeInfo".equals(string2)) continue;
            if (DAV_CAPABILITY_YES.equals(string)) {
                this.myCapabilities.put(SVNCapability.MERGE_INFO, DAV_CAPABILITY_YES);
                continue;
            }
            if (!DAV_CAPABILITY_NO.equals(string)) continue;
            this.myCapabilities.put(SVNCapability.MERGE_INFO, DAV_CAPABILITY_NO);
        }
    }

    protected String getRelativePath(String string) {
        if (this.myRepositoryRoot == null) {
            assert (!this.hasHttpV2Support());
            throw new UnsupportedOperationException();
        }
        String string2 = this.myRepositoryRoot.getURIEncodedPath();
        return SVNPathUtil.getPathAsChild(string2, string);
    }

    protected String getRelativePath() {
        return this.getRelativePath(this.myRepository.getLocation().getURIEncodedPath());
    }

    private String getActivityCollectionURL(String string, boolean bl2) {
        if (!bl2 && this.myActivityCollectionURL != null) {
            return this.myActivityCollectionURL;
        }
        DAVOptionsHandler dAVOptionsHandler = new DAVOptionsHandler();
        IHTTPConnection iHTTPConnection = this.getConnection();
        this.performHttpRequest(iHTTPConnection, "OPTIONS", string, null, DAVOptionsHandler.OPTIONS_REQUEST, -1, 0, null, (DefaultHandler)dAVOptionsHandler);
        this.myActivityCollectionURL = dAVOptionsHandler.getActivityCollectionURL();
        if (this.myActivityCollectionURL == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "The OPTIONS request did not include the requested activity-collection-set; this often means that the URL is not WebDAV-enabled");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return this.myActivityCollectionURL;
    }

    private static String generateUUID() {
        try {
            return SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        }
        catch (SVNException sVNException) {
            long l2 = System.currentTimeMillis();
            String string = Long.toHexString(l2);
            int n2 = 16 - string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                string = "0" + string;
            }
            return string;
        }
    }

    private void beforeCall() {
        this.myLastStatus = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPStatus performHttpRequest(IHTTPConnection iHTTPConnection, String string, String string2, HTTPHeader hTTPHeader, byte[] byArray, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler) {
        this.myLastStatus = null;
        try {
            HTTPStatus hTTPStatus = this.myLastStatus = iHTTPConnection.request(string, string2, hTTPHeader, byArray != null ? new ByteArrayInputStream(byArray) : null, n2, n3, outputStream, defaultHandler);
            return hTTPStatus;
        }
        finally {
            this.myLastStatus = iHTTPConnection.getLastStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPStatus performHttpRequest(IHTTPConnection iHTTPConnection, String string, String string2, HTTPHeader hTTPHeader, StringBuffer stringBuffer, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler) {
        this.myLastStatus = null;
        try {
            HTTPStatus hTTPStatus = this.myLastStatus = iHTTPConnection.request(string, string2, hTTPHeader, stringBuffer, n2, n3, outputStream, defaultHandler);
            return hTTPStatus;
        }
        finally {
            this.myLastStatus = iHTTPConnection.getLastStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPStatus performHttpRequest(IHTTPConnection iHTTPConnection, String string, String string2, HTTPHeader hTTPHeader, StringBuffer stringBuffer, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler, SVNErrorMessage sVNErrorMessage) {
        this.myLastStatus = null;
        try {
            HTTPStatus hTTPStatus = this.myLastStatus = iHTTPConnection.request(string, string2, hTTPHeader, stringBuffer, n2, n3, outputStream, defaultHandler, sVNErrorMessage);
            return hTTPStatus;
        }
        finally {
            this.myLastStatus = iHTTPConnection.getLastStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPStatus performHttpRequest(IHTTPConnection iHTTPConnection, String string, String string2, HTTPHeader hTTPHeader, InputStream inputStream, int n2, int n3, OutputStream outputStream, DefaultHandler defaultHandler) {
        this.myLastStatus = null;
        try {
            HTTPStatus hTTPStatus = this.myLastStatus = iHTTPConnection.request(string, string2, hTTPHeader, inputStream, n2, n3, outputStream, defaultHandler);
            return hTTPStatus;
        }
        finally {
            this.myLastStatus = iHTTPConnection.getLastStatus();
        }
    }
}

