/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVResource;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBodyInputStream;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.helpers.DefaultHandler;

class DAVCommitEditor
implements ISVNEditor {
    public static final String CREATE_TXN_WITH_PROPS = "create-txn-with-props";
    public static final String CREATE_TXN = "create-txn";
    public static final String SKEL_MIME_TYPE = "application/vnd.svn-skel";
    private DAVConnection myConnection;
    private SVNURL myLocation;
    private DAVRepository myRepository;
    private Runnable myCloseCallback;
    private String myActivity;
    private Stack myDirsStack;
    private ISVNWorkspaceMediator myCommitMediator;
    private Map myPathsMap;
    private Map myFilesMap;
    private Map myBaseRevisionsMap;
    private String myBaseChecksum;
    private SVNProperties myRevProps;
    private String myActivityLocation;
    private Set myDeletedPaths;
    private String myTxnRootUrl;
    private String myTxnUrl;
    private OutputStream myCurrentDelta = null;
    private File myDeltaFile;
    private boolean myIsAborted;
    private boolean myIsFirstWindow;

    public DAVCommitEditor(DAVRepository dAVRepository, DAVConnection dAVConnection, String string, ISVNWorkspaceMediator iSVNWorkspaceMediator, Runnable runnable) {
        this(dAVRepository, dAVConnection, (SVNProperties)null, iSVNWorkspaceMediator, runnable);
        this.myRevProps = new SVNProperties();
        if (string != null) {
            this.myRevProps.put("svn:log", string);
        }
        this.myDeletedPaths = new HashSet();
    }

    public DAVCommitEditor(DAVRepository dAVRepository, DAVConnection dAVConnection, SVNProperties sVNProperties, ISVNWorkspaceMediator iSVNWorkspaceMediator, Runnable runnable) {
        this.myConnection = dAVConnection;
        this.myLocation = dAVRepository.getLocation();
        this.myRepository = dAVRepository;
        this.myCloseCallback = runnable;
        this.myCommitMediator = iSVNWorkspaceMediator;
        this.myDirsStack = new Stack();
        this.myPathsMap = new SVNHashMap();
        this.myFilesMap = new SVNHashMap();
        this.myBaseRevisionsMap = new SVNHashMap();
        this.myRevProps = sVNProperties != null ? sVNProperties : new SVNProperties();
        this.myDeletedPaths = new HashSet();
    }

    @Override
    public void targetRevision(long l2) {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void openRoot(long l2) {
        String string;
        if (this.myConnection.hasHttpV2Support()) {
            Object object;
            Object object2;
            boolean bl2 = this.myConnection.getSupportedPosts().contains(CREATE_TXN_WITH_PROPS);
            byte[] byArray = this.createTxnPostBody(bl2 ? this.myRevProps : null);
            String string2 = SKEL_MIME_TYPE;
            String string3 = this.myConnection.getMeResource();
            HTTPStatus hTTPStatus = this.myConnection.doPost(string3, SKEL_MIME_TYPE, byArray);
            if (hTTPStatus.getCode() != 201 && (object2 = DAVUtil.createUnexpectedStatusErrorMessage(hTTPStatus, "POST", string3)) != null) {
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.NETWORK);
            }
            if ((object2 = hTTPStatus.getHeader()) != null) {
                if (((HTTPHeader)object2).hasHeader("SVN-Txn-Name")) {
                    this.myTxnUrl = SVNPathUtil.append(this.myConnection.getTxnStub(), ((HTTPHeader)object2).getFirstHeaderValue("SVN-Txn-Name"));
                    this.myTxnRootUrl = SVNPathUtil.append(this.myConnection.getTxnRootStub(), ((HTTPHeader)object2).getFirstHeaderValue("SVN-Txn-Name"));
                }
                if (((HTTPHeader)object2).hasHeader("SVN-VTxn-Name")) {
                    this.myTxnUrl = SVNPathUtil.append(this.myConnection.getVtxnStub(), ((HTTPHeader)object2).getFirstHeaderValue("SVN-VTxn-Name"));
                    this.myTxnRootUrl = SVNPathUtil.append(this.myConnection.getVtxnRootStub(), ((HTTPHeader)object2).getFirstHeaderValue("SVN-VTxn-Name"));
                }
            }
            if (this.myTxnRootUrl == null || this.myTxnUrl == null) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "POST request did not return transaction information");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            object = this.myConnection.getRelativePath();
            this.myTxnRootUrl = SVNPathUtil.append(this.myTxnRootUrl, (String)object);
            DAVResource dAVResource = new DAVResource(this.myCommitMediator, this.myConnection, "", l2);
            dAVResource.setCustomURL(this.myTxnRootUrl);
            this.myDirsStack.push(dAVResource);
            string = bl2 ? null : this.myTxnUrl;
        } else {
            String[] stringArray = this.createActivity();
            this.myActivity = stringArray[0];
            this.myActivityLocation = stringArray[1];
            DAVResource dAVResource = new DAVResource(this.myCommitMediator, this.myConnection, "", l2);
            dAVResource.fetchVersionURL(null, false);
            this.myDirsStack.push(dAVResource);
            this.myPathsMap.put(dAVResource.getURL(), dAVResource.getPath());
            string = null;
        }
        if (string != null) {
            this.patchResourceProperties(string, this.myRevProps);
        }
    }

    @Override
    public void deleteEntry(String string, long l2) {
        string = SVNEncodingUtil.uriEncode(string);
        if (this.myConnection.hasHttpV2Support()) {
            SVNErrorMessage sVNErrorMessage;
            String string2 = SVNPathUtil.append(this.myTxnRootUrl, string);
            HTTPStatus hTTPStatus = this.myConnection.doDelete(string, string2, l2);
            if (hTTPStatus.getCode() != 204 && (sVNErrorMessage = DAVUtil.createUnexpectedStatusErrorMessage(hTTPStatus, "DELETE", string)) != null) {
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.myDeletedPaths.add(string);
        } else {
            String string3;
            DAVResource dAVResource = (DAVResource)this.myDirsStack.peek();
            this.checkoutResource(dAVResource, true);
            String string4 = dAVResource.getWorkingURL();
            if (this.myDirsStack.size() == 1) {
                string4 = SVNPathUtil.append(dAVResource.getWorkingURL(), string);
                string3 = SVNPathUtil.append(dAVResource.getURL(), string);
            } else {
                string4 = SVNPathUtil.append(string4, SVNPathUtil.tail(string));
                string3 = SVNPathUtil.append(dAVResource.getURL(), SVNPathUtil.tail(string));
            }
            this.myConnection.doDelete(string3, string4, l2);
            if (this.myDirsStack.size() == 1) {
                this.myPathsMap.put(SVNPathUtil.append(dAVResource.getURL(), string), string);
            } else {
                this.myPathsMap.put(SVNPathUtil.append(dAVResource.getURL(), SVNPathUtil.tail(string)), string);
            }
        }
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        string = SVNEncodingUtil.uriEncode(string);
        DAVResource dAVResource = (DAVResource)this.myDirsStack.peek();
        if (!this.myConnection.hasHttpV2Support()) {
            this.checkoutResource(dAVResource, true);
        }
        String string3 = dAVResource.getWorkingURL();
        DAVResource dAVResource2 = new DAVResource(this.myCommitMediator, this.myConnection, string, -1L, string2 != null);
        dAVResource2.setWorkingURL(SVNPathUtil.append(string3, SVNPathUtil.tail(string)));
        dAVResource2.setAdded(true);
        dAVResource2.setCustomURL(SVNPathUtil.append(this.myTxnRootUrl, string));
        String string4 = this.myConnection.hasHttpV2Support() ? dAVResource2.getCustomURL() : dAVResource2.getWorkingURL();
        this.myDirsStack.push(dAVResource2);
        this.myPathsMap.put(dAVResource2.getURL(), string);
        if (string2 != null) {
            string2 = this.myRepository.doGetFullPath(string2);
            string2 = SVNEncodingUtil.uriEncode(string2);
            DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(this.myConnection, this.myRepository, string2, l2, false, false, null);
            string2 = SVNPathUtil.append(dAVBaselineInfo.baselineBase, dAVBaselineInfo.baselinePath);
            String string5 = this.myLocation.setPath(this.myConnection.hasHttpV2Support() ? dAVResource2.getCustomURL() : dAVResource2.getWorkingURL(), true).toString();
            this.myConnection.doCopy(string2, string5, 1);
        } else {
            try {
                this.myConnection.doMakeCollection(string4);
            }
            catch (SVNException sVNException) {
                if (!sVNException.getErrorMessage().getErrorCode().isAuthentication() && sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.CANCELLED) {
                    SVNErrorMessage sVNErrorMessage = null;
                    try {
                        DAVBaselineInfo dAVBaselineInfo = DAVUtil.getStableURL(this.myConnection, this.myRepository, dAVResource2.getURL(), -1L, false, false, null);
                        if (dAVBaselineInfo != null) {
                            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)dAVResource2.getURL());
                        }
                    }
                    catch (SVNException sVNException2) {
                        // empty catch block
                    }
                    if (sVNErrorMessage != null) {
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                    }
                }
                throw sVNException;
            }
        }
    }

    @Override
    public void openDir(String string, long l2) {
        string = SVNEncodingUtil.uriEncode(string);
        DAVResource dAVResource = this.myDirsStack.peek() != null ? (DAVResource)this.myDirsStack.peek() : null;
        DAVResource dAVResource2 = new DAVResource(this.myCommitMediator, this.myConnection, string, l2, dAVResource != null && dAVResource.isCopy());
        if (this.myConnection.hasHttpV2Support()) {
            dAVResource2.setCustomURL(SVNPathUtil.append(this.myTxnRootUrl, string));
        } else if (dAVResource != null && dAVResource.getVersionURL() == null) {
            dAVResource2.setWorkingURL(SVNPathUtil.append(dAVResource.getWorkingURL(), SVNPathUtil.tail(string)));
        } else {
            dAVResource2.fetchVersionURL(dAVResource, false);
        }
        this.myDirsStack.push(dAVResource2);
        this.myPathsMap.put(dAVResource2.getURL(), dAVResource2.getPath());
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        DAVResource dAVResource = (DAVResource)this.myDirsStack.peek();
        if (!this.myConnection.hasHttpV2Support()) {
            this.checkoutResource(dAVResource, true);
        }
        dAVResource.putProperty(string, sVNPropertyValue);
        this.myPathsMap.put(dAVResource.getURL(), dAVResource.getPath());
    }

    @Override
    public void closeDir() {
        DAVResource dAVResource = (DAVResource)this.myDirsStack.pop();
        if (dAVResource.getProperties() != null) {
            StringBuffer stringBuffer = DAVProppatchHandler.generatePropertyRequest(null, dAVResource.getProperties());
            String string = this.myConnection.hasHttpV2Support() ? dAVResource.getCustomURL() : dAVResource.getWorkingURL();
            this.myConnection.doProppatch(dAVResource.getURL(), string, stringBuffer, null, null);
        }
        dAVResource.dispose();
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        Object object;
        Object object2;
        this.myBaseRevisionsMap.put(string, -1L);
        String string3 = string;
        string = SVNEncodingUtil.uriEncode(string);
        DAVResource dAVResource = (DAVResource)this.myDirsStack.peek();
        if (!this.myConnection.hasHttpV2Support()) {
            this.checkoutResource(dAVResource, true);
        }
        String string4 = dAVResource.getWorkingURL();
        DAVResource dAVResource2 = new DAVResource(this.myCommitMediator, this.myConnection, string, -1L, string2 != null);
        dAVResource2.setWorkingURL(SVNPathUtil.append(string4, SVNPathUtil.tail(string)));
        dAVResource2.setCustomURL(SVNPathUtil.append(this.myTxnRootUrl, string));
        String string5 = string;
        while (string5 != null && string5.length() > 0 && !this.myDeletedPaths.contains(string5)) {
            string5 = SVNPathUtil.removeTail(string5);
        }
        if (!(this.myConnection.hasHttpV2Support() || dAVResource.isAdded() || this.myPathsMap.containsKey(dAVResource2.getURL()))) {
            object2 = SVNPathUtil.append(dAVResource.getURL(), SVNPathUtil.tail(string));
            object = null;
            SVNErrorMessage sVNErrorMessage = null;
            try {
                DAVUtil.getResourceProperties(this.myConnection, (String)object2, null, DAVElement.STARTING_PROPERTIES);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage() == null) {
                    throw sVNException;
                }
                object = sVNException.getErrorMessage();
            }
            try {
                DAVUtil.getResourceProperties(this.myConnection, dAVResource2.getWorkingURL(), null, DAVElement.STARTING_PROPERTIES);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage() == null) {
                    throw sVNException;
                }
                sVNErrorMessage = sVNException.getErrorMessage();
            }
            if (object == null && sVNErrorMessage == null) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_ALREADY_EXISTS, "File ''{0}'' already exists", object2);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            } else if (!(object != null && ((SVNErrorMessage)object).getErrorCode() == SVNErrorCode.FS_NOT_FOUND || sVNErrorMessage != null && sVNErrorMessage.getErrorCode() == SVNErrorCode.FS_NOT_FOUND)) {
                SVNErrorManager.error((SVNErrorMessage)object, sVNErrorMessage, SVNLogType.NETWORK);
            }
        }
        this.myPathsMap.put(dAVResource2.getURL(), dAVResource2.getPath());
        this.myFilesMap.put(string3, dAVResource2);
        dAVResource2.setAdded(true);
        if (string2 != null) {
            string2 = this.myRepository.doGetFullPath(string2);
            string2 = SVNEncodingUtil.uriEncode(string2);
            object2 = DAVUtil.getStableURL(this.myConnection, this.myRepository, string2, l2, false, false, null);
            string2 = SVNPathUtil.append(((DAVBaselineInfo)object2).baselineBase, ((DAVBaselineInfo)object2).baselinePath);
            object = this.myLocation.setPath(this.myConnection.hasHttpV2Support() ? dAVResource2.getCustomURL() : dAVResource2.getWorkingURL(), true).toString();
            this.myConnection.doCopy(string2, (String)object, 0);
        } else if (!(!this.myConnection.hasHttpV2Support() || dAVResource.isAdded() && !dAVResource.isCopy() || string5 != null && string5.length() > 0)) {
            object2 = SVNPathUtil.append(this.myRepository.getLocation().getPath(), string);
            this.myConnection.doHead((String)object2);
        }
    }

    @Override
    public void openFile(String string, long l2) {
        this.myBaseRevisionsMap.put(string, l2);
        String string2 = string;
        string = SVNEncodingUtil.uriEncode(string);
        DAVResource dAVResource = new DAVResource(this.myCommitMediator, this.myConnection, string, l2);
        DAVResource dAVResource2 = (DAVResource)this.myDirsStack.peek();
        if (this.myConnection.hasHttpV2Support()) {
            dAVResource.setCustomURL(SVNPathUtil.append(this.myTxnRootUrl, string));
        } else {
            if (dAVResource2.getVersionURL() == null) {
                dAVResource.setWorkingURL(SVNPathUtil.append(dAVResource2.getWorkingURL(), SVNPathUtil.tail(string)));
            } else {
                dAVResource.fetchVersionURL(dAVResource2, false);
            }
            this.checkoutResource(dAVResource, true);
        }
        this.myPathsMap.put(dAVResource.getURL(), dAVResource.getPath());
        this.myFilesMap.put(string2, dAVResource);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        this.myCurrentDelta = null;
        this.myIsFirstWindow = true;
        this.myDeltaFile = null;
        this.myBaseChecksum = string2;
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        try {
            if (this.myCurrentDelta == null) {
                this.myDeltaFile = SVNFileUtil.createTempFile("svnkit", ".tmp");
                this.myCurrentDelta = SVNFileUtil.openFileForWriting(this.myDeltaFile);
            }
            sVNDiffWindow.writeTo(this.myCurrentDelta, this.myIsFirstWindow);
            this.myIsFirstWindow = false;
            return SVNFileUtil.DUMMY_OUT;
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile(this.myCurrentDelta);
            SVNFileUtil.deleteFile(this.myDeltaFile);
            this.myDeltaFile = null;
            this.myCurrentDelta = null;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.NETWORK);
            return null;
        }
    }

    @Override
    public void textDeltaEnd(String string) {
        SVNFileUtil.closeFile(this.myCurrentDelta);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        DAVResource dAVResource = (DAVResource)this.myFilesMap.get(string);
        dAVResource.putProperty(string2, sVNPropertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(String string, String string2) {
        DAVResource dAVResource = (DAVResource)this.myFilesMap.get(string);
        try {
            Object object;
            Object object2;
            if (this.myDeltaFile != null) {
                object2 = null;
                try {
                    object2 = new HTTPBodyInputStream(this.myDeltaFile);
                    object = (Long)this.myBaseRevisionsMap.get(string);
                    this.myConnection.doPutDiff(dAVResource.getURL(), this.myConnection.hasHttpV2Support() ? dAVResource.getCustomURL() : dAVResource.getWorkingURL(), (InputStream)object2, this.myDeltaFile.length(), this.myBaseChecksum, string2, object == null ? -1L : (Long)object);
                }
                catch (SVNException sVNException) {
                    try {
                        HTTPStatus hTTPStatus = this.myConnection.getLastStatus();
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_REQUEST_FAILED && hTTPStatus != null) {
                            switch (hTTPStatus.getCode()) {
                                case 423: {
                                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "No lock on path ''{0}'' (Status {0} on PUT Request)", new Object[]{this.myConnection.hasHttpV2Support() ? dAVResource.getCustomURL() : dAVResource.getWorkingURL(), hTTPStatus.getCode()});
                                    SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.CLIENT);
                                }
                            }
                            throw sVNException;
                        }
                        throw sVNException;
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(object2);
                        SVNFileUtil.deleteFile(this.myDeltaFile);
                        this.myDeltaFile = null;
                        throw throwable;
                    }
                }
                SVNFileUtil.closeFile((InputStream)object2);
                SVNFileUtil.deleteFile(this.myDeltaFile);
                this.myDeltaFile = null;
            }
            if (dAVResource.getProperties() != null) {
                object2 = DAVProppatchHandler.generatePropertyRequest(null, dAVResource.getProperties());
                object = this.myConnection.hasHttpV2Support() ? dAVResource.getCustomURL() : dAVResource.getWorkingURL();
                this.myConnection.doProppatch(dAVResource.getURL(), (String)object, (StringBuffer)object2, null, null);
            }
        }
        finally {
            dAVResource.dispose();
            this.myCurrentDelta = null;
            this.myBaseChecksum = null;
            this.myFilesMap.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNCommitInfo closeEdit() {
        try {
            Object object;
            Object object2;
            Object object3;
            if (!this.myDirsStack.isEmpty()) {
                object3 = (DAVResource)this.myDirsStack.pop();
                if (((DAVResource)object3).getProperties() != null) {
                    object2 = DAVProppatchHandler.generatePropertyRequest(null, ((DAVResource)object3).getProperties());
                    object = this.myConnection.hasHttpV2Support() ? ((DAVResource)object3).getCustomURL() : ((DAVResource)object3).getWorkingURL();
                    this.myConnection.doProppatch(((DAVResource)object3).getURL(), (String)object, (StringBuffer)object2, null, null);
                }
                ((DAVResource)object3).dispose();
            }
            object3 = this.myActivity != null ? this.myActivity : this.myTxnUrl;
            object2 = new DAVMergeHandler(this.myCommitMediator, this.myPathsMap);
            if (!this.myConnection.hasHttpV2Support()) {
                this.patchResourceProperties(this.myActivityLocation, this.myRevProps);
            }
            if (((HTTPStatus)(object = this.myConnection.doMerge((String)object3, true, (DefaultHandler)object2))).getError() != null) {
                this.myIsAborted = true;
                SVNErrorManager.error(((HTTPStatus)object).getError(), SVNLogType.NETWORK);
            }
            SVNCommitInfo sVNCommitInfo = ((DAVMergeHandler)object2).getCommitInfo();
            return sVNCommitInfo;
        }
        finally {
            try {
                this.abortEdit();
            }
            catch (SVNException sVNException) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.DEFAULT, sVNException);
            }
            this.runCloseCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortEdit() {
        if (this.myIsAborted) {
            return;
        }
        this.myIsAborted = true;
        try {
            try {
                if (this.myActivity != null) {
                    this.myConnection.doDelete(this.myActivity);
                }
            }
            finally {
                if (this.myFilesMap != null) {
                    for (DAVResource dAVResource : this.myFilesMap.values()) {
                        dAVResource.dispose();
                    }
                    this.myFilesMap = null;
                }
                for (DAVResource dAVResource : this.myDirsStack) {
                    dAVResource.dispose();
                }
                this.myDirsStack = null;
            }
        }
        finally {
            this.runCloseCallback();
        }
    }

    private void runCloseCallback() {
        if (this.myCloseCallback != null) {
            this.myCloseCallback.run();
            this.myCloseCallback = null;
        }
    }

    private String[] createActivity() {
        String string;
        Object object;
        String string2 = this.myConnection.doMakeActivity(this.myCommitMediator);
        String string3 = SVNEncodingUtil.uriEncode(this.myLocation.getPath());
        String string4 = DAVUtil.getPropertyValue(this.myConnection, string3, null, DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        HTTPStatus hTTPStatus = null;
        for (int i2 = 0; i2 < 5; ++i2) {
            object = DAVUtil.getPropertyValue(this.myConnection, string4, null, DAVElement.CHECKED_IN);
            try {
                hTTPStatus = this.myConnection.doCheckout(string2, null, (String)object, false);
                break;
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.APMOD_BAD_BASELINE && i2 != 4) continue;
                throw sVNException;
            }
        }
        if ((string = hTTPStatus.getHeader().getFirstHeaderValue("Location")) == null) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The CHECKOUT response did not contain a 'Location:' header");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        if (this.myRevProps != null) {
            object = this.myRevProps.remove("svn:author");
            this.patchResourceProperties(string, this.myRevProps);
            if (object != null) {
                this.myRevProps = new SVNProperties();
                this.myRevProps.put("svn:author", (SVNPropertyValue)object);
            } else {
                this.myRevProps = null;
            }
        }
        return new String[]{string2, string};
    }

    private void patchResourceProperties(String string, SVNProperties sVNProperties) {
        if (sVNProperties != null && sVNProperties.size() > 0) {
            StringBuffer stringBuffer = DAVProppatchHandler.generatePropertyRequest(null, sVNProperties);
            try {
                this.myConnection.doProppatch(null, string, stringBuffer, null, null);
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "applying log message to {0}", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
        }
    }

    private void checkoutResource(DAVResource dAVResource, boolean bl2) {
        String string;
        if (dAVResource.getWorkingURL() != null) {
            return;
        }
        HTTPStatus hTTPStatus = null;
        try {
            hTTPStatus = this.myConnection.doCheckout(this.myActivity, dAVResource.getURL(), dAVResource.getVersionURL(), bl2);
            if (bl2 && hTTPStatus.getCode() == 404) {
                dAVResource.fetchVersionURL(null, true);
                hTTPStatus = this.myConnection.doCheckout(this.myActivity, dAVResource.getURL(), dAVResource.getVersionURL(), false);
            }
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_CONFLICT) {
                String string2 = dAVResource.getPath();
                if ("".equals(string2)) {
                    string2 = dAVResource.getURL();
                }
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CONFLICT, "File or directory ''{0}'' is out of date; try updating", (Object)string2);
                SVNErrorManager.error(sVNErrorMessage, sVNException.getErrorMessage(), SVNLogType.NETWORK);
            }
            throw sVNException;
        }
        String string3 = string = hTTPStatus != null ? hTTPStatus.getHeader().getFirstHeaderValue("Location") : null;
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The CHECKOUT response did not contain a 'Location:' header");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        dAVResource.setWorkingURL(string);
    }

    private byte[] createTxnPostBody(SVNProperties sVNProperties) {
        SVNSkel sVNSkel = SVNSkel.createEmptyList();
        if (sVNProperties != null) {
            SVNSkel sVNSkel2 = SVNSkel.createPropList(sVNProperties.asMap());
            sVNSkel.prepend(sVNSkel2);
            sVNSkel.prependString(CREATE_TXN_WITH_PROPS);
            return sVNSkel.unparse();
        }
        return "( create-txn )".getBytes();
    }
}

