/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.InflaterInputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDeltaReader {
    private ByteBuffer myBuffer = ByteBuffer.allocate(4096);
    private int myHeaderBytes;
    private long myLastSourceOffset;
    private int myLastSourceLength;
    private boolean myIsWindowSent;
    private byte myVersion;

    public SVNDeltaReader() {
        this.myBuffer.clear();
        this.myBuffer.limit(0);
    }

    public void reset(String string, ISVNDeltaConsumer iSVNDeltaConsumer) {
        if (this.myHeaderBytes == 4 && !this.myIsWindowSent) {
            OutputStream outputStream = iSVNDeltaConsumer.textDeltaChunk(string, SVNDiffWindow.EMPTY);
            SVNFileUtil.closeFile(outputStream);
        }
        this.myLastSourceLength = 0;
        this.myLastSourceOffset = 0L;
        this.myHeaderBytes = 0;
        this.myIsWindowSent = false;
        this.myVersion = 0;
        this.myBuffer.clear();
        this.myBuffer.limit(0);
    }

    public void nextWindow(byte[] byArray, int n2, int n3, String string, ISVNDeltaConsumer iSVNDeltaConsumer) {
        this.appendToBuffer(byArray, n2, n3);
        if (this.myHeaderBytes < 4) {
            if (this.myBuffer.remaining() < 4) {
                return;
            }
            if (this.myBuffer.get(0) != 83 || this.myBuffer.get(1) != 86 || this.myBuffer.get(2) != 78 || this.myBuffer.get(3) != 0 && this.myBuffer.get(3) != 1 && this.myBuffer.get(3) != 2) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW, "Svndiff has invalid header");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
            this.myVersion = this.myBuffer.get(3);
            this.myBuffer.position(4);
            int n4 = this.myBuffer.remaining();
            this.myBuffer.compact();
            this.myBuffer.position(0);
            this.myBuffer.limit(n4);
            this.myHeaderBytes = 4;
        }
        long l2;
        while ((l2 = this.readLongOffset()) >= 0L) {
            Object object;
            int n5 = this.readOffset();
            if (n5 < 0) {
                return;
            }
            int n6 = this.readOffset();
            if (n6 < 0) {
                return;
            }
            int n7 = this.readOffset();
            if (n7 < 0) {
                return;
            }
            int n8 = this.readOffset();
            if (n8 < 0) {
                return;
            }
            if (n5 > 0 && (l2 < this.myLastSourceOffset || l2 + (long)n5 < this.myLastSourceOffset + (long)this.myLastSourceLength)) {
                object = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW, "Svndiff has backwards-sliding source views");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            }
            if (this.myBuffer.remaining() < n7 + n8) {
                return;
            }
            this.myLastSourceOffset = l2;
            this.myLastSourceLength = n5;
            int n9 = n8 + n7;
            if (this.myVersion == 1 || this.myVersion == 2) {
                Object object2;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n10 = this.myBuffer.position();
                try {
                    n7 = this.deflate(n7, byteArrayOutputStream, this.myVersion);
                    n8 = this.deflate(n8, byteArrayOutputStream, this.myVersion);
                }
                catch (IOException iOException) {
                    SVNDebugLog.getDefaultLog().logSevere(SVNLogType.DEFAULT, iOException);
                    object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.NETWORK);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                object2 = ByteBuffer.wrap(byArray2);
                ((ByteBuffer)object2).position(0);
                object = new SVNDiffWindow(l2, n5, n6, n7, n8);
                ((SVNDiffWindow)object).setData((ByteBuffer)object2);
                this.myBuffer.position(n10);
            } else {
                object = new SVNDiffWindow(l2, n5, n6, n7, n8);
                ((SVNDiffWindow)object).setData(this.myBuffer);
            }
            int n11 = this.myBuffer.position();
            OutputStream outputStream = iSVNDeltaConsumer.textDeltaChunk(string, (SVNDiffWindow)object);
            SVNFileUtil.closeFile(outputStream);
            this.myBuffer.position(n11 + n9);
            int n12 = this.myBuffer.remaining();
            this.myIsWindowSent = true;
            this.myBuffer.compact();
            this.myBuffer.position(0);
            this.myBuffer.limit(n12);
        }
        return;
    }

    private int deflate(int n2, OutputStream outputStream, int n3) {
        int n4 = this.myBuffer.position();
        int n5 = this.readOffset();
        if (n5 == n2 - (this.myBuffer.position() - n4)) {
            int n6 = this.myBuffer.arrayOffset() + this.myBuffer.position();
            outputStream.write(this.myBuffer.array(), n6, n5);
        } else {
            byte[] byArray = new byte[n5];
            byte[] byArray2 = this.myBuffer.array();
            int n7 = this.myBuffer.arrayOffset() + this.myBuffer.position();
            if (n3 == 1) {
                int n8;
                InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray2, n7, n2));
                for (int i2 = 0; i2 < n5 && (n8 = ((InputStream)inflaterInputStream).read(byArray, i2, n5 - i2)) >= 0; i2 += n8) {
                }
            } else if (n3 == 2) {
                LZ4FastDecompressor lZ4FastDecompressor = LZ4Factory.fastestInstance().fastDecompressor();
                lZ4FastDecompressor.decompress(byArray2, n7, byArray, 0, n5);
            }
            outputStream.write(byArray);
        }
        this.myBuffer.position(n4 + n2);
        return n5;
    }

    private void appendToBuffer(byte[] byArray, int n2, int n3) {
        int n4 = this.myBuffer.limit();
        if (this.myBuffer.capacity() < n4 + n3) {
            ByteBuffer byteBuffer = ByteBuffer.allocate((n4 + n3) * 3 / 2);
            this.myBuffer.position(0);
            byteBuffer.put(this.myBuffer);
            this.myBuffer = byteBuffer;
        } else {
            this.myBuffer.limit(n4 + n3);
            this.myBuffer.position(n4);
        }
        this.myBuffer.put(byArray, n2, n3);
        this.myBuffer.position(0);
        this.myBuffer.limit(n4 + n3);
    }

    private int readOffset() {
        this.myBuffer.mark();
        int n2 = 0;
        while (this.myBuffer.hasRemaining()) {
            byte by = this.myBuffer.get();
            n2 = n2 << 7 | by & 0x7F;
            if ((by & 0x80) != 0) continue;
            return n2;
        }
        this.myBuffer.reset();
        return -1;
    }

    private long readLongOffset() {
        this.myBuffer.mark();
        long l2 = 0L;
        while (this.myBuffer.hasRemaining()) {
            byte by = this.myBuffer.get();
            l2 = l2 << 7 | (long)(by & 0x7F);
            if ((by & 0x80) != 0) continue;
            return l2;
        }
        this.myBuffer.reset();
        return -1L;
    }
}

