/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.InflaterInputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner$SVNOffsetsIndex;
import org.tmatesoft.svn.core.internal.delta.SVNRangeTree;
import org.tmatesoft.svn.core.internal.delta.SVNRangeTree$SVNRangeListNode;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDeltaCombiner {
    private SVNDiffWindow myWindow;
    private ByteBuffer myWindowData;
    private ByteBuffer myNextWindowInstructions;
    private ByteBuffer myNextWindowData;
    private ByteBuffer myTarget;
    private ByteBuffer myRealTarget;
    private ByteBuffer myReadWindowBuffer;
    private SVNRangeTree myRangeTree = new SVNRangeTree();
    private SVNDeltaCombiner$SVNOffsetsIndex myOffsetsIndex;
    private SVNDiffInstruction[] myWindowInstructions = new SVNDiffInstruction[10];
    private SVNDiffInstruction myInstructionTemplate = new SVNDiffInstruction(0, 0, 0);

    public SVNDeltaCombiner() {
        this.myOffsetsIndex = new SVNDeltaCombiner$SVNOffsetsIndex();
        this.myNextWindowData = ByteBuffer.allocate(2048);
    }

    public void reset() {
        this.myWindow = null;
        this.myWindowData = null;
        this.myReadWindowBuffer = null;
        this.myNextWindowData = this.clearBuffer(this.myNextWindowData);
        this.myNextWindowInstructions = null;
        this.myTarget = null;
        this.myRealTarget = null;
        this.myRangeTree.dispose();
    }

    public SVNDiffWindow readWindow(FSFile fSFile, int n2) {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, 4096);
        long l2 = 0L;
        try {
            l2 = fSFile.position();
            fSFile.read(this.myReadWindowBuffer);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(sVNErrorMessage2, iOException, SVNLogType.DEFAULT);
        }
        this.myReadWindowBuffer.flip();
        long l3 = this.readLongOffset(this.myReadWindowBuffer);
        int n3 = this.readOffset(this.myReadWindowBuffer);
        int n4 = this.readOffset(this.myReadWindowBuffer);
        Object object2 = this.readOffset(this.myReadWindowBuffer);
        Object object3 = this.readOffset(this.myReadWindowBuffer);
        if (l3 < 0L || n3 < 0 || n4 < 0 || object2 < 0 || object3 < 0) {
            object = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        fSFile.seek(l2 += (long)this.myReadWindowBuffer.position());
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, object2 + object3);
        this.myReadWindowBuffer.limit(object2 + object3);
        try {
            fSFile.read(this.myReadWindowBuffer);
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().logSevere(SVNLogType.DEFAULT, iOException);
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
        }
        this.myReadWindowBuffer.position(0);
        this.myReadWindowBuffer.limit(this.myReadWindowBuffer.capacity());
        if (n2 == 1 || n2 == 2) {
            try {
                object = this.decompress((int)object2, (int)object3, n2);
                object2 = object[0];
                object3 = object[1];
            }
            catch (IOException iOException) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            }
        }
        object = new SVNDiffWindow(l3, n3, n4, (int)object2, (int)object3);
        ((SVNDiffWindow)object).setData(this.myReadWindowBuffer);
        return object;
    }

    private int[] decompress(int n2, int n3, int n4) {
        int n5;
        Object object;
        byte[] byArray;
        int n6 = this.myReadWindowBuffer.position();
        int n7 = this.readOffset(this.myReadWindowBuffer);
        byte[] byArray2 = new byte[n7];
        byte[] byArray3 = null;
        int n8 = 0;
        int n9 = n2 - (this.myReadWindowBuffer.position() - n6);
        if (n7 == n9) {
            System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), byArray2, 0, n7);
            this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + n7);
        } else {
            byArray = new byte[n9];
            System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), byArray, 0, n9);
            this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + n9);
            if (n4 == 1) {
                object = new InflaterInputStream(new ByteArrayInputStream(byArray));
                for (n5 = 0; n5 < n7; n5 += ((InflaterInputStream)object).read(byArray2, n5, n7 - n5)) {
                }
            } else if (n4 == 2) {
                object = LZ4Factory.fastestInstance().fastDecompressor();
                ((LZ4FastDecompressor)object).decompress(byArray, 0, byArray2, 0, n7);
            }
        }
        if (n3 > 0) {
            n6 = this.myReadWindowBuffer.position();
            n8 = this.readOffset(this.myReadWindowBuffer);
            n9 = n3 - (this.myReadWindowBuffer.position() - n6);
            byArray3 = new byte[n8];
            if (n9 == n8) {
                System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), byArray3, 0, n8);
                this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + n8);
            } else {
                byArray = new byte[n9];
                System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), byArray, 0, n9);
                this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + n9);
                if (n4 == 1) {
                    object = new InflaterInputStream(new ByteArrayInputStream(byArray));
                    for (n5 = 0; n5 < n8; n5 += ((InflaterInputStream)object).read(byArray3, n5, n8 - n5)) {
                    }
                } else if (n4 == 2) {
                    object = LZ4Factory.fastestInstance().fastDecompressor();
                    ((LZ4FastDecompressor)object).decompress(byArray, 0, byArray3, 0, n8);
                }
            }
        }
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, n7 + n8);
        this.myReadWindowBuffer.put(byArray2);
        if (byArray3 != null) {
            this.myReadWindowBuffer.put(byArray3);
        }
        this.myReadWindowBuffer.position(0);
        this.myReadWindowBuffer.limit(this.myReadWindowBuffer.capacity());
        return new int[]{n7, n8};
    }

    public void skipWindow(FSFile fSFile) {
        SVNErrorMessage sVNErrorMessage;
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, 4096);
        long l2 = 0L;
        try {
            l2 = fSFile.position();
            fSFile.read(this.myReadWindowBuffer);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(sVNErrorMessage2, iOException, SVNLogType.DEFAULT);
        }
        this.myReadWindowBuffer.flip();
        if (this.readLongOffset(this.myReadWindowBuffer) < 0L) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (this.readOffset(this.myReadWindowBuffer) < 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (this.readOffset(this.myReadWindowBuffer) < 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        int n2 = this.readOffset(this.myReadWindowBuffer);
        int n3 = this.readOffset(this.myReadWindowBuffer);
        if (n2 < 0 || n3 < 0) {
            SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(sVNErrorMessage3, SVNLogType.DEFAULT);
        }
        fSFile.seek((l2 += (long)this.myReadWindowBuffer.position()) + (long)n3 + (long)n2);
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
    }

    public ByteBuffer addWindow(SVNDiffWindow sVNDiffWindow) {
        if (sVNDiffWindow.getSourceViewLength() == 0 || !sVNDiffWindow.hasCopyFromSourceInstructions()) {
            this.myTarget = this.clearBuffer(this.myTarget);
            this.myTarget = this.ensureBufferSize(this.myTarget, sVNDiffWindow.getTargetViewLength());
            sVNDiffWindow.apply(new byte[0], this.myTarget.array());
            ByteBuffer byteBuffer = null;
            if (this.myWindow != null) {
                this.myRealTarget = this.clearBuffer(this.myRealTarget);
                this.myRealTarget = this.ensureBufferSize(this.myRealTarget, this.myWindow.getTargetViewLength());
                this.myWindow.apply(this.myTarget.array(), this.myRealTarget.array());
                byteBuffer = this.myRealTarget;
            } else {
                byteBuffer = this.myTarget;
            }
            byteBuffer.position(0);
            int n2 = this.myWindow != null ? this.myWindow.getTargetViewLength() : sVNDiffWindow.getTargetViewLength();
            byteBuffer.limit(n2);
            return byteBuffer;
        }
        if (this.myWindow != null) {
            this.myWindow = this.combineWindows(sVNDiffWindow);
            return null;
        }
        this.myWindowData = this.clearBuffer(this.myWindowData);
        this.myWindowData = this.ensureBufferSize(this.myWindowData, sVNDiffWindow.getDataLength());
        this.myWindow = sVNDiffWindow.clone(this.myWindowData);
        return null;
    }

    private SVNDiffWindow combineWindows(SVNDiffWindow sVNDiffWindow) {
        this.myNextWindowInstructions = this.clearBuffer(this.myNextWindowInstructions);
        this.myNextWindowData = this.clearBuffer(this.myNextWindowData);
        int n2 = 0;
        this.myWindowInstructions = sVNDiffWindow.loadDiffInstructions(this.myWindowInstructions);
        this.createOffsetsIndex(this.myWindowInstructions, sVNDiffWindow.getInstructionsCount());
        SVNRangeTree sVNRangeTree = this.myRangeTree;
        sVNRangeTree.dispose();
        Iterator iterator = this.myWindow.instructions(true);
        while (iterator.hasNext()) {
            SVNDiffInstruction sVNDiffInstruction = (SVNDiffInstruction)iterator.next();
            if (sVNDiffInstruction.type != 0) {
                this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                sVNDiffInstruction.writeTo(this.myNextWindowInstructions);
                if (sVNDiffInstruction.type == 2) {
                    this.myNextWindowData = this.ensureBufferSize(this.myNextWindowData, sVNDiffInstruction.length);
                    this.myWindow.writeNewData(this.myNextWindowData, sVNDiffInstruction.offset, sVNDiffInstruction.length);
                }
            } else {
                SVNRangeTree$SVNRangeListNode sVNRangeTree$SVNRangeListNode;
                int n3 = sVNDiffInstruction.offset;
                int n4 = sVNDiffInstruction.offset + sVNDiffInstruction.length;
                int n5 = n2;
                sVNRangeTree.splay(n3);
                SVNRangeTree$SVNRangeListNode sVNRangeTree$SVNRangeListNode2 = sVNRangeTree.buildRangeList(n3, n4);
                SVNRangeTree$SVNRangeListNode sVNRangeTree$SVNRangeListNode3 = sVNRangeTree$SVNRangeListNode = sVNRangeTree$SVNRangeListNode2.head;
                while (sVNRangeTree$SVNRangeListNode3 != null) {
                    if (sVNRangeTree$SVNRangeListNode3.kind == SVNRangeTree$SVNRangeListNode.FROM_TARGET) {
                        this.myInstructionTemplate.type = 1;
                        this.myInstructionTemplate.length = sVNRangeTree$SVNRangeListNode3.limit - sVNRangeTree$SVNRangeListNode3.offset;
                        this.myInstructionTemplate.offset = sVNRangeTree$SVNRangeListNode3.targetOffset;
                        this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                        this.myInstructionTemplate.writeTo(this.myNextWindowInstructions);
                    } else {
                        this.copySourceInstructions(sVNRangeTree$SVNRangeListNode3.offset, sVNRangeTree$SVNRangeListNode3.limit, n5, sVNDiffWindow, this.myWindowInstructions);
                    }
                    n5 += sVNRangeTree$SVNRangeListNode3.limit - sVNRangeTree$SVNRangeListNode3.offset;
                    sVNRangeTree$SVNRangeListNode3 = sVNRangeTree$SVNRangeListNode3.next;
                }
                SVNErrorManager.assertionFailure(n5 == n2 + sVNDiffInstruction.length, null, SVNLogType.DEFAULT);
                sVNRangeTree.disposeList(sVNRangeTree$SVNRangeListNode);
                sVNRangeTree.insert(n3, n4, n2);
            }
            n2 += sVNDiffInstruction.length;
        }
        this.myNextWindowData.flip();
        this.myNextWindowInstructions.flip();
        int n6 = this.myNextWindowInstructions.limit();
        int n7 = this.myNextWindowData.limit();
        this.myWindowData = this.clearBuffer(this.myWindowData);
        this.myWindowData = this.ensureBufferSize(this.myWindowData, n6 + n7);
        this.myWindowData.put(this.myNextWindowInstructions);
        this.myWindowData.put(this.myNextWindowData);
        this.myWindowData.position(0);
        this.myWindow = new SVNDiffWindow(sVNDiffWindow.getSourceViewOffset(), sVNDiffWindow.getSourceViewLength(), this.myWindow.getTargetViewLength(), n6, n7);
        this.myWindow.setData(this.myWindowData);
        this.myNextWindowInstructions = this.clearBuffer(this.myNextWindowInstructions);
        this.myNextWindowData = this.clearBuffer(this.myNextWindowData);
        return this.myWindow;
    }

    private void copySourceInstructions(int n2, int n3, int n4, SVNDiffWindow sVNDiffWindow, SVNDiffInstruction[] sVNDiffInstructionArray) {
        int n5 = this.findInstructionIndex(this.myOffsetsIndex, n2);
        int n6 = this.findInstructionIndex(this.myOffsetsIndex, n3 - 1);
        for (int i2 = n5; i2 <= n6; ++i2) {
            int n7;
            int n8;
            SVNDiffInstruction sVNDiffInstruction = sVNDiffInstructionArray[i2];
            int n9 = this.myOffsetsIndex.offsets[i2];
            int n10 = this.myOffsetsIndex.offsets[i2 + 1];
            int n11 = n2 > n9 ? n2 - n9 : 0;
            int n12 = n10 > n3 ? n10 - n3 : 0;
            SVNErrorManager.assertionFailure(n11 + n12 < sVNDiffInstruction.length, null, SVNLogType.DEFAULT);
            if (sVNDiffInstruction.type != 1) {
                n8 = sVNDiffInstruction.offset;
                n7 = sVNDiffInstruction.length;
                sVNDiffInstruction.offset += n11;
                sVNDiffInstruction.length = n7 - n11 - n12;
                this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                sVNDiffInstruction.writeTo(this.myNextWindowInstructions);
                if (sVNDiffInstruction.type == 2) {
                    this.myNextWindowData = this.ensureBufferSize(this.myNextWindowData, sVNDiffInstruction.length);
                    sVNDiffWindow.writeNewData(this.myNextWindowData, sVNDiffInstruction.offset, sVNDiffInstruction.length);
                }
                sVNDiffInstruction.offset = n8;
                sVNDiffInstruction.length = n7;
            } else {
                SVNErrorManager.assertionFailure(sVNDiffInstruction.offset < n9, null, SVNLogType.DEFAULT);
                if (sVNDiffInstruction.offset + sVNDiffInstruction.length - n12 <= n9) {
                    this.copySourceInstructions(sVNDiffInstruction.offset + n11, sVNDiffInstruction.offset + sVNDiffInstruction.length - n12, n4, sVNDiffWindow, sVNDiffInstructionArray);
                } else {
                    int n13;
                    n8 = n9 - sVNDiffInstruction.offset;
                    n7 = n11 % n8;
                    SVNErrorManager.assertionFailure(n8 > n7, null, SVNLogType.DEFAULT);
                    int n14 = n11;
                    int n15 = n4;
                    if (n7 >= 0) {
                        n13 = Math.min(sVNDiffInstruction.length - n14 - n12, n8 - n7);
                        this.copySourceInstructions(sVNDiffInstruction.offset + n7, sVNDiffInstruction.offset + n7 + n13, n15, sVNDiffWindow, sVNDiffInstructionArray);
                        n15 += n13;
                        n14 += n13;
                    }
                    SVNErrorManager.assertionFailure(n14 + n12 <= sVNDiffInstruction.length, null, SVNLogType.DEFAULT);
                    if (n7 > 0 && n14 + n12 < sVNDiffInstruction.length) {
                        n13 = Math.min(sVNDiffInstruction.length - n14 - n12, n7);
                        this.copySourceInstructions(sVNDiffInstruction.offset, sVNDiffInstruction.offset + n13, n15, sVNDiffWindow, sVNDiffInstructionArray);
                        n15 += n13;
                        n14 += n13;
                    }
                    SVNErrorManager.assertionFailure(n14 + n12 <= sVNDiffInstruction.length, null, SVNLogType.DEFAULT);
                    if (n14 + n12 < sVNDiffInstruction.length) {
                        this.myInstructionTemplate.type = 1;
                        this.myInstructionTemplate.length = sVNDiffInstruction.length - n14 - n12;
                        this.myInstructionTemplate.offset = n15 - n8;
                        this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                        this.myInstructionTemplate.writeTo(this.myNextWindowInstructions);
                    }
                }
            }
            n4 += sVNDiffInstruction.length - n11 - n12;
        }
    }

    private void createOffsetsIndex(SVNDiffInstruction[] sVNDiffInstructionArray, int n2) {
        if (this.myOffsetsIndex == null) {
            this.myOffsetsIndex = new SVNDeltaCombiner$SVNOffsetsIndex();
        }
        this.myOffsetsIndex.clear();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            SVNDiffInstruction sVNDiffInstruction = sVNDiffInstructionArray[i2];
            this.myOffsetsIndex.addOffset(n3);
            n3 += sVNDiffInstruction.length;
        }
        this.myOffsetsIndex.addOffset(n3);
    }

    private int findInstructionIndex(SVNDeltaCombiner$SVNOffsetsIndex sVNDeltaCombiner$SVNOffsetsIndex, int n2) {
        int n3 = 0;
        int n4 = sVNDeltaCombiner$SVNOffsetsIndex.length - 1;
        int n5 = (n3 + n4) / 2;
        SVNErrorManager.assertionFailure(n2 < sVNDeltaCombiner$SVNOffsetsIndex.offsets[sVNDeltaCombiner$SVNOffsetsIndex.length - 1], null, SVNLogType.DEFAULT);
        while (n3 < n4) {
            int n6 = sVNDeltaCombiner$SVNOffsetsIndex.offsets[n5];
            int n7 = sVNDeltaCombiner$SVNOffsetsIndex.offsets[n5 + 1];
            if (n2 < n6) {
                n4 = n5;
            } else if (n2 > n7) {
                n3 = n5;
            } else {
                if (n2 != n7) break;
                ++n5;
                break;
            }
            n5 = (n3 + n4) / 2;
        }
        SVNErrorManager.assertionFailure(sVNDeltaCombiner$SVNOffsetsIndex.offsets[n5] <= n2 && n2 < sVNDeltaCombiner$SVNOffsetsIndex.offsets[n5 + 1], null, SVNLogType.DEFAULT);
        return n5;
    }

    private ByteBuffer clearBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    private ByteBuffer ensureBufferSize(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null || byteBuffer.remaining() < n2) {
            ByteBuffer byteBuffer2 = byteBuffer != null ? ByteBuffer.allocate((byteBuffer.position() + n2) * 3 / 2) : ByteBuffer.allocate(n2 * 3 / 2);
            byteBuffer2.clear();
            if (byteBuffer != null) {
                byteBuffer2.put(byteBuffer.array(), 0, byteBuffer.position());
            }
            byteBuffer = byteBuffer2;
        }
        return byteBuffer;
    }

    private int readOffset(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            n2 = n2 << 7 | by & 0x7F;
            if ((by & 0x80) != 0) continue;
            return n2;
        }
        byteBuffer.reset();
        return -1;
    }

    private long readLongOffset(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        long l2 = 0L;
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            l2 = l2 << 7 | (long)(by & 0x7F);
            if ((by & 0x80) != 0) continue;
            return l2;
        }
        byteBuffer.reset();
        return -1L;
    }
}

