/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.nio.ByteBuffer;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;

public abstract class SVNDeltaAlgorithm {
    private ByteBuffer myNewData = ByteBuffer.allocate(1024);
    private ByteBuffer myData = ByteBuffer.allocate(2048);
    private int myNewDataLength;
    private int myInstructionsLength;
    private SVNDiffInstruction myTemplateInstruction = new SVNDiffInstruction(0, 0, 0);

    public void reset() {
        this.myNewData.clear();
        this.myData.clear();
        this.myInstructionsLength = 0;
        this.myNewDataLength = 0;
    }

    public abstract void computeDelta(byte[] var1, int var2, byte[] var3, int var4);

    public ByteBuffer getData() {
        if (this.myNewData.position() > 0) {
            this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, this.myNewData.position());
            this.myData.put(this.myNewData.array(), 0, this.myNewData.position());
            this.myNewData.clear();
        }
        this.myData.flip();
        return this.myData;
    }

    public int getInstructionsLength() {
        return this.myInstructionsLength;
    }

    public int getNewDataLength() {
        return this.myNewDataLength;
    }

    protected void copyFromSource(int n2, int n3) {
        this.myTemplateInstruction.type = 0;
        this.myTemplateInstruction.offset = n2;
        this.myTemplateInstruction.length = n3;
        this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, 10);
        this.myTemplateInstruction.writeTo(this.myData);
        this.myInstructionsLength = this.myData.position();
    }

    protected void copyFromTarget(int n2, int n3) {
        this.myTemplateInstruction.type = 1;
        this.myTemplateInstruction.offset = n2;
        this.myTemplateInstruction.length = n3;
        this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, 10);
        this.myTemplateInstruction.writeTo(this.myData);
        this.myInstructionsLength = this.myData.position();
    }

    protected void copyFromNewData(byte[] byArray, int n2, int n3) {
        this.myTemplateInstruction.type = 2;
        this.myTemplateInstruction.offset = 0;
        this.myTemplateInstruction.length = n3;
        this.myData = SVNDeltaAlgorithm.ensureBufferSize(this.myData, 10);
        this.myTemplateInstruction.writeTo(this.myData);
        this.myInstructionsLength = this.myData.position();
        this.myNewData = SVNDeltaAlgorithm.ensureBufferSize(this.myNewData, n3);
        this.myNewData.put(byArray, n2, n3);
        this.myNewDataLength += n3;
    }

    private static ByteBuffer ensureBufferSize(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.remaining() < n2) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate((byteBuffer.position() + n2) * 3 / 2);
            byteBuffer2.put(byteBuffer.array(), 0, byteBuffer.position());
            byteBuffer = byteBuffer2;
        }
        return byteBuffer;
    }
}

