/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.List;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.wc2.SvnChecksum;

public class SVNSqlJetUnionStatement
extends SVNSqlJetStatement {
    private SVNSqlJetStatement[] statements;
    private int current = 0;

    public SVNSqlJetUnionStatement(SVNSqlJetDb sVNSqlJetDb, SVNSqlJetStatement ... sVNSqlJetStatementArray) {
        super(sVNSqlJetDb);
        this.statements = sVNSqlJetStatementArray;
    }

    @Override
    public boolean next() {
        if (this.statements == null) {
            return false;
        }
        boolean bl2 = false;
        while (!bl2 && this.current < this.statements.length) {
            SVNSqlJetStatement sVNSqlJetStatement = this.statements[this.current];
            if (sVNSqlJetStatement != null) {
                bl2 = sVNSqlJetStatement.next();
            }
            if (bl2) continue;
            ++this.current;
        }
        return bl2;
    }

    @Override
    protected ISqlJetCursor getCursor() {
        if (this.statements == null) {
            return null;
        }
        if (this.current < this.statements.length) {
            return this.statements[this.current].getCursor();
        }
        return null;
    }

    @Override
    public void reset() {
        this.current = 0;
        if (this.statements == null) {
            return;
        }
        for (SVNSqlJetStatement sVNSqlJetStatement : this.statements) {
            sVNSqlJetStatement.reset();
        }
    }

    private void updateBinds() {
        if (this.statements == null) {
            return;
        }
        for (SVNSqlJetStatement sVNSqlJetStatement : this.statements) {
            List list = sVNSqlJetStatement.getBinds();
            list.clear();
            list.addAll(this.getBinds());
        }
    }

    @Override
    public void bindf(String string, Object ... objectArray) {
        super.bindf(string, objectArray);
        this.updateBinds();
    }

    @Override
    public void bindLong(int n2, long l2) {
        super.bindLong(n2, l2);
        this.updateBinds();
    }

    @Override
    public void bindString(int n2, String string) {
        super.bindString(n2, string);
        this.updateBinds();
    }

    @Override
    public void bindNull(int n2) {
        super.bindNull(n2);
        this.updateBinds();
    }

    @Override
    public void bindBlob(int n2, byte[] byArray) {
        super.bindBlob(n2, byArray);
        this.updateBinds();
    }

    @Override
    public void bindChecksum(int n2, SvnChecksum svnChecksum) {
        super.bindChecksum(n2, svnChecksum);
        this.updateBinds();
    }

    @Override
    public void bindProperties(int n2, SVNProperties sVNProperties) {
        super.bindProperties(n2, sVNProperties);
        this.updateBinds();
    }
}

