/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;

public abstract class SVNSqlJetTableStatement
extends SVNSqlJetStatement {
    protected ISqlJetTable table;
    protected String tableName;
    private Collection triggers;

    public SVNSqlJetTableStatement(SVNSqlJetDb sVNSqlJetDb, Enum enum_) {
        this(sVNSqlJetDb, enum_.toString());
    }

    public String getTableName() {
        return this.tableName;
    }

    public SVNSqlJetTableStatement(SVNSqlJetDb sVNSqlJetDb, String string) {
        super(sVNSqlJetDb);
        this.tableName = string;
        try {
            this.table = sVNSqlJetDb.getDb().getTable(string);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
        }
    }

    public void addTrigger(ISVNSqlJetTrigger iSVNSqlJetTrigger) {
        if (iSVNSqlJetTrigger != null) {
            if (this.triggers == null) {
                this.triggers = new ArrayList();
            }
            this.triggers.add(iSVNSqlJetTrigger);
        }
    }

    protected Collection getTriggers() {
        if (this.triggers == null) {
            return Collections.emptyList();
        }
        return this.triggers;
    }

    public ISqlJetTable getTable() {
        return this.table;
    }

    protected void statementStarted() {
        for (ISVNSqlJetTrigger iSVNSqlJetTrigger : this.getTriggers()) {
            try {
                iSVNSqlJetTrigger.statementStarted(this.sDb.getDb());
            }
            catch (SqlJetException sqlJetException) {}
        }
    }

    protected void statementCompleted(SqlJetException sqlJetException) {
        for (ISVNSqlJetTrigger iSVNSqlJetTrigger : this.getTriggers()) {
            try {
                iSVNSqlJetTrigger.statementCompleted(this.sDb.getDb(), sqlJetException);
            }
            catch (SqlJetException sqlJetException2) {}
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.triggers != null) {
            this.triggers.clear();
        }
    }
}

