/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNSqlJetStatement {
    protected SVNSqlJetDb sDb;
    private ISqlJetCursor cursor;
    protected List binds = new ArrayList();
    protected SqlJetTransactionMode transactionMode = SqlJetTransactionMode.READ_ONLY;

    protected ISqlJetCursor openCursor() {
        throw new UnsupportedOperationException();
    }

    public long insert(Object ... objectArray) {
        throw new UnsupportedOperationException();
    }

    public long exec() {
        throw new UnsupportedOperationException();
    }

    public SVNSqlJetStatement(SVNSqlJetDb sVNSqlJetDb) {
        this.sDb = sVNSqlJetDb;
        this.setCursor(null);
    }

    public List getBinds() {
        return this.binds;
    }

    public boolean isNeedsReset() {
        return this.getCursor() != null;
    }

    public void reset() {
        this.binds.clear();
        if (this.isNeedsReset()) {
            try {
                this.getCursor().close();
            }
            catch (SqlJetException sqlJetException) {
                SVNSqlJetDb.createSqlJetError(sqlJetException);
            }
            finally {
                this.setCursor(null);
                this.sDb.commit();
            }
        }
    }

    public boolean next() {
        try {
            if (this.getCursor() == null) {
                this.sDb.beginTransaction(this.transactionMode);
                try {
                    this.setCursor(this.openCursor());
                    return !this.getCursor().eof();
                }
                catch (SVNException sVNException) {
                    if (this.getCursor() == null) {
                        this.sDb.commit();
                    }
                    throw sVNException;
                }
            }
            return this.getCursor().next();
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return false;
        }
    }

    public boolean eof() {
        try {
            if (this.getCursor() == null) {
                this.sDb.beginTransaction(this.transactionMode);
                this.setCursor(this.openCursor());
            }
            return this.getCursor().eof();
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return false;
        }
    }

    public void bindf(String string, Object ... objectArray) {
        int n2 = 0;
        int n3 = objectArray.length;
        block7: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case 's': 
                case 't': {
                    if (n2 > n3 || objectArray[n2] == null) {
                        this.bindNull(i2 + 1);
                    } else if (objectArray[n2] instanceof File) {
                        this.bindString(i2 + 1, SVNFileUtil.getFilePath((File)objectArray[n2]));
                    } else {
                        this.bindString(i2 + 1, objectArray[n2].toString());
                    }
                    ++n2;
                    continue block7;
                }
                case 'i': {
                    if (n2 > n3 || objectArray[n2] == null) {
                        this.bindNull(i2 + 1);
                    } else if (objectArray[n2] instanceof Number) {
                        this.bindLong(i2 + 1, ((Number)objectArray[n2]).longValue());
                    } else if (objectArray[n2] instanceof SVNDate) {
                        this.bindLong(i2 + 1, ((SVNDate)objectArray[n2]).getTimeInMicros());
                    } else {
                        SVNErrorManager.assertionFailure(false, String.format("Number argument required in %d", i2 + 1), SVNLogType.WC);
                    }
                    ++n2;
                    continue block7;
                }
                case 'r': {
                    if (n2 > n3 || objectArray[n2] == null) {
                        this.bindNull(i2 + 1);
                    } else if (objectArray[n2] instanceof Number) {
                        this.bindRevision(i2 + 1, ((Number)objectArray[n2]).longValue());
                    } else {
                        SVNErrorManager.assertionFailure(false, String.format("Number argument required in %d", i2 + 1), SVNLogType.WC);
                    }
                    ++n2;
                    continue block7;
                }
                case 'b': {
                    if (n2 > n3 || objectArray[n2] == null) {
                        this.bindNull(i2 + 1);
                    } else if (objectArray[n2] instanceof byte[]) {
                        this.bindBlob(i2 + 1, (byte[])objectArray[n2]);
                    } else {
                        SVNErrorManager.assertionFailure(false, String.format("Byte array argument required in %d", i2 + 1), SVNLogType.WC);
                    }
                    ++n2;
                    continue block7;
                }
                case 'n': {
                    this.bindNull(i2 + 1);
                    continue block7;
                }
                default: {
                    SVNErrorManager.assertionFailure(false, String.format("Unknown format '%s' in %d", Character.valueOf(c2), i2 + 1), SVNLogType.WC);
                }
            }
        }
    }

    private void adjustBinds(int n2) {
        int n3 = this.binds.size();
        if (n3 < n2) {
            for (int i2 = n3; i2 < n2; ++i2) {
                this.binds.add(null);
            }
        }
    }

    public void bindNull(int n2) {
        this.adjustBinds(n2);
        this.binds.set(n2 - 1, null);
    }

    public void bindLong(int n2, long l2) {
        this.adjustBinds(n2);
        this.binds.set(n2 - 1, l2);
    }

    public void bindString(int n2, String string) {
        this.adjustBinds(n2);
        this.binds.set(n2 - 1, string);
    }

    public void bindProperties(int n2, SVNProperties sVNProperties) {
        this.adjustBinds(n2);
        this.binds.set(n2 - 1, sVNProperties != null ? SVNSkel.createPropList(sVNProperties.asMap()).unparse() : null);
    }

    public void bindIProperties(int n2, Map map) {
        this.adjustBinds(n2);
        this.binds.set(n2 - 1, map != null ? SVNSkel.createInheritedProperties(map).unparse() : null);
    }

    public void bindChecksum(int n2, SvnChecksum svnChecksum) {
        this.adjustBinds(n2);
        this.binds.set(n2 - 1, svnChecksum != null ? svnChecksum.toString() : null);
    }

    public void bindBlob(int n2, byte[] byArray) {
        this.adjustBinds(n2);
        this.binds.set(n2 - 1, byArray);
    }

    public void bindRevision(int n2, long l2) {
        this.adjustBinds(n2);
        if (SVNRevision.isValidRevisionNumber(l2)) {
            this.bindLong(n2, l2);
        } else {
            this.bindNull(n2);
        }
    }

    protected Object getBind(int n2) {
        this.adjustBinds(n2);
        return this.binds.get(n2 - 1);
    }

    public long count() {
        try {
            if (this.getCursor() == null || this.getCursor().eof()) {
                return 0L;
            }
            return this.getCursor().getRowCount();
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return 0L;
        }
    }

    public Object getColumn(Enum enum_) {
        return this.getColumn(enum_.toString());
    }

    protected Object getColumn(String string) {
        try {
            if (this.getCursor() == null || this.getCursor().eof()) {
                return null;
            }
            return this.getCursor().getValue(string);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return null;
        }
    }

    public long getColumnLong(Enum enum_) {
        return this.getColumnLong(enum_.toString());
    }

    protected long getColumnLong(String string) {
        try {
            if (this.getCursor() == null || this.getCursor().eof()) {
                return 0L;
            }
            return this.getCursor().getInteger(string);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return 0L;
        }
    }

    public String getColumnString(Enum enum_) {
        return this.getColumnString(enum_.toString());
    }

    protected String getColumnString(String string) {
        try {
            if (this.getCursor() == null || this.getCursor().eof()) {
                return null;
            }
            return this.getCursor().getString(string);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return null;
        }
    }

    public boolean isColumnNull(Enum enum_) {
        return this.isColumnNull(enum_.toString());
    }

    protected boolean isColumnNull(String string) {
        try {
            if (this.getCursor() == null || this.getCursor().eof()) {
                return true;
            }
            return this.getCursor().isNull(string);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return false;
        }
    }

    public byte[] getColumnBlob(Enum enum_) {
        return this.getColumnBlob(enum_.toString());
    }

    protected byte[] getColumnBlob(String string) {
        try {
            if (this.getCursor() == null || this.getCursor().eof()) {
                return null;
            }
            return this.getCursor().getBlobAsArray(string);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return null;
        }
    }

    public boolean getColumnBoolean(Enum enum_) {
        return this.getColumnLong(enum_) != 0L;
    }

    public SVNSqlJetStatement getJoinedStatement(String string) {
        SVNErrorManager.assertionFailure(false, "unsupported", SVNLogType.WC);
        return null;
    }

    public SVNSqlJetStatement getJoinedStatement(Enum enum_) {
        return this.getJoinedStatement(enum_.toString());
    }

    public SVNProperties getColumnProperties(Enum enum_) {
        return this.getColumnProperties(enum_.name());
    }

    public boolean hasColumnProperties(Enum enum_) {
        return this.hasColumnProperties(enum_.name());
    }

    public List getColumnInheritedProperties(Enum enum_) {
        return this.getColumnInheritedProperties(enum_.name());
    }

    public boolean hasColumnInheritedProperties(Enum enum_) {
        return this.hasColumnInheritedProperties(enum_.name());
    }

    protected SVNProperties getColumnProperties(String string) {
        if (this.isColumnNull(string)) {
            return null;
        }
        byte[] byArray = this.getColumnBlob(string);
        return SVNSqlJetStatement.parseProperties(byArray);
    }

    protected boolean hasColumnProperties(String string) {
        if (this.isColumnNull(string)) {
            return false;
        }
        byte[] byArray = this.getColumnBlob(string);
        return byArray.length > 2;
    }

    public List getColumnInheritedProperties(String string) {
        if (this.isColumnNull(string)) {
            return null;
        }
        byte[] byArray = this.getColumnBlob(string);
        return SVNSqlJetStatement.parseInheritedProperties(byArray);
    }

    public boolean hasColumnInheritedProperties(String string) {
        if (this.isColumnNull(string)) {
            return false;
        }
        byte[] byArray = this.getColumnBlob(string);
        return byArray.length > 2;
    }

    public static SVNProperties parseProperties(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        SVNSkel sVNSkel = SVNSkel.parse(byArray);
        if (sVNSkel == null || !sVNSkel.isValidPropList()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "proplist");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return SVNProperties.wrap(sVNSkel.parsePropList());
    }

    public static List parseInheritedProperties(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        SVNSkel sVNSkel = SVNSkel.parse(byArray);
        if (sVNSkel == null || !sVNSkel.isValidInheritedProperties()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "inhertied-props");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return sVNSkel.parseInheritedProperties();
    }

    public long done() {
        try {
            long l2 = this.exec();
            return l2;
        }
        finally {
            this.reset();
        }
    }

    public void nextRow() {
        if (!this.next()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, "Expected database row missing");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    public long getColumnRevnum(Enum enum_) {
        if (this.isColumnNull(enum_)) {
            return -1L;
        }
        return this.getColumnLong(enum_);
    }

    protected ISqlJetCursor getCursor() {
        return this.cursor;
    }

    protected void setCursor(ISqlJetCursor iSqlJetCursor) {
        this.cursor = iSqlJetCursor;
    }

    public Map getRowValues() {
        throw new UnsupportedOperationException();
    }
}

