/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Indices;

public class SVNSqlJetSelectStatement
extends SVNSqlJetTableStatement {
    private String indexName;
    private Map rowValues;

    public SVNSqlJetSelectStatement(SVNSqlJetDb sVNSqlJetDb, Enum enum_) {
        this(sVNSqlJetDb, enum_.toString());
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sVNSqlJetDb, Enum enum_, Enum enum_2) {
        this(sVNSqlJetDb, enum_.toString(), enum_2 != null ? enum_2.toString() : null);
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sVNSqlJetDb, String string) {
        super(sVNSqlJetDb, string);
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sVNSqlJetDb, String string, String string2) {
        this(sVNSqlJetDb, string);
        this.indexName = string2;
    }

    @Override
    protected ISqlJetCursor openCursor() {
        try {
            Object[] objectArray = this.getWhere();
            if (this.isPathScoped() && this.isPathScopeInIndex()) {
                objectArray = new Object[]{objectArray[0], this.getPathScope()};
                return this.getTable().scope(this.getIndexName(), objectArray, null);
            }
            return this.getTable().lookup(this.getIndexName(), objectArray);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return null;
        }
    }

    private boolean isPathScoped() {
        Object[] objectArray = this.getWhere();
        if (this.getPathScope() != null && this.getIndexName() == null && SVNWCDbSchema.NODES.toString().equals(this.getTableName()) && objectArray.length == 1) {
            return true;
        }
        if (this.getPathScope() != null && this.getIndexName() == SVNWCDbSchema$NODES__Indices.I_NODES_PARENT.name() && SVNWCDbSchema.NODES.toString().equals(this.getTableName()) && objectArray.length == 1) {
            return true;
        }
        return this.getPathScope() != null && this.getIndexName() == SVNWCDbSchema$NODES__Indices.I_NODES_MOVED.name() && SVNWCDbSchema.NODES.toString().equals(this.getTableName()) && objectArray.length == 1;
    }

    protected String getPathScope() {
        return null;
    }

    protected boolean isStrictiDescendant() {
        return false;
    }

    protected boolean isPathScopeInIndex() {
        Enum enum_ = this.getRowPathField();
        return enum_ == this.getDefaultRowPathField();
    }

    protected String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    protected Object[] getWhere() {
        if (this.binds.size() == 0) {
            return null;
        }
        return this.binds.toArray();
    }

    @Override
    public boolean next() {
        boolean bl2 = false;
        do {
            bl2 = super.next();
            this.loadRowValues(bl2);
            if (bl2 && this.pathScopeMatches()) continue;
        } while (bl2 && !this.pathIsDecendant());
        while (bl2 && !this.isFilterPassed()) {
            do {
                bl2 = super.next();
                this.loadRowValues(bl2);
                if (!bl2 || this.pathScopeMatches()) continue;
                return false;
            } while (bl2 && !this.pathIsDecendant());
        }
        return bl2;
    }

    private boolean pathScopeMatches() {
        if (this.isPathScoped()) {
            String string = this.getRowPath();
            if (!(!"".equals(this.getPathScope()) || this.isStrictiDescendant() && "".equals(string))) {
                return true;
            }
            if (string != null) {
                return !this.isStrictiDescendant() && this.getPathScope().equals(string) || string.startsWith(this.getPathScope());
            }
            return false;
        }
        return true;
    }

    private boolean pathIsDecendant() {
        if (this.getPathScope() != null) {
            String string = this.getRowPath();
            if (string != null) {
                if (!(!"".equals(this.getPathScope()) || this.isStrictiDescendant() && "".equals(string))) {
                    return true;
                }
                return !this.isStrictiDescendant() && this.getPathScope().equals(string) || string.startsWith(this.getPathScope() + "/");
            }
            return false;
        }
        return true;
    }

    protected Enum getRowPathField() {
        return this.getDefaultRowPathField();
    }

    private Enum getDefaultRowPathField() {
        if (SVNWCDbSchema$NODES__Indices.I_NODES_PARENT.toString().equals(this.getIndexName())) {
            return SVNWCDbSchema$NODES__Fields.parent_relpath;
        }
        if (SVNWCDbSchema$NODES__Indices.I_NODES_MOVED.toString().equals(this.getIndexName())) {
            return SVNWCDbSchema$NODES__Fields.moved_to;
        }
        return SVNWCDbSchema$NODES__Fields.local_relpath;
    }

    protected String getRowPath() {
        Enum enum_ = this.getRowPathField();
        if (enum_ == null) {
            return null;
        }
        return (String)this.rowValues.get(enum_.name());
    }

    protected boolean isFilterPassed() {
        return true;
    }

    @Override
    public boolean eof() {
        boolean bl2 = true;
        do {
            bl2 = bl2 ? super.eof() : !super.next();
            this.loadRowValues(!bl2);
            if (bl2 || this.pathScopeMatches()) continue;
            return true;
        } while (!bl2 && !this.pathIsDecendant());
        while (!bl2 && !this.isFilterPassed()) {
            do {
                bl2 = !super.next();
                this.loadRowValues(!bl2);
                if (bl2 || this.pathScopeMatches()) continue;
                return true;
            } while (!bl2 && !this.pathIsDecendant());
        }
        return bl2;
    }

    private void loadRowValues(boolean bl2) {
        if (bl2) {
            this.rowValues = this.getRowValues2(this.rowValues);
        } else if (this.rowValues != null) {
            this.rowValues.clear();
        }
    }

    public Map getRowValues2(Map map) {
        map = map == null ? new HashMap() : map;
        try {
            Object[] objectArray;
            List list = this.getTable().getDefinition().getColumns();
            Object[] objectArray2 = this.getCursor().getRowValues();
            if (objectArray2.length < list.size()) {
                objectArray = new Object[list.size()];
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            } else {
                objectArray = objectArray2;
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                map.put(((ISqlJetColumnDef)list.get(i2)).getName(), objectArray[i2]);
            }
            return map;
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return null;
        }
    }

    @Override
    public Map getRowValues() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            List list = this.getTable().getDefinition().getColumns();
            for (ISqlJetColumnDef iSqlJetColumnDef : list) {
                String string = iSqlJetColumnDef.getName();
                SqlJetValueType sqlJetValueType = this.getCursor().getFieldType(string);
                if (sqlJetValueType == SqlJetValueType.NULL) {
                    hashMap.put(string, null);
                    continue;
                }
                if (sqlJetValueType == SqlJetValueType.BLOB) {
                    hashMap.put(string, this.getCursor().getBlobAsArray(string));
                    continue;
                }
                hashMap.put(string, this.getCursor().getValue(string));
            }
            return hashMap;
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return null;
        }
    }

    @Override
    protected Object getColumn(String string) {
        return this.rowValues != null ? this.rowValues.get(string) : null;
    }

    @Override
    protected long getColumnLong(String string) {
        if (this.rowValues == null) {
            return 0L;
        }
        Object v2 = this.rowValues.get(string);
        if (v2 instanceof Long) {
            return (Long)v2;
        }
        if (v2 instanceof String) {
            try {
                return Long.parseLong((String)v2);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        return 0L;
    }

    @Override
    protected String getColumnString(String string) {
        if (this.rowValues == null) {
            return null;
        }
        Object v2 = this.rowValues.get(string);
        if (v2 == null) {
            return null;
        }
        return v2 instanceof String ? (String)v2 : v2.toString();
    }

    @Override
    protected boolean isColumnNull(String string) {
        if (this.rowValues == null) {
            return true;
        }
        return this.rowValues.get(string) == null;
    }

    @Override
    protected byte[] getColumnBlob(String string) {
        if (this.rowValues == null) {
            return null;
        }
        Object v2 = this.rowValues.get(string);
        if (v2 instanceof ISqlJetMemoryPointer) {
            ISqlJetMemoryPointer iSqlJetMemoryPointer = (ISqlJetMemoryPointer)v2;
            return iSqlJetMemoryPointer != null ? SqlJetUtility.readByteBuffer(iSqlJetMemoryPointer) : null;
        }
        if (v2 instanceof String) {
            try {
                return ((String)v2).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return ((String)v2).getBytes();
            }
        }
        if (v2 instanceof byte[]) {
            return (byte[])v2;
        }
        return null;
    }

    @Override
    public void reset() {
        if (this.rowValues != null) {
            this.rowValues.clear();
        }
        super.reset();
    }

    protected static boolean isStrictDescendantOf(String string, String string2) {
        return string.startsWith(string2 + "/");
    }
}

