/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public abstract class SVNSqlJetInsertStatement
extends SVNSqlJetTableStatement {
    protected SqlJetConflictAction conflictAction = null;

    public SVNSqlJetInsertStatement(SVNSqlJetDb sVNSqlJetDb, Enum enum_) {
        super(sVNSqlJetDb, enum_);
        this.transactionMode = SqlJetTransactionMode.WRITE;
        if (SVNWCDbSchema.NODES == enum_) {
            SvnNodesPristineTrigger svnNodesPristineTrigger = new SvnNodesPristineTrigger();
            this.addTrigger(svnNodesPristineTrigger);
        }
    }

    public SVNSqlJetInsertStatement(SVNSqlJetDb sVNSqlJetDb, Enum enum_, SqlJetConflictAction sqlJetConflictAction) {
        this(sVNSqlJetDb, enum_);
        this.conflictAction = sqlJetConflictAction;
    }

    @Override
    public long exec() {
        Map map = this.getInsertValues();
        if (map == null) {
            return 0L;
        }
        this.statementStarted();
        try {
            this.beforeInsert(this.conflictAction, this.table, map);
            long l2 = this.table.insertByFieldNamesOr(this.conflictAction, map);
            this.statementCompleted(null);
            return l2;
        }
        catch (SqlJetException sqlJetException) {
            this.statementCompleted(sqlJetException);
            SVNSqlJetDb.createSqlJetError(sqlJetException);
            return -1L;
        }
    }

    private void beforeInsert(SqlJetConflictAction sqlJetConflictAction, ISqlJetTable iSqlJetTable, Map map) {
        for (ISVNSqlJetTrigger iSVNSqlJetTrigger : this.getTriggers()) {
            try {
                iSVNSqlJetTrigger.beforeInsert(sqlJetConflictAction, iSqlJetTable, map);
            }
            catch (SqlJetException sqlJetException) {}
        }
    }

    protected abstract Map getInsertValues();
}

