/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.EnumMap;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.sqljet.core.table.SqlJetTimeoutBusyHandler;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTransaction;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSqlJetDb {
    private static final ISqlJetBusyHandler DEFAULT_BUSY_HANDLER = new SqlJetTimeoutBusyHandler(10000);
    private static boolean logTransactions = "true".equalsIgnoreCase(System.getProperty("svnkit.log.transactions", "false"));
    private static SqlJetPagerJournalMode ourPagerJournalMode = SqlJetPagerJournalMode.DELETE;
    private SqlJetDb db;
    private EnumMap statements;
    private int openCount = 0;
    private SVNSqlJetDb temporaryDb;
    private boolean temporaryDbInMemory;

    private SVNSqlJetDb(SqlJetDb sqlJetDb, boolean bl2) {
        this.db = sqlJetDb;
        this.temporaryDbInMemory = bl2;
        this.statements = new EnumMap(SVNWCDbStatements.class);
    }

    public SqlJetDb getDb() {
        return this.db;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public void close() {
        if (this.temporaryDb != null) {
            try {
                this.temporaryDb.close();
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            this.temporaryDb = null;
        }
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (SqlJetException sqlJetException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
    }

    public static void setJournalMode(SqlJetPagerJournalMode sqlJetPagerJournalMode) {
        ourPagerJournalMode = sqlJetPagerJournalMode == null ? SqlJetPagerJournalMode.DELETE : sqlJetPagerJournalMode;
    }

    public static SqlJetPagerJournalMode getJournalMode() {
        return ourPagerJournalMode;
    }

    public static SVNSqlJetDb open(File file, SVNSqlJetDb$Mode sVNSqlJetDb$Mode) {
        return SVNSqlJetDb.open(file, sVNSqlJetDb$Mode, SVNSqlJetDb.getJournalMode(), false);
    }

    public static SVNSqlJetDb open(File file, SVNSqlJetDb$Mode sVNSqlJetDb$Mode, SqlJetPagerJournalMode sqlJetPagerJournalMode, boolean bl2) {
        Object object;
        if (sVNSqlJetDb$Mode != SVNSqlJetDb$Mode.RWCreate && !file.exists()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "File not found ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sqlJetPagerJournalMode == null) {
            sqlJetPagerJournalMode = SVNSqlJetDb.getJournalMode();
        }
        try {
            object = SqlJetDb.open(file, sVNSqlJetDb$Mode != SVNSqlJetDb$Mode.ReadOnly);
            ((SqlJetEngine)object).setBusyHandler(DEFAULT_BUSY_HANDLER);
            ((SqlJetEngine)object).setSafetyLevel(SqlJetSafetyLevel.OFF);
            ((SqlJetEngine)object).setJournalMode(sqlJetPagerJournalMode);
            return new SVNSqlJetDb((SqlJetDb)object, bl2);
        }
        catch (SqlJetException sqlJetException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            return null;
        }
    }

    public SVNSqlJetDb getTemporaryDb() {
        if (this.temporaryDb == null) {
            try {
                this.temporaryDb = new SVNSqlJetDb(this.getDb().getTemporaryDatabase(this.temporaryDbInMemory), this.temporaryDbInMemory);
            }
            catch (SqlJetException sqlJetException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                return null;
            }
        }
        return this.temporaryDb;
    }

    public SVNSqlJetStatement getStatement(SVNWCDbStatements sVNWCDbStatements) {
        assert (sVNWCDbStatements != null);
        SVNSqlJetStatement sVNSqlJetStatement = (SVNSqlJetStatement)this.statements.get((Object)sVNWCDbStatements);
        if (sVNSqlJetStatement == null) {
            sVNSqlJetStatement = this.prepareStatement(sVNWCDbStatements);
            this.statements.put(sVNWCDbStatements, sVNSqlJetStatement);
        } else if (sVNSqlJetStatement instanceof SVNSqlJetInsertStatement || sVNSqlJetStatement instanceof SVNSqlJetUpdateStatement || sVNSqlJetStatement instanceof SVNSqlJetDeleteStatement) {
            String string = ((SVNSqlJetTableStatement)sVNSqlJetStatement).getTableName();
            if (SVNWCDbSchema.NODES.toString().equals(string)) {
                SvnNodesPristineTrigger svnNodesPristineTrigger = new SvnNodesPristineTrigger();
                ((SVNSqlJetTableStatement)sVNSqlJetStatement).addTrigger(svnNodesPristineTrigger);
            }
        }
        if (sVNSqlJetStatement != null && sVNSqlJetStatement.isNeedsReset()) {
            sVNSqlJetStatement.reset();
        }
        return sVNSqlJetStatement;
    }

    private SVNSqlJetStatement prepareStatement(SVNWCDbStatements sVNWCDbStatements) {
        Class clazz = sVNWCDbStatements.getStatementClass();
        SVNErrorManager.assertionFailure(clazz != null, String.format("Statement '%s' not defined", sVNWCDbStatements.toString()), SVNLogType.WC);
        if (clazz == null) {
            return null;
        }
        try {
            Constructor constructor = clazz.getConstructor(SVNSqlJetDb.class);
            SVNSqlJetStatement sVNSqlJetStatement = (SVNSqlJetStatement)constructor.newInstance(this);
            return sVNSqlJetStatement;
        }
        catch (Exception exception) {
            SVNErrorCode sVNErrorCode = SVNErrorCode.UNSUPPORTED_FEATURE;
            String string = exception.getMessage() != null ? exception.getMessage() : sVNErrorCode.getDescription();
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, string, new Object[0], 0, exception);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            return null;
        }
    }

    public void execStatement(SVNWCDbStatements sVNWCDbStatements) {
        SVNSqlJetStatement sVNSqlJetStatement = this.getStatement(sVNWCDbStatements);
        if (sVNSqlJetStatement != null) {
            sVNSqlJetStatement.exec();
        }
    }

    public static void createSqlJetError(SqlJetException sqlJetException) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    public void beginTransaction(SqlJetTransactionMode sqlJetTransactionMode) {
        if (sqlJetTransactionMode != null) {
            ++this.openCount;
            if (SVNSqlJetDb.isLogTransactions()) {
                this.logCall("Being transaction request (" + this.openCount + "): " + (Object)((Object)sqlJetTransactionMode), 5);
            }
            if (this.isNeedStartTransaction(sqlJetTransactionMode)) {
                try {
                    this.db.beginTransaction(sqlJetTransactionMode);
                    if (SVNSqlJetDb.isLogTransactions()) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "transaction started");
                    }
                }
                catch (SqlJetException sqlJetException) {
                    SVNSqlJetDb.createSqlJetError(sqlJetException);
                }
            }
        } else {
            SVNErrorManager.assertionFailure(sqlJetTransactionMode != null, "transaction mode is null", SVNLogType.WC);
        }
    }

    private boolean isNeedStartTransaction(SqlJetTransactionMode sqlJetTransactionMode) {
        if (!this.db.isInTransaction()) {
            return true;
        }
        SqlJetTransactionMode sqlJetTransactionMode2 = this.db.getTransactionMode();
        return sqlJetTransactionMode != sqlJetTransactionMode2 && (SqlJetTransactionMode.WRITE == sqlJetTransactionMode || SqlJetTransactionMode.EXCLUSIVE == sqlJetTransactionMode) && SqlJetTransactionMode.READ_ONLY == sqlJetTransactionMode2;
    }

    public void commit() {
        if (this.openCount > 0) {
            --this.openCount;
            if (SVNSqlJetDb.isLogTransactions()) {
                this.logCall("Commit transaction request (" + this.openCount + ")", 5);
            }
            if (this.openCount == 0) {
                try {
                    this.db.commit();
                    if (SVNSqlJetDb.isLogTransactions()) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "transaction committed");
                    }
                }
                catch (SqlJetException sqlJetException) {
                    SVNSqlJetDb.createSqlJetError(sqlJetException);
                }
            }
        } else {
            SVNErrorManager.assertionFailure(this.openCount > 0, "no opened transactions", SVNLogType.WC);
        }
    }

    public void verifyNoWork() {
    }

    public void runTransaction(SVNSqlJetTransaction sVNSqlJetTransaction) {
        this.runTransaction(sVNSqlJetTransaction, SqlJetTransactionMode.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(SVNSqlJetTransaction sVNSqlJetTransaction, SqlJetTransactionMode sqlJetTransactionMode) {
        try {
            this.beginTransaction(sqlJetTransactionMode);
            sVNSqlJetTransaction.transaction(this);
        }
        catch (SqlJetException sqlJetException) {
            try {
                this.db.rollback();
            }
            catch (SqlJetException sqlJetException2) {
                sqlJetException2.initCause(sqlJetException);
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        finally {
            this.commit();
        }
    }

    public void rollback() {
        try {
            this.db.rollback();
        }
        catch (SqlJetException sqlJetException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    public boolean hasTable(String string) {
        try {
            return string != null && this.db.getSchema().getTableNames().contains(string);
        }
        catch (SqlJetException sqlJetException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            return false;
        }
    }

    private void logCall(String string, int n2) {
        if (SVNSqlJetDb.isLogTransactions()) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(":\n");
            for (int i2 = 0; i2 < stackTraceElementArray.length && i2 < n2; ++i2) {
                stringBuffer.append(stackTraceElementArray[i2].getClassName());
                stringBuffer.append('.');
                stringBuffer.append(stackTraceElementArray[i2].getMethodName());
                stringBuffer.append(':');
                stringBuffer.append(stackTraceElementArray[i2].getLineNumber());
                stringBuffer.append('\n');
            }
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, string.toString());
        }
    }

    private static boolean isLogTransactions() {
        return logTransactions;
    }
}

