/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;

public class SVNSSLAuthentication
extends SVNAuthentication {
    public static final String MSCAPI = "MSCAPI";
    public static final String SSL = "SSL";
    private File myCertificate;
    private char[] myPassword;
    private String mySSLKind;
    private String myAlias;
    private String myCertificatePath;
    private byte[] myCertificateData;

    public static SVNSSLAuthentication newInstance(File file, char[] cArray, boolean bl2, SVNURL sVNURL, boolean bl3) {
        return new SVNSSLAuthentication(SSL, null, file, cArray, bl2, sVNURL, bl3);
    }

    public static SVNSSLAuthentication newInstance(byte[] byArray, char[] cArray, boolean bl2, SVNURL sVNURL, boolean bl3) {
        return new SVNSSLAuthentication(SSL, null, byArray, cArray, bl2, sVNURL, bl3);
    }

    public static SVNSSLAuthentication newInstance(String string, String string2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        return new SVNSSLAuthentication(string, string2, (File)null, null, bl2, sVNURL, bl3);
    }

    public SVNSSLAuthentication(File file, String string, boolean bl2) {
        this(SSL, null, file, string != null ? string.toCharArray() : null, bl2, null, false);
    }

    public SVNSSLAuthentication(File file, String string, boolean bl2, SVNURL sVNURL, boolean bl3) {
        this(SSL, null, file, string != null ? string.toCharArray() : null, bl2, sVNURL, bl3);
    }

    public SVNSSLAuthentication(String string, String string2, boolean bl2, SVNURL sVNURL, boolean bl3) {
        this(string, string2, (File)null, null, bl2, sVNURL, bl3);
    }

    private SVNSSLAuthentication(String string, String string2, File file, char[] cArray, boolean bl2, SVNURL sVNURL, boolean bl3) {
        super("svn.ssl.client-passphrase", null, bl2, sVNURL, bl3);
        this.mySSLKind = string;
        this.myAlias = string2;
        this.myCertificate = file;
        this.myPassword = cArray;
    }

    private SVNSSLAuthentication(String string, String string2, byte[] byArray, char[] cArray, boolean bl2, SVNURL sVNURL, boolean bl3) {
        super("svn.ssl.client-passphrase", null, bl2, sVNURL, bl3);
        this.mySSLKind = string;
        this.myAlias = string2;
        this.myCertificateData = byArray;
        this.myPassword = cArray;
    }

    public String getPassword() {
        return this.myPassword != null ? new String(this.myPassword) : null;
    }

    public byte[] getCertificate() {
        return this.myCertificateData;
    }

    public char[] getPasswordValue() {
        return this.myPassword;
    }

    public File getCertificateFile() {
        return this.myCertificate;
    }

    public String getSSLKind() {
        return this.mySSLKind;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public String getCertificatePath() {
        if (this.myCertificatePath != null) {
            return this.myCertificatePath;
        }
        return null;
    }

    public void setCertificatePath(String string) {
        this.myCertificatePath = string;
    }

    public static boolean isCertificatePath(String string) {
        return SVNFileType.getType(new File(string)) == SVNFileType.FILE;
    }

    @Override
    public void dismissSensitiveData() {
        super.dismissSensitiveData();
        SVNEncodingUtil.clearArray(this.myPassword);
    }

    @Override
    public SVNAuthentication copy() {
        return new SVNSSLAuthentication(this.mySSLKind, this.myAlias, this.myCertificate, this.copyOf(this.myPassword), this.isStorageAllowed(), this.getURL(), this.isPartial());
    }
}

